/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.android.net;

import android.net.IConnectivityManager;
import android.net.Network;
import android.net.SocketKeepalive;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import java.net.InetAddress;
import java.util.concurrent.Executor;

public class NattSocketKeepalive
extends SocketKeepalive {
    public static final int NATT_PORT = 4500;
    private final InetAddress mSource;
    private final InetAddress mDestination;
    private final int mResourceId;

    public NattSocketKeepalive(IConnectivityManager service, Network network, ParcelFileDescriptor pfd, int resourceId, InetAddress source, InetAddress destination, Executor executor, SocketKeepalive.Callback callback) {
        super(service, network, pfd, executor, callback);
        this.mSource = source;
        this.mDestination = destination;
        this.mResourceId = resourceId;
    }

    @Override
    protected void startImpl(int intervalSec, int flags, Network underpinnedNetwork) {
        if (0 != (flags & 0xFFFFFFFE)) {
            throw new IllegalArgumentException("Illegal flag value for " + this.getClass().getSimpleName() + " : " + flags);
        }
        boolean automaticOnOffKeepalives = 0 != (flags & 1);
        this.mExecutor.execute(() -> {
            try {
                this.mService.startNattKeepaliveWithFd(this.mNetwork, this.mPfd, this.mResourceId, intervalSec, this.mCallback, this.mSource.getHostAddress(), this.mDestination.getHostAddress(), automaticOnOffKeepalives, underpinnedNetwork);
            }
            catch (RemoteException e) {
                Log.e("SocketKeepalive", "Error starting socket keepalive: ", e);
                throw e.rethrowFromSystemServer();
            }
        });
    }

    @Override
    protected void stopImpl() {
        this.mExecutor.execute(() -> {
            try {
                this.mService.stopKeepalive(this.mCallback);
            }
            catch (RemoteException e) {
                Log.e("SocketKeepalive", "Error stopping socket keepalive: ", e);
                throw e.rethrowFromSystemServer();
            }
        });
    }
}

