/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.android.net;

import android.net.IConnectivityManager;
import android.net.Network;
import android.net.SocketKeepalive;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import java.util.concurrent.Executor;

public class TcpSocketKeepalive
extends SocketKeepalive {
    public TcpSocketKeepalive(IConnectivityManager service, Network network, ParcelFileDescriptor pfd, Executor executor, SocketKeepalive.Callback callback) {
        super(service, network, pfd, executor, callback);
    }

    @Override
    protected void startImpl(int intervalSec, int flags, Network underpinnedNetwork) {
        if (0 != flags) {
            throw new IllegalArgumentException("Illegal flag value for " + this.getClass().getSimpleName() + " : " + flags);
        }
        if (underpinnedNetwork != null) {
            throw new IllegalArgumentException("Illegal underpinned network for " + this.getClass().getSimpleName() + " : " + underpinnedNetwork);
        }
        this.mExecutor.execute(() -> {
            try {
                this.mService.startTcpKeepalive(this.mNetwork, this.mPfd, intervalSec, this.mCallback);
            }
            catch (RemoteException e) {
                Log.e("SocketKeepalive", "Error starting packet keepalive: ", e);
                throw e.rethrowFromSystemServer();
            }
        });
    }

    @Override
    protected void stopImpl() {
        this.mExecutor.execute(() -> {
            try {
                this.mService.stopKeepalive(this.mCallback);
            }
            catch (RemoteException e) {
                Log.e("SocketKeepalive", "Error stopping packet keepalive: ", e);
                throw e.rethrowFromSystemServer();
            }
        });
    }
}

