/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.com.android.net.module.util;

import android.util.ArrayMap;
import android.util.Pair;
import android.util.SparseArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> boolean isEmpty(T[] array2) {
        return array2 == null || array2.length == 0;
    }

    public static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static int[] toIntArray(Collection<Integer> list) {
        int[] array2 = new int[list.size()];
        int i = 0;
        for (Integer item : list) {
            array2[i] = item;
            ++i;
        }
        return array2;
    }

    public static long[] toLongArray(Collection<Long> list) {
        long[] array2 = new long[list.size()];
        int i = 0;
        for (Long item : list) {
            array2[i] = item;
            ++i;
        }
        return array2;
    }

    public static <T> boolean all(Collection<T> elem, Predicate<T> predicate) {
        for (T e : elem) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean any(Collection<T> elem, Predicate<T> predicate) {
        return CollectionUtils.indexOf(elem, predicate) >= 0;
    }

    public static <T> int indexOf(Collection<T> elem, Predicate<? super T> predicate) {
        int idx = 0;
        for (T e : elem) {
            if (predicate.test(e)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public static <T> boolean any(SparseArray<T> array2, Predicate<T> predicate) {
        for (int i = 0; i < array2.size(); ++i) {
            if (!predicate.test(array2.valueAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(short[] array2, short value) {
        if (array2 == null) {
            return false;
        }
        for (short element : array2) {
            if (element != value) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] array2, int value) {
        if (array2 == null) {
            return false;
        }
        for (int element : array2) {
            if (element != value) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean contains(T[] array2, T value) {
        return CollectionUtils.indexOf(array2, value) != -1;
    }

    public static <T> int indexOf(T[] array2, T value) {
        if (array2 == null) {
            return -1;
        }
        for (int i = 0; i < array2.length; ++i) {
            if (!Objects.equals(array2[i], value)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfSubArray(byte[] haystack, byte[] needle) {
        for (int i = 0; i < haystack.length - needle.length + 1; ++i) {
            boolean found = true;
            for (int j = 0; j < needle.length; ++j) {
                if (haystack[i + j] == needle[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    public static <T> ArrayList<T> filter(Collection<T> source, Predicate<T> test) {
        ArrayList<T> matches = new ArrayList<T>();
        for (T e : source) {
            if (!test.test(e)) continue;
            matches.add(e);
        }
        return matches;
    }

    public static long total(long[] array2) {
        long total = 0L;
        if (array2 != null) {
            for (long value : array2) {
                total += value;
            }
        }
        return total;
    }

    public static <T> boolean containsAny(Collection<T> haystack, Collection<? extends T> needles) {
        for (T needle : needles) {
            if (!haystack.contains(needle)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsAll(Collection<T> haystack, Collection<? extends T> needles) {
        return haystack.containsAll(needles);
    }

    public static <T> T findFirst(Collection<T> haystack, Predicate<? super T> condition) {
        for (T needle : haystack) {
            if (!condition.test(needle)) continue;
            return needle;
        }
        return null;
    }

    public static <T> T findLast(List<T> haystack, Predicate<? super T> condition) {
        for (int i = haystack.size() - 1; i >= 0; --i) {
            T needle = haystack.get(i);
            if (!condition.test(needle)) continue;
            return needle;
        }
        return null;
    }

    public static <T> boolean contains(Collection<T> haystack, Predicate<? super T> condition) {
        return -1 != CollectionUtils.indexOf(haystack, condition);
    }

    public static <T, R> ArrayList<R> map(Collection<T> source, Function<? super T, ? extends R> transform) {
        ArrayList<R> dest = new ArrayList<R>(source.size());
        for (T e : source) {
            dest.add(transform.apply(e));
        }
        return dest;
    }

    public static <T, R> ArrayList<Pair<T, R>> zip(List<T> first, List<R> second) {
        int size = first.size();
        if (size != second.size()) {
            throw new IllegalArgumentException("zip : collections must be the same size");
        }
        ArrayList<Pair<T, R>> dest = new ArrayList<Pair<T, R>>(size);
        for (int i = 0; i < size; ++i) {
            dest.add(new Pair<T, R>(first.get(i), second.get(i)));
        }
        return dest;
    }

    public static <T, R> ArrayMap<T, R> assoc(List<T> keys, List<R> values) {
        int size = keys.size();
        if (size != values.size()) {
            throw new IllegalArgumentException("assoc : collections must be the same size");
        }
        ArrayMap<T, R> dest = new ArrayMap<T, R>(size);
        for (int i = 0; i < size; ++i) {
            T key = keys.get(i);
            if (dest.containsKey(key)) {
                throw new IllegalArgumentException("assoc : keys may not contain the same value twice");
            }
            dest.put(key, values.get(i));
        }
        return dest;
    }
}

