/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.com.android.net.module.util;

import android.net.NetworkCapabilities;
import android.net.connectivity.com.android.net.module.util.BitUtils;
import android.net.connectivity.com.android.net.module.util.CollectionUtils;
import com.android.internal.annotations.VisibleForTesting;

public class NetworkCapabilitiesUtils {
    private static final int[] DISPLAY_TRANSPORT_PRIORITIES = new int[]{4, 0, 5, 2, 1, 3, 8};
    @VisibleForTesting
    public static final long RESTRICTED_CAPABILITIES = BitUtils.packBitList(31, 5, 2, 10, 29, 3, 7, 4, 23, 8, 27, 30, 9, 33);
    private static final long FORCE_RESTRICTED_CAPABILITIES = BitUtils.packBitList(29, 22, 26);
    @VisibleForTesting
    public static final long UNRESTRICTED_CAPABILITIES = BitUtils.packBitList(12, 0, 1, 6);

    public static int getDisplayTransport(int[] transports) {
        for (int transport : DISPLAY_TRANSPORT_PRIORITIES) {
            if (!CollectionUtils.contains(transports, transport)) continue;
            return transport;
        }
        if (transports.length < 1) {
            throw new IllegalArgumentException("No transport in the provided array");
        }
        return transports[0];
    }

    public static boolean inferRestrictedCapability(NetworkCapabilities nc) {
        for (int capability : BitUtils.unpackBits(FORCE_RESTRICTED_CAPABILITIES)) {
            if (!nc.hasCapability(capability)) continue;
            return true;
        }
        for (int capability : BitUtils.unpackBits(UNRESTRICTED_CAPABILITIES)) {
            if (!nc.hasCapability(capability)) continue;
            return false;
        }
        for (int capability : BitUtils.unpackBits(RESTRICTED_CAPABILITIES)) {
            if (!nc.hasCapability(capability)) continue;
            return true;
        }
        return false;
    }
}

