/*
 * Decompiled with CFR 0.152.
 */
package android.net.ipsec.ike.ike3gpp;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.net.ipsec.ike.IkeManager;
import com.android.internal.net.ipsec.ike.ike3gpp.Ike3gppDeviceIdentityUtils;
import java.util.Objects;

@SystemApi
public class Ike3gppParams {
    @SuppressLint(value={"NoByteOrShort"})
    public static final byte PDU_SESSION_ID_UNSET = 0;
    private final byte mPduSessionId;
    private final String mDeviceIdentity;

    private Ike3gppParams(byte pduSessionId, String deviceIdentity) {
        this.mPduSessionId = pduSessionId;
        this.mDeviceIdentity = deviceIdentity;
    }

    @SuppressLint(value={"NoByteOrShort"})
    public byte getPduSessionId() {
        return this.mPduSessionId;
    }

    public boolean hasPduSessionId() {
        return this.mPduSessionId != 0;
    }

    public String getMobileDeviceIdentity() {
        return this.mDeviceIdentity;
    }

    public int hashCode() {
        return Objects.hash(this.mPduSessionId, this.mDeviceIdentity);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Ike3gppParams)) {
            return false;
        }
        Ike3gppParams that = (Ike3gppParams)o;
        return this.mPduSessionId == that.mPduSessionId && Objects.equals(this.mDeviceIdentity, that.mDeviceIdentity);
    }

    public String toString() {
        return "Ike3gppParams={ " + "mPduSessionId=" + String.format("%02X ", this.mPduSessionId) + "mDeviceIdentity=" + IkeManager.getIkeLog().pii(String.format("%16s ", this.mDeviceIdentity)) + " }";
    }

    public static class Builder {
        private byte mPduSessionId = 0;
        private String mDeviceIdentity;

        public Builder setPduSessionId(@SuppressLint(value={"NoByteOrShort"}) byte pduSessionId) {
            this.mPduSessionId = pduSessionId;
            return this;
        }

        public Builder setMobileDeviceIdentity(String deviceIdentity) {
            this.mDeviceIdentity = deviceIdentity;
            return this;
        }

        public Ike3gppParams build() {
            if (this.mDeviceIdentity != null && !Ike3gppDeviceIdentityUtils.isValidDeviceIdentity(this.mDeviceIdentity)) {
                throw new IllegalArgumentException("valid device identity should be 15 or 16 digits or set to null");
            }
            return new Ike3gppParams(this.mPduSessionId, this.mDeviceIdentity);
        }
    }
}

