/*
 * Decompiled with CFR 0.152.
 */
package android.net.netstats.provider;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface INetworkStatsProvider
extends IInterface {
    public static final String DESCRIPTOR = "android.net.netstats.provider.INetworkStatsProvider";

    public void onRequestStatsUpdate(int var1) throws RemoteException;

    public void onSetAlert(long var1) throws RemoteException;

    public void onSetWarningAndLimit(String var1, long var2, long var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INetworkStatsProvider {
        static final int TRANSACTION_onRequestStatsUpdate = 1;
        static final int TRANSACTION_onSetAlert = 2;
        static final int TRANSACTION_onSetWarningAndLimit = 3;

        public Stub() {
            this.attachInterface(this, INetworkStatsProvider.DESCRIPTOR);
        }

        public static INetworkStatsProvider asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(INetworkStatsProvider.DESCRIPTOR);
            if (iin != null && iin instanceof INetworkStatsProvider) {
                return (INetworkStatsProvider)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onRequestStatsUpdate";
                }
                case 2: {
                    return "onSetAlert";
                }
                case 3: {
                    return "onSetWarningAndLimit";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = INetworkStatsProvider.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestStatsUpdate(_arg0);
                    break;
                }
                case 2: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onSetAlert(_arg0);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onSetWarningAndLimit(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements INetworkStatsProvider {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return INetworkStatsProvider.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestStatsUpdate(int token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(INetworkStatsProvider.DESCRIPTOR);
                    _data.writeInt(token);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSetAlert(long quotaBytes) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(INetworkStatsProvider.DESCRIPTOR);
                    _data.writeLong(quotaBytes);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSetWarningAndLimit(String iface, long warningBytes, long limitBytes) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(INetworkStatsProvider.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeLong(warningBytes);
                    _data.writeLong(limitBytes);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INetworkStatsProvider {
        @Override
        public void onRequestStatsUpdate(int token) throws RemoteException {
        }

        @Override
        public void onSetAlert(long quotaBytes) throws RemoteException {
        }

        @Override
        public void onSetWarningAndLimit(String iface, long warningBytes, long limitBytes) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

