/*
 * Decompiled with CFR 0.152.
 */
package android.net.netstats.provider;

import android.net.NetworkStats;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface INetworkStatsProviderCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.netstats.provider.INetworkStatsProviderCallback";

    public void notifyStatsUpdated(int var1, NetworkStats var2, NetworkStats var3) throws RemoteException;

    public void notifyAlertReached() throws RemoteException;

    public void notifyWarningReached() throws RemoteException;

    public void notifyLimitReached() throws RemoteException;

    public void unregister() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INetworkStatsProviderCallback {
        static final int TRANSACTION_notifyStatsUpdated = 1;
        static final int TRANSACTION_notifyAlertReached = 2;
        static final int TRANSACTION_notifyWarningReached = 3;
        static final int TRANSACTION_notifyLimitReached = 4;
        static final int TRANSACTION_unregister = 5;

        public Stub() {
            this.attachInterface(this, INetworkStatsProviderCallback.DESCRIPTOR);
        }

        public static INetworkStatsProviderCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(INetworkStatsProviderCallback.DESCRIPTOR);
            if (iin != null && iin instanceof INetworkStatsProviderCallback) {
                return (INetworkStatsProviderCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "notifyStatsUpdated";
                }
                case 2: {
                    return "notifyAlertReached";
                }
                case 3: {
                    return "notifyWarningReached";
                }
                case 4: {
                    return "notifyLimitReached";
                }
                case 5: {
                    return "unregister";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = INetworkStatsProviderCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    NetworkStats _arg1 = data.readTypedObject(NetworkStats.CREATOR);
                    NetworkStats _arg2 = data.readTypedObject(NetworkStats.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyStatsUpdated(_arg0, _arg1, _arg2);
                    break;
                }
                case 2: {
                    this.notifyAlertReached();
                    break;
                }
                case 3: {
                    this.notifyWarningReached();
                    break;
                }
                case 4: {
                    this.notifyLimitReached();
                    break;
                }
                case 5: {
                    this.unregister();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements INetworkStatsProviderCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return INetworkStatsProviderCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyStatsUpdated(int token, NetworkStats ifaceStats, NetworkStats uidStats) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(INetworkStatsProviderCallback.DESCRIPTOR);
                    _data.writeInt(token);
                    _data.writeTypedObject(ifaceStats, 0);
                    _data.writeTypedObject(uidStats, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void notifyAlertReached() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(INetworkStatsProviderCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void notifyWarningReached() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(INetworkStatsProviderCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void notifyLimitReached() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(INetworkStatsProviderCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void unregister() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(INetworkStatsProviderCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INetworkStatsProviderCallback {
        @Override
        public void notifyStatsUpdated(int token, NetworkStats ifaceStats, NetworkStats uidStats) throws RemoteException {
        }

        @Override
        public void notifyAlertReached() throws RemoteException {
        }

        @Override
        public void notifyWarningReached() throws RemoteException {
        }

        @Override
        public void notifyLimitReached() throws RemoteException {
        }

        @Override
        public void unregister() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

