/*
 * Decompiled with CFR 0.152.
 */
package android.net.nsd;

import android.net.connectivity.android.net.nsd.INsdManagerCallback;
import android.net.connectivity.android.net.nsd.INsdServiceConnector;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface INsdManager
extends IInterface {
    public INsdServiceConnector connect(INsdManagerCallback var1, boolean var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INsdManager {
        public static final String DESCRIPTOR = "android.net.nsd.INsdManager";
        static final int TRANSACTION_connect = 1;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static INsdManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof INsdManager) {
                return (INsdManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "connect";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    INsdManagerCallback _arg0 = INsdManagerCallback.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    INsdServiceConnector _result = this.connect(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements INsdManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public INsdServiceConnector connect(INsdManagerCallback cb, boolean useJavaBackend) throws RemoteException {
                INsdServiceConnector _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    _data.writeBoolean(useJavaBackend);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = INsdServiceConnector.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements INsdManager {
        @Override
        public INsdServiceConnector connect(INsdManagerCallback cb, boolean useJavaBackend) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

