/*
 * Decompiled with CFR 0.152.
 */
package android.net.nsd;

import android.compat.annotation.UnsupportedAppUsage;
import android.net.Network;
import android.net.connectivity.com.android.net.module.util.InetAddressUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class NsdServiceInfo
implements Parcelable {
    private static final String TAG = "NsdServiceInfo";
    private String mServiceName;
    private String mServiceType;
    private final ArrayMap<String, byte[]> mTxtRecord = new ArrayMap();
    private final List<InetAddress> mHostAddresses = new ArrayList<InetAddress>();
    private int mPort;
    private Network mNetwork;
    private int mInterfaceIndex;
    public static final Parcelable.Creator<NsdServiceInfo> CREATOR = new Parcelable.Creator<NsdServiceInfo>(){

        @Override
        public NsdServiceInfo createFromParcel(Parcel in) {
            NsdServiceInfo info = new NsdServiceInfo();
            info.mServiceName = in.readString();
            info.mServiceType = in.readString();
            info.mPort = in.readInt();
            int recordCount = in.readInt();
            for (int i = 0; i < recordCount; ++i) {
                byte[] valueArray = null;
                if (in.readInt() == 1) {
                    int valueLength = in.readInt();
                    valueArray = new byte[valueLength];
                    in.readByteArray(valueArray);
                }
                info.mTxtRecord.put(in.readString(), valueArray);
            }
            info.mNetwork = in.readParcelable(null, Network.class);
            info.mInterfaceIndex = in.readInt();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                info.mHostAddresses.add(InetAddressUtils.unparcelInetAddress(in));
            }
            return info;
        }

        public NsdServiceInfo[] newArray(int size) {
            return new NsdServiceInfo[size];
        }
    };

    public NsdServiceInfo() {
    }

    public NsdServiceInfo(String sn, String rt) {
        this.mServiceName = sn;
        this.mServiceType = rt;
    }

    public String getServiceName() {
        return this.mServiceName;
    }

    public void setServiceName(String s) {
        this.mServiceName = s;
    }

    public String getServiceType() {
        return this.mServiceType;
    }

    public void setServiceType(String s) {
        this.mServiceType = s;
    }

    @Deprecated
    public InetAddress getHost() {
        return this.mHostAddresses.size() == 0 ? null : this.mHostAddresses.get(0);
    }

    @Deprecated
    public void setHost(InetAddress s) {
        this.setHostAddresses(Collections.singletonList(s));
    }

    public int getPort() {
        return this.mPort;
    }

    public void setPort(int p) {
        this.mPort = p;
    }

    public List<InetAddress> getHostAddresses() {
        return new ArrayList<InetAddress>(this.mHostAddresses);
    }

    public void setHostAddresses(List<InetAddress> addresses) {
        this.mHostAddresses.clear();
        this.mHostAddresses.addAll(addresses);
    }

    public void setTxtRecords(byte[] txtRecordsRawBytes) {
        int recordLen;
        for (int pos = 0; pos < txtRecordsRawBytes.length; pos += recordLen) {
            recordLen = txtRecordsRawBytes[pos] & 0xFF;
            ++pos;
            try {
                if (recordLen == 0) {
                    throw new IllegalArgumentException("Zero sized txt record");
                }
                if (pos + recordLen > txtRecordsRawBytes.length) {
                    Log.w(TAG, "Corrupt record length (pos = " + pos + "): " + recordLen);
                    recordLen = txtRecordsRawBytes.length - pos;
                }
                String key = null;
                byte[] value = null;
                int valueLen = 0;
                for (int i = pos; i < pos + recordLen; ++i) {
                    if (key == null) {
                        if (txtRecordsRawBytes[i] != 61) continue;
                        key = new String(txtRecordsRawBytes, pos, i - pos, StandardCharsets.US_ASCII);
                        continue;
                    }
                    if (value == null) {
                        value = new byte[recordLen - key.length() - 1];
                    }
                    value[valueLen] = txtRecordsRawBytes[i];
                    ++valueLen;
                }
                if (key == null) {
                    key = new String(txtRecordsRawBytes, pos, recordLen, StandardCharsets.US_ASCII);
                }
                if (TextUtils.isEmpty(key)) {
                    throw new IllegalArgumentException("Invalid txt record (key is empty)");
                }
                if (this.getAttributes().containsKey(key)) {
                    throw new IllegalArgumentException("Invalid txt record (duplicate key \"" + key + "\")");
                }
                this.setAttribute(key, value);
                continue;
            }
            catch (IllegalArgumentException e) {
                Log.e(TAG, "While parsing txt records (pos = " + pos + "): " + e.getMessage());
            }
        }
    }

    @UnsupportedAppUsage
    public void setAttribute(String key, byte[] value) {
        int txtRecordSize;
        int futureSize;
        if (TextUtils.isEmpty(key)) {
            throw new IllegalArgumentException("Key cannot be empty");
        }
        for (int i = 0; i < key.length(); ++i) {
            char character = key.charAt(i);
            if (character < ' ' || character > '~') {
                throw new IllegalArgumentException("Key strings must be printable US-ASCII");
            }
            if (character != '=') continue;
            throw new IllegalArgumentException("Key strings must not include '='");
        }
        if (key.length() + (value == null ? 0 : value.length) >= 255) {
            throw new IllegalArgumentException("Key length + value length must be < 255 bytes");
        }
        if (key.length() > 9) {
            Log.w(TAG, "Key lengths > 9 are discouraged: " + key);
        }
        if ((futureSize = (txtRecordSize = this.getTxtRecordSize()) + key.length() + (value == null ? 0 : value.length) + 2) > 1300) {
            throw new IllegalArgumentException("Total length of attributes must be < 1300 bytes");
        }
        if (futureSize > 400) {
            Log.w(TAG, "Total length of all attributes exceeds 400 bytes; truncation may occur");
        }
        this.mTxtRecord.put(key, value);
    }

    public void setAttribute(String key, String value) {
        try {
            this.setAttribute(key, value == null ? (byte[])null : value.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Value must be UTF-8");
        }
    }

    public void removeAttribute(String key) {
        this.mTxtRecord.remove(key);
    }

    public Map<String, byte[]> getAttributes() {
        return Collections.unmodifiableMap(this.mTxtRecord);
    }

    private int getTxtRecordSize() {
        int txtRecordSize = 0;
        for (Map.Entry<String, byte[]> entry : this.mTxtRecord.entrySet()) {
            txtRecordSize += 2;
            txtRecordSize += entry.getKey().length();
            byte[] value = entry.getValue();
            txtRecordSize += value == null ? 0 : value.length;
        }
        return txtRecordSize;
    }

    public byte[] getTxtRecord() {
        int txtRecordSize = this.getTxtRecordSize();
        if (txtRecordSize == 0) {
            return new byte[0];
        }
        byte[] txtRecord = new byte[txtRecordSize];
        int ptr = 0;
        for (Map.Entry<String, byte[]> entry : this.mTxtRecord.entrySet()) {
            String key = entry.getKey();
            byte[] value = entry.getValue();
            txtRecord[ptr++] = (byte)(key.length() + (value == null ? 0 : value.length) + 1);
            System.arraycopy(key.getBytes(StandardCharsets.US_ASCII), 0, txtRecord, ptr, key.length());
            ptr += key.length();
            txtRecord[ptr++] = 61;
            if (value == null) continue;
            System.arraycopy(value, 0, txtRecord, ptr, value.length);
            ptr += value.length;
        }
        return txtRecord;
    }

    public Network getNetwork() {
        return this.mNetwork;
    }

    public void setNetwork(Network network) {
        this.mNetwork = network;
    }

    public int getInterfaceIndex() {
        return this.mInterfaceIndex;
    }

    public void setInterfaceIndex(int interfaceIndex) {
        this.mInterfaceIndex = interfaceIndex;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name: ").append(this.mServiceName).append(", type: ").append(this.mServiceType).append(", hostAddresses: ").append(TextUtils.join((CharSequence)", ", this.mHostAddresses)).append(", port: ").append(this.mPort).append(", network: ").append(this.mNetwork);
        byte[] txtRecord = this.getTxtRecord();
        sb.append(", txtRecord: ").append(new String(txtRecord, StandardCharsets.UTF_8));
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mServiceName);
        dest.writeString(this.mServiceType);
        dest.writeInt(this.mPort);
        dest.writeInt(this.mTxtRecord.size());
        for (String key : this.mTxtRecord.keySet()) {
            byte[] value = this.mTxtRecord.get(key);
            if (value != null) {
                dest.writeInt(1);
                dest.writeInt(value.length);
                dest.writeByteArray(value);
            } else {
                dest.writeInt(0);
            }
            dest.writeString(key);
        }
        dest.writeParcelable(this.mNetwork, 0);
        dest.writeInt(this.mInterfaceIndex);
        dest.writeInt(this.mHostAddresses.size());
        for (InetAddress address : this.mHostAddresses) {
            InetAddressUtils.parcelInetAddress(dest, address, flags);
        }
    }
}

