/*
 * Decompiled with CFR 0.152.
 */
package android.net.vcn;

import android.content.Context;
import android.net.vcn.VcnGatewayConnectionConfig;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import com.android.server.vcn.repackaged.util.PersistableBundleUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public class VcnConfig
implements Parcelable {
    private static final String TAG = VcnConfig.class.getSimpleName();
    private static final Set<Integer> ALLOWED_TRANSPORTS = new ArraySet<Integer>();
    private static final String PACKAGE_NAME_KEY = "mPackageName";
    private final String mPackageName;
    private static final String GATEWAY_CONNECTION_CONFIGS_KEY = "mGatewayConnectionConfigs";
    private final Set<VcnGatewayConnectionConfig> mGatewayConnectionConfigs;
    private static final Set<Integer> RESTRICTED_TRANSPORTS_DEFAULT;
    private static final String RESTRICTED_TRANSPORTS_KEY = "mRestrictedTransports";
    private final Set<Integer> mRestrictedTransports;
    private static final String IS_TEST_MODE_PROFILE_KEY = "mIsTestModeProfile";
    private final boolean mIsTestModeProfile;
    public static final Parcelable.Creator<VcnConfig> CREATOR;

    private VcnConfig(String packageName, Set<VcnGatewayConnectionConfig> gatewayConnectionConfigs, Set<Integer> restrictedTransports, boolean isTestModeProfile) {
        this.mPackageName = packageName;
        this.mGatewayConnectionConfigs = Collections.unmodifiableSet(new ArraySet<VcnGatewayConnectionConfig>(gatewayConnectionConfigs));
        this.mRestrictedTransports = Collections.unmodifiableSet(new ArraySet<Integer>(restrictedTransports));
        this.mIsTestModeProfile = isTestModeProfile;
        this.validate();
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public VcnConfig(PersistableBundle in) {
        this.mPackageName = in.getString(PACKAGE_NAME_KEY);
        PersistableBundle gatewayConnectionConfigsBundle = in.getPersistableBundle(GATEWAY_CONNECTION_CONFIGS_KEY);
        this.mGatewayConnectionConfigs = new ArraySet<VcnGatewayConnectionConfig>(PersistableBundleUtils.toList(gatewayConnectionConfigsBundle, VcnGatewayConnectionConfig::new));
        PersistableBundle restrictedTransportsBundle = in.getPersistableBundle(RESTRICTED_TRANSPORTS_KEY);
        this.mRestrictedTransports = restrictedTransportsBundle == null ? RESTRICTED_TRANSPORTS_DEFAULT : new ArraySet<Integer>(PersistableBundleUtils.toList(restrictedTransportsBundle, PersistableBundleUtils.INTEGER_DESERIALIZER));
        this.mIsTestModeProfile = in.getBoolean(IS_TEST_MODE_PROFILE_KEY);
        this.validate();
    }

    private void validate() {
        Objects.requireNonNull(this.mPackageName, "packageName was null");
        Preconditions.checkCollectionNotEmpty(this.mGatewayConnectionConfigs, "gatewayConnectionConfigs was empty");
        Iterator<Integer> iterator = this.mRestrictedTransports.iterator();
        while (iterator.hasNext()) {
            int transport = iterator.next();
            if (!ALLOWED_TRANSPORTS.contains(transport)) {
                iterator.remove();
                Log.w(TAG, "Found invalid transport " + transport + " which might be from a new version of VcnConfig");
            }
            if (transport != 7 || this.mIsTestModeProfile) continue;
            throw new IllegalArgumentException("Found TRANSPORT_TEST in a non-test-mode profile");
        }
    }

    public String getProvisioningPackageName() {
        return this.mPackageName;
    }

    public Set<VcnGatewayConnectionConfig> getGatewayConnectionConfigs() {
        return Collections.unmodifiableSet(this.mGatewayConnectionConfigs);
    }

    public Set<Integer> getRestrictedUnderlyingNetworkTransports() {
        return Collections.unmodifiableSet(this.mRestrictedTransports);
    }

    public boolean isTestModeProfile() {
        return this.mIsTestModeProfile;
    }

    public PersistableBundle toPersistableBundle() {
        PersistableBundle result = new PersistableBundle();
        result.putString(PACKAGE_NAME_KEY, this.mPackageName);
        PersistableBundle gatewayConnectionConfigsBundle = PersistableBundleUtils.fromList(new ArrayList<VcnGatewayConnectionConfig>(this.mGatewayConnectionConfigs), VcnGatewayConnectionConfig::toPersistableBundle);
        result.putPersistableBundle(GATEWAY_CONNECTION_CONFIGS_KEY, gatewayConnectionConfigsBundle);
        PersistableBundle restrictedTransportsBundle = PersistableBundleUtils.fromList(new ArrayList<Integer>(this.mRestrictedTransports), PersistableBundleUtils.INTEGER_SERIALIZER);
        result.putPersistableBundle(RESTRICTED_TRANSPORTS_KEY, restrictedTransportsBundle);
        result.putBoolean(IS_TEST_MODE_PROFILE_KEY, this.mIsTestModeProfile);
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.mPackageName, this.mGatewayConnectionConfigs, this.mRestrictedTransports, this.mIsTestModeProfile);
    }

    public boolean equals(Object other) {
        if (!(other instanceof VcnConfig)) {
            return false;
        }
        VcnConfig rhs = (VcnConfig)other;
        return this.mPackageName.equals(rhs.mPackageName) && this.mGatewayConnectionConfigs.equals(rhs.mGatewayConnectionConfigs) && this.mRestrictedTransports.equals(rhs.mRestrictedTransports) && this.mIsTestModeProfile == rhs.mIsTestModeProfile;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(this.toPersistableBundle(), flags);
    }

    static {
        ALLOWED_TRANSPORTS.add(1);
        ALLOWED_TRANSPORTS.add(0);
        ALLOWED_TRANSPORTS.add(7);
        RESTRICTED_TRANSPORTS_DEFAULT = Collections.singleton(1);
        CREATOR = new Parcelable.Creator<VcnConfig>(){

            @Override
            public VcnConfig createFromParcel(Parcel in) {
                return new VcnConfig(in.readParcelable(null, PersistableBundle.class));
            }

            public VcnConfig[] newArray(int size) {
                return new VcnConfig[size];
            }
        };
    }

    public static class Builder {
        private final String mPackageName;
        private final Set<VcnGatewayConnectionConfig> mGatewayConnectionConfigs = new ArraySet<VcnGatewayConnectionConfig>();
        private final Set<Integer> mRestrictedTransports = new ArraySet<Integer>();
        private boolean mIsTestModeProfile = false;

        public Builder(Context context) {
            Objects.requireNonNull(context, "context was null");
            this.mPackageName = context.getOpPackageName();
            this.mRestrictedTransports.addAll(RESTRICTED_TRANSPORTS_DEFAULT);
        }

        public Builder addGatewayConnectionConfig(VcnGatewayConnectionConfig gatewayConnectionConfig) {
            Objects.requireNonNull(gatewayConnectionConfig, "gatewayConnectionConfig was null");
            for (VcnGatewayConnectionConfig vcnGatewayConnectionConfig : this.mGatewayConnectionConfigs) {
                if (!vcnGatewayConnectionConfig.getGatewayConnectionName().equals(gatewayConnectionConfig.getGatewayConnectionName())) continue;
                throw new IllegalArgumentException("GatewayConnection for specified name already exists");
            }
            this.mGatewayConnectionConfigs.add(gatewayConnectionConfig);
            return this;
        }

        private void validateRestrictedTransportsOrThrow(Set<Integer> restrictedTransports) {
            Objects.requireNonNull(restrictedTransports, "transports was null");
            for (int transport : restrictedTransports) {
                if (ALLOWED_TRANSPORTS.contains(transport)) continue;
                throw new IllegalArgumentException("Invalid transport " + transport);
            }
        }

        public Builder setRestrictedUnderlyingNetworkTransports(Set<Integer> transports) {
            this.validateRestrictedTransportsOrThrow(transports);
            this.mRestrictedTransports.clear();
            this.mRestrictedTransports.addAll(transports);
            return this;
        }

        public Builder setIsTestModeProfile() {
            this.mIsTestModeProfile = true;
            return this;
        }

        public VcnConfig build() {
            return new VcnConfig(this.mPackageName, this.mGatewayConnectionConfigs, this.mRestrictedTransports, this.mIsTestModeProfile);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface VcnUnderlyingNetworkTransport {
    }
}

