/*
 * Decompiled with CFR 0.152.
 */
package android.net.vcn;

import android.annotation.SuppressLint;
import android.net.vcn.VcnUnderlyingNetworkTemplate;
import android.os.PersistableBundle;
import android.util.ArraySet;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.vcn.repackaged.util.PersistableBundleUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class VcnWifiUnderlyingNetworkTemplate
extends VcnUnderlyingNetworkTemplate {
    private static final String SSIDS_KEY = "mSsids";
    private final Set<String> mSsids;

    private VcnWifiUnderlyingNetworkTemplate(int meteredMatchCriteria, int minEntryUpstreamBandwidthKbps, int minExitUpstreamBandwidthKbps, int minEntryDownstreamBandwidthKbps, int minExitDownstreamBandwidthKbps, Set<String> ssids) {
        super(1, meteredMatchCriteria, minEntryUpstreamBandwidthKbps, minExitUpstreamBandwidthKbps, minEntryDownstreamBandwidthKbps, minExitDownstreamBandwidthKbps);
        this.mSsids = new ArraySet<String>(ssids);
        this.validate();
    }

    @Override
    protected void validate() {
        super.validate();
        VcnWifiUnderlyingNetworkTemplate.validateSsids(this.mSsids);
    }

    private static void validateSsids(Set<String> ssids) {
        Objects.requireNonNull(ssids, "ssids is null");
        for (String ssid : ssids) {
            Objects.requireNonNull(ssid, "found null value ssid");
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PROTECTED)
    public static VcnWifiUnderlyingNetworkTemplate fromPersistableBundle(PersistableBundle in) {
        Objects.requireNonNull(in, "PersistableBundle is null");
        int meteredMatchCriteria = in.getInt("mMeteredMatchCriteria");
        int minEntryUpstreamBandwidthKbps = in.getInt("mMinEntryUpstreamBandwidthKbps", 0);
        int minExitUpstreamBandwidthKbps = in.getInt("mMinExitUpstreamBandwidthKbps", 0);
        int minEntryDownstreamBandwidthKbps = in.getInt("mMinEntryDownstreamBandwidthKbps", 0);
        int minExitDownstreamBandwidthKbps = in.getInt("mMinExitDownstreamBandwidthKbps", 0);
        PersistableBundle ssidsBundle = in.getPersistableBundle(SSIDS_KEY);
        Objects.requireNonNull(ssidsBundle, "ssidsBundle is null");
        ArraySet<String> ssids = new ArraySet<String>(PersistableBundleUtils.toList(ssidsBundle, PersistableBundleUtils.STRING_DESERIALIZER));
        return new VcnWifiUnderlyingNetworkTemplate(meteredMatchCriteria, minEntryUpstreamBandwidthKbps, minExitUpstreamBandwidthKbps, minEntryDownstreamBandwidthKbps, minExitDownstreamBandwidthKbps, ssids);
    }

    @Override
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PROTECTED)
    public PersistableBundle toPersistableBundle() {
        PersistableBundle result = super.toPersistableBundle();
        PersistableBundle ssidsBundle = PersistableBundleUtils.fromList(new ArrayList<String>(this.mSsids), PersistableBundleUtils.STRING_SERIALIZER);
        result.putPersistableBundle(SSIDS_KEY, ssidsBundle);
        return result;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mSsids);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof VcnWifiUnderlyingNetworkTemplate)) {
            return false;
        }
        VcnWifiUnderlyingNetworkTemplate rhs = (VcnWifiUnderlyingNetworkTemplate)other;
        return this.mSsids.equals(rhs.mSsids);
    }

    @Override
    void dumpTransportSpecificFields(IndentingPrintWriter pw) {
        if (!this.mSsids.isEmpty()) {
            pw.println("mSsids: " + this.mSsids);
        }
    }

    public Set<String> getSsids() {
        return Collections.unmodifiableSet(this.mSsids);
    }

    @Override
    public Map<Integer, Integer> getCapabilitiesMatchCriteria() {
        return Collections.singletonMap(12, 1);
    }

    public static class Builder {
        private int mMeteredMatchCriteria = 0;
        private final Set<String> mSsids = new ArraySet<String>();
        private int mMinEntryUpstreamBandwidthKbps = 0;
        private int mMinExitUpstreamBandwidthKbps = 0;
        private int mMinEntryDownstreamBandwidthKbps = 0;
        private int mMinExitDownstreamBandwidthKbps = 0;

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setMetered(int matchCriteria) {
            VcnUnderlyingNetworkTemplate.validateMatchCriteria(matchCriteria, "setMetered");
            this.mMeteredMatchCriteria = matchCriteria;
            return this;
        }

        public Builder setSsids(Set<String> ssids) {
            VcnWifiUnderlyingNetworkTemplate.validateSsids(ssids);
            this.mSsids.clear();
            this.mSsids.addAll(ssids);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setMinUpstreamBandwidthKbps(int minEntryUpstreamBandwidthKbps, int minExitUpstreamBandwidthKbps) {
            VcnUnderlyingNetworkTemplate.validateMinBandwidthKbps(minEntryUpstreamBandwidthKbps, minExitUpstreamBandwidthKbps);
            this.mMinEntryUpstreamBandwidthKbps = minEntryUpstreamBandwidthKbps;
            this.mMinExitUpstreamBandwidthKbps = minExitUpstreamBandwidthKbps;
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setMinDownstreamBandwidthKbps(int minEntryDownstreamBandwidthKbps, int minExitDownstreamBandwidthKbps) {
            VcnUnderlyingNetworkTemplate.validateMinBandwidthKbps(minEntryDownstreamBandwidthKbps, minExitDownstreamBandwidthKbps);
            this.mMinEntryDownstreamBandwidthKbps = minEntryDownstreamBandwidthKbps;
            this.mMinExitDownstreamBandwidthKbps = minExitDownstreamBandwidthKbps;
            return this;
        }

        public VcnWifiUnderlyingNetworkTemplate build() {
            return new VcnWifiUnderlyingNetworkTemplate(this.mMeteredMatchCriteria, this.mMinEntryUpstreamBandwidthKbps, this.mMinExitUpstreamBandwidthKbps, this.mMinEntryDownstreamBandwidthKbps, this.mMinExitDownstreamBandwidthKbps, this.mSsids);
        }
    }
}

