/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.wifi.CoexUnsafeChannel;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface ICoexCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.ICoexCallback";

    public void onCoexUnsafeChannelsChanged(List<CoexUnsafeChannel> var1, int var2) throws RemoteException;

    public static class _Parcel {
        private static <T extends Parcelable> void writeTypedList(Parcel parcel, List<T> value, int parcelableFlags) {
            if (value == null) {
                parcel.writeInt(-1);
            } else {
                int N = value.size();
                parcel.writeInt(N);
                for (int i = 0; i < N; ++i) {
                    parcel.writeTypedObject((Parcelable)value.get(i), parcelableFlags);
                }
            }
        }
    }

    public static abstract class Stub
    extends Binder
    implements ICoexCallback {
        static final int TRANSACTION_onCoexUnsafeChannelsChanged = 1;

        public Stub() {
            this.attachInterface(this, ICoexCallback.DESCRIPTOR);
        }

        public static ICoexCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ICoexCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ICoexCallback) {
                return (ICoexCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onCoexUnsafeChannelsChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ICoexCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    ArrayList<CoexUnsafeChannel> _arg0 = data.createTypedArrayList(CoexUnsafeChannel.CREATOR);
                    int _arg1 = data.readInt();
                    this.onCoexUnsafeChannelsChanged(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements ICoexCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ICoexCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCoexUnsafeChannelsChanged(List<CoexUnsafeChannel> unsafeChannels, int restrictions) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICoexCallback.DESCRIPTOR);
                    _Parcel.writeTypedList(_data, unsafeChannels, 0);
                    _data.writeInt(restrictions);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ICoexCallback {
        @Override
        public void onCoexUnsafeChannelsChanged(List<CoexUnsafeChannel> unsafeChannels, int restrictions) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

