/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IDppCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.IDppCallback";

    public void onSuccessConfigReceived(int var1) throws RemoteException;

    public void onSuccess(int var1) throws RemoteException;

    public void onFailure(int var1, String var2, String var3, int[] var4) throws RemoteException;

    public void onProgress(int var1) throws RemoteException;

    public void onBootstrapUriGenerated(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDppCallback {
        static final int TRANSACTION_onSuccessConfigReceived = 1;
        static final int TRANSACTION_onSuccess = 2;
        static final int TRANSACTION_onFailure = 3;
        static final int TRANSACTION_onProgress = 4;
        static final int TRANSACTION_onBootstrapUriGenerated = 5;

        public Stub() {
            this.attachInterface(this, IDppCallback.DESCRIPTOR);
        }

        public static IDppCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IDppCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IDppCallback) {
                return (IDppCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onSuccessConfigReceived";
                }
                case 2: {
                    return "onSuccess";
                }
                case 3: {
                    return "onFailure";
                }
                case 4: {
                    return "onProgress";
                }
                case 5: {
                    return "onBootstrapUriGenerated";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IDppCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    this.onSuccessConfigReceived(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    this.onSuccess(_arg0);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int[] _arg3 = data.createIntArray();
                    this.onFailure(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    this.onProgress(_arg0);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    this.onBootstrapUriGenerated(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements IDppCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IDppCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccessConfigReceived(int newNetworkId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDppCallback.DESCRIPTOR);
                    _data.writeInt(newNetworkId);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(int status) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDppCallback.DESCRIPTOR);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(int status, String ssid, String channelList, int[] bandArray) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDppCallback.DESCRIPTOR);
                    _data.writeInt(status);
                    _data.writeString(ssid);
                    _data.writeString(channelList);
                    _data.writeIntArray(bandArray);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onProgress(int status) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDppCallback.DESCRIPTOR);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBootstrapUriGenerated(String uri) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDppCallback.DESCRIPTOR);
                    _data.writeString(uri);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IDppCallback {
        @Override
        public void onSuccessConfigReceived(int newNetworkId) throws RemoteException {
        }

        @Override
        public void onSuccess(int status) throws RemoteException {
        }

        @Override
        public void onFailure(int status, String ssid, String channelList, int[] bandArray) throws RemoteException {
        }

        @Override
        public void onProgress(int status) throws RemoteException {
        }

        @Override
        public void onBootstrapUriGenerated(String uri) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

