/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.wifi.INetworkRequestUserSelectionCallback;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface INetworkRequestMatchCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.INetworkRequestMatchCallback";

    public void onUserSelectionCallbackRegistration(INetworkRequestUserSelectionCallback var1) throws RemoteException;

    public void onAbort() throws RemoteException;

    public void onMatch(List<ScanResult> var1) throws RemoteException;

    public void onUserSelectionConnectSuccess(WifiConfiguration var1) throws RemoteException;

    public void onUserSelectionConnectFailure(WifiConfiguration var1) throws RemoteException;

    public static class _Parcel {
        private static <T extends Parcelable> void writeTypedList(Parcel parcel, List<T> value, int parcelableFlags) {
            if (value == null) {
                parcel.writeInt(-1);
            } else {
                int N = value.size();
                parcel.writeInt(N);
                for (int i = 0; i < N; ++i) {
                    parcel.writeTypedObject((Parcelable)value.get(i), parcelableFlags);
                }
            }
        }
    }

    public static abstract class Stub
    extends Binder
    implements INetworkRequestMatchCallback {
        static final int TRANSACTION_onUserSelectionCallbackRegistration = 1;
        static final int TRANSACTION_onAbort = 2;
        static final int TRANSACTION_onMatch = 3;
        static final int TRANSACTION_onUserSelectionConnectSuccess = 4;
        static final int TRANSACTION_onUserSelectionConnectFailure = 5;

        public Stub() {
            this.attachInterface(this, INetworkRequestMatchCallback.DESCRIPTOR);
        }

        public static INetworkRequestMatchCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(INetworkRequestMatchCallback.DESCRIPTOR);
            if (iin != null && iin instanceof INetworkRequestMatchCallback) {
                return (INetworkRequestMatchCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onUserSelectionCallbackRegistration";
                }
                case 2: {
                    return "onAbort";
                }
                case 3: {
                    return "onMatch";
                }
                case 4: {
                    return "onUserSelectionConnectSuccess";
                }
                case 5: {
                    return "onUserSelectionConnectFailure";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = INetworkRequestMatchCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    INetworkRequestUserSelectionCallback _arg0 = INetworkRequestUserSelectionCallback.Stub.asInterface(data.readStrongBinder());
                    this.onUserSelectionCallbackRegistration(_arg0);
                    break;
                }
                case 2: {
                    this.onAbort();
                    break;
                }
                case 3: {
                    ArrayList<ScanResult> _arg0 = data.createTypedArrayList(ScanResult.CREATOR);
                    this.onMatch(_arg0);
                    break;
                }
                case 4: {
                    WifiConfiguration _arg0 = data.readTypedObject(WifiConfiguration.CREATOR);
                    this.onUserSelectionConnectSuccess(_arg0);
                    break;
                }
                case 5: {
                    WifiConfiguration _arg0 = data.readTypedObject(WifiConfiguration.CREATOR);
                    this.onUserSelectionConnectFailure(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements INetworkRequestMatchCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return INetworkRequestMatchCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUserSelectionCallbackRegistration(INetworkRequestUserSelectionCallback userSelectionCallback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkRequestMatchCallback.DESCRIPTOR);
                    _data.writeStrongInterface(userSelectionCallback);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onAbort() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkRequestMatchCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMatch(List<ScanResult> scanResults) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkRequestMatchCallback.DESCRIPTOR);
                    _Parcel.writeTypedList(_data, scanResults, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUserSelectionConnectSuccess(WifiConfiguration wificonfiguration) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkRequestMatchCallback.DESCRIPTOR);
                    _data.writeTypedObject(wificonfiguration, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUserSelectionConnectFailure(WifiConfiguration wificonfiguration) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkRequestMatchCallback.DESCRIPTOR);
                    _data.writeTypedObject(wificonfiguration, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INetworkRequestMatchCallback {
        @Override
        public void onUserSelectionCallbackRegistration(INetworkRequestUserSelectionCallback userSelectionCallback) throws RemoteException {
        }

        @Override
        public void onAbort() throws RemoteException {
        }

        @Override
        public void onMatch(List<ScanResult> scanResults) throws RemoteException {
        }

        @Override
        public void onUserSelectionConnectSuccess(WifiConfiguration wificonfiguration) throws RemoteException {
        }

        @Override
        public void onUserSelectionConnectFailure(WifiConfiguration wificonfiguration) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

