/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.wifi.WifiConfiguration;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface INetworkRequestUserSelectionCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.INetworkRequestUserSelectionCallback";

    public void select(WifiConfiguration var1) throws RemoteException;

    public void reject() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INetworkRequestUserSelectionCallback {
        static final int TRANSACTION_select = 1;
        static final int TRANSACTION_reject = 2;

        public Stub() {
            this.attachInterface(this, INetworkRequestUserSelectionCallback.DESCRIPTOR);
        }

        public static INetworkRequestUserSelectionCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(INetworkRequestUserSelectionCallback.DESCRIPTOR);
            if (iin != null && iin instanceof INetworkRequestUserSelectionCallback) {
                return (INetworkRequestUserSelectionCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "select";
                }
                case 2: {
                    return "reject";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = INetworkRequestUserSelectionCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    WifiConfiguration _arg0 = data.readTypedObject(WifiConfiguration.CREATOR);
                    this.select(_arg0);
                    break;
                }
                case 2: {
                    this.reject();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements INetworkRequestUserSelectionCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return INetworkRequestUserSelectionCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void select(WifiConfiguration wificonfiguration) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkRequestUserSelectionCallback.DESCRIPTOR);
                    _data.writeTypedObject(wificonfiguration, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void reject() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkRequestUserSelectionCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INetworkRequestUserSelectionCallback {
        @Override
        public void select(WifiConfiguration wificonfiguration) throws RemoteException {
        }

        @Override
        public void reject() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

