/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IScoreUpdateObserver
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.IScoreUpdateObserver";

    public void notifyScoreUpdate(int var1, int var2) throws RemoteException;

    public void triggerUpdateOfWifiUsabilityStats(int var1) throws RemoteException;

    public void notifyStatusUpdate(int var1, boolean var2) throws RemoteException;

    public void requestNudOperation(int var1) throws RemoteException;

    public void blocklistCurrentBssid(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IScoreUpdateObserver {
        static final int TRANSACTION_notifyScoreUpdate = 1;
        static final int TRANSACTION_triggerUpdateOfWifiUsabilityStats = 2;
        static final int TRANSACTION_notifyStatusUpdate = 3;
        static final int TRANSACTION_requestNudOperation = 4;
        static final int TRANSACTION_blocklistCurrentBssid = 5;

        public Stub() {
            this.attachInterface(this, IScoreUpdateObserver.DESCRIPTOR);
        }

        public static IScoreUpdateObserver asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IScoreUpdateObserver.DESCRIPTOR);
            if (iin != null && iin instanceof IScoreUpdateObserver) {
                return (IScoreUpdateObserver)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "notifyScoreUpdate";
                }
                case 2: {
                    return "triggerUpdateOfWifiUsabilityStats";
                }
                case 3: {
                    return "notifyStatusUpdate";
                }
                case 4: {
                    return "requestNudOperation";
                }
                case 5: {
                    return "blocklistCurrentBssid";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IScoreUpdateObserver.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.notifyScoreUpdate(_arg0, _arg1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    this.triggerUpdateOfWifiUsabilityStats(_arg0);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    this.notifyStatusUpdate(_arg0, _arg1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    this.requestNudOperation(_arg0);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    this.blocklistCurrentBssid(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements IScoreUpdateObserver {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IScoreUpdateObserver.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyScoreUpdate(int sessionId, int score) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScoreUpdateObserver.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeInt(score);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void triggerUpdateOfWifiUsabilityStats(int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScoreUpdateObserver.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyStatusUpdate(int sessionId, boolean isUsable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScoreUpdateObserver.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeBoolean(isUsable);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestNudOperation(int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScoreUpdateObserver.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void blocklistCurrentBssid(int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScoreUpdateObserver.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IScoreUpdateObserver {
        @Override
        public void notifyScoreUpdate(int sessionId, int score) throws RemoteException {
        }

        @Override
        public void triggerUpdateOfWifiUsabilityStats(int sessionId) throws RemoteException {
        }

        @Override
        public void notifyStatusUpdate(int sessionId, boolean isUsable) throws RemoteException {
        }

        @Override
        public void requestNudOperation(int sessionId) throws RemoteException {
        }

        @Override
        public void blocklistCurrentBssid(int sessionId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

