/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.compat.annotation.UnsupportedAppUsage;
import android.net.DhcpInfo;
import android.net.DhcpOption;
import android.net.Network;
import android.net.wifi.CoexUnsafeChannel;
import android.net.wifi.IActionListener;
import android.net.wifi.IBooleanListener;
import android.net.wifi.ICoexCallback;
import android.net.wifi.IDppCallback;
import android.net.wifi.IIntegerListener;
import android.net.wifi.IInterfaceCreationInfoCallback;
import android.net.wifi.ILastCallerListener;
import android.net.wifi.IListListener;
import android.net.wifi.ILocalOnlyConnectionStatusListener;
import android.net.wifi.ILocalOnlyHotspotCallback;
import android.net.wifi.INetworkRequestMatchCallback;
import android.net.wifi.IOnWifiActivityEnergyInfoListener;
import android.net.wifi.IOnWifiDriverCountryCodeChangedListener;
import android.net.wifi.IOnWifiUsabilityStatsListener;
import android.net.wifi.IPnoScanResultsCallback;
import android.net.wifi.IScanResultsCallback;
import android.net.wifi.ISoftApCallback;
import android.net.wifi.IStringListener;
import android.net.wifi.ISubsystemRestartCallback;
import android.net.wifi.ISuggestionConnectionStatusListener;
import android.net.wifi.ISuggestionUserApprovalStatusListener;
import android.net.wifi.ITrafficStateCallback;
import android.net.wifi.IWifiBandsListener;
import android.net.wifi.IWifiConnectedNetworkScorer;
import android.net.wifi.IWifiLowLatencyLockListener;
import android.net.wifi.IWifiNetworkSelectionConfigListener;
import android.net.wifi.IWifiNetworkStateChangedListener;
import android.net.wifi.IWifiVerboseLoggingStatusChangedListener;
import android.net.wifi.QosPolicyParams;
import android.net.wifi.ScanResult;
import android.net.wifi.SoftApConfiguration;
import android.net.wifi.WifiAvailableChannel;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiNetworkSelectionConfig;
import android.net.wifi.WifiNetworkSuggestion;
import android.net.wifi.WifiSsid;
import android.net.wifi.hotspot2.IProvisioningCallback;
import android.net.wifi.hotspot2.OsuProvider;
import android.net.wifi.hotspot2.PasspointConfiguration;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.WorkSource;
import com.android.wifi.x.com.android.modules.utils.ParceledListSlice;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface IWifiManager
extends IInterface {
    public long getSupportedFeatures() throws RemoteException;

    public void getWifiActivityEnergyInfoAsync(IOnWifiActivityEnergyInfoListener var1) throws RemoteException;

    public void setNetworkSelectionConfig(WifiNetworkSelectionConfig var1) throws RemoteException;

    public void getNetworkSelectionConfig(IWifiNetworkSelectionConfigListener var1) throws RemoteException;

    public void setThirdPartyAppEnablingWifiConfirmationDialogEnabled(boolean var1) throws RemoteException;

    public boolean isThirdPartyAppEnablingWifiConfirmationDialogEnabled() throws RemoteException;

    public void setScreenOnScanSchedule(int[] var1, int[] var2) throws RemoteException;

    public void setOneShotScreenOnConnectivityScanDelayMillis(int var1) throws RemoteException;

    public ParceledListSlice getConfiguredNetworks(String var1, String var2, boolean var3) throws RemoteException;

    public ParceledListSlice getPrivilegedConfiguredNetworks(String var1, String var2, Bundle var3) throws RemoteException;

    public WifiConfiguration getPrivilegedConnectedNetwork(String var1, String var2, Bundle var3) throws RemoteException;

    public Map getAllMatchingFqdnsForScanResults(List<ScanResult> var1) throws RemoteException;

    public void setSsidsAllowlist(String var1, List<WifiSsid> var2) throws RemoteException;

    public List getSsidsAllowlist(String var1) throws RemoteException;

    public Map getMatchingOsuProviders(List<ScanResult> var1) throws RemoteException;

    public Map getMatchingPasspointConfigsForOsuProviders(List<OsuProvider> var1) throws RemoteException;

    public int addOrUpdateNetwork(WifiConfiguration var1, String var2, Bundle var3) throws RemoteException;

    public WifiManager.AddNetworkResult addOrUpdateNetworkPrivileged(WifiConfiguration var1, String var2) throws RemoteException;

    public boolean addOrUpdatePasspointConfiguration(PasspointConfiguration var1, String var2) throws RemoteException;

    public boolean removePasspointConfiguration(String var1, String var2) throws RemoteException;

    public List<PasspointConfiguration> getPasspointConfigurations(String var1) throws RemoteException;

    public List<WifiConfiguration> getWifiConfigsForPasspointProfiles(List<String> var1) throws RemoteException;

    public void queryPasspointIcon(long var1, String var3) throws RemoteException;

    public int matchProviderWithCurrentNetwork(String var1) throws RemoteException;

    public boolean removeNetwork(int var1, String var2) throws RemoteException;

    public boolean removeNonCallerConfiguredNetworks(String var1) throws RemoteException;

    public boolean enableNetwork(int var1, boolean var2, String var3) throws RemoteException;

    public boolean disableNetwork(int var1, String var2) throws RemoteException;

    public void allowAutojoinGlobal(boolean var1, String var2, Bundle var3) throws RemoteException;

    public void queryAutojoinGlobal(IBooleanListener var1) throws RemoteException;

    public void allowAutojoin(int var1, boolean var2) throws RemoteException;

    public void allowAutojoinPasspoint(String var1, boolean var2) throws RemoteException;

    public void setMacRandomizationSettingPasspointEnabled(String var1, boolean var2) throws RemoteException;

    public void setPasspointMeteredOverride(String var1, int var2) throws RemoteException;

    public boolean startScan(String var1, String var2) throws RemoteException;

    public List<ScanResult> getScanResults(String var1, String var2) throws RemoteException;

    public void getChannelData(IListListener var1, String var2, Bundle var3) throws RemoteException;

    public boolean disconnect(String var1) throws RemoteException;

    public boolean reconnect(String var1) throws RemoteException;

    public boolean reassociate(String var1) throws RemoteException;

    public WifiInfo getConnectionInfo(String var1, String var2) throws RemoteException;

    public boolean setWifiEnabled(String var1, boolean var2) throws RemoteException;

    public int getWifiEnabledState() throws RemoteException;

    public void registerDriverCountryCodeChangedListener(IOnWifiDriverCountryCodeChangedListener var1, String var2, String var3) throws RemoteException;

    public void unregisterDriverCountryCodeChangedListener(IOnWifiDriverCountryCodeChangedListener var1) throws RemoteException;

    public void addWifiNetworkStateChangedListener(IWifiNetworkStateChangedListener var1) throws RemoteException;

    public void removeWifiNetworkStateChangedListener(IWifiNetworkStateChangedListener var1) throws RemoteException;

    public String getCountryCode(String var1, String var2) throws RemoteException;

    public void setOverrideCountryCode(String var1) throws RemoteException;

    public void clearOverrideCountryCode() throws RemoteException;

    public void setDefaultCountryCode(String var1) throws RemoteException;

    public boolean is24GHzBandSupported() throws RemoteException;

    public boolean is5GHzBandSupported() throws RemoteException;

    public boolean is6GHzBandSupported() throws RemoteException;

    public boolean is60GHzBandSupported() throws RemoteException;

    public boolean isWifiStandardSupported(int var1) throws RemoteException;

    public DhcpInfo getDhcpInfo(String var1) throws RemoteException;

    public void setScanAlwaysAvailable(boolean var1, String var2) throws RemoteException;

    public boolean isScanAlwaysAvailable() throws RemoteException;

    public boolean acquireWifiLock(IBinder var1, int var2, String var3, WorkSource var4) throws RemoteException;

    public void updateWifiLockWorkSource(IBinder var1, WorkSource var2) throws RemoteException;

    public boolean releaseWifiLock(IBinder var1) throws RemoteException;

    public void initializeMulticastFiltering() throws RemoteException;

    public boolean isMulticastEnabled() throws RemoteException;

    public void acquireMulticastLock(IBinder var1, String var2) throws RemoteException;

    public void releaseMulticastLock(String var1) throws RemoteException;

    public void updateInterfaceIpState(String var1, int var2) throws RemoteException;

    public boolean isDefaultCoexAlgorithmEnabled() throws RemoteException;

    public void setCoexUnsafeChannels(List<CoexUnsafeChannel> var1, int var2) throws RemoteException;

    public void registerCoexCallback(ICoexCallback var1) throws RemoteException;

    public void unregisterCoexCallback(ICoexCallback var1) throws RemoteException;

    public boolean startSoftAp(WifiConfiguration var1, String var2) throws RemoteException;

    public boolean startTetheredHotspot(SoftApConfiguration var1, String var2) throws RemoteException;

    public boolean stopSoftAp() throws RemoteException;

    public boolean validateSoftApConfiguration(SoftApConfiguration var1) throws RemoteException;

    public int startLocalOnlyHotspot(ILocalOnlyHotspotCallback var1, String var2, String var3, SoftApConfiguration var4, Bundle var5) throws RemoteException;

    public void stopLocalOnlyHotspot() throws RemoteException;

    public void registerLocalOnlyHotspotSoftApCallback(ISoftApCallback var1, Bundle var2) throws RemoteException;

    public void unregisterLocalOnlyHotspotSoftApCallback(ISoftApCallback var1, Bundle var2) throws RemoteException;

    public void startWatchLocalOnlyHotspot(ILocalOnlyHotspotCallback var1) throws RemoteException;

    public void stopWatchLocalOnlyHotspot() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="packages/modules/Wifi/framework/java/android/net/wifi/IWifiManager.aidl:246:1:246:25")
    public int getWifiApEnabledState() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="packages/modules/Wifi/framework/java/android/net/wifi/IWifiManager.aidl:249:1:249:25")
    public WifiConfiguration getWifiApConfiguration() throws RemoteException;

    public SoftApConfiguration getSoftApConfiguration() throws RemoteException;

    public void queryLastConfiguredTetheredApPassphraseSinceBoot(IStringListener var1) throws RemoteException;

    public boolean setWifiApConfiguration(WifiConfiguration var1, String var2) throws RemoteException;

    public boolean setSoftApConfiguration(SoftApConfiguration var1, String var2) throws RemoteException;

    public void notifyUserOfApBandConversion(String var1) throws RemoteException;

    public void enableTdls(String var1, boolean var2) throws RemoteException;

    public void enableTdlsWithRemoteIpAddress(String var1, boolean var2, IBooleanListener var3) throws RemoteException;

    public void enableTdlsWithMacAddress(String var1, boolean var2) throws RemoteException;

    public void enableTdlsWithRemoteMacAddress(String var1, boolean var2, IBooleanListener var3) throws RemoteException;

    public void isTdlsOperationCurrentlyAvailable(IBooleanListener var1) throws RemoteException;

    public void getMaxSupportedConcurrentTdlsSessions(IIntegerListener var1) throws RemoteException;

    public void getNumberOfEnabledTdlsSessions(IIntegerListener var1) throws RemoteException;

    public String getCurrentNetworkWpsNfcConfigurationToken() throws RemoteException;

    public void enableVerboseLogging(int var1) throws RemoteException;

    public int getVerboseLoggingLevel() throws RemoteException;

    public void disableEphemeralNetwork(String var1, String var2) throws RemoteException;

    public void factoryReset(String var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="packages/modules/Wifi/framework/java/android/net/wifi/IWifiManager.aidl:286:1:286:69")
    public Network getCurrentNetwork() throws RemoteException;

    public byte[] retrieveBackupData() throws RemoteException;

    public void restoreBackupData(byte[] var1) throws RemoteException;

    public byte[] retrieveSoftApBackupData() throws RemoteException;

    public SoftApConfiguration restoreSoftApBackupData(byte[] var1) throws RemoteException;

    public void restoreSupplicantBackupData(byte[] var1, byte[] var2) throws RemoteException;

    public void startSubscriptionProvisioning(OsuProvider var1, IProvisioningCallback var2) throws RemoteException;

    public void registerSoftApCallback(ISoftApCallback var1) throws RemoteException;

    public void unregisterSoftApCallback(ISoftApCallback var1) throws RemoteException;

    public void addWifiVerboseLoggingStatusChangedListener(IWifiVerboseLoggingStatusChangedListener var1) throws RemoteException;

    public void removeWifiVerboseLoggingStatusChangedListener(IWifiVerboseLoggingStatusChangedListener var1) throws RemoteException;

    public void addOnWifiUsabilityStatsListener(IOnWifiUsabilityStatsListener var1) throws RemoteException;

    public void removeOnWifiUsabilityStatsListener(IOnWifiUsabilityStatsListener var1) throws RemoteException;

    public void registerTrafficStateCallback(ITrafficStateCallback var1) throws RemoteException;

    public void unregisterTrafficStateCallback(ITrafficStateCallback var1) throws RemoteException;

    public void registerNetworkRequestMatchCallback(INetworkRequestMatchCallback var1) throws RemoteException;

    public void unregisterNetworkRequestMatchCallback(INetworkRequestMatchCallback var1) throws RemoteException;

    public int addNetworkSuggestions(List<WifiNetworkSuggestion> var1, String var2, String var3) throws RemoteException;

    public int removeNetworkSuggestions(List<WifiNetworkSuggestion> var1, String var2, int var3) throws RemoteException;

    public List<WifiNetworkSuggestion> getNetworkSuggestions(String var1) throws RemoteException;

    public String[] getFactoryMacAddresses() throws RemoteException;

    public void setDeviceMobilityState(int var1) throws RemoteException;

    public void startDppAsConfiguratorInitiator(IBinder var1, String var2, String var3, int var4, int var5, IDppCallback var6) throws RemoteException;

    public void startDppAsEnrolleeInitiator(IBinder var1, String var2, IDppCallback var3) throws RemoteException;

    public void startDppAsEnrolleeResponder(IBinder var1, String var2, int var3, IDppCallback var4) throws RemoteException;

    public void stopDppSession() throws RemoteException;

    public void updateWifiUsabilityScore(int var1, int var2, int var3) throws RemoteException;

    public void connect(WifiConfiguration var1, int var2, IActionListener var3, String var4) throws RemoteException;

    public void save(WifiConfiguration var1, IActionListener var2, String var3) throws RemoteException;

    public void forget(int var1, IActionListener var2) throws RemoteException;

    public void registerScanResultsCallback(IScanResultsCallback var1) throws RemoteException;

    public void unregisterScanResultsCallback(IScanResultsCallback var1) throws RemoteException;

    public void registerSuggestionConnectionStatusListener(ISuggestionConnectionStatusListener var1, String var2, String var3) throws RemoteException;

    public void unregisterSuggestionConnectionStatusListener(ISuggestionConnectionStatusListener var1, String var2) throws RemoteException;

    public void addLocalOnlyConnectionStatusListener(ILocalOnlyConnectionStatusListener var1, String var2, String var3) throws RemoteException;

    public void removeLocalOnlyConnectionStatusListener(ILocalOnlyConnectionStatusListener var1, String var2) throws RemoteException;

    public int calculateSignalLevel(int var1) throws RemoteException;

    public List<WifiConfiguration> getWifiConfigForMatchedNetworkSuggestionsSharedWithUser(List<ScanResult> var1) throws RemoteException;

    public boolean setWifiConnectedNetworkScorer(IBinder var1, IWifiConnectedNetworkScorer var2) throws RemoteException;

    public void clearWifiConnectedNetworkScorer() throws RemoteException;

    public void setExternalPnoScanRequest(IBinder var1, IPnoScanResultsCallback var2, List<WifiSsid> var3, int[] var4, String var5, String var6) throws RemoteException;

    public void clearExternalPnoScanRequest() throws RemoteException;

    public void getLastCallerInfoForApi(int var1, ILastCallerListener var2) throws RemoteException;

    public Map getMatchingScanResults(List<WifiNetworkSuggestion> var1, List<ScanResult> var2, String var3, String var4) throws RemoteException;

    public void setScanThrottleEnabled(boolean var1) throws RemoteException;

    public boolean isScanThrottleEnabled() throws RemoteException;

    public Map getAllMatchingPasspointProfilesForScanResults(List<ScanResult> var1) throws RemoteException;

    public void setAutoWakeupEnabled(boolean var1) throws RemoteException;

    public boolean isAutoWakeupEnabled() throws RemoteException;

    public void startRestrictingAutoJoinToSubscriptionId(int var1) throws RemoteException;

    public void stopRestrictingAutoJoinToSubscriptionId() throws RemoteException;

    public void setCarrierNetworkOffloadEnabled(int var1, boolean var2, boolean var3) throws RemoteException;

    public boolean isCarrierNetworkOffloadEnabled(int var1, boolean var2) throws RemoteException;

    public void registerSubsystemRestartCallback(ISubsystemRestartCallback var1) throws RemoteException;

    public void unregisterSubsystemRestartCallback(ISubsystemRestartCallback var1) throws RemoteException;

    public void restartWifiSubsystem() throws RemoteException;

    public void addSuggestionUserApprovalStatusListener(ISuggestionUserApprovalStatusListener var1, String var2) throws RemoteException;

    public void removeSuggestionUserApprovalStatusListener(ISuggestionUserApprovalStatusListener var1, String var2) throws RemoteException;

    public void setEmergencyScanRequestInProgress(boolean var1) throws RemoteException;

    public void removeAppState(int var1, String var2) throws RemoteException;

    public boolean setWifiScoringEnabled(boolean var1) throws RemoteException;

    public void flushPasspointAnqpCache(String var1) throws RemoteException;

    public List<WifiAvailableChannel> getUsableChannels(int var1, int var2, int var3, String var4, Bundle var5) throws RemoteException;

    public boolean isWifiPasspointEnabled() throws RemoteException;

    public void setWifiPasspointEnabled(boolean var1) throws RemoteException;

    public int getStaConcurrencyForMultiInternetMode() throws RemoteException;

    public boolean setStaConcurrencyForMultiInternetMode(int var1) throws RemoteException;

    public void notifyMinimumRequiredWifiSecurityLevelChanged(int var1) throws RemoteException;

    public void notifyWifiSsidPolicyChanged(int var1, List<WifiSsid> var2) throws RemoteException;

    public String[] getOemPrivilegedWifiAdminPackages() throws RemoteException;

    public void replyToP2pInvitationReceivedDialog(int var1, boolean var2, String var3) throws RemoteException;

    public void replyToSimpleDialog(int var1, int var2) throws RemoteException;

    public void addCustomDhcpOptions(WifiSsid var1, byte[] var2, List<DhcpOption> var3) throws RemoteException;

    public void removeCustomDhcpOptions(WifiSsid var1, byte[] var2) throws RemoteException;

    public void reportCreateInterfaceImpact(String var1, int var2, boolean var3, IInterfaceCreationInfoCallback var4) throws RemoteException;

    public int getMaxNumberOfChannelsPerRequest() throws RemoteException;

    public void addQosPolicies(List<QosPolicyParams> var1, IBinder var2, String var3, IListListener var4) throws RemoteException;

    public void removeQosPolicies(int[] var1, String var2) throws RemoteException;

    public void removeAllQosPolicies(String var1) throws RemoteException;

    public void setLinkLayerStatsPollingInterval(int var1) throws RemoteException;

    public void getLinkLayerStatsPollingInterval(IIntegerListener var1) throws RemoteException;

    public void setMloMode(int var1, IBooleanListener var2) throws RemoteException;

    public void getMloMode(IIntegerListener var1) throws RemoteException;

    public void addWifiLowLatencyLockListener(IWifiLowLatencyLockListener var1) throws RemoteException;

    public void removeWifiLowLatencyLockListener(IWifiLowLatencyLockListener var1) throws RemoteException;

    public void getMaxMloAssociationLinkCount(IIntegerListener var1, Bundle var2) throws RemoteException;

    public void getMaxMloStrLinkCount(IIntegerListener var1, Bundle var2) throws RemoteException;

    public void getSupportedSimultaneousBandCombinations(IWifiBandsListener var1, Bundle var2) throws RemoteException;

    public static class _Parcel {
        private static <T extends Parcelable> void writeTypedList(Parcel parcel, List<T> value, int parcelableFlags) {
            if (value == null) {
                parcel.writeInt(-1);
            } else {
                int N = value.size();
                parcel.writeInt(N);
                for (int i = 0; i < N; ++i) {
                    parcel.writeTypedObject((Parcelable)value.get(i), parcelableFlags);
                }
            }
        }
    }

    public static abstract class Stub
    extends Binder
    implements IWifiManager {
        public static final String DESCRIPTOR = "android.net.wifi.IWifiManager";
        static final int TRANSACTION_getSupportedFeatures = 1;
        static final int TRANSACTION_getWifiActivityEnergyInfoAsync = 2;
        static final int TRANSACTION_setNetworkSelectionConfig = 3;
        static final int TRANSACTION_getNetworkSelectionConfig = 4;
        static final int TRANSACTION_setThirdPartyAppEnablingWifiConfirmationDialogEnabled = 5;
        static final int TRANSACTION_isThirdPartyAppEnablingWifiConfirmationDialogEnabled = 6;
        static final int TRANSACTION_setScreenOnScanSchedule = 7;
        static final int TRANSACTION_setOneShotScreenOnConnectivityScanDelayMillis = 8;
        static final int TRANSACTION_getConfiguredNetworks = 9;
        static final int TRANSACTION_getPrivilegedConfiguredNetworks = 10;
        static final int TRANSACTION_getPrivilegedConnectedNetwork = 11;
        static final int TRANSACTION_getAllMatchingFqdnsForScanResults = 12;
        static final int TRANSACTION_setSsidsAllowlist = 13;
        static final int TRANSACTION_getSsidsAllowlist = 14;
        static final int TRANSACTION_getMatchingOsuProviders = 15;
        static final int TRANSACTION_getMatchingPasspointConfigsForOsuProviders = 16;
        static final int TRANSACTION_addOrUpdateNetwork = 17;
        static final int TRANSACTION_addOrUpdateNetworkPrivileged = 18;
        static final int TRANSACTION_addOrUpdatePasspointConfiguration = 19;
        static final int TRANSACTION_removePasspointConfiguration = 20;
        static final int TRANSACTION_getPasspointConfigurations = 21;
        static final int TRANSACTION_getWifiConfigsForPasspointProfiles = 22;
        static final int TRANSACTION_queryPasspointIcon = 23;
        static final int TRANSACTION_matchProviderWithCurrentNetwork = 24;
        static final int TRANSACTION_removeNetwork = 25;
        static final int TRANSACTION_removeNonCallerConfiguredNetworks = 26;
        static final int TRANSACTION_enableNetwork = 27;
        static final int TRANSACTION_disableNetwork = 28;
        static final int TRANSACTION_allowAutojoinGlobal = 29;
        static final int TRANSACTION_queryAutojoinGlobal = 30;
        static final int TRANSACTION_allowAutojoin = 31;
        static final int TRANSACTION_allowAutojoinPasspoint = 32;
        static final int TRANSACTION_setMacRandomizationSettingPasspointEnabled = 33;
        static final int TRANSACTION_setPasspointMeteredOverride = 34;
        static final int TRANSACTION_startScan = 35;
        static final int TRANSACTION_getScanResults = 36;
        static final int TRANSACTION_getChannelData = 37;
        static final int TRANSACTION_disconnect = 38;
        static final int TRANSACTION_reconnect = 39;
        static final int TRANSACTION_reassociate = 40;
        static final int TRANSACTION_getConnectionInfo = 41;
        static final int TRANSACTION_setWifiEnabled = 42;
        static final int TRANSACTION_getWifiEnabledState = 43;
        static final int TRANSACTION_registerDriverCountryCodeChangedListener = 44;
        static final int TRANSACTION_unregisterDriverCountryCodeChangedListener = 45;
        static final int TRANSACTION_addWifiNetworkStateChangedListener = 46;
        static final int TRANSACTION_removeWifiNetworkStateChangedListener = 47;
        static final int TRANSACTION_getCountryCode = 48;
        static final int TRANSACTION_setOverrideCountryCode = 49;
        static final int TRANSACTION_clearOverrideCountryCode = 50;
        static final int TRANSACTION_setDefaultCountryCode = 51;
        static final int TRANSACTION_is24GHzBandSupported = 52;
        static final int TRANSACTION_is5GHzBandSupported = 53;
        static final int TRANSACTION_is6GHzBandSupported = 54;
        static final int TRANSACTION_is60GHzBandSupported = 55;
        static final int TRANSACTION_isWifiStandardSupported = 56;
        static final int TRANSACTION_getDhcpInfo = 57;
        static final int TRANSACTION_setScanAlwaysAvailable = 58;
        static final int TRANSACTION_isScanAlwaysAvailable = 59;
        static final int TRANSACTION_acquireWifiLock = 60;
        static final int TRANSACTION_updateWifiLockWorkSource = 61;
        static final int TRANSACTION_releaseWifiLock = 62;
        static final int TRANSACTION_initializeMulticastFiltering = 63;
        static final int TRANSACTION_isMulticastEnabled = 64;
        static final int TRANSACTION_acquireMulticastLock = 65;
        static final int TRANSACTION_releaseMulticastLock = 66;
        static final int TRANSACTION_updateInterfaceIpState = 67;
        static final int TRANSACTION_isDefaultCoexAlgorithmEnabled = 68;
        static final int TRANSACTION_setCoexUnsafeChannels = 69;
        static final int TRANSACTION_registerCoexCallback = 70;
        static final int TRANSACTION_unregisterCoexCallback = 71;
        static final int TRANSACTION_startSoftAp = 72;
        static final int TRANSACTION_startTetheredHotspot = 73;
        static final int TRANSACTION_stopSoftAp = 74;
        static final int TRANSACTION_validateSoftApConfiguration = 75;
        static final int TRANSACTION_startLocalOnlyHotspot = 76;
        static final int TRANSACTION_stopLocalOnlyHotspot = 77;
        static final int TRANSACTION_registerLocalOnlyHotspotSoftApCallback = 78;
        static final int TRANSACTION_unregisterLocalOnlyHotspotSoftApCallback = 79;
        static final int TRANSACTION_startWatchLocalOnlyHotspot = 80;
        static final int TRANSACTION_stopWatchLocalOnlyHotspot = 81;
        static final int TRANSACTION_getWifiApEnabledState = 82;
        static final int TRANSACTION_getWifiApConfiguration = 83;
        static final int TRANSACTION_getSoftApConfiguration = 84;
        static final int TRANSACTION_queryLastConfiguredTetheredApPassphraseSinceBoot = 85;
        static final int TRANSACTION_setWifiApConfiguration = 86;
        static final int TRANSACTION_setSoftApConfiguration = 87;
        static final int TRANSACTION_notifyUserOfApBandConversion = 88;
        static final int TRANSACTION_enableTdls = 89;
        static final int TRANSACTION_enableTdlsWithRemoteIpAddress = 90;
        static final int TRANSACTION_enableTdlsWithMacAddress = 91;
        static final int TRANSACTION_enableTdlsWithRemoteMacAddress = 92;
        static final int TRANSACTION_isTdlsOperationCurrentlyAvailable = 93;
        static final int TRANSACTION_getMaxSupportedConcurrentTdlsSessions = 94;
        static final int TRANSACTION_getNumberOfEnabledTdlsSessions = 95;
        static final int TRANSACTION_getCurrentNetworkWpsNfcConfigurationToken = 96;
        static final int TRANSACTION_enableVerboseLogging = 97;
        static final int TRANSACTION_getVerboseLoggingLevel = 98;
        static final int TRANSACTION_disableEphemeralNetwork = 99;
        static final int TRANSACTION_factoryReset = 100;
        static final int TRANSACTION_getCurrentNetwork = 101;
        static final int TRANSACTION_retrieveBackupData = 102;
        static final int TRANSACTION_restoreBackupData = 103;
        static final int TRANSACTION_retrieveSoftApBackupData = 104;
        static final int TRANSACTION_restoreSoftApBackupData = 105;
        static final int TRANSACTION_restoreSupplicantBackupData = 106;
        static final int TRANSACTION_startSubscriptionProvisioning = 107;
        static final int TRANSACTION_registerSoftApCallback = 108;
        static final int TRANSACTION_unregisterSoftApCallback = 109;
        static final int TRANSACTION_addWifiVerboseLoggingStatusChangedListener = 110;
        static final int TRANSACTION_removeWifiVerboseLoggingStatusChangedListener = 111;
        static final int TRANSACTION_addOnWifiUsabilityStatsListener = 112;
        static final int TRANSACTION_removeOnWifiUsabilityStatsListener = 113;
        static final int TRANSACTION_registerTrafficStateCallback = 114;
        static final int TRANSACTION_unregisterTrafficStateCallback = 115;
        static final int TRANSACTION_registerNetworkRequestMatchCallback = 116;
        static final int TRANSACTION_unregisterNetworkRequestMatchCallback = 117;
        static final int TRANSACTION_addNetworkSuggestions = 118;
        static final int TRANSACTION_removeNetworkSuggestions = 119;
        static final int TRANSACTION_getNetworkSuggestions = 120;
        static final int TRANSACTION_getFactoryMacAddresses = 121;
        static final int TRANSACTION_setDeviceMobilityState = 122;
        static final int TRANSACTION_startDppAsConfiguratorInitiator = 123;
        static final int TRANSACTION_startDppAsEnrolleeInitiator = 124;
        static final int TRANSACTION_startDppAsEnrolleeResponder = 125;
        static final int TRANSACTION_stopDppSession = 126;
        static final int TRANSACTION_updateWifiUsabilityScore = 127;
        static final int TRANSACTION_connect = 128;
        static final int TRANSACTION_save = 129;
        static final int TRANSACTION_forget = 130;
        static final int TRANSACTION_registerScanResultsCallback = 131;
        static final int TRANSACTION_unregisterScanResultsCallback = 132;
        static final int TRANSACTION_registerSuggestionConnectionStatusListener = 133;
        static final int TRANSACTION_unregisterSuggestionConnectionStatusListener = 134;
        static final int TRANSACTION_addLocalOnlyConnectionStatusListener = 135;
        static final int TRANSACTION_removeLocalOnlyConnectionStatusListener = 136;
        static final int TRANSACTION_calculateSignalLevel = 137;
        static final int TRANSACTION_getWifiConfigForMatchedNetworkSuggestionsSharedWithUser = 138;
        static final int TRANSACTION_setWifiConnectedNetworkScorer = 139;
        static final int TRANSACTION_clearWifiConnectedNetworkScorer = 140;
        static final int TRANSACTION_setExternalPnoScanRequest = 141;
        static final int TRANSACTION_clearExternalPnoScanRequest = 142;
        static final int TRANSACTION_getLastCallerInfoForApi = 143;
        static final int TRANSACTION_getMatchingScanResults = 144;
        static final int TRANSACTION_setScanThrottleEnabled = 145;
        static final int TRANSACTION_isScanThrottleEnabled = 146;
        static final int TRANSACTION_getAllMatchingPasspointProfilesForScanResults = 147;
        static final int TRANSACTION_setAutoWakeupEnabled = 148;
        static final int TRANSACTION_isAutoWakeupEnabled = 149;
        static final int TRANSACTION_startRestrictingAutoJoinToSubscriptionId = 150;
        static final int TRANSACTION_stopRestrictingAutoJoinToSubscriptionId = 151;
        static final int TRANSACTION_setCarrierNetworkOffloadEnabled = 152;
        static final int TRANSACTION_isCarrierNetworkOffloadEnabled = 153;
        static final int TRANSACTION_registerSubsystemRestartCallback = 154;
        static final int TRANSACTION_unregisterSubsystemRestartCallback = 155;
        static final int TRANSACTION_restartWifiSubsystem = 156;
        static final int TRANSACTION_addSuggestionUserApprovalStatusListener = 157;
        static final int TRANSACTION_removeSuggestionUserApprovalStatusListener = 158;
        static final int TRANSACTION_setEmergencyScanRequestInProgress = 159;
        static final int TRANSACTION_removeAppState = 160;
        static final int TRANSACTION_setWifiScoringEnabled = 161;
        static final int TRANSACTION_flushPasspointAnqpCache = 162;
        static final int TRANSACTION_getUsableChannels = 163;
        static final int TRANSACTION_isWifiPasspointEnabled = 164;
        static final int TRANSACTION_setWifiPasspointEnabled = 165;
        static final int TRANSACTION_getStaConcurrencyForMultiInternetMode = 166;
        static final int TRANSACTION_setStaConcurrencyForMultiInternetMode = 167;
        static final int TRANSACTION_notifyMinimumRequiredWifiSecurityLevelChanged = 168;
        static final int TRANSACTION_notifyWifiSsidPolicyChanged = 169;
        static final int TRANSACTION_getOemPrivilegedWifiAdminPackages = 170;
        static final int TRANSACTION_replyToP2pInvitationReceivedDialog = 171;
        static final int TRANSACTION_replyToSimpleDialog = 172;
        static final int TRANSACTION_addCustomDhcpOptions = 173;
        static final int TRANSACTION_removeCustomDhcpOptions = 174;
        static final int TRANSACTION_reportCreateInterfaceImpact = 175;
        static final int TRANSACTION_getMaxNumberOfChannelsPerRequest = 176;
        static final int TRANSACTION_addQosPolicies = 177;
        static final int TRANSACTION_removeQosPolicies = 178;
        static final int TRANSACTION_removeAllQosPolicies = 179;
        static final int TRANSACTION_setLinkLayerStatsPollingInterval = 180;
        static final int TRANSACTION_getLinkLayerStatsPollingInterval = 181;
        static final int TRANSACTION_setMloMode = 182;
        static final int TRANSACTION_getMloMode = 183;
        static final int TRANSACTION_addWifiLowLatencyLockListener = 184;
        static final int TRANSACTION_removeWifiLowLatencyLockListener = 185;
        static final int TRANSACTION_getMaxMloAssociationLinkCount = 186;
        static final int TRANSACTION_getMaxMloStrLinkCount = 187;
        static final int TRANSACTION_getSupportedSimultaneousBandCombinations = 188;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWifiManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWifiManager) {
                return (IWifiManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getSupportedFeatures";
                }
                case 2: {
                    return "getWifiActivityEnergyInfoAsync";
                }
                case 3: {
                    return "setNetworkSelectionConfig";
                }
                case 4: {
                    return "getNetworkSelectionConfig";
                }
                case 5: {
                    return "setThirdPartyAppEnablingWifiConfirmationDialogEnabled";
                }
                case 6: {
                    return "isThirdPartyAppEnablingWifiConfirmationDialogEnabled";
                }
                case 7: {
                    return "setScreenOnScanSchedule";
                }
                case 8: {
                    return "setOneShotScreenOnConnectivityScanDelayMillis";
                }
                case 9: {
                    return "getConfiguredNetworks";
                }
                case 10: {
                    return "getPrivilegedConfiguredNetworks";
                }
                case 11: {
                    return "getPrivilegedConnectedNetwork";
                }
                case 12: {
                    return "getAllMatchingFqdnsForScanResults";
                }
                case 13: {
                    return "setSsidsAllowlist";
                }
                case 14: {
                    return "getSsidsAllowlist";
                }
                case 15: {
                    return "getMatchingOsuProviders";
                }
                case 16: {
                    return "getMatchingPasspointConfigsForOsuProviders";
                }
                case 17: {
                    return "addOrUpdateNetwork";
                }
                case 18: {
                    return "addOrUpdateNetworkPrivileged";
                }
                case 19: {
                    return "addOrUpdatePasspointConfiguration";
                }
                case 20: {
                    return "removePasspointConfiguration";
                }
                case 21: {
                    return "getPasspointConfigurations";
                }
                case 22: {
                    return "getWifiConfigsForPasspointProfiles";
                }
                case 23: {
                    return "queryPasspointIcon";
                }
                case 24: {
                    return "matchProviderWithCurrentNetwork";
                }
                case 25: {
                    return "removeNetwork";
                }
                case 26: {
                    return "removeNonCallerConfiguredNetworks";
                }
                case 27: {
                    return "enableNetwork";
                }
                case 28: {
                    return "disableNetwork";
                }
                case 29: {
                    return "allowAutojoinGlobal";
                }
                case 30: {
                    return "queryAutojoinGlobal";
                }
                case 31: {
                    return "allowAutojoin";
                }
                case 32: {
                    return "allowAutojoinPasspoint";
                }
                case 33: {
                    return "setMacRandomizationSettingPasspointEnabled";
                }
                case 34: {
                    return "setPasspointMeteredOverride";
                }
                case 35: {
                    return "startScan";
                }
                case 36: {
                    return "getScanResults";
                }
                case 37: {
                    return "getChannelData";
                }
                case 38: {
                    return "disconnect";
                }
                case 39: {
                    return "reconnect";
                }
                case 40: {
                    return "reassociate";
                }
                case 41: {
                    return "getConnectionInfo";
                }
                case 42: {
                    return "setWifiEnabled";
                }
                case 43: {
                    return "getWifiEnabledState";
                }
                case 44: {
                    return "registerDriverCountryCodeChangedListener";
                }
                case 45: {
                    return "unregisterDriverCountryCodeChangedListener";
                }
                case 46: {
                    return "addWifiNetworkStateChangedListener";
                }
                case 47: {
                    return "removeWifiNetworkStateChangedListener";
                }
                case 48: {
                    return "getCountryCode";
                }
                case 49: {
                    return "setOverrideCountryCode";
                }
                case 50: {
                    return "clearOverrideCountryCode";
                }
                case 51: {
                    return "setDefaultCountryCode";
                }
                case 52: {
                    return "is24GHzBandSupported";
                }
                case 53: {
                    return "is5GHzBandSupported";
                }
                case 54: {
                    return "is6GHzBandSupported";
                }
                case 55: {
                    return "is60GHzBandSupported";
                }
                case 56: {
                    return "isWifiStandardSupported";
                }
                case 57: {
                    return "getDhcpInfo";
                }
                case 58: {
                    return "setScanAlwaysAvailable";
                }
                case 59: {
                    return "isScanAlwaysAvailable";
                }
                case 60: {
                    return "acquireWifiLock";
                }
                case 61: {
                    return "updateWifiLockWorkSource";
                }
                case 62: {
                    return "releaseWifiLock";
                }
                case 63: {
                    return "initializeMulticastFiltering";
                }
                case 64: {
                    return "isMulticastEnabled";
                }
                case 65: {
                    return "acquireMulticastLock";
                }
                case 66: {
                    return "releaseMulticastLock";
                }
                case 67: {
                    return "updateInterfaceIpState";
                }
                case 68: {
                    return "isDefaultCoexAlgorithmEnabled";
                }
                case 69: {
                    return "setCoexUnsafeChannels";
                }
                case 70: {
                    return "registerCoexCallback";
                }
                case 71: {
                    return "unregisterCoexCallback";
                }
                case 72: {
                    return "startSoftAp";
                }
                case 73: {
                    return "startTetheredHotspot";
                }
                case 74: {
                    return "stopSoftAp";
                }
                case 75: {
                    return "validateSoftApConfiguration";
                }
                case 76: {
                    return "startLocalOnlyHotspot";
                }
                case 77: {
                    return "stopLocalOnlyHotspot";
                }
                case 78: {
                    return "registerLocalOnlyHotspotSoftApCallback";
                }
                case 79: {
                    return "unregisterLocalOnlyHotspotSoftApCallback";
                }
                case 80: {
                    return "startWatchLocalOnlyHotspot";
                }
                case 81: {
                    return "stopWatchLocalOnlyHotspot";
                }
                case 82: {
                    return "getWifiApEnabledState";
                }
                case 83: {
                    return "getWifiApConfiguration";
                }
                case 84: {
                    return "getSoftApConfiguration";
                }
                case 85: {
                    return "queryLastConfiguredTetheredApPassphraseSinceBoot";
                }
                case 86: {
                    return "setWifiApConfiguration";
                }
                case 87: {
                    return "setSoftApConfiguration";
                }
                case 88: {
                    return "notifyUserOfApBandConversion";
                }
                case 89: {
                    return "enableTdls";
                }
                case 90: {
                    return "enableTdlsWithRemoteIpAddress";
                }
                case 91: {
                    return "enableTdlsWithMacAddress";
                }
                case 92: {
                    return "enableTdlsWithRemoteMacAddress";
                }
                case 93: {
                    return "isTdlsOperationCurrentlyAvailable";
                }
                case 94: {
                    return "getMaxSupportedConcurrentTdlsSessions";
                }
                case 95: {
                    return "getNumberOfEnabledTdlsSessions";
                }
                case 96: {
                    return "getCurrentNetworkWpsNfcConfigurationToken";
                }
                case 97: {
                    return "enableVerboseLogging";
                }
                case 98: {
                    return "getVerboseLoggingLevel";
                }
                case 99: {
                    return "disableEphemeralNetwork";
                }
                case 100: {
                    return "factoryReset";
                }
                case 101: {
                    return "getCurrentNetwork";
                }
                case 102: {
                    return "retrieveBackupData";
                }
                case 103: {
                    return "restoreBackupData";
                }
                case 104: {
                    return "retrieveSoftApBackupData";
                }
                case 105: {
                    return "restoreSoftApBackupData";
                }
                case 106: {
                    return "restoreSupplicantBackupData";
                }
                case 107: {
                    return "startSubscriptionProvisioning";
                }
                case 108: {
                    return "registerSoftApCallback";
                }
                case 109: {
                    return "unregisterSoftApCallback";
                }
                case 110: {
                    return "addWifiVerboseLoggingStatusChangedListener";
                }
                case 111: {
                    return "removeWifiVerboseLoggingStatusChangedListener";
                }
                case 112: {
                    return "addOnWifiUsabilityStatsListener";
                }
                case 113: {
                    return "removeOnWifiUsabilityStatsListener";
                }
                case 114: {
                    return "registerTrafficStateCallback";
                }
                case 115: {
                    return "unregisterTrafficStateCallback";
                }
                case 116: {
                    return "registerNetworkRequestMatchCallback";
                }
                case 117: {
                    return "unregisterNetworkRequestMatchCallback";
                }
                case 118: {
                    return "addNetworkSuggestions";
                }
                case 119: {
                    return "removeNetworkSuggestions";
                }
                case 120: {
                    return "getNetworkSuggestions";
                }
                case 121: {
                    return "getFactoryMacAddresses";
                }
                case 122: {
                    return "setDeviceMobilityState";
                }
                case 123: {
                    return "startDppAsConfiguratorInitiator";
                }
                case 124: {
                    return "startDppAsEnrolleeInitiator";
                }
                case 125: {
                    return "startDppAsEnrolleeResponder";
                }
                case 126: {
                    return "stopDppSession";
                }
                case 127: {
                    return "updateWifiUsabilityScore";
                }
                case 128: {
                    return "connect";
                }
                case 129: {
                    return "save";
                }
                case 130: {
                    return "forget";
                }
                case 131: {
                    return "registerScanResultsCallback";
                }
                case 132: {
                    return "unregisterScanResultsCallback";
                }
                case 133: {
                    return "registerSuggestionConnectionStatusListener";
                }
                case 134: {
                    return "unregisterSuggestionConnectionStatusListener";
                }
                case 135: {
                    return "addLocalOnlyConnectionStatusListener";
                }
                case 136: {
                    return "removeLocalOnlyConnectionStatusListener";
                }
                case 137: {
                    return "calculateSignalLevel";
                }
                case 138: {
                    return "getWifiConfigForMatchedNetworkSuggestionsSharedWithUser";
                }
                case 139: {
                    return "setWifiConnectedNetworkScorer";
                }
                case 140: {
                    return "clearWifiConnectedNetworkScorer";
                }
                case 141: {
                    return "setExternalPnoScanRequest";
                }
                case 142: {
                    return "clearExternalPnoScanRequest";
                }
                case 143: {
                    return "getLastCallerInfoForApi";
                }
                case 144: {
                    return "getMatchingScanResults";
                }
                case 145: {
                    return "setScanThrottleEnabled";
                }
                case 146: {
                    return "isScanThrottleEnabled";
                }
                case 147: {
                    return "getAllMatchingPasspointProfilesForScanResults";
                }
                case 148: {
                    return "setAutoWakeupEnabled";
                }
                case 149: {
                    return "isAutoWakeupEnabled";
                }
                case 150: {
                    return "startRestrictingAutoJoinToSubscriptionId";
                }
                case 151: {
                    return "stopRestrictingAutoJoinToSubscriptionId";
                }
                case 152: {
                    return "setCarrierNetworkOffloadEnabled";
                }
                case 153: {
                    return "isCarrierNetworkOffloadEnabled";
                }
                case 154: {
                    return "registerSubsystemRestartCallback";
                }
                case 155: {
                    return "unregisterSubsystemRestartCallback";
                }
                case 156: {
                    return "restartWifiSubsystem";
                }
                case 157: {
                    return "addSuggestionUserApprovalStatusListener";
                }
                case 158: {
                    return "removeSuggestionUserApprovalStatusListener";
                }
                case 159: {
                    return "setEmergencyScanRequestInProgress";
                }
                case 160: {
                    return "removeAppState";
                }
                case 161: {
                    return "setWifiScoringEnabled";
                }
                case 162: {
                    return "flushPasspointAnqpCache";
                }
                case 163: {
                    return "getUsableChannels";
                }
                case 164: {
                    return "isWifiPasspointEnabled";
                }
                case 165: {
                    return "setWifiPasspointEnabled";
                }
                case 166: {
                    return "getStaConcurrencyForMultiInternetMode";
                }
                case 167: {
                    return "setStaConcurrencyForMultiInternetMode";
                }
                case 168: {
                    return "notifyMinimumRequiredWifiSecurityLevelChanged";
                }
                case 169: {
                    return "notifyWifiSsidPolicyChanged";
                }
                case 170: {
                    return "getOemPrivilegedWifiAdminPackages";
                }
                case 171: {
                    return "replyToP2pInvitationReceivedDialog";
                }
                case 172: {
                    return "replyToSimpleDialog";
                }
                case 173: {
                    return "addCustomDhcpOptions";
                }
                case 174: {
                    return "removeCustomDhcpOptions";
                }
                case 175: {
                    return "reportCreateInterfaceImpact";
                }
                case 176: {
                    return "getMaxNumberOfChannelsPerRequest";
                }
                case 177: {
                    return "addQosPolicies";
                }
                case 178: {
                    return "removeQosPolicies";
                }
                case 179: {
                    return "removeAllQosPolicies";
                }
                case 180: {
                    return "setLinkLayerStatsPollingInterval";
                }
                case 181: {
                    return "getLinkLayerStatsPollingInterval";
                }
                case 182: {
                    return "setMloMode";
                }
                case 183: {
                    return "getMloMode";
                }
                case 184: {
                    return "addWifiLowLatencyLockListener";
                }
                case 185: {
                    return "removeWifiLowLatencyLockListener";
                }
                case 186: {
                    return "getMaxMloAssociationLinkCount";
                }
                case 187: {
                    return "getMaxMloStrLinkCount";
                }
                case 188: {
                    return "getSupportedSimultaneousBandCombinations";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    long _result = this.getSupportedFeatures();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 2: {
                    IOnWifiActivityEnergyInfoListener _arg0 = IOnWifiActivityEnergyInfoListener.Stub.asInterface(data.readStrongBinder());
                    this.getWifiActivityEnergyInfoAsync(_arg0);
                    break;
                }
                case 3: {
                    WifiNetworkSelectionConfig _arg0 = data.readTypedObject(WifiNetworkSelectionConfig.CREATOR);
                    this.setNetworkSelectionConfig(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    IWifiNetworkSelectionConfigListener _arg0 = IWifiNetworkSelectionConfigListener.Stub.asInterface(data.readStrongBinder());
                    this.getNetworkSelectionConfig(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    boolean _arg0 = data.readBoolean();
                    this.setThirdPartyAppEnablingWifiConfirmationDialogEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    boolean _result = this.isThirdPartyAppEnablingWifiConfirmationDialogEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 7: {
                    int[] _arg0 = data.createIntArray();
                    int[] _arg1 = data.createIntArray();
                    this.setScreenOnScanSchedule(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    this.setOneShotScreenOnConnectivityScanDelayMillis(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _arg2 = data.readBoolean();
                    ParceledListSlice _result = this.getConfiguredNetworks(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    ParceledListSlice _result = this.getPrivilegedConfiguredNetworks(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    WifiConfiguration _result = this.getPrivilegedConnectedNetwork(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 12: {
                    ArrayList<ScanResult> _arg0 = data.createTypedArrayList(ScanResult.CREATOR);
                    Map _result = this.getAllMatchingFqdnsForScanResults(_arg0);
                    reply.writeNoException();
                    reply.writeMap(_result);
                    break;
                }
                case 13: {
                    String _arg0 = data.readString();
                    ArrayList<WifiSsid> _arg1 = data.createTypedArrayList(WifiSsid.CREATOR);
                    this.setSsidsAllowlist(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    String _arg0 = data.readString();
                    List _result = this.getSsidsAllowlist(_arg0);
                    reply.writeNoException();
                    reply.writeList(_result);
                    break;
                }
                case 15: {
                    ArrayList<ScanResult> _arg0 = data.createTypedArrayList(ScanResult.CREATOR);
                    Map _result = this.getMatchingOsuProviders(_arg0);
                    reply.writeNoException();
                    reply.writeMap(_result);
                    break;
                }
                case 16: {
                    ArrayList<OsuProvider> _arg0 = data.createTypedArrayList(OsuProvider.CREATOR);
                    Map _result = this.getMatchingPasspointConfigsForOsuProviders(_arg0);
                    reply.writeNoException();
                    reply.writeMap(_result);
                    break;
                }
                case 17: {
                    WifiConfiguration _arg0 = data.readTypedObject(WifiConfiguration.CREATOR);
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    int _result = this.addOrUpdateNetwork(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 18: {
                    WifiConfiguration _arg0 = data.readTypedObject(WifiConfiguration.CREATOR);
                    String _arg1 = data.readString();
                    WifiManager.AddNetworkResult _result = this.addOrUpdateNetworkPrivileged(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 19: {
                    PasspointConfiguration _arg0 = data.readTypedObject(PasspointConfiguration.CREATOR);
                    String _arg1 = data.readString();
                    boolean _result = this.addOrUpdatePasspointConfiguration(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 20: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _result = this.removePasspointConfiguration(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 21: {
                    String _arg0 = data.readString();
                    List<PasspointConfiguration> _result = this.getPasspointConfigurations(_arg0);
                    reply.writeNoException();
                    _Parcel.writeTypedList(reply, _result, 1);
                    break;
                }
                case 22: {
                    ArrayList<String> _arg0 = data.createStringArrayList();
                    List<WifiConfiguration> _result = this.getWifiConfigsForPasspointProfiles(_arg0);
                    reply.writeNoException();
                    _Parcel.writeTypedList(reply, _result, 1);
                    break;
                }
                case 23: {
                    long _arg0 = data.readLong();
                    String _arg1 = data.readString();
                    this.queryPasspointIcon(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    String _arg0 = data.readString();
                    int _result = this.matchProviderWithCurrentNetwork(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 25: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    boolean _result = this.removeNetwork(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 26: {
                    String _arg0 = data.readString();
                    boolean _result = this.removeNonCallerConfiguredNetworks(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 27: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    String _arg2 = data.readString();
                    boolean _result = this.enableNetwork(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 28: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    boolean _result = this.disableNetwork(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 29: {
                    boolean _arg0 = data.readBoolean();
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    this.allowAutojoinGlobal(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    IBooleanListener _arg0 = IBooleanListener.Stub.asInterface(data.readStrongBinder());
                    this.queryAutojoinGlobal(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    this.allowAutojoin(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 32: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    this.allowAutojoinPasspoint(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    this.setMacRandomizationSettingPasspointEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.setPasspointMeteredOverride(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _result = this.startScan(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 36: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    List<ScanResult> _result = this.getScanResults(_arg0, _arg1);
                    reply.writeNoException();
                    _Parcel.writeTypedList(reply, _result, 1);
                    break;
                }
                case 37: {
                    IListListener _arg0 = IListListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    this.getChannelData(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    String _arg0 = data.readString();
                    boolean _result = this.disconnect(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 39: {
                    String _arg0 = data.readString();
                    boolean _result = this.reconnect(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 40: {
                    String _arg0 = data.readString();
                    boolean _result = this.reassociate(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 41: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    WifiInfo _result = this.getConnectionInfo(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 42: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    boolean _result = this.setWifiEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 43: {
                    int _result = this.getWifiEnabledState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 44: {
                    IOnWifiDriverCountryCodeChangedListener _arg0 = IOnWifiDriverCountryCodeChangedListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    this.registerDriverCountryCodeChangedListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 45: {
                    IOnWifiDriverCountryCodeChangedListener _arg0 = IOnWifiDriverCountryCodeChangedListener.Stub.asInterface(data.readStrongBinder());
                    this.unregisterDriverCountryCodeChangedListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 46: {
                    IWifiNetworkStateChangedListener _arg0 = IWifiNetworkStateChangedListener.Stub.asInterface(data.readStrongBinder());
                    this.addWifiNetworkStateChangedListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 47: {
                    IWifiNetworkStateChangedListener _arg0 = IWifiNetworkStateChangedListener.Stub.asInterface(data.readStrongBinder());
                    this.removeWifiNetworkStateChangedListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 48: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _result = this.getCountryCode(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 49: {
                    String _arg0 = data.readString();
                    this.setOverrideCountryCode(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 50: {
                    this.clearOverrideCountryCode();
                    reply.writeNoException();
                    break;
                }
                case 51: {
                    String _arg0 = data.readString();
                    this.setDefaultCountryCode(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 52: {
                    boolean _result = this.is24GHzBandSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 53: {
                    boolean _result = this.is5GHzBandSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 54: {
                    boolean _result = this.is6GHzBandSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 55: {
                    boolean _result = this.is60GHzBandSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 56: {
                    int _arg0 = data.readInt();
                    boolean _result = this.isWifiStandardSupported(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 57: {
                    String _arg0 = data.readString();
                    DhcpInfo _result = this.getDhcpInfo(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 58: {
                    boolean _arg0 = data.readBoolean();
                    String _arg1 = data.readString();
                    this.setScanAlwaysAvailable(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 59: {
                    boolean _result = this.isScanAlwaysAvailable();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 60: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    WorkSource _arg3 = data.readTypedObject(WorkSource.CREATOR);
                    boolean _result = this.acquireWifiLock(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 61: {
                    IBinder _arg0 = data.readStrongBinder();
                    WorkSource _arg1 = data.readTypedObject(WorkSource.CREATOR);
                    this.updateWifiLockWorkSource(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 62: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _result = this.releaseWifiLock(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 63: {
                    this.initializeMulticastFiltering();
                    reply.writeNoException();
                    break;
                }
                case 64: {
                    boolean _result = this.isMulticastEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 65: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    this.acquireMulticastLock(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 66: {
                    String _arg0 = data.readString();
                    this.releaseMulticastLock(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 67: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.updateInterfaceIpState(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 68: {
                    boolean _result = this.isDefaultCoexAlgorithmEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 69: {
                    ArrayList<CoexUnsafeChannel> _arg0 = data.createTypedArrayList(CoexUnsafeChannel.CREATOR);
                    int _arg1 = data.readInt();
                    this.setCoexUnsafeChannels(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 70: {
                    ICoexCallback _arg0 = ICoexCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerCoexCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 71: {
                    ICoexCallback _arg0 = ICoexCallback.Stub.asInterface(data.readStrongBinder());
                    this.unregisterCoexCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 72: {
                    WifiConfiguration _arg0 = data.readTypedObject(WifiConfiguration.CREATOR);
                    String _arg1 = data.readString();
                    boolean _result = this.startSoftAp(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 73: {
                    SoftApConfiguration _arg0 = data.readTypedObject(SoftApConfiguration.CREATOR);
                    String _arg1 = data.readString();
                    boolean _result = this.startTetheredHotspot(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 74: {
                    boolean _result = this.stopSoftAp();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 75: {
                    SoftApConfiguration _arg0 = data.readTypedObject(SoftApConfiguration.CREATOR);
                    boolean _result = this.validateSoftApConfiguration(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 76: {
                    ILocalOnlyHotspotCallback _arg0 = ILocalOnlyHotspotCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    SoftApConfiguration _arg3 = data.readTypedObject(SoftApConfiguration.CREATOR);
                    Bundle _arg4 = data.readTypedObject(Bundle.CREATOR);
                    int _result = this.startLocalOnlyHotspot(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 77: {
                    this.stopLocalOnlyHotspot();
                    reply.writeNoException();
                    break;
                }
                case 78: {
                    ISoftApCallback _arg0 = ISoftApCallback.Stub.asInterface(data.readStrongBinder());
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    this.registerLocalOnlyHotspotSoftApCallback(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 79: {
                    ISoftApCallback _arg0 = ISoftApCallback.Stub.asInterface(data.readStrongBinder());
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    this.unregisterLocalOnlyHotspotSoftApCallback(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 80: {
                    ILocalOnlyHotspotCallback _arg0 = ILocalOnlyHotspotCallback.Stub.asInterface(data.readStrongBinder());
                    this.startWatchLocalOnlyHotspot(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 81: {
                    this.stopWatchLocalOnlyHotspot();
                    reply.writeNoException();
                    break;
                }
                case 82: {
                    int _result = this.getWifiApEnabledState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 83: {
                    WifiConfiguration _result = this.getWifiApConfiguration();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 84: {
                    SoftApConfiguration _result = this.getSoftApConfiguration();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 85: {
                    IStringListener _arg0 = IStringListener.Stub.asInterface(data.readStrongBinder());
                    this.queryLastConfiguredTetheredApPassphraseSinceBoot(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 86: {
                    WifiConfiguration _arg0 = data.readTypedObject(WifiConfiguration.CREATOR);
                    String _arg1 = data.readString();
                    boolean _result = this.setWifiApConfiguration(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 87: {
                    SoftApConfiguration _arg0 = data.readTypedObject(SoftApConfiguration.CREATOR);
                    String _arg1 = data.readString();
                    boolean _result = this.setSoftApConfiguration(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 88: {
                    String _arg0 = data.readString();
                    this.notifyUserOfApBandConversion(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 89: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    this.enableTdls(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 90: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    IBooleanListener _arg2 = IBooleanListener.Stub.asInterface(data.readStrongBinder());
                    this.enableTdlsWithRemoteIpAddress(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 91: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    this.enableTdlsWithMacAddress(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 92: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    IBooleanListener _arg2 = IBooleanListener.Stub.asInterface(data.readStrongBinder());
                    this.enableTdlsWithRemoteMacAddress(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 93: {
                    IBooleanListener _arg0 = IBooleanListener.Stub.asInterface(data.readStrongBinder());
                    this.isTdlsOperationCurrentlyAvailable(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 94: {
                    IIntegerListener _arg0 = IIntegerListener.Stub.asInterface(data.readStrongBinder());
                    this.getMaxSupportedConcurrentTdlsSessions(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 95: {
                    IIntegerListener _arg0 = IIntegerListener.Stub.asInterface(data.readStrongBinder());
                    this.getNumberOfEnabledTdlsSessions(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 96: {
                    String _result = this.getCurrentNetworkWpsNfcConfigurationToken();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 97: {
                    int _arg0 = data.readInt();
                    this.enableVerboseLogging(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 98: {
                    int _result = this.getVerboseLoggingLevel();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 99: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.disableEphemeralNetwork(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 100: {
                    String _arg0 = data.readString();
                    this.factoryReset(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 101: {
                    Network _result = this.getCurrentNetwork();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 102: {
                    byte[] _result = this.retrieveBackupData();
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    break;
                }
                case 103: {
                    byte[] _arg0 = data.createByteArray();
                    this.restoreBackupData(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 104: {
                    byte[] _result = this.retrieveSoftApBackupData();
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    break;
                }
                case 105: {
                    byte[] _arg0 = data.createByteArray();
                    SoftApConfiguration _result = this.restoreSoftApBackupData(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 106: {
                    byte[] _arg0 = data.createByteArray();
                    byte[] _arg1 = data.createByteArray();
                    this.restoreSupplicantBackupData(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 107: {
                    OsuProvider _arg0 = data.readTypedObject(OsuProvider.CREATOR);
                    IProvisioningCallback _arg1 = IProvisioningCallback.Stub.asInterface(data.readStrongBinder());
                    this.startSubscriptionProvisioning(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 108: {
                    ISoftApCallback _arg0 = ISoftApCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerSoftApCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 109: {
                    ISoftApCallback _arg0 = ISoftApCallback.Stub.asInterface(data.readStrongBinder());
                    this.unregisterSoftApCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 110: {
                    IWifiVerboseLoggingStatusChangedListener _arg0 = IWifiVerboseLoggingStatusChangedListener.Stub.asInterface(data.readStrongBinder());
                    this.addWifiVerboseLoggingStatusChangedListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 111: {
                    IWifiVerboseLoggingStatusChangedListener _arg0 = IWifiVerboseLoggingStatusChangedListener.Stub.asInterface(data.readStrongBinder());
                    this.removeWifiVerboseLoggingStatusChangedListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 112: {
                    IOnWifiUsabilityStatsListener _arg0 = IOnWifiUsabilityStatsListener.Stub.asInterface(data.readStrongBinder());
                    this.addOnWifiUsabilityStatsListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 113: {
                    IOnWifiUsabilityStatsListener _arg0 = IOnWifiUsabilityStatsListener.Stub.asInterface(data.readStrongBinder());
                    this.removeOnWifiUsabilityStatsListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 114: {
                    ITrafficStateCallback _arg0 = ITrafficStateCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerTrafficStateCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 115: {
                    ITrafficStateCallback _arg0 = ITrafficStateCallback.Stub.asInterface(data.readStrongBinder());
                    this.unregisterTrafficStateCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 116: {
                    INetworkRequestMatchCallback _arg0 = INetworkRequestMatchCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerNetworkRequestMatchCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 117: {
                    INetworkRequestMatchCallback _arg0 = INetworkRequestMatchCallback.Stub.asInterface(data.readStrongBinder());
                    this.unregisterNetworkRequestMatchCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 118: {
                    ArrayList<WifiNetworkSuggestion> _arg0 = data.createTypedArrayList(WifiNetworkSuggestion.CREATOR);
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _result = this.addNetworkSuggestions(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 119: {
                    ArrayList<WifiNetworkSuggestion> _arg0 = data.createTypedArrayList(WifiNetworkSuggestion.CREATOR);
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _result = this.removeNetworkSuggestions(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 120: {
                    String _arg0 = data.readString();
                    List<WifiNetworkSuggestion> _result = this.getNetworkSuggestions(_arg0);
                    reply.writeNoException();
                    _Parcel.writeTypedList(reply, _result, 1);
                    break;
                }
                case 121: {
                    String[] _result = this.getFactoryMacAddresses();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 122: {
                    int _arg0 = data.readInt();
                    this.setDeviceMobilityState(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 123: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    IDppCallback _arg5 = IDppCallback.Stub.asInterface(data.readStrongBinder());
                    this.startDppAsConfiguratorInitiator(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 124: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    IDppCallback _arg2 = IDppCallback.Stub.asInterface(data.readStrongBinder());
                    this.startDppAsEnrolleeInitiator(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 125: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    IDppCallback _arg3 = IDppCallback.Stub.asInterface(data.readStrongBinder());
                    this.startDppAsEnrolleeResponder(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 126: {
                    this.stopDppSession();
                    reply.writeNoException();
                    break;
                }
                case 127: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.updateWifiUsabilityScore(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 128: {
                    WifiConfiguration _arg0 = data.readTypedObject(WifiConfiguration.CREATOR);
                    int _arg1 = data.readInt();
                    IActionListener _arg2 = IActionListener.Stub.asInterface(data.readStrongBinder());
                    String _arg3 = data.readString();
                    this.connect(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 129: {
                    WifiConfiguration _arg0 = data.readTypedObject(WifiConfiguration.CREATOR);
                    IActionListener _arg1 = IActionListener.Stub.asInterface(data.readStrongBinder());
                    String _arg2 = data.readString();
                    this.save(_arg0, _arg1, _arg2);
                    break;
                }
                case 130: {
                    int _arg0 = data.readInt();
                    IActionListener _arg1 = IActionListener.Stub.asInterface(data.readStrongBinder());
                    this.forget(_arg0, _arg1);
                    break;
                }
                case 131: {
                    IScanResultsCallback _arg0 = IScanResultsCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerScanResultsCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 132: {
                    IScanResultsCallback _arg0 = IScanResultsCallback.Stub.asInterface(data.readStrongBinder());
                    this.unregisterScanResultsCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 133: {
                    ISuggestionConnectionStatusListener _arg0 = ISuggestionConnectionStatusListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    this.registerSuggestionConnectionStatusListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 134: {
                    ISuggestionConnectionStatusListener _arg0 = ISuggestionConnectionStatusListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    this.unregisterSuggestionConnectionStatusListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 135: {
                    ILocalOnlyConnectionStatusListener _arg0 = ILocalOnlyConnectionStatusListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    this.addLocalOnlyConnectionStatusListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 136: {
                    ILocalOnlyConnectionStatusListener _arg0 = ILocalOnlyConnectionStatusListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    this.removeLocalOnlyConnectionStatusListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 137: {
                    int _arg0 = data.readInt();
                    int _result = this.calculateSignalLevel(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 138: {
                    ArrayList<ScanResult> _arg0 = data.createTypedArrayList(ScanResult.CREATOR);
                    List<WifiConfiguration> _result = this.getWifiConfigForMatchedNetworkSuggestionsSharedWithUser(_arg0);
                    reply.writeNoException();
                    _Parcel.writeTypedList(reply, _result, 1);
                    break;
                }
                case 139: {
                    IBinder _arg0 = data.readStrongBinder();
                    IWifiConnectedNetworkScorer _arg1 = IWifiConnectedNetworkScorer.Stub.asInterface(data.readStrongBinder());
                    boolean _result = this.setWifiConnectedNetworkScorer(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 140: {
                    this.clearWifiConnectedNetworkScorer();
                    reply.writeNoException();
                    break;
                }
                case 141: {
                    IBinder _arg0 = data.readStrongBinder();
                    IPnoScanResultsCallback _arg1 = IPnoScanResultsCallback.Stub.asInterface(data.readStrongBinder());
                    ArrayList<WifiSsid> _arg2 = data.createTypedArrayList(WifiSsid.CREATOR);
                    int[] _arg3 = data.createIntArray();
                    String _arg4 = data.readString();
                    String _arg5 = data.readString();
                    this.setExternalPnoScanRequest(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 142: {
                    this.clearExternalPnoScanRequest();
                    reply.writeNoException();
                    break;
                }
                case 143: {
                    int _arg0 = data.readInt();
                    ILastCallerListener _arg1 = ILastCallerListener.Stub.asInterface(data.readStrongBinder());
                    this.getLastCallerInfoForApi(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 144: {
                    ArrayList<WifiNetworkSuggestion> _arg0 = data.createTypedArrayList(WifiNetworkSuggestion.CREATOR);
                    ArrayList<ScanResult> _arg1 = data.createTypedArrayList(ScanResult.CREATOR);
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    Map _result = this.getMatchingScanResults(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeMap(_result);
                    break;
                }
                case 145: {
                    boolean _arg0 = data.readBoolean();
                    this.setScanThrottleEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 146: {
                    boolean _result = this.isScanThrottleEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 147: {
                    ArrayList<ScanResult> _arg0 = data.createTypedArrayList(ScanResult.CREATOR);
                    Map _result = this.getAllMatchingPasspointProfilesForScanResults(_arg0);
                    reply.writeNoException();
                    reply.writeMap(_result);
                    break;
                }
                case 148: {
                    boolean _arg0 = data.readBoolean();
                    this.setAutoWakeupEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 149: {
                    boolean _result = this.isAutoWakeupEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 150: {
                    int _arg0 = data.readInt();
                    this.startRestrictingAutoJoinToSubscriptionId(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 151: {
                    this.stopRestrictingAutoJoinToSubscriptionId();
                    reply.writeNoException();
                    break;
                }
                case 152: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    boolean _arg2 = data.readBoolean();
                    this.setCarrierNetworkOffloadEnabled(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 153: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    boolean _result = this.isCarrierNetworkOffloadEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 154: {
                    ISubsystemRestartCallback _arg0 = ISubsystemRestartCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerSubsystemRestartCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 155: {
                    ISubsystemRestartCallback _arg0 = ISubsystemRestartCallback.Stub.asInterface(data.readStrongBinder());
                    this.unregisterSubsystemRestartCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 156: {
                    this.restartWifiSubsystem();
                    reply.writeNoException();
                    break;
                }
                case 157: {
                    ISuggestionUserApprovalStatusListener _arg0 = ISuggestionUserApprovalStatusListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    this.addSuggestionUserApprovalStatusListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 158: {
                    ISuggestionUserApprovalStatusListener _arg0 = ISuggestionUserApprovalStatusListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    this.removeSuggestionUserApprovalStatusListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 159: {
                    boolean _arg0 = data.readBoolean();
                    this.setEmergencyScanRequestInProgress(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 160: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.removeAppState(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 161: {
                    boolean _arg0 = data.readBoolean();
                    boolean _result = this.setWifiScoringEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 162: {
                    String _arg0 = data.readString();
                    this.flushPasspointAnqpCache(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 163: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    Bundle _arg4 = data.readTypedObject(Bundle.CREATOR);
                    List<WifiAvailableChannel> _result = this.getUsableChannels(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    _Parcel.writeTypedList(reply, _result, 1);
                    break;
                }
                case 164: {
                    boolean _result = this.isWifiPasspointEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 165: {
                    boolean _arg0 = data.readBoolean();
                    this.setWifiPasspointEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 166: {
                    int _result = this.getStaConcurrencyForMultiInternetMode();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 167: {
                    int _arg0 = data.readInt();
                    boolean _result = this.setStaConcurrencyForMultiInternetMode(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 168: {
                    int _arg0 = data.readInt();
                    this.notifyMinimumRequiredWifiSecurityLevelChanged(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 169: {
                    int _arg0 = data.readInt();
                    ArrayList<WifiSsid> _arg1 = data.createTypedArrayList(WifiSsid.CREATOR);
                    this.notifyWifiSsidPolicyChanged(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 170: {
                    String[] _result = this.getOemPrivilegedWifiAdminPackages();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 171: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    String _arg2 = data.readString();
                    this.replyToP2pInvitationReceivedDialog(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 172: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.replyToSimpleDialog(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 173: {
                    WifiSsid _arg0 = data.readTypedObject(WifiSsid.CREATOR);
                    byte[] _arg1 = data.createByteArray();
                    ArrayList<DhcpOption> _arg2 = data.createTypedArrayList(DhcpOption.CREATOR);
                    this.addCustomDhcpOptions(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 174: {
                    WifiSsid _arg0 = data.readTypedObject(WifiSsid.CREATOR);
                    byte[] _arg1 = data.createByteArray();
                    this.removeCustomDhcpOptions(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 175: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    IInterfaceCreationInfoCallback _arg3 = IInterfaceCreationInfoCallback.Stub.asInterface(data.readStrongBinder());
                    this.reportCreateInterfaceImpact(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 176: {
                    int _result = this.getMaxNumberOfChannelsPerRequest();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 177: {
                    ArrayList<QosPolicyParams> _arg0 = data.createTypedArrayList(QosPolicyParams.CREATOR);
                    IBinder _arg1 = data.readStrongBinder();
                    String _arg2 = data.readString();
                    IListListener _arg3 = IListListener.Stub.asInterface(data.readStrongBinder());
                    this.addQosPolicies(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 178: {
                    int[] _arg0 = data.createIntArray();
                    String _arg1 = data.readString();
                    this.removeQosPolicies(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 179: {
                    String _arg0 = data.readString();
                    this.removeAllQosPolicies(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 180: {
                    int _arg0 = data.readInt();
                    this.setLinkLayerStatsPollingInterval(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 181: {
                    IIntegerListener _arg0 = IIntegerListener.Stub.asInterface(data.readStrongBinder());
                    this.getLinkLayerStatsPollingInterval(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 182: {
                    int _arg0 = data.readInt();
                    IBooleanListener _arg1 = IBooleanListener.Stub.asInterface(data.readStrongBinder());
                    this.setMloMode(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 183: {
                    IIntegerListener _arg0 = IIntegerListener.Stub.asInterface(data.readStrongBinder());
                    this.getMloMode(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 184: {
                    IWifiLowLatencyLockListener _arg0 = IWifiLowLatencyLockListener.Stub.asInterface(data.readStrongBinder());
                    this.addWifiLowLatencyLockListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 185: {
                    IWifiLowLatencyLockListener _arg0 = IWifiLowLatencyLockListener.Stub.asInterface(data.readStrongBinder());
                    this.removeWifiLowLatencyLockListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 186: {
                    IIntegerListener _arg0 = IIntegerListener.Stub.asInterface(data.readStrongBinder());
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    this.getMaxMloAssociationLinkCount(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 187: {
                    IIntegerListener _arg0 = IIntegerListener.Stub.asInterface(data.readStrongBinder());
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    this.getMaxMloStrLinkCount(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 188: {
                    IWifiBandsListener _arg0 = IWifiBandsListener.Stub.asInterface(data.readStrongBinder());
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    this.getSupportedSimultaneousBandCombinations(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 187;
        }

        private static class Proxy
        implements IWifiManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getSupportedFeatures() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getWifiActivityEnergyInfoAsync(IOnWifiActivityEnergyInfoListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNetworkSelectionConfig(WifiNetworkSelectionConfig nsConfig) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(nsConfig, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getNetworkSelectionConfig(IWifiNetworkSelectionConfigListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setThirdPartyAppEnablingWifiConfirmationDialogEnabled(boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isThirdPartyAppEnablingWifiConfirmationDialogEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setScreenOnScanSchedule(int[] scanScheduleSeconds, int[] scanType) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(scanScheduleSeconds);
                    _data.writeIntArray(scanType);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOneShotScreenOnConnectivityScanDelayMillis(int delayMs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(delayMs);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getConfiguredNetworks(String packageName, String featureId, boolean callerNetworksOnly) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    _data.writeBoolean(callerNetworksOnly);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getPrivilegedConfiguredNetworks(String packageName, String featureId, Bundle extras) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WifiConfiguration getPrivilegedConnectedNetwork(String packageName, String featureId, Bundle extras) throws RemoteException {
                WifiConfiguration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(WifiConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getAllMatchingFqdnsForScanResults(List<ScanResult> scanResult) throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _Parcel.writeTypedList(_data, scanResult, 0);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSsidsAllowlist(String packageName, List<WifiSsid> ssids) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _Parcel.writeTypedList(_data, ssids, 0);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List getSsidsAllowlist(String packageName) throws RemoteException {
                ArrayList _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readArrayList(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getMatchingOsuProviders(List<ScanResult> scanResult) throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _Parcel.writeTypedList(_data, scanResult, 0);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getMatchingPasspointConfigsForOsuProviders(List<OsuProvider> osuProviders) throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _Parcel.writeTypedList(_data, osuProviders, 0);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addOrUpdateNetwork(WifiConfiguration config, String packageName, Bundle extras) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    _data.writeString(packageName);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WifiManager.AddNetworkResult addOrUpdateNetworkPrivileged(WifiConfiguration config, String packageName) throws RemoteException {
                WifiManager.AddNetworkResult _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(WifiManager.AddNetworkResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean addOrUpdatePasspointConfiguration(PasspointConfiguration config, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removePasspointConfiguration(String fqdn, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(fqdn);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<PasspointConfiguration> getPasspointConfigurations(String packageName) throws RemoteException {
                ArrayList<PasspointConfiguration> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(PasspointConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<WifiConfiguration> getWifiConfigsForPasspointProfiles(List<String> fqdnList) throws RemoteException {
                ArrayList<WifiConfiguration> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringList(fqdnList);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(WifiConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void queryPasspointIcon(long bssid, String fileName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(bssid);
                    _data.writeString(fileName);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int matchProviderWithCurrentNetwork(String fqdn) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(fqdn);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeNetwork(int netId, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeNonCallerConfiguredNetworks(String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enableNetwork(int netId, boolean disableOthers, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    _data.writeBoolean(disableOthers);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean disableNetwork(int netId, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void allowAutojoinGlobal(boolean choice, String packageName, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(choice);
                    _data.writeString(packageName);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void queryAutojoinGlobal(IBooleanListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void allowAutojoin(int netId, boolean choice) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    _data.writeBoolean(choice);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void allowAutojoinPasspoint(String fqdn, boolean enableAutoJoin) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(fqdn);
                    _data.writeBoolean(enableAutoJoin);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMacRandomizationSettingPasspointEnabled(String fqdn, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(fqdn);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPasspointMeteredOverride(String fqdn, int meteredOverride) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(fqdn);
                    _data.writeInt(meteredOverride);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startScan(String packageName, String featureId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ScanResult> getScanResults(String callingPackage, String callingFeatureId) throws RemoteException {
                ArrayList<ScanResult> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(ScanResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getChannelData(IListListener listener, String packageName, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeString(packageName);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean disconnect(String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean reconnect(String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean reassociate(String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WifiInfo getConnectionInfo(String callingPackage, String callingFeatureId) throws RemoteException {
                WifiInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(WifiInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setWifiEnabled(String packageName, boolean enable) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getWifiEnabledState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerDriverCountryCodeChangedListener(IOnWifiDriverCountryCodeChangedListener listener, String packageName, String featureId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterDriverCountryCodeChangedListener(IOnWifiDriverCountryCodeChangedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addWifiNetworkStateChangedListener(IWifiNetworkStateChangedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeWifiNetworkStateChangedListener(IWifiNetworkStateChangedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getCountryCode(String packageName, String featureId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOverrideCountryCode(String country) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(country);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearOverrideCountryCode() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDefaultCountryCode(String country) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(country);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean is24GHzBandSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean is5GHzBandSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean is6GHzBandSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean is60GHzBandSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isWifiStandardSupported(int standard) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(standard);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DhcpInfo getDhcpInfo(String packageName) throws RemoteException {
                DhcpInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(DhcpInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setScanAlwaysAvailable(boolean isAvailable, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(isAvailable);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isScanAlwaysAvailable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean acquireWifiLock(IBinder lock, int lockType, String tag, WorkSource ws) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    _data.writeInt(lockType);
                    _data.writeString(tag);
                    _data.writeTypedObject(ws, 0);
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateWifiLockWorkSource(IBinder lock, WorkSource ws) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    _data.writeTypedObject(ws, 0);
                    boolean _status = this.mRemote.transact(61, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean releaseWifiLock(IBinder lock) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    boolean _status = this.mRemote.transact(62, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initializeMulticastFiltering() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(63, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMulticastEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(64, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void acquireMulticastLock(IBinder binder, String tag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    _data.writeString(tag);
                    boolean _status = this.mRemote.transact(65, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseMulticastLock(String tag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(tag);
                    boolean _status = this.mRemote.transact(66, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateInterfaceIpState(String ifaceName, int mode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(ifaceName);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(67, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDefaultCoexAlgorithmEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(68, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCoexUnsafeChannels(List<CoexUnsafeChannel> unsafeChannels, int mandatoryRestrictions) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _Parcel.writeTypedList(_data, unsafeChannels, 0);
                    _data.writeInt(mandatoryRestrictions);
                    boolean _status = this.mRemote.transact(69, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCoexCallback(ICoexCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(70, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCoexCallback(ICoexCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(71, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startSoftAp(WifiConfiguration wifiConfig, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(wifiConfig, 0);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(72, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startTetheredHotspot(SoftApConfiguration softApConfig, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(softApConfig, 0);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(73, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean stopSoftAp() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(74, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean validateSoftApConfiguration(SoftApConfiguration config) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    boolean _status = this.mRemote.transact(75, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int startLocalOnlyHotspot(ILocalOnlyHotspotCallback callback, String packageName, String featureId, SoftApConfiguration customConfig, Bundle extras) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    _data.writeTypedObject(customConfig, 0);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(76, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopLocalOnlyHotspot() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(77, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerLocalOnlyHotspotSoftApCallback(ISoftApCallback callback, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(78, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterLocalOnlyHotspotSoftApCallback(ISoftApCallback callback, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(79, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startWatchLocalOnlyHotspot(ILocalOnlyHotspotCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(80, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopWatchLocalOnlyHotspot() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(81, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getWifiApEnabledState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(82, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WifiConfiguration getWifiApConfiguration() throws RemoteException {
                WifiConfiguration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(83, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(WifiConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SoftApConfiguration getSoftApConfiguration() throws RemoteException {
                SoftApConfiguration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(84, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SoftApConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void queryLastConfiguredTetheredApPassphraseSinceBoot(IStringListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(85, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setWifiApConfiguration(WifiConfiguration wifiConfig, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(wifiConfig, 0);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(86, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setSoftApConfiguration(SoftApConfiguration softApConfig, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(softApConfig, 0);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(87, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyUserOfApBandConversion(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(88, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableTdls(String remoteIPAddress, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(remoteIPAddress);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(89, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableTdlsWithRemoteIpAddress(String remoteIPAddress, boolean enable, IBooleanListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(remoteIPAddress);
                    _data.writeBoolean(enable);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(90, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableTdlsWithMacAddress(String remoteMacAddress, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(remoteMacAddress);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(91, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableTdlsWithRemoteMacAddress(String remoteMacAddress, boolean enable, IBooleanListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(remoteMacAddress);
                    _data.writeBoolean(enable);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(92, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void isTdlsOperationCurrentlyAvailable(IBooleanListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(93, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getMaxSupportedConcurrentTdlsSessions(IIntegerListener callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(94, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getNumberOfEnabledTdlsSessions(IIntegerListener callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(95, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getCurrentNetworkWpsNfcConfigurationToken() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(96, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableVerboseLogging(int verbose) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(verbose);
                    boolean _status = this.mRemote.transact(97, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getVerboseLoggingLevel() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(98, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableEphemeralNetwork(String SSID, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(SSID);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(99, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void factoryReset(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(100, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Network getCurrentNetwork() throws RemoteException {
                Network _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(101, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Network.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] retrieveBackupData() throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(102, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restoreBackupData(byte[] data) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(data);
                    boolean _status = this.mRemote.transact(103, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] retrieveSoftApBackupData() throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(104, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SoftApConfiguration restoreSoftApBackupData(byte[] data) throws RemoteException {
                SoftApConfiguration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(data);
                    boolean _status = this.mRemote.transact(105, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SoftApConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restoreSupplicantBackupData(byte[] supplicantData, byte[] ipConfigData) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(supplicantData);
                    _data.writeByteArray(ipConfigData);
                    boolean _status = this.mRemote.transact(106, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startSubscriptionProvisioning(OsuProvider provider, IProvisioningCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(provider, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(107, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSoftApCallback(ISoftApCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(108, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSoftApCallback(ISoftApCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(109, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addWifiVerboseLoggingStatusChangedListener(IWifiVerboseLoggingStatusChangedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(110, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeWifiVerboseLoggingStatusChangedListener(IWifiVerboseLoggingStatusChangedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(111, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOnWifiUsabilityStatsListener(IOnWifiUsabilityStatsListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(112, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeOnWifiUsabilityStatsListener(IOnWifiUsabilityStatsListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(113, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerTrafficStateCallback(ITrafficStateCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(114, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterTrafficStateCallback(ITrafficStateCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(115, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerNetworkRequestMatchCallback(INetworkRequestMatchCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(116, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterNetworkRequestMatchCallback(INetworkRequestMatchCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(117, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addNetworkSuggestions(List<WifiNetworkSuggestion> networkSuggestions, String packageName, String featureId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _Parcel.writeTypedList(_data, networkSuggestions, 0);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(118, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int removeNetworkSuggestions(List<WifiNetworkSuggestion> networkSuggestions, String packageName, int action) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _Parcel.writeTypedList(_data, networkSuggestions, 0);
                    _data.writeString(packageName);
                    _data.writeInt(action);
                    boolean _status = this.mRemote.transact(119, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<WifiNetworkSuggestion> getNetworkSuggestions(String packageName) throws RemoteException {
                ArrayList<WifiNetworkSuggestion> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(120, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(WifiNetworkSuggestion.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getFactoryMacAddresses() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(121, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDeviceMobilityState(int state) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(state);
                    boolean _status = this.mRemote.transact(122, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startDppAsConfiguratorInitiator(IBinder binder, String packageName, String enrolleeUri, int selectedNetworkId, int netRole, IDppCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    _data.writeString(packageName);
                    _data.writeString(enrolleeUri);
                    _data.writeInt(selectedNetworkId);
                    _data.writeInt(netRole);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(123, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startDppAsEnrolleeInitiator(IBinder binder, String configuratorUri, IDppCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    _data.writeString(configuratorUri);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(124, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startDppAsEnrolleeResponder(IBinder binder, String deviceInfo, int curve, IDppCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    _data.writeString(deviceInfo);
                    _data.writeInt(curve);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(125, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopDppSession() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(126, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateWifiUsabilityScore(int seqNum, int score, int predictionHorizonSec) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(seqNum);
                    _data.writeInt(score);
                    _data.writeInt(predictionHorizonSec);
                    boolean _status = this.mRemote.transact(127, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connect(WifiConfiguration config, int netId, IActionListener listener, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    _data.writeInt(netId);
                    _data.writeStrongInterface(listener);
                    _data.writeString(packageName);
                    boolean bl = this.mRemote.transact(128, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void save(WifiConfiguration config, IActionListener listener, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    _data.writeStrongInterface(listener);
                    _data.writeString(packageName);
                    boolean bl = this.mRemote.transact(129, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forget(int netId, IActionListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    _data.writeStrongInterface(listener);
                    boolean bl = this.mRemote.transact(130, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerScanResultsCallback(IScanResultsCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(131, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterScanResultsCallback(IScanResultsCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(132, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSuggestionConnectionStatusListener(ISuggestionConnectionStatusListener listener, String packageName, String featureId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(133, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSuggestionConnectionStatusListener(ISuggestionConnectionStatusListener listener, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(134, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addLocalOnlyConnectionStatusListener(ILocalOnlyConnectionStatusListener listener, String packageName, String featureId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(135, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeLocalOnlyConnectionStatusListener(ILocalOnlyConnectionStatusListener listener, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(136, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int calculateSignalLevel(int rssi) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(rssi);
                    boolean _status = this.mRemote.transact(137, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<WifiConfiguration> getWifiConfigForMatchedNetworkSuggestionsSharedWithUser(List<ScanResult> scanResults) throws RemoteException {
                ArrayList<WifiConfiguration> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _Parcel.writeTypedList(_data, scanResults, 0);
                    boolean _status = this.mRemote.transact(138, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(WifiConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setWifiConnectedNetworkScorer(IBinder binder, IWifiConnectedNetworkScorer scorer) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    _data.writeStrongInterface(scorer);
                    boolean _status = this.mRemote.transact(139, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearWifiConnectedNetworkScorer() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(140, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setExternalPnoScanRequest(IBinder binder, IPnoScanResultsCallback callback, List<WifiSsid> ssids, int[] frequencies, String packageName, String featureId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    _data.writeStrongInterface(callback);
                    _Parcel.writeTypedList(_data, ssids, 0);
                    _data.writeIntArray(frequencies);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(141, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearExternalPnoScanRequest() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(142, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getLastCallerInfoForApi(int api, ILastCallerListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(api);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(143, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getMatchingScanResults(List<WifiNetworkSuggestion> networkSuggestions, List<ScanResult> scanResults, String callingPackage, String callingFeatureId) throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _Parcel.writeTypedList(_data, networkSuggestions, 0);
                    _Parcel.writeTypedList(_data, scanResults, 0);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(144, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setScanThrottleEnabled(boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(145, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isScanThrottleEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(146, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getAllMatchingPasspointProfilesForScanResults(List<ScanResult> scanResult) throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _Parcel.writeTypedList(_data, scanResult, 0);
                    boolean _status = this.mRemote.transact(147, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAutoWakeupEnabled(boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(148, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAutoWakeupEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(149, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startRestrictingAutoJoinToSubscriptionId(int subId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(150, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopRestrictingAutoJoinToSubscriptionId() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(151, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCarrierNetworkOffloadEnabled(int subscriptionId, boolean merged, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subscriptionId);
                    _data.writeBoolean(merged);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(152, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCarrierNetworkOffloadEnabled(int subscriptionId, boolean merged) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subscriptionId);
                    _data.writeBoolean(merged);
                    boolean _status = this.mRemote.transact(153, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSubsystemRestartCallback(ISubsystemRestartCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(154, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSubsystemRestartCallback(ISubsystemRestartCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(155, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restartWifiSubsystem() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(156, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addSuggestionUserApprovalStatusListener(ISuggestionUserApprovalStatusListener listener, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(157, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeSuggestionUserApprovalStatusListener(ISuggestionUserApprovalStatusListener listener, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(158, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setEmergencyScanRequestInProgress(boolean inProgress) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(inProgress);
                    boolean _status = this.mRemote.transact(159, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAppState(int targetAppUid, String targetApppackageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(targetAppUid);
                    _data.writeString(targetApppackageName);
                    boolean _status = this.mRemote.transact(160, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setWifiScoringEnabled(boolean enabled) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(161, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void flushPasspointAnqpCache(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(162, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<WifiAvailableChannel> getUsableChannels(int band, int mode, int filter, String packageName, Bundle extras) throws RemoteException {
                ArrayList<WifiAvailableChannel> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(band);
                    _data.writeInt(mode);
                    _data.writeInt(filter);
                    _data.writeString(packageName);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(163, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(WifiAvailableChannel.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isWifiPasspointEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(164, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWifiPasspointEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(165, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getStaConcurrencyForMultiInternetMode() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(166, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setStaConcurrencyForMultiInternetMode(int mode) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(167, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyMinimumRequiredWifiSecurityLevelChanged(int level) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(level);
                    boolean _status = this.mRemote.transact(168, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyWifiSsidPolicyChanged(int policyType, List<WifiSsid> ssids) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(policyType);
                    _Parcel.writeTypedList(_data, ssids, 0);
                    boolean _status = this.mRemote.transact(169, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getOemPrivilegedWifiAdminPackages() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(170, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void replyToP2pInvitationReceivedDialog(int dialogId, boolean accepted, String optionalPin) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(dialogId);
                    _data.writeBoolean(accepted);
                    _data.writeString(optionalPin);
                    boolean _status = this.mRemote.transact(171, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void replyToSimpleDialog(int dialogId, int reply) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(dialogId);
                    _data.writeInt(reply);
                    boolean _status = this.mRemote.transact(172, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addCustomDhcpOptions(WifiSsid ssid, byte[] oui, List<DhcpOption> options) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ssid, 0);
                    _data.writeByteArray(oui);
                    _Parcel.writeTypedList(_data, options, 0);
                    boolean _status = this.mRemote.transact(173, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeCustomDhcpOptions(WifiSsid ssid, byte[] oui) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ssid, 0);
                    _data.writeByteArray(oui);
                    boolean _status = this.mRemote.transact(174, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportCreateInterfaceImpact(String packageName, int interfaceType, boolean requireNewInterface, IInterfaceCreationInfoCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(interfaceType);
                    _data.writeBoolean(requireNewInterface);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(175, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMaxNumberOfChannelsPerRequest() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(176, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addQosPolicies(List<QosPolicyParams> policyParamsList, IBinder binder, String packageName, IListListener callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _Parcel.writeTypedList(_data, policyParamsList, 0);
                    _data.writeStrongBinder(binder);
                    _data.writeString(packageName);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(177, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeQosPolicies(int[] policyIdList, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(policyIdList);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(178, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAllQosPolicies(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(179, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLinkLayerStatsPollingInterval(int intervalMs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(intervalMs);
                    boolean _status = this.mRemote.transact(180, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getLinkLayerStatsPollingInterval(IIntegerListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(181, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMloMode(int mode, IBooleanListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(182, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getMloMode(IIntegerListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(183, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addWifiLowLatencyLockListener(IWifiLowLatencyLockListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(184, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeWifiLowLatencyLockListener(IWifiLowLatencyLockListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(185, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getMaxMloAssociationLinkCount(IIntegerListener listener, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(186, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getMaxMloStrLinkCount(IIntegerListener listener, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(187, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getSupportedSimultaneousBandCombinations(IWifiBandsListener listener, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(188, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWifiManager {
        @Override
        public long getSupportedFeatures() throws RemoteException {
            return 0L;
        }

        @Override
        public void getWifiActivityEnergyInfoAsync(IOnWifiActivityEnergyInfoListener listener) throws RemoteException {
        }

        @Override
        public void setNetworkSelectionConfig(WifiNetworkSelectionConfig nsConfig) throws RemoteException {
        }

        @Override
        public void getNetworkSelectionConfig(IWifiNetworkSelectionConfigListener listener) throws RemoteException {
        }

        @Override
        public void setThirdPartyAppEnablingWifiConfirmationDialogEnabled(boolean enable) throws RemoteException {
        }

        @Override
        public boolean isThirdPartyAppEnablingWifiConfirmationDialogEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void setScreenOnScanSchedule(int[] scanScheduleSeconds, int[] scanType) throws RemoteException {
        }

        @Override
        public void setOneShotScreenOnConnectivityScanDelayMillis(int delayMs) throws RemoteException {
        }

        @Override
        public ParceledListSlice getConfiguredNetworks(String packageName, String featureId, boolean callerNetworksOnly) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getPrivilegedConfiguredNetworks(String packageName, String featureId, Bundle extras) throws RemoteException {
            return null;
        }

        @Override
        public WifiConfiguration getPrivilegedConnectedNetwork(String packageName, String featureId, Bundle extras) throws RemoteException {
            return null;
        }

        @Override
        public Map getAllMatchingFqdnsForScanResults(List<ScanResult> scanResult) throws RemoteException {
            return null;
        }

        @Override
        public void setSsidsAllowlist(String packageName, List<WifiSsid> ssids) throws RemoteException {
        }

        @Override
        public List getSsidsAllowlist(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public Map getMatchingOsuProviders(List<ScanResult> scanResult) throws RemoteException {
            return null;
        }

        @Override
        public Map getMatchingPasspointConfigsForOsuProviders(List<OsuProvider> osuProviders) throws RemoteException {
            return null;
        }

        @Override
        public int addOrUpdateNetwork(WifiConfiguration config, String packageName, Bundle extras) throws RemoteException {
            return 0;
        }

        @Override
        public WifiManager.AddNetworkResult addOrUpdateNetworkPrivileged(WifiConfiguration config, String packageName) throws RemoteException {
            return null;
        }

        @Override
        public boolean addOrUpdatePasspointConfiguration(PasspointConfiguration config, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean removePasspointConfiguration(String fqdn, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public List<PasspointConfiguration> getPasspointConfigurations(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public List<WifiConfiguration> getWifiConfigsForPasspointProfiles(List<String> fqdnList) throws RemoteException {
            return null;
        }

        @Override
        public void queryPasspointIcon(long bssid, String fileName) throws RemoteException {
        }

        @Override
        public int matchProviderWithCurrentNetwork(String fqdn) throws RemoteException {
            return 0;
        }

        @Override
        public boolean removeNetwork(int netId, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean removeNonCallerConfiguredNetworks(String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean enableNetwork(int netId, boolean disableOthers, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean disableNetwork(int netId, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public void allowAutojoinGlobal(boolean choice, String packageName, Bundle extras) throws RemoteException {
        }

        @Override
        public void queryAutojoinGlobal(IBooleanListener listener) throws RemoteException {
        }

        @Override
        public void allowAutojoin(int netId, boolean choice) throws RemoteException {
        }

        @Override
        public void allowAutojoinPasspoint(String fqdn, boolean enableAutoJoin) throws RemoteException {
        }

        @Override
        public void setMacRandomizationSettingPasspointEnabled(String fqdn, boolean enable) throws RemoteException {
        }

        @Override
        public void setPasspointMeteredOverride(String fqdn, int meteredOverride) throws RemoteException {
        }

        @Override
        public boolean startScan(String packageName, String featureId) throws RemoteException {
            return false;
        }

        @Override
        public List<ScanResult> getScanResults(String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public void getChannelData(IListListener listener, String packageName, Bundle extras) throws RemoteException {
        }

        @Override
        public boolean disconnect(String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean reconnect(String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean reassociate(String packageName) throws RemoteException {
            return false;
        }

        @Override
        public WifiInfo getConnectionInfo(String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public boolean setWifiEnabled(String packageName, boolean enable) throws RemoteException {
            return false;
        }

        @Override
        public int getWifiEnabledState() throws RemoteException {
            return 0;
        }

        @Override
        public void registerDriverCountryCodeChangedListener(IOnWifiDriverCountryCodeChangedListener listener, String packageName, String featureId) throws RemoteException {
        }

        @Override
        public void unregisterDriverCountryCodeChangedListener(IOnWifiDriverCountryCodeChangedListener listener) throws RemoteException {
        }

        @Override
        public void addWifiNetworkStateChangedListener(IWifiNetworkStateChangedListener listener) throws RemoteException {
        }

        @Override
        public void removeWifiNetworkStateChangedListener(IWifiNetworkStateChangedListener listener) throws RemoteException {
        }

        @Override
        public String getCountryCode(String packageName, String featureId) throws RemoteException {
            return null;
        }

        @Override
        public void setOverrideCountryCode(String country) throws RemoteException {
        }

        @Override
        public void clearOverrideCountryCode() throws RemoteException {
        }

        @Override
        public void setDefaultCountryCode(String country) throws RemoteException {
        }

        @Override
        public boolean is24GHzBandSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean is5GHzBandSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean is6GHzBandSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean is60GHzBandSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isWifiStandardSupported(int standard) throws RemoteException {
            return false;
        }

        @Override
        public DhcpInfo getDhcpInfo(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public void setScanAlwaysAvailable(boolean isAvailable, String packageName) throws RemoteException {
        }

        @Override
        public boolean isScanAlwaysAvailable() throws RemoteException {
            return false;
        }

        @Override
        public boolean acquireWifiLock(IBinder lock, int lockType, String tag, WorkSource ws) throws RemoteException {
            return false;
        }

        @Override
        public void updateWifiLockWorkSource(IBinder lock, WorkSource ws) throws RemoteException {
        }

        @Override
        public boolean releaseWifiLock(IBinder lock) throws RemoteException {
            return false;
        }

        @Override
        public void initializeMulticastFiltering() throws RemoteException {
        }

        @Override
        public boolean isMulticastEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void acquireMulticastLock(IBinder binder, String tag) throws RemoteException {
        }

        @Override
        public void releaseMulticastLock(String tag) throws RemoteException {
        }

        @Override
        public void updateInterfaceIpState(String ifaceName, int mode) throws RemoteException {
        }

        @Override
        public boolean isDefaultCoexAlgorithmEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void setCoexUnsafeChannels(List<CoexUnsafeChannel> unsafeChannels, int mandatoryRestrictions) throws RemoteException {
        }

        @Override
        public void registerCoexCallback(ICoexCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterCoexCallback(ICoexCallback callback) throws RemoteException {
        }

        @Override
        public boolean startSoftAp(WifiConfiguration wifiConfig, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean startTetheredHotspot(SoftApConfiguration softApConfig, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean stopSoftAp() throws RemoteException {
            return false;
        }

        @Override
        public boolean validateSoftApConfiguration(SoftApConfiguration config) throws RemoteException {
            return false;
        }

        @Override
        public int startLocalOnlyHotspot(ILocalOnlyHotspotCallback callback, String packageName, String featureId, SoftApConfiguration customConfig, Bundle extras) throws RemoteException {
            return 0;
        }

        @Override
        public void stopLocalOnlyHotspot() throws RemoteException {
        }

        @Override
        public void registerLocalOnlyHotspotSoftApCallback(ISoftApCallback callback, Bundle extras) throws RemoteException {
        }

        @Override
        public void unregisterLocalOnlyHotspotSoftApCallback(ISoftApCallback callback, Bundle extras) throws RemoteException {
        }

        @Override
        public void startWatchLocalOnlyHotspot(ILocalOnlyHotspotCallback callback) throws RemoteException {
        }

        @Override
        public void stopWatchLocalOnlyHotspot() throws RemoteException {
        }

        @Override
        public int getWifiApEnabledState() throws RemoteException {
            return 0;
        }

        @Override
        public WifiConfiguration getWifiApConfiguration() throws RemoteException {
            return null;
        }

        @Override
        public SoftApConfiguration getSoftApConfiguration() throws RemoteException {
            return null;
        }

        @Override
        public void queryLastConfiguredTetheredApPassphraseSinceBoot(IStringListener listener) throws RemoteException {
        }

        @Override
        public boolean setWifiApConfiguration(WifiConfiguration wifiConfig, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean setSoftApConfiguration(SoftApConfiguration softApConfig, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public void notifyUserOfApBandConversion(String packageName) throws RemoteException {
        }

        @Override
        public void enableTdls(String remoteIPAddress, boolean enable) throws RemoteException {
        }

        @Override
        public void enableTdlsWithRemoteIpAddress(String remoteIPAddress, boolean enable, IBooleanListener listener) throws RemoteException {
        }

        @Override
        public void enableTdlsWithMacAddress(String remoteMacAddress, boolean enable) throws RemoteException {
        }

        @Override
        public void enableTdlsWithRemoteMacAddress(String remoteMacAddress, boolean enable, IBooleanListener listener) throws RemoteException {
        }

        @Override
        public void isTdlsOperationCurrentlyAvailable(IBooleanListener listener) throws RemoteException {
        }

        @Override
        public void getMaxSupportedConcurrentTdlsSessions(IIntegerListener callback) throws RemoteException {
        }

        @Override
        public void getNumberOfEnabledTdlsSessions(IIntegerListener callback) throws RemoteException {
        }

        @Override
        public String getCurrentNetworkWpsNfcConfigurationToken() throws RemoteException {
            return null;
        }

        @Override
        public void enableVerboseLogging(int verbose) throws RemoteException {
        }

        @Override
        public int getVerboseLoggingLevel() throws RemoteException {
            return 0;
        }

        @Override
        public void disableEphemeralNetwork(String SSID, String packageName) throws RemoteException {
        }

        @Override
        public void factoryReset(String packageName) throws RemoteException {
        }

        @Override
        public Network getCurrentNetwork() throws RemoteException {
            return null;
        }

        @Override
        public byte[] retrieveBackupData() throws RemoteException {
            return null;
        }

        @Override
        public void restoreBackupData(byte[] data) throws RemoteException {
        }

        @Override
        public byte[] retrieveSoftApBackupData() throws RemoteException {
            return null;
        }

        @Override
        public SoftApConfiguration restoreSoftApBackupData(byte[] data) throws RemoteException {
            return null;
        }

        @Override
        public void restoreSupplicantBackupData(byte[] supplicantData, byte[] ipConfigData) throws RemoteException {
        }

        @Override
        public void startSubscriptionProvisioning(OsuProvider provider, IProvisioningCallback callback) throws RemoteException {
        }

        @Override
        public void registerSoftApCallback(ISoftApCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterSoftApCallback(ISoftApCallback callback) throws RemoteException {
        }

        @Override
        public void addWifiVerboseLoggingStatusChangedListener(IWifiVerboseLoggingStatusChangedListener listener) throws RemoteException {
        }

        @Override
        public void removeWifiVerboseLoggingStatusChangedListener(IWifiVerboseLoggingStatusChangedListener listener) throws RemoteException {
        }

        @Override
        public void addOnWifiUsabilityStatsListener(IOnWifiUsabilityStatsListener listener) throws RemoteException {
        }

        @Override
        public void removeOnWifiUsabilityStatsListener(IOnWifiUsabilityStatsListener listener) throws RemoteException {
        }

        @Override
        public void registerTrafficStateCallback(ITrafficStateCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterTrafficStateCallback(ITrafficStateCallback callback) throws RemoteException {
        }

        @Override
        public void registerNetworkRequestMatchCallback(INetworkRequestMatchCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterNetworkRequestMatchCallback(INetworkRequestMatchCallback callback) throws RemoteException {
        }

        @Override
        public int addNetworkSuggestions(List<WifiNetworkSuggestion> networkSuggestions, String packageName, String featureId) throws RemoteException {
            return 0;
        }

        @Override
        public int removeNetworkSuggestions(List<WifiNetworkSuggestion> networkSuggestions, String packageName, int action) throws RemoteException {
            return 0;
        }

        @Override
        public List<WifiNetworkSuggestion> getNetworkSuggestions(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public String[] getFactoryMacAddresses() throws RemoteException {
            return null;
        }

        @Override
        public void setDeviceMobilityState(int state) throws RemoteException {
        }

        @Override
        public void startDppAsConfiguratorInitiator(IBinder binder, String packageName, String enrolleeUri, int selectedNetworkId, int netRole, IDppCallback callback) throws RemoteException {
        }

        @Override
        public void startDppAsEnrolleeInitiator(IBinder binder, String configuratorUri, IDppCallback callback) throws RemoteException {
        }

        @Override
        public void startDppAsEnrolleeResponder(IBinder binder, String deviceInfo, int curve, IDppCallback callback) throws RemoteException {
        }

        @Override
        public void stopDppSession() throws RemoteException {
        }

        @Override
        public void updateWifiUsabilityScore(int seqNum, int score, int predictionHorizonSec) throws RemoteException {
        }

        @Override
        public void connect(WifiConfiguration config, int netId, IActionListener listener, String packageName) throws RemoteException {
        }

        @Override
        public void save(WifiConfiguration config, IActionListener listener, String packageName) throws RemoteException {
        }

        @Override
        public void forget(int netId, IActionListener listener) throws RemoteException {
        }

        @Override
        public void registerScanResultsCallback(IScanResultsCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterScanResultsCallback(IScanResultsCallback callback) throws RemoteException {
        }

        @Override
        public void registerSuggestionConnectionStatusListener(ISuggestionConnectionStatusListener listener, String packageName, String featureId) throws RemoteException {
        }

        @Override
        public void unregisterSuggestionConnectionStatusListener(ISuggestionConnectionStatusListener listener, String packageName) throws RemoteException {
        }

        @Override
        public void addLocalOnlyConnectionStatusListener(ILocalOnlyConnectionStatusListener listener, String packageName, String featureId) throws RemoteException {
        }

        @Override
        public void removeLocalOnlyConnectionStatusListener(ILocalOnlyConnectionStatusListener listener, String packageName) throws RemoteException {
        }

        @Override
        public int calculateSignalLevel(int rssi) throws RemoteException {
            return 0;
        }

        @Override
        public List<WifiConfiguration> getWifiConfigForMatchedNetworkSuggestionsSharedWithUser(List<ScanResult> scanResults) throws RemoteException {
            return null;
        }

        @Override
        public boolean setWifiConnectedNetworkScorer(IBinder binder, IWifiConnectedNetworkScorer scorer) throws RemoteException {
            return false;
        }

        @Override
        public void clearWifiConnectedNetworkScorer() throws RemoteException {
        }

        @Override
        public void setExternalPnoScanRequest(IBinder binder, IPnoScanResultsCallback callback, List<WifiSsid> ssids, int[] frequencies, String packageName, String featureId) throws RemoteException {
        }

        @Override
        public void clearExternalPnoScanRequest() throws RemoteException {
        }

        @Override
        public void getLastCallerInfoForApi(int api, ILastCallerListener listener) throws RemoteException {
        }

        @Override
        public Map getMatchingScanResults(List<WifiNetworkSuggestion> networkSuggestions, List<ScanResult> scanResults, String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public void setScanThrottleEnabled(boolean enable) throws RemoteException {
        }

        @Override
        public boolean isScanThrottleEnabled() throws RemoteException {
            return false;
        }

        @Override
        public Map getAllMatchingPasspointProfilesForScanResults(List<ScanResult> scanResult) throws RemoteException {
            return null;
        }

        @Override
        public void setAutoWakeupEnabled(boolean enable) throws RemoteException {
        }

        @Override
        public boolean isAutoWakeupEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void startRestrictingAutoJoinToSubscriptionId(int subId) throws RemoteException {
        }

        @Override
        public void stopRestrictingAutoJoinToSubscriptionId() throws RemoteException {
        }

        @Override
        public void setCarrierNetworkOffloadEnabled(int subscriptionId, boolean merged, boolean enabled) throws RemoteException {
        }

        @Override
        public boolean isCarrierNetworkOffloadEnabled(int subscriptionId, boolean merged) throws RemoteException {
            return false;
        }

        @Override
        public void registerSubsystemRestartCallback(ISubsystemRestartCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterSubsystemRestartCallback(ISubsystemRestartCallback callback) throws RemoteException {
        }

        @Override
        public void restartWifiSubsystem() throws RemoteException {
        }

        @Override
        public void addSuggestionUserApprovalStatusListener(ISuggestionUserApprovalStatusListener listener, String packageName) throws RemoteException {
        }

        @Override
        public void removeSuggestionUserApprovalStatusListener(ISuggestionUserApprovalStatusListener listener, String packageName) throws RemoteException {
        }

        @Override
        public void setEmergencyScanRequestInProgress(boolean inProgress) throws RemoteException {
        }

        @Override
        public void removeAppState(int targetAppUid, String targetApppackageName) throws RemoteException {
        }

        @Override
        public boolean setWifiScoringEnabled(boolean enabled) throws RemoteException {
            return false;
        }

        @Override
        public void flushPasspointAnqpCache(String packageName) throws RemoteException {
        }

        @Override
        public List<WifiAvailableChannel> getUsableChannels(int band, int mode, int filter, String packageName, Bundle extras) throws RemoteException {
            return null;
        }

        @Override
        public boolean isWifiPasspointEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void setWifiPasspointEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public int getStaConcurrencyForMultiInternetMode() throws RemoteException {
            return 0;
        }

        @Override
        public boolean setStaConcurrencyForMultiInternetMode(int mode) throws RemoteException {
            return false;
        }

        @Override
        public void notifyMinimumRequiredWifiSecurityLevelChanged(int level) throws RemoteException {
        }

        @Override
        public void notifyWifiSsidPolicyChanged(int policyType, List<WifiSsid> ssids) throws RemoteException {
        }

        @Override
        public String[] getOemPrivilegedWifiAdminPackages() throws RemoteException {
            return null;
        }

        @Override
        public void replyToP2pInvitationReceivedDialog(int dialogId, boolean accepted, String optionalPin) throws RemoteException {
        }

        @Override
        public void replyToSimpleDialog(int dialogId, int reply) throws RemoteException {
        }

        @Override
        public void addCustomDhcpOptions(WifiSsid ssid, byte[] oui, List<DhcpOption> options) throws RemoteException {
        }

        @Override
        public void removeCustomDhcpOptions(WifiSsid ssid, byte[] oui) throws RemoteException {
        }

        @Override
        public void reportCreateInterfaceImpact(String packageName, int interfaceType, boolean requireNewInterface, IInterfaceCreationInfoCallback callback) throws RemoteException {
        }

        @Override
        public int getMaxNumberOfChannelsPerRequest() throws RemoteException {
            return 0;
        }

        @Override
        public void addQosPolicies(List<QosPolicyParams> policyParamsList, IBinder binder, String packageName, IListListener callback) throws RemoteException {
        }

        @Override
        public void removeQosPolicies(int[] policyIdList, String packageName) throws RemoteException {
        }

        @Override
        public void removeAllQosPolicies(String packageName) throws RemoteException {
        }

        @Override
        public void setLinkLayerStatsPollingInterval(int intervalMs) throws RemoteException {
        }

        @Override
        public void getLinkLayerStatsPollingInterval(IIntegerListener listener) throws RemoteException {
        }

        @Override
        public void setMloMode(int mode, IBooleanListener listener) throws RemoteException {
        }

        @Override
        public void getMloMode(IIntegerListener listener) throws RemoteException {
        }

        @Override
        public void addWifiLowLatencyLockListener(IWifiLowLatencyLockListener listener) throws RemoteException {
        }

        @Override
        public void removeWifiLowLatencyLockListener(IWifiLowLatencyLockListener listener) throws RemoteException {
        }

        @Override
        public void getMaxMloAssociationLinkCount(IIntegerListener listener, Bundle extras) throws RemoteException {
        }

        @Override
        public void getMaxMloStrLinkCount(IIntegerListener listener, Bundle extras) throws RemoteException {
        }

        @Override
        public void getSupportedSimultaneousBandCombinations(IWifiBandsListener listener, Bundle extras) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

