/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.wifi.IWifiScannerListener;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiScanner;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.WorkSource;
import java.util.ArrayList;
import java.util.List;

public interface IWifiScanner
extends IInterface {
    public Bundle getAvailableChannels(int var1, String var2, String var3, Bundle var4) throws RemoteException;

    public boolean isScanning() throws RemoteException;

    public boolean setScanningEnabled(boolean var1, int var2, String var3) throws RemoteException;

    public void registerScanListener(IWifiScannerListener var1, String var2, String var3) throws RemoteException;

    public void unregisterScanListener(IWifiScannerListener var1, String var2, String var3) throws RemoteException;

    public void startBackgroundScan(IWifiScannerListener var1, WifiScanner.ScanSettings var2, WorkSource var3, String var4, String var5) throws RemoteException;

    public void stopBackgroundScan(IWifiScannerListener var1, String var2, String var3) throws RemoteException;

    public boolean getScanResults(String var1, String var2) throws RemoteException;

    public void startScan(IWifiScannerListener var1, WifiScanner.ScanSettings var2, WorkSource var3, String var4, String var5) throws RemoteException;

    public void stopScan(IWifiScannerListener var1, String var2, String var3) throws RemoteException;

    public List<ScanResult> getSingleScanResults(String var1, String var2) throws RemoteException;

    public void startPnoScan(IWifiScannerListener var1, WifiScanner.ScanSettings var2, WifiScanner.PnoSettings var3, String var4, String var5) throws RemoteException;

    public void stopPnoScan(IWifiScannerListener var1, String var2, String var3) throws RemoteException;

    public void enableVerboseLogging(boolean var1) throws RemoteException;

    public static class _Parcel {
        private static <T extends Parcelable> void writeTypedList(Parcel parcel, List<T> value, int parcelableFlags) {
            if (value == null) {
                parcel.writeInt(-1);
            } else {
                int N = value.size();
                parcel.writeInt(N);
                for (int i = 0; i < N; ++i) {
                    parcel.writeTypedObject((Parcelable)value.get(i), parcelableFlags);
                }
            }
        }
    }

    public static abstract class Stub
    extends Binder
    implements IWifiScanner {
        public static final String DESCRIPTOR = "android.net.wifi.IWifiScanner";
        static final int TRANSACTION_getAvailableChannels = 1;
        static final int TRANSACTION_isScanning = 2;
        static final int TRANSACTION_setScanningEnabled = 3;
        static final int TRANSACTION_registerScanListener = 4;
        static final int TRANSACTION_unregisterScanListener = 5;
        static final int TRANSACTION_startBackgroundScan = 6;
        static final int TRANSACTION_stopBackgroundScan = 7;
        static final int TRANSACTION_getScanResults = 8;
        static final int TRANSACTION_startScan = 9;
        static final int TRANSACTION_stopScan = 10;
        static final int TRANSACTION_getSingleScanResults = 11;
        static final int TRANSACTION_startPnoScan = 12;
        static final int TRANSACTION_stopPnoScan = 13;
        static final int TRANSACTION_enableVerboseLogging = 14;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWifiScanner asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWifiScanner) {
                return (IWifiScanner)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getAvailableChannels";
                }
                case 2: {
                    return "isScanning";
                }
                case 3: {
                    return "setScanningEnabled";
                }
                case 4: {
                    return "registerScanListener";
                }
                case 5: {
                    return "unregisterScanListener";
                }
                case 6: {
                    return "startBackgroundScan";
                }
                case 7: {
                    return "stopBackgroundScan";
                }
                case 8: {
                    return "getScanResults";
                }
                case 9: {
                    return "startScan";
                }
                case 10: {
                    return "stopScan";
                }
                case 11: {
                    return "getSingleScanResults";
                }
                case 12: {
                    return "startPnoScan";
                }
                case 13: {
                    return "stopPnoScan";
                }
                case 14: {
                    return "enableVerboseLogging";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    Bundle _arg3 = data.readTypedObject(Bundle.CREATOR);
                    Bundle _result = this.getAvailableChannels(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    boolean _result = this.isScanning();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 3: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    boolean _result = this.setScanningEnabled(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 4: {
                    IWifiScannerListener _arg0 = IWifiScannerListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    this.registerScanListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    IWifiScannerListener _arg0 = IWifiScannerListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    this.unregisterScanListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    IWifiScannerListener _arg0 = IWifiScannerListener.Stub.asInterface(data.readStrongBinder());
                    WifiScanner.ScanSettings _arg1 = data.readTypedObject(WifiScanner.ScanSettings.CREATOR);
                    WorkSource _arg2 = data.readTypedObject(WorkSource.CREATOR);
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    this.startBackgroundScan(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    IWifiScannerListener _arg0 = IWifiScannerListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    this.stopBackgroundScan(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _result = this.getScanResults(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 9: {
                    IWifiScannerListener _arg0 = IWifiScannerListener.Stub.asInterface(data.readStrongBinder());
                    WifiScanner.ScanSettings _arg1 = data.readTypedObject(WifiScanner.ScanSettings.CREATOR);
                    WorkSource _arg2 = data.readTypedObject(WorkSource.CREATOR);
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    this.startScan(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    IWifiScannerListener _arg0 = IWifiScannerListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    this.stopScan(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    List<ScanResult> _result = this.getSingleScanResults(_arg0, _arg1);
                    reply.writeNoException();
                    _Parcel.writeTypedList(reply, _result, 1);
                    break;
                }
                case 12: {
                    IWifiScannerListener _arg0 = IWifiScannerListener.Stub.asInterface(data.readStrongBinder());
                    WifiScanner.ScanSettings _arg1 = data.readTypedObject(WifiScanner.ScanSettings.CREATOR);
                    WifiScanner.PnoSettings _arg2 = data.readTypedObject(WifiScanner.PnoSettings.CREATOR);
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    this.startPnoScan(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    IWifiScannerListener _arg0 = IWifiScannerListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    this.stopPnoScan(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    boolean _arg0 = data.readBoolean();
                    this.enableVerboseLogging(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 13;
        }

        private static class Proxy
        implements IWifiScanner {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bundle getAvailableChannels(int band, String packageName, String featureId, Bundle extras) throws RemoteException {
                Bundle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(band);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Bundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isScanning() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setScanningEnabled(boolean enable, int tid, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enable);
                    _data.writeInt(tid);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerScanListener(IWifiScannerListener listener, String packageName, String featureId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterScanListener(IWifiScannerListener listener, String packageName, String featureId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startBackgroundScan(IWifiScannerListener listener, WifiScanner.ScanSettings settings, WorkSource workSource, String packageName, String featureId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeTypedObject(settings, 0);
                    _data.writeTypedObject(workSource, 0);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopBackgroundScan(IWifiScannerListener listener, String packageName, String featureId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getScanResults(String packageName, String featureId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startScan(IWifiScannerListener listener, WifiScanner.ScanSettings settings, WorkSource workSource, String packageName, String featureId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeTypedObject(settings, 0);
                    _data.writeTypedObject(workSource, 0);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopScan(IWifiScannerListener listener, String packageName, String featureId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ScanResult> getSingleScanResults(String packageName, String featureId) throws RemoteException {
                ArrayList<ScanResult> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(ScanResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startPnoScan(IWifiScannerListener listener, WifiScanner.ScanSettings scanSettings, WifiScanner.PnoSettings pnoSettings, String packageName, String featureId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeTypedObject(scanSettings, 0);
                    _data.writeTypedObject(pnoSettings, 0);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopPnoScan(IWifiScannerListener listener, String packageName, String featureId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableVerboseLogging(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWifiScanner {
        @Override
        public Bundle getAvailableChannels(int band, String packageName, String featureId, Bundle extras) throws RemoteException {
            return null;
        }

        @Override
        public boolean isScanning() throws RemoteException {
            return false;
        }

        @Override
        public boolean setScanningEnabled(boolean enable, int tid, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public void registerScanListener(IWifiScannerListener listener, String packageName, String featureId) throws RemoteException {
        }

        @Override
        public void unregisterScanListener(IWifiScannerListener listener, String packageName, String featureId) throws RemoteException {
        }

        @Override
        public void startBackgroundScan(IWifiScannerListener listener, WifiScanner.ScanSettings settings, WorkSource workSource, String packageName, String featureId) throws RemoteException {
        }

        @Override
        public void stopBackgroundScan(IWifiScannerListener listener, String packageName, String featureId) throws RemoteException {
        }

        @Override
        public boolean getScanResults(String packageName, String featureId) throws RemoteException {
            return false;
        }

        @Override
        public void startScan(IWifiScannerListener listener, WifiScanner.ScanSettings settings, WorkSource workSource, String packageName, String featureId) throws RemoteException {
        }

        @Override
        public void stopScan(IWifiScannerListener listener, String packageName, String featureId) throws RemoteException {
        }

        @Override
        public List<ScanResult> getSingleScanResults(String packageName, String featureId) throws RemoteException {
            return null;
        }

        @Override
        public void startPnoScan(IWifiScannerListener listener, WifiScanner.ScanSettings scanSettings, WifiScanner.PnoSettings pnoSettings, String packageName, String featureId) throws RemoteException {
        }

        @Override
        public void stopPnoScan(IWifiScannerListener listener, String packageName, String featureId) throws RemoteException {
        }

        @Override
        public void enableVerboseLogging(boolean enabled) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

