/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
public class QosPolicyParams
implements Parcelable {
    private static final String TAG = "QosPolicyParams";
    public static final int DSCP_ANY = -1;
    public static final int PROTOCOL_ANY = -1;
    public static final int PROTOCOL_TCP = 6;
    public static final int PROTOCOL_UDP = 17;
    public static final int PROTOCOL_ESP = 50;
    public static final int DIRECTION_UPLINK = 0;
    public static final int DIRECTION_DOWNLINK = 1;
    public static final int USER_PRIORITY_ANY = -1;
    public static final int USER_PRIORITY_BACKGROUND_LOW = 1;
    public static final int USER_PRIORITY_BACKGROUND_HIGH = 2;
    public static final int USER_PRIORITY_BEST_EFFORT_LOW = 0;
    public static final int USER_PRIORITY_BEST_EFFORT_HIGH = 3;
    public static final int USER_PRIORITY_VIDEO_LOW = 4;
    public static final int USER_PRIORITY_VIDEO_HIGH = 5;
    public static final int USER_PRIORITY_VOICE_LOW = 6;
    public static final int USER_PRIORITY_VOICE_HIGH = 7;
    public static final int IP_VERSION_ANY = -1;
    public static final int IP_VERSION_4 = 4;
    public static final int IP_VERSION_6 = 6;
    public static final int DESTINATION_PORT_ANY = -1;
    private final int mPolicyId;
    private int mTranslatedPolicyId;
    private final int mDscp;
    private final int mUserPriority;
    private final InetAddress mSrcIp;
    private final InetAddress mDstIp;
    private final int mSrcPort;
    private final int mProtocol;
    private final int mDstPort;
    private final int[] mDstPortRange;
    private final int mDirection;
    private final int mIpVersion;
    private final byte[] mFlowLabel;
    public static final Parcelable.Creator<QosPolicyParams> CREATOR = new Parcelable.Creator<QosPolicyParams>(){

        @Override
        public QosPolicyParams createFromParcel(Parcel in) {
            return new QosPolicyParams(in);
        }

        public QosPolicyParams[] newArray(int size) {
            return new QosPolicyParams[size];
        }
    };

    private QosPolicyParams(int policyId, int dscp, int userPriority, InetAddress srcIp, InetAddress dstIp, int srcPort, int protocol, int[] dstPortRange, int direction, int ipVersion, int dstPort, byte[] flowLabel) {
        this.mPolicyId = policyId;
        this.mDscp = dscp;
        this.mUserPriority = userPriority;
        this.mSrcIp = srcIp;
        this.mDstIp = dstIp;
        this.mSrcPort = srcPort;
        this.mProtocol = protocol;
        this.mDstPort = dstPort;
        this.mDstPortRange = dstPortRange;
        this.mDirection = direction;
        this.mIpVersion = ipVersion;
        this.mFlowLabel = flowLabel;
    }

    public boolean validate() {
        if (this.mPolicyId < 1 || this.mPolicyId > 255) {
            Log.e(TAG, "Policy ID not in valid range: " + this.mPolicyId);
            return false;
        }
        if (this.mDscp < -1 || this.mDscp > 63) {
            Log.e(TAG, "DSCP value not in valid range: " + this.mDscp);
            return false;
        }
        if (this.mUserPriority < -1 || this.mUserPriority > 7) {
            Log.e(TAG, "User priority not in valid range: " + this.mUserPriority);
            return false;
        }
        if (this.mSrcPort < -1 || this.mSrcPort > 65535) {
            Log.e(TAG, "Source port not in valid range: " + this.mSrcPort);
            return false;
        }
        if (this.mDstPort < -1 || this.mDstPort > 65535) {
            Log.e(TAG, "Destination port not in valid range: " + this.mDstPort);
            return false;
        }
        if (this.mDstPortRange != null && (this.mDstPortRange[0] < 0 || this.mDstPortRange[0] > 65535 || this.mDstPortRange[1] < 0 || this.mDstPortRange[1] > 65535)) {
            Log.e(TAG, "Dst port range value not valid. start=" + this.mDstPortRange[0] + ", end=" + this.mDstPortRange[1]);
            return false;
        }
        if (this.mDirection != 0 && this.mDirection != 1) {
            Log.e(TAG, "Invalid direction enum: " + this.mDirection);
            return false;
        }
        if (this.mIpVersion != -1 && this.mIpVersion != 4 && this.mIpVersion != 6) {
            Log.e(TAG, "Invalid ipVersion enum: " + this.mIpVersion);
            return false;
        }
        if (this.mIpVersion == 4) {
            if (this.mSrcIp != null && !(this.mSrcIp instanceof Inet4Address)) {
                Log.e(TAG, "Src address does not match IP version " + this.mIpVersion);
                return false;
            }
            if (this.mDstIp != null && !(this.mDstIp instanceof Inet4Address)) {
                Log.e(TAG, "Dst address does not match IP version " + this.mIpVersion);
                return false;
            }
        }
        if (this.mIpVersion == 6) {
            if (this.mSrcIp != null && !(this.mSrcIp instanceof Inet6Address)) {
                Log.e(TAG, "Src address does not match IP version " + this.mIpVersion);
                return false;
            }
            if (this.mDstIp != null && !(this.mDstIp instanceof Inet6Address)) {
                Log.e(TAG, "Dst address does not match IP version " + this.mIpVersion);
                return false;
            }
        }
        if (this.mDirection == 0) {
            if (this.mDscp == -1) {
                Log.e(TAG, "DSCP must be provided for uplink requests");
                return false;
            }
            if (this.mIpVersion != -1) {
                Log.e(TAG, "IP Version should not be set for uplink requests");
                return false;
            }
            if (this.mDstPort != -1) {
                Log.e(TAG, "Single destination port should not be set for uplink requests");
                return false;
            }
            if (this.mFlowLabel != null) {
                Log.e(TAG, "Flow label should not be set for uplink requests");
                return false;
            }
        } else {
            if (this.mUserPriority == -1) {
                Log.e(TAG, "User priority must be provided for downlink requests");
                return false;
            }
            if (this.mIpVersion == -1) {
                Log.e(TAG, "IP version must be provided for downlink requests");
                return false;
            }
            if (this.mDstPortRange != null) {
                Log.e(TAG, "Destination port range should not be set for downlink requests");
                return false;
            }
            if (this.mFlowLabel != null) {
                if (this.mIpVersion != 6) {
                    Log.e(TAG, "Flow label can only be used with IP version 6");
                    return false;
                }
                if (this.mFlowLabel.length != 3) {
                    Log.e(TAG, "Flow label must be of size 3, provided size is " + this.mFlowLabel.length);
                    return false;
                }
            }
        }
        return true;
    }

    public void setTranslatedPolicyId(int translatedPolicyId) {
        this.mTranslatedPolicyId = translatedPolicyId;
    }

    public int getPolicyId() {
        return this.mPolicyId;
    }

    public int getTranslatedPolicyId() {
        return this.mTranslatedPolicyId;
    }

    public int getDscp() {
        return this.mDscp;
    }

    public int getUserPriority() {
        return this.mUserPriority;
    }

    public InetAddress getSourceAddress() {
        return this.mSrcIp;
    }

    public InetAddress getDestinationAddress() {
        return this.mDstIp;
    }

    public int getSourcePort() {
        return this.mSrcPort;
    }

    public int getProtocol() {
        return this.mProtocol;
    }

    public int getDestinationPort() {
        return this.mDstPort;
    }

    public int[] getDestinationPortRange() {
        return this.mDstPortRange;
    }

    public int getDirection() {
        return this.mDirection;
    }

    public int getIpVersion() {
        return this.mIpVersion;
    }

    public byte[] getFlowLabel() {
        return this.mFlowLabel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QosPolicyParams that = (QosPolicyParams)o;
        return this.mPolicyId == that.mPolicyId && this.mDscp == that.mDscp && this.mUserPriority == that.mUserPriority && this.mSrcIp.equals(that.mSrcIp) && this.mDstIp.equals(that.mDstIp) && this.mSrcPort == that.mSrcPort && this.mProtocol == that.mProtocol && this.mDstPort == that.mDstPort && Arrays.equals(this.mDstPortRange, that.mDstPortRange) && this.mDirection == that.mDirection && this.mIpVersion == that.mIpVersion && this.mFlowLabel == that.mFlowLabel;
    }

    public int hashCode() {
        return Objects.hash(this.mPolicyId, this.mDscp, this.mUserPriority, this.mSrcIp, this.mDstIp, this.mSrcPort, this.mProtocol, Arrays.hashCode(this.mDstPortRange), this.mDirection, this.mIpVersion, this.mDstPort, Arrays.hashCode(this.mFlowLabel));
    }

    public String toString() {
        return "{policyId=" + this.mPolicyId + ", dscp=" + this.mDscp + ", userPriority=" + this.mUserPriority + ", srcIp=" + this.mSrcIp + ", dstIp=" + this.mDstIp + ", srcPort=" + this.mSrcPort + ", protocol=" + this.mProtocol + ", dstPort=" + this.mDstPort + ", dstPortRange=" + Arrays.toString(this.mDstPortRange) + ", direction=" + this.mDirection + ", ipVersion=" + this.mIpVersion + ", flowLabel=" + Arrays.toString(this.mFlowLabel) + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private InetAddress getInetAddrOrNull(byte[] byteAddr) {
        if (byteAddr == null) {
            return null;
        }
        try {
            return InetAddress.getByAddress(byteAddr);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mPolicyId);
        dest.writeInt(this.mDscp);
        dest.writeInt(this.mUserPriority);
        dest.writeByteArray(this.mSrcIp != null ? this.mSrcIp.getAddress() : null);
        dest.writeByteArray(this.mDstIp != null ? this.mDstIp.getAddress() : null);
        dest.writeInt(this.mSrcPort);
        dest.writeInt(this.mProtocol);
        dest.writeInt(this.mDstPort);
        dest.writeIntArray(this.mDstPortRange);
        dest.writeInt(this.mDirection);
        dest.writeInt(this.mIpVersion);
        dest.writeByteArray(this.mFlowLabel);
    }

    QosPolicyParams(Parcel in) {
        this.mPolicyId = in.readInt();
        this.mDscp = in.readInt();
        this.mUserPriority = in.readInt();
        this.mSrcIp = this.getInetAddrOrNull(in.createByteArray());
        this.mDstIp = this.getInetAddrOrNull(in.createByteArray());
        this.mSrcPort = in.readInt();
        this.mProtocol = in.readInt();
        this.mDstPort = in.readInt();
        this.mDstPortRange = in.createIntArray();
        this.mDirection = in.readInt();
        this.mIpVersion = in.readInt();
        this.mFlowLabel = in.createByteArray();
    }

    public static class Builder {
        private final int mPolicyId;
        private final int mDirection;
        private InetAddress mSrcIp;
        private InetAddress mDstIp;
        private int mDscp = -1;
        private int mUserPriority = -1;
        private int mSrcPort = -1;
        private int mProtocol = -1;
        private int mDstPort = -1;
        private int[] mDstPortRange;
        private int mIpVersion = -1;
        private byte[] mFlowLabel;

        public Builder(int policyId, int direction) {
            this.mPolicyId = policyId;
            this.mDirection = direction;
        }

        public Builder setSourceAddress(InetAddress value) {
            this.mSrcIp = value;
            return this;
        }

        public Builder setDestinationAddress(InetAddress value) {
            this.mDstIp = value;
            return this;
        }

        public Builder setDscp(int value) {
            this.mDscp = value;
            return this;
        }

        public Builder setUserPriority(int value) {
            this.mUserPriority = value;
            return this;
        }

        public Builder setSourcePort(int value) {
            this.mSrcPort = value;
            return this;
        }

        public Builder setProtocol(int value) {
            this.mProtocol = value;
            return this;
        }

        public Builder setDestinationPort(int value) {
            this.mDstPort = value;
            return this;
        }

        public Builder setDestinationPortRange(int start, int end) {
            this.mDstPortRange = new int[]{start, end};
            return this;
        }

        public Builder setIpVersion(int value) {
            this.mIpVersion = value;
            return this;
        }

        public Builder setFlowLabel(byte[] value) {
            this.mFlowLabel = value;
            return this;
        }

        public QosPolicyParams build() {
            QosPolicyParams params = new QosPolicyParams(this.mPolicyId, this.mDscp, this.mUserPriority, this.mSrcIp, this.mDstIp, this.mSrcPort, this.mProtocol, this.mDstPortRange, this.mDirection, this.mIpVersion, this.mDstPort, this.mFlowLabel);
            if (!params.validate()) {
                throw new IllegalArgumentException("Provided parameters are invalid");
            }
            return params;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IpVersion {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UserPriority {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Direction {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Protocol {
    }
}

