/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.wifi.WifiConfiguration;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.BitSet;
import java.util.Objects;

public class SecurityParams
implements Parcelable {
    private static final String TAG = "SecurityParams";
    public static final int PASSPOINT_R1 = 1;
    public static final int PASSPOINT_R2 = 2;
    public static final int PASSPOINT_R3 = 3;
    private int mSecurityType = 2;
    private boolean mEnabled = true;
    private BitSet mAllowedKeyManagement = new BitSet();
    private BitSet mAllowedProtocols = new BitSet();
    private BitSet mAllowedAuthAlgorithms = new BitSet();
    private BitSet mAllowedPairwiseCiphers = new BitSet();
    private BitSet mAllowedGroupCiphers = new BitSet();
    private BitSet mAllowedGroupManagementCiphers = new BitSet();
    private BitSet mAllowedSuiteBCiphers = new BitSet();
    private boolean mRequirePmf = false;
    private int mPasspointRelease = 2;
    private boolean mIsSaeH2eOnlyMode = false;
    private boolean mIsSaePkOnlyMode = false;
    private boolean mIsAddedByAutoUpgrade = false;
    public static final Parcelable.Creator<SecurityParams> CREATOR = new Parcelable.Creator<SecurityParams>(){

        @Override
        public SecurityParams createFromParcel(Parcel in) {
            SecurityParams params = new SecurityParams();
            params.mSecurityType = in.readInt();
            params.mEnabled = in.readBoolean();
            params.mAllowedKeyManagement = SecurityParams.readBitSet(in);
            params.mAllowedProtocols = SecurityParams.readBitSet(in);
            params.mAllowedAuthAlgorithms = SecurityParams.readBitSet(in);
            params.mAllowedPairwiseCiphers = SecurityParams.readBitSet(in);
            params.mAllowedGroupCiphers = SecurityParams.readBitSet(in);
            params.mAllowedGroupManagementCiphers = SecurityParams.readBitSet(in);
            params.mAllowedSuiteBCiphers = SecurityParams.readBitSet(in);
            params.mRequirePmf = in.readBoolean();
            params.mIsAddedByAutoUpgrade = in.readBoolean();
            params.mIsSaeH2eOnlyMode = in.readBoolean();
            params.mIsSaePkOnlyMode = in.readBoolean();
            return params;
        }

        public SecurityParams[] newArray(int size) {
            return new SecurityParams[size];
        }
    };

    private SecurityParams() {
    }

    public SecurityParams(SecurityParams source) {
        this.mSecurityType = source.mSecurityType;
        this.mEnabled = source.mEnabled;
        this.mAllowedKeyManagement = (BitSet)source.mAllowedKeyManagement.clone();
        this.mAllowedProtocols = (BitSet)source.mAllowedProtocols.clone();
        this.mAllowedAuthAlgorithms = (BitSet)source.mAllowedAuthAlgorithms.clone();
        this.mAllowedPairwiseCiphers = (BitSet)source.mAllowedPairwiseCiphers.clone();
        this.mAllowedGroupCiphers = (BitSet)source.mAllowedGroupCiphers.clone();
        this.mAllowedGroupManagementCiphers = (BitSet)source.mAllowedGroupManagementCiphers.clone();
        this.mAllowedSuiteBCiphers = (BitSet)source.mAllowedSuiteBCiphers.clone();
        this.mRequirePmf = source.mRequirePmf;
        this.mIsSaeH2eOnlyMode = source.mIsSaeH2eOnlyMode;
        this.mIsSaePkOnlyMode = source.mIsSaePkOnlyMode;
        this.mIsAddedByAutoUpgrade = source.mIsAddedByAutoUpgrade;
    }

    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (!(thatObject instanceof SecurityParams)) {
            return false;
        }
        SecurityParams that = (SecurityParams)thatObject;
        if (this.mSecurityType != that.mSecurityType) {
            return false;
        }
        if (this.mEnabled != that.mEnabled) {
            return false;
        }
        if (!this.mAllowedKeyManagement.equals(that.mAllowedKeyManagement)) {
            return false;
        }
        if (!this.mAllowedProtocols.equals(that.mAllowedProtocols)) {
            return false;
        }
        if (!this.mAllowedAuthAlgorithms.equals(that.mAllowedAuthAlgorithms)) {
            return false;
        }
        if (!this.mAllowedPairwiseCiphers.equals(that.mAllowedPairwiseCiphers)) {
            return false;
        }
        if (!this.mAllowedGroupCiphers.equals(that.mAllowedGroupCiphers)) {
            return false;
        }
        if (!this.mAllowedGroupManagementCiphers.equals(that.mAllowedGroupManagementCiphers)) {
            return false;
        }
        if (!this.mAllowedSuiteBCiphers.equals(that.mAllowedSuiteBCiphers)) {
            return false;
        }
        if (this.mRequirePmf != that.mRequirePmf) {
            return false;
        }
        if (this.mIsSaeH2eOnlyMode != that.mIsSaeH2eOnlyMode) {
            return false;
        }
        if (this.mIsSaePkOnlyMode != that.mIsSaePkOnlyMode) {
            return false;
        }
        return this.mIsAddedByAutoUpgrade == that.mIsAddedByAutoUpgrade;
    }

    public int hashCode() {
        return Objects.hash(this.mSecurityType, this.mEnabled, this.mAllowedKeyManagement, this.mAllowedProtocols, this.mAllowedAuthAlgorithms, this.mAllowedPairwiseCiphers, this.mAllowedGroupCiphers, this.mAllowedGroupManagementCiphers, this.mAllowedSuiteBCiphers, this.mRequirePmf, this.mIsSaeH2eOnlyMode, this.mIsSaePkOnlyMode, this.mIsAddedByAutoUpgrade);
    }

    public int getSecurityType() {
        return this.mSecurityType;
    }

    public boolean isSecurityType(int type) {
        return type == this.mSecurityType;
    }

    public boolean isSameSecurityType(SecurityParams params) {
        return params.mSecurityType == this.mSecurityType;
    }

    public void updateLegacyWifiConfiguration(WifiConfiguration config) {
        config.allowedKeyManagement = (BitSet)this.mAllowedKeyManagement.clone();
        config.allowedProtocols = (BitSet)this.mAllowedProtocols.clone();
        config.allowedAuthAlgorithms = (BitSet)this.mAllowedAuthAlgorithms.clone();
        config.allowedPairwiseCiphers = (BitSet)this.mAllowedPairwiseCiphers.clone();
        config.allowedGroupCiphers = (BitSet)this.mAllowedGroupCiphers.clone();
        config.allowedGroupManagementCiphers = (BitSet)this.mAllowedGroupManagementCiphers.clone();
        config.allowedSuiteBCiphers = (BitSet)this.mAllowedSuiteBCiphers.clone();
        config.requirePmf = this.mRequirePmf;
    }

    public void setEnabled(boolean enable) {
        this.mEnabled = enable;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void enableFils(boolean enableFilsSha256, boolean enableFilsSha384) {
        if (enableFilsSha256) {
            this.mAllowedKeyManagement.set(15);
        }
        if (enableFilsSha384) {
            this.mAllowedKeyManagement.set(16);
        }
    }

    public BitSet getAllowedKeyManagement() {
        return (BitSet)this.mAllowedKeyManagement.clone();
    }

    public BitSet getAllowedProtocols() {
        return (BitSet)this.mAllowedProtocols.clone();
    }

    public BitSet getAllowedAuthAlgorithms() {
        return (BitSet)this.mAllowedAuthAlgorithms.clone();
    }

    public BitSet getAllowedPairwiseCiphers() {
        return (BitSet)this.mAllowedPairwiseCiphers.clone();
    }

    public BitSet getAllowedGroupCiphers() {
        return (BitSet)this.mAllowedGroupCiphers.clone();
    }

    public BitSet getAllowedGroupManagementCiphers() {
        return (BitSet)this.mAllowedGroupManagementCiphers.clone();
    }

    public void enableSuiteBCiphers(boolean enableEcdheEcdsa, boolean enableEcdheRsa) {
        if (enableEcdheEcdsa) {
            this.mAllowedSuiteBCiphers.set(0);
        } else {
            this.mAllowedSuiteBCiphers.clear(0);
        }
        if (enableEcdheRsa) {
            this.mAllowedSuiteBCiphers.set(1);
        } else {
            this.mAllowedSuiteBCiphers.clear(1);
        }
    }

    public BitSet getAllowedSuiteBCiphers() {
        return (BitSet)this.mAllowedSuiteBCiphers.clone();
    }

    public void setRequirePmf(boolean required) {
        this.mRequirePmf = required;
    }

    public boolean isRequirePmf() {
        return this.mRequirePmf;
    }

    public boolean isOpenSecurityType() {
        return this.isSecurityType(0) || this.isSecurityType(6);
    }

    public boolean isEnterpriseSecurityType() {
        return this.mAllowedKeyManagement.get(2) || this.mAllowedKeyManagement.get(3) || this.mAllowedKeyManagement.get(10) || this.mAllowedKeyManagement.get(14);
    }

    public void enableSaeH2eOnlyMode(boolean enable) {
        this.mIsSaeH2eOnlyMode = enable;
    }

    public boolean isSaeH2eOnlyMode() {
        return this.mIsSaeH2eOnlyMode;
    }

    public void enableSaePkOnlyMode(boolean enable) {
        this.mIsSaePkOnlyMode = enable;
    }

    public boolean isSaePkOnlyMode() {
        return this.mIsSaePkOnlyMode;
    }

    public void setIsAddedByAutoUpgrade(boolean addedByAutoUpgrade) {
        this.mIsAddedByAutoUpgrade = addedByAutoUpgrade;
    }

    public boolean isAddedByAutoUpgrade() {
        return this.mIsAddedByAutoUpgrade;
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("Security Parameters:\n");
        sbuf.append(" Type: ").append(this.mSecurityType).append("\n");
        sbuf.append(" Enabled: ").append(this.mEnabled).append("\n");
        sbuf.append(" KeyMgmt:");
        for (int k = 0; k < this.mAllowedKeyManagement.size(); ++k) {
            if (!this.mAllowedKeyManagement.get(k)) continue;
            sbuf.append(" ");
            if (k < WifiConfiguration.KeyMgmt.strings.length) {
                sbuf.append(WifiConfiguration.KeyMgmt.strings[k]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append('\n');
        sbuf.append(" Protocols:");
        for (int p = 0; p < this.mAllowedProtocols.size(); ++p) {
            if (!this.mAllowedProtocols.get(p)) continue;
            sbuf.append(" ");
            if (p < WifiConfiguration.Protocol.strings.length) {
                sbuf.append(WifiConfiguration.Protocol.strings[p]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append('\n');
        sbuf.append(" AuthAlgorithms:");
        for (int a = 0; a < this.mAllowedAuthAlgorithms.size(); ++a) {
            if (!this.mAllowedAuthAlgorithms.get(a)) continue;
            sbuf.append(" ");
            if (a < WifiConfiguration.AuthAlgorithm.strings.length) {
                sbuf.append(WifiConfiguration.AuthAlgorithm.strings[a]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append('\n');
        sbuf.append(" PairwiseCiphers:");
        for (int pc = 0; pc < this.mAllowedPairwiseCiphers.size(); ++pc) {
            if (!this.mAllowedPairwiseCiphers.get(pc)) continue;
            sbuf.append(" ");
            if (pc < WifiConfiguration.PairwiseCipher.strings.length) {
                sbuf.append(WifiConfiguration.PairwiseCipher.strings[pc]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append('\n');
        sbuf.append(" GroupCiphers:");
        for (int gc = 0; gc < this.mAllowedGroupCiphers.size(); ++gc) {
            if (!this.mAllowedGroupCiphers.get(gc)) continue;
            sbuf.append(" ");
            if (gc < WifiConfiguration.GroupCipher.strings.length) {
                sbuf.append(WifiConfiguration.GroupCipher.strings[gc]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append('\n');
        sbuf.append(" GroupMgmtCiphers:");
        for (int gmc = 0; gmc < this.mAllowedGroupManagementCiphers.size(); ++gmc) {
            if (!this.mAllowedGroupManagementCiphers.get(gmc)) continue;
            sbuf.append(" ");
            if (gmc < WifiConfiguration.GroupMgmtCipher.strings.length) {
                sbuf.append(WifiConfiguration.GroupMgmtCipher.strings[gmc]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append('\n');
        sbuf.append(" SuiteBCiphers:");
        for (int sbc = 0; sbc < this.mAllowedSuiteBCiphers.size(); ++sbc) {
            if (!this.mAllowedSuiteBCiphers.get(sbc)) continue;
            sbuf.append(" ");
            if (sbc < WifiConfiguration.SuiteBCipher.strings.length) {
                sbuf.append(WifiConfiguration.SuiteBCipher.strings[sbc]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append('\n');
        sbuf.append(" RequirePmf: ").append(this.mRequirePmf).append('\n');
        sbuf.append(" IsAddedByAutoUpgrade: ").append(this.mIsAddedByAutoUpgrade).append("\n");
        sbuf.append(" IsSaeH2eOnlyMode: ").append(this.mIsSaeH2eOnlyMode).append("\n");
        sbuf.append(" IsSaePkOnlyMode: ").append(this.mIsSaePkOnlyMode).append("\n");
        return sbuf.toString();
    }

    private static BitSet readBitSet(Parcel src) {
        int cardinality = src.readInt();
        BitSet set = new BitSet();
        for (int i = 0; i < cardinality; ++i) {
            set.set(src.readInt());
        }
        return set;
    }

    private static void writeBitSet(Parcel dest, BitSet set) {
        int nextSetBit = -1;
        dest.writeInt(set.cardinality());
        while ((nextSetBit = set.nextSetBit(nextSetBit + 1)) != -1) {
            dest.writeInt(nextSetBit);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mSecurityType);
        dest.writeBoolean(this.mEnabled);
        SecurityParams.writeBitSet(dest, this.mAllowedKeyManagement);
        SecurityParams.writeBitSet(dest, this.mAllowedProtocols);
        SecurityParams.writeBitSet(dest, this.mAllowedAuthAlgorithms);
        SecurityParams.writeBitSet(dest, this.mAllowedPairwiseCiphers);
        SecurityParams.writeBitSet(dest, this.mAllowedGroupCiphers);
        SecurityParams.writeBitSet(dest, this.mAllowedGroupManagementCiphers);
        SecurityParams.writeBitSet(dest, this.mAllowedSuiteBCiphers);
        dest.writeBoolean(this.mRequirePmf);
        dest.writeBoolean(this.mIsAddedByAutoUpgrade);
        dest.writeBoolean(this.mIsSaeH2eOnlyMode);
        dest.writeBoolean(this.mIsSaePkOnlyMode);
    }

    public static SecurityParams createSecurityParamsBySecurityType(int securityType) {
        switch (securityType) {
            case 0: {
                return SecurityParams.createOpenParams();
            }
            case 1: {
                return SecurityParams.createWepParams();
            }
            case 2: {
                return SecurityParams.createWpaWpa2PersonalParams();
            }
            case 3: {
                return SecurityParams.createWpaWpa2EnterpriseParams();
            }
            case 4: {
                return SecurityParams.createWpa3PersonalParams();
            }
            case 5: {
                return SecurityParams.createWpa3Enterprise192BitParams();
            }
            case 6: {
                return SecurityParams.createEnhancedOpenParams();
            }
            case 7: {
                return SecurityParams.createWapiPskParams();
            }
            case 8: {
                return SecurityParams.createWapiCertParams();
            }
            case 9: {
                return SecurityParams.createWpa3EnterpriseParams();
            }
            case 10: {
                return SecurityParams.createOsenParams();
            }
            case 11: {
                return SecurityParams.createPasspointParams(2);
            }
            case 12: {
                return SecurityParams.createPasspointParams(3);
            }
            case 13: {
                return SecurityParams.createDppParams();
            }
        }
        throw new IllegalArgumentException("unknown security type " + securityType);
    }

    private static SecurityParams createWpaWpa2EnterpriseParams() {
        SecurityParams params = new SecurityParams();
        params.mSecurityType = 3;
        params.mAllowedKeyManagement.set(2);
        params.mAllowedKeyManagement.set(3);
        params.mAllowedProtocols.set(1);
        params.mAllowedProtocols.set(0);
        params.mAllowedPairwiseCiphers.set(2);
        params.mAllowedPairwiseCiphers.set(1);
        params.mAllowedPairwiseCiphers.set(3);
        params.mAllowedGroupCiphers.set(3);
        params.mAllowedGroupCiphers.set(2);
        params.mAllowedGroupCiphers.set(5);
        return params;
    }

    private static SecurityParams createPasspointParams(int release) {
        SecurityParams params = new SecurityParams();
        switch (release) {
            case 1: 
            case 2: {
                params.mSecurityType = 11;
                break;
            }
            case 3: {
                params.mSecurityType = 12;
                params.mRequirePmf = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid passpoint release " + release);
            }
        }
        params.mAllowedKeyManagement.set(2);
        params.mAllowedKeyManagement.set(3);
        params.mAllowedProtocols.set(1);
        params.mAllowedPairwiseCiphers.set(2);
        params.mAllowedPairwiseCiphers.set(3);
        params.mAllowedGroupCiphers.set(3);
        params.mAllowedGroupCiphers.set(5);
        return params;
    }

    private static SecurityParams createEnhancedOpenParams() {
        SecurityParams params = new SecurityParams();
        params.mSecurityType = 6;
        params.mAllowedKeyManagement.set(9);
        params.mAllowedProtocols.set(1);
        params.mAllowedPairwiseCiphers.set(2);
        params.mAllowedPairwiseCiphers.set(5);
        params.mAllowedPairwiseCiphers.set(3);
        params.mAllowedGroupCiphers.set(3);
        params.mAllowedGroupCiphers.set(7);
        params.mAllowedGroupCiphers.set(5);
        params.mRequirePmf = true;
        return params;
    }

    private static SecurityParams createOpenParams() {
        SecurityParams params = new SecurityParams();
        params.mSecurityType = 0;
        params.mAllowedKeyManagement.set(0);
        params.mAllowedProtocols.set(1);
        params.mAllowedProtocols.set(0);
        return params;
    }

    private static SecurityParams createOsenParams() {
        SecurityParams params = new SecurityParams();
        params.mSecurityType = 10;
        params.mAllowedKeyManagement.set(5);
        params.mAllowedProtocols.set(2);
        params.mAllowedPairwiseCiphers.set(2);
        params.mAllowedPairwiseCiphers.set(1);
        params.mAllowedGroupCiphers.set(3);
        params.mAllowedGroupCiphers.set(2);
        return params;
    }

    private static SecurityParams createWapiCertParams() {
        SecurityParams params = new SecurityParams();
        params.mSecurityType = 8;
        params.mAllowedKeyManagement.set(14);
        params.mAllowedProtocols.set(3);
        params.mAllowedPairwiseCiphers.set(4);
        params.mAllowedGroupCiphers.set(6);
        return params;
    }

    private static SecurityParams createWapiPskParams() {
        SecurityParams params = new SecurityParams();
        params.mSecurityType = 7;
        params.mAllowedKeyManagement.set(13);
        params.mAllowedProtocols.set(3);
        params.mAllowedPairwiseCiphers.set(4);
        params.mAllowedGroupCiphers.set(6);
        return params;
    }

    private static SecurityParams createWepParams() {
        SecurityParams params = new SecurityParams();
        params.mSecurityType = 1;
        params.mAllowedKeyManagement.set(0);
        params.mAllowedProtocols.set(1);
        params.mAllowedAuthAlgorithms.set(0);
        params.mAllowedAuthAlgorithms.set(1);
        params.mAllowedPairwiseCiphers.set(2);
        params.mAllowedPairwiseCiphers.set(1);
        params.mAllowedGroupCiphers.set(3);
        params.mAllowedGroupCiphers.set(2);
        params.mAllowedGroupCiphers.set(0);
        params.mAllowedGroupCiphers.set(1);
        return params;
    }

    private static SecurityParams createWpa3Enterprise192BitParams() {
        SecurityParams params = new SecurityParams();
        params.mSecurityType = 5;
        params.mAllowedKeyManagement.set(2);
        params.mAllowedKeyManagement.set(3);
        params.mAllowedKeyManagement.set(10);
        params.mAllowedProtocols.set(1);
        params.mAllowedPairwiseCiphers.set(5);
        params.mAllowedPairwiseCiphers.set(3);
        params.mAllowedGroupCiphers.set(7);
        params.mAllowedGroupCiphers.set(5);
        params.mAllowedGroupManagementCiphers.set(2);
        params.mRequirePmf = true;
        return params;
    }

    private static SecurityParams createWpa3EnterpriseParams() {
        SecurityParams params = new SecurityParams();
        params.mSecurityType = 9;
        params.mAllowedKeyManagement.set(2);
        params.mAllowedKeyManagement.set(3);
        params.mAllowedProtocols.set(1);
        params.mAllowedPairwiseCiphers.set(2);
        params.mAllowedPairwiseCiphers.set(3);
        params.mAllowedGroupCiphers.set(3);
        params.mAllowedGroupCiphers.set(5);
        params.mRequirePmf = true;
        return params;
    }

    private static SecurityParams createWpa3PersonalParams() {
        SecurityParams params = new SecurityParams();
        params.mSecurityType = 4;
        params.mAllowedKeyManagement.set(8);
        params.mAllowedProtocols.set(1);
        params.mAllowedPairwiseCiphers.set(2);
        params.mAllowedPairwiseCiphers.set(5);
        params.mAllowedPairwiseCiphers.set(3);
        params.mAllowedGroupCiphers.set(3);
        params.mAllowedGroupCiphers.set(7);
        params.mAllowedGroupCiphers.set(5);
        params.mRequirePmf = true;
        return params;
    }

    private static SecurityParams createWpaWpa2PersonalParams() {
        SecurityParams params = new SecurityParams();
        params.mSecurityType = 2;
        params.mAllowedKeyManagement.set(1);
        params.mAllowedProtocols.set(1);
        params.mAllowedProtocols.set(0);
        params.mAllowedPairwiseCiphers.set(2);
        params.mAllowedPairwiseCiphers.set(1);
        params.mAllowedGroupCiphers.set(3);
        params.mAllowedGroupCiphers.set(2);
        params.mAllowedGroupCiphers.set(0);
        params.mAllowedGroupCiphers.set(1);
        return params;
    }

    private static SecurityParams createDppParams() {
        SecurityParams params = new SecurityParams();
        params.mSecurityType = 13;
        params.mAllowedKeyManagement.set(17);
        params.mAllowedProtocols.set(1);
        params.mAllowedPairwiseCiphers.set(2);
        params.mAllowedPairwiseCiphers.set(5);
        params.mAllowedPairwiseCiphers.set(3);
        params.mAllowedGroupCiphers.set(3);
        params.mAllowedGroupCiphers.set(7);
        params.mAllowedGroupCiphers.set(5);
        params.mRequirePmf = true;
        return params;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PasspointRelease {
    }
}

