/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class WifiAvailableChannel
implements Parcelable {
    public static final int OP_MODE_STA = 1;
    public static final int OP_MODE_SAP = 2;
    public static final int OP_MODE_WIFI_DIRECT_CLI = 4;
    public static final int OP_MODE_WIFI_DIRECT_GO = 8;
    public static final int OP_MODE_WIFI_AWARE = 16;
    public static final int OP_MODE_TDLS = 32;
    public static final int FILTER_REGULATORY = 0;
    public static final int FILTER_CELLULAR_COEXISTENCE = 1;
    public static final int FILTER_CONCURRENCY = 2;
    public static final int FILTER_NAN_INSTANT_MODE = 4;
    private int mFrequency;
    private int mOpModes;
    public static final Parcelable.Creator<WifiAvailableChannel> CREATOR = new Parcelable.Creator<WifiAvailableChannel>(){

        @Override
        public WifiAvailableChannel createFromParcel(Parcel in) {
            return new WifiAvailableChannel(in);
        }

        public WifiAvailableChannel[] newArray(int size) {
            return new WifiAvailableChannel[size];
        }
    };

    public WifiAvailableChannel(int freq, int opModes) {
        this.mFrequency = freq;
        this.mOpModes = opModes;
    }

    private WifiAvailableChannel(Parcel in) {
        this.readFromParcel(in);
    }

    private void readFromParcel(Parcel in) {
        this.mFrequency = in.readInt();
        this.mOpModes = in.readInt();
    }

    public int getFrequencyMhz() {
        return this.mFrequency;
    }

    public int getOperationalModes() {
        return this.mOpModes;
    }

    public static int getUsableFilter() {
        return 3;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WifiAvailableChannel that = (WifiAvailableChannel)o;
        return this.mFrequency == that.mFrequency && this.mOpModes == that.mOpModes;
    }

    public int hashCode() {
        return Objects.hash(this.mFrequency, this.mOpModes);
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("mFrequency = ").append(this.mFrequency).append(", mOpModes = ").append(String.format("%x", this.mOpModes));
        return sbuf.toString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mFrequency);
        dest.writeInt(this.mOpModes);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Filter {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OpMode {
    }
}

