/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.SystemApi;
import android.net.MacAddress;
import android.net.wifi.WifiManager;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.Objects;

@SystemApi
public class WifiClient
implements Parcelable {
    private static final String TAG = "WifiClient";
    private final MacAddress mMacAddress;
    private final String mApInstanceIdentifier;
    public static final Parcelable.Creator<WifiClient> CREATOR = new Parcelable.Creator<WifiClient>(){

        @Override
        public WifiClient createFromParcel(Parcel in) {
            return new WifiClient(in);
        }

        public WifiClient[] newArray(int size) {
            return new WifiClient[size];
        }
    };

    public MacAddress getMacAddress() {
        return this.mMacAddress;
    }

    public String getApInstanceIdentifier() {
        return this.mApInstanceIdentifier;
    }

    private WifiClient(Parcel in) {
        this.mMacAddress = (MacAddress)in.readParcelable(null);
        this.mApInstanceIdentifier = in.readString();
    }

    public WifiClient(MacAddress macAddress, String apInstanceIdentifier) {
        if (macAddress == null) {
            Log.wtf(TAG, "Null MacAddress provided");
            this.mMacAddress = WifiManager.ALL_ZEROS_MAC_ADDRESS;
        } else {
            this.mMacAddress = macAddress;
        }
        this.mApInstanceIdentifier = apInstanceIdentifier;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mMacAddress, flags);
        dest.writeString(this.mApInstanceIdentifier);
    }

    public String toString() {
        return "WifiClient{mMacAddress=" + this.mMacAddress + "mApInstanceIdentifier=" + this.mApInstanceIdentifier + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WifiClient)) {
            return false;
        }
        WifiClient client = (WifiClient)o;
        return Objects.equals(this.mMacAddress, client.mMacAddress) && this.mApInstanceIdentifier.equals(client.mApInstanceIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.mMacAddress, this.mApInstanceIdentifier);
    }
}

