/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.MacAddress;
import android.net.MatchAllNetworkSpecifier;
import android.net.NetworkSpecifier;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiNetworkSpecifier;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.wifi.x.com.android.internal.util.Preconditions;
import java.util.Objects;

public class WifiNetworkAgentSpecifier
extends NetworkSpecifier
implements Parcelable {
    private final WifiConfiguration mWifiConfiguration;
    private final int mBand;
    private final boolean mMatchLocalOnlySpecifiers;
    public static final Parcelable.Creator<WifiNetworkAgentSpecifier> CREATOR = new Parcelable.Creator<WifiNetworkAgentSpecifier>(){

        @Override
        public WifiNetworkAgentSpecifier createFromParcel(Parcel in) {
            WifiConfiguration wifiConfiguration = (WifiConfiguration)in.readParcelable(null);
            int band = in.readInt();
            boolean matchLocalOnlySpecifiers = in.readBoolean();
            return new WifiNetworkAgentSpecifier(wifiConfiguration, band, matchLocalOnlySpecifiers);
        }

        public WifiNetworkAgentSpecifier[] newArray(int size) {
            return new WifiNetworkAgentSpecifier[size];
        }
    };

    public WifiNetworkAgentSpecifier(WifiConfiguration wifiConfiguration, int band, boolean matchLocalOnlySpecifiers) {
        Preconditions.checkNotNull(wifiConfiguration);
        this.mWifiConfiguration = wifiConfiguration;
        this.mBand = band;
        this.mMatchLocalOnlySpecifiers = matchLocalOnlySpecifiers;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mWifiConfiguration, flags);
        dest.writeInt(this.mBand);
        dest.writeBoolean(this.mMatchLocalOnlySpecifiers);
    }

    @Override
    public boolean canBeSatisfiedBy(NetworkSpecifier other) {
        if (this == other) {
            return true;
        }
        if (other == null || other instanceof MatchAllNetworkSpecifier) {
            return true;
        }
        if (other instanceof WifiNetworkSpecifier) {
            return this.satisfiesNetworkSpecifier((WifiNetworkSpecifier)other);
        }
        return this.equals(other);
    }

    public boolean satisfiesNetworkSpecifier(WifiNetworkSpecifier ns) {
        MacAddress matchMask;
        MacAddress matchBaseAddress;
        Preconditions.checkNotNull(ns);
        Preconditions.checkNotNull(ns.ssidPatternMatcher);
        Preconditions.checkNotNull(ns.bssidPatternMatcher);
        Preconditions.checkNotNull(ns.wifiConfiguration.allowedKeyManagement);
        Preconditions.checkNotNull(this.mWifiConfiguration.SSID);
        Preconditions.checkNotNull(this.mWifiConfiguration.BSSID);
        Preconditions.checkNotNull(this.mWifiConfiguration.allowedKeyManagement);
        if (!this.mMatchLocalOnlySpecifiers) {
            return ns.getBand() == this.mBand;
        }
        if (ns.getBand() != -1 && ns.getBand() != this.mBand) {
            return false;
        }
        String ssidWithQuotes = this.mWifiConfiguration.SSID;
        Preconditions.checkState(ssidWithQuotes.startsWith("\"") && ssidWithQuotes.endsWith("\""));
        String ssidWithoutQuotes = ssidWithQuotes.substring(1, ssidWithQuotes.length() - 1);
        if (!ns.ssidPatternMatcher.match(ssidWithoutQuotes)) {
            return false;
        }
        MacAddress bssid = MacAddress.fromString(this.mWifiConfiguration.BSSID);
        if (!bssid.matches(matchBaseAddress = (MacAddress)ns.bssidPatternMatcher.first, matchMask = (MacAddress)ns.bssidPatternMatcher.second)) {
            return false;
        }
        return ns.wifiConfiguration.allowedKeyManagement.equals(this.mWifiConfiguration.allowedKeyManagement);
    }

    public int hashCode() {
        return Objects.hash(this.mWifiConfiguration.SSID, this.mWifiConfiguration.BSSID, this.mWifiConfiguration.allowedKeyManagement, this.mBand, this.mMatchLocalOnlySpecifiers);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WifiNetworkAgentSpecifier)) {
            return false;
        }
        WifiNetworkAgentSpecifier lhs = (WifiNetworkAgentSpecifier)obj;
        return Objects.equals(this.mWifiConfiguration.SSID, lhs.mWifiConfiguration.SSID) && Objects.equals(this.mWifiConfiguration.BSSID, lhs.mWifiConfiguration.BSSID) && Objects.equals(this.mWifiConfiguration.allowedKeyManagement, lhs.mWifiConfiguration.allowedKeyManagement) && this.mBand == lhs.mBand && this.mMatchLocalOnlySpecifiers == lhs.mMatchLocalOnlySpecifiers;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WifiNetworkAgentSpecifier [");
        sb.append("WifiConfiguration=").append(", SSID=").append(this.mWifiConfiguration.SSID).append(", BSSID=").append(this.mWifiConfiguration.BSSID).append(", band=").append(this.mBand).append(", mMatchLocalOnlySpecifiers=").append(this.mMatchLocalOnlySpecifiers).append("]");
        return sb.toString();
    }

    @Override
    public NetworkSpecifier redact() {
        return null;
    }
}

