/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import androidx.annotation.RequiresApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
@RequiresApi(value=33)
public class WifiNetworkSelectionConfig
implements Parcelable {
    public static final int ASSOCIATED_NETWORK_SELECTION_OVERRIDE_NONE = 0;
    public static final int ASSOCIATED_NETWORK_SELECTION_OVERRIDE_ENABLED = 1;
    public static final int ASSOCIATED_NETWORK_SELECTION_OVERRIDE_DISABLED = 2;
    public static final int FREQUENCY_WEIGHT_LOW = 0;
    public static final int FREQUENCY_WEIGHT_HIGH = 1;
    private boolean mSufficiencyCheckEnabledWhenScreenOff = true;
    private boolean mSufficiencyCheckEnabledWhenScreenOn = true;
    private boolean mUserConnectChoiceOverrideEnabled = true;
    private boolean mLastSelectionWeightEnabled = true;
    private int mAssociatedNetworkSelectionOverride = 0;
    private int[] mRssi2Thresholds = new int[4];
    private int[] mRssi5Thresholds = new int[4];
    private int[] mRssi6Thresholds = new int[4];
    private SparseArray<Integer> mFrequencyWeights = new SparseArray();
    public static final Parcelable.Creator<WifiNetworkSelectionConfig> CREATOR = new Parcelable.Creator<WifiNetworkSelectionConfig>(){

        @Override
        public WifiNetworkSelectionConfig createFromParcel(Parcel in) {
            WifiNetworkSelectionConfig config = new WifiNetworkSelectionConfig();
            config.mSufficiencyCheckEnabledWhenScreenOff = in.readBoolean();
            config.mSufficiencyCheckEnabledWhenScreenOn = in.readBoolean();
            config.mAssociatedNetworkSelectionOverride = in.readInt();
            config.mUserConnectChoiceOverrideEnabled = in.readBoolean();
            config.mLastSelectionWeightEnabled = in.readBoolean();
            in.readIntArray(config.mRssi2Thresholds);
            in.readIntArray(config.mRssi5Thresholds);
            in.readIntArray(config.mRssi6Thresholds);
            config.mFrequencyWeights = in.readSparseArray(null, Integer.class);
            return config;
        }

        public WifiNetworkSelectionConfig[] newArray(int size) {
            return new WifiNetworkSelectionConfig[size];
        }
    };

    private WifiNetworkSelectionConfig() {
    }

    private WifiNetworkSelectionConfig(WifiNetworkSelectionConfig that) {
        this.mSufficiencyCheckEnabledWhenScreenOff = that.mSufficiencyCheckEnabledWhenScreenOff;
        this.mSufficiencyCheckEnabledWhenScreenOn = that.mSufficiencyCheckEnabledWhenScreenOn;
        this.mAssociatedNetworkSelectionOverride = that.mAssociatedNetworkSelectionOverride;
        this.mUserConnectChoiceOverrideEnabled = that.mUserConnectChoiceOverrideEnabled;
        this.mLastSelectionWeightEnabled = that.mLastSelectionWeightEnabled;
        this.mRssi2Thresholds = that.mRssi2Thresholds;
        this.mRssi5Thresholds = that.mRssi5Thresholds;
        this.mRssi6Thresholds = that.mRssi6Thresholds;
        this.mFrequencyWeights = that.mFrequencyWeights;
    }

    public boolean isSufficiencyCheckEnabledWhenScreenOff() {
        return this.mSufficiencyCheckEnabledWhenScreenOff;
    }

    public boolean isSufficiencyCheckEnabledWhenScreenOn() {
        return this.mSufficiencyCheckEnabledWhenScreenOn;
    }

    public boolean isUserConnectChoiceOverrideEnabled() {
        return this.mUserConnectChoiceOverrideEnabled;
    }

    public boolean isLastSelectionWeightEnabled() {
        return this.mLastSelectionWeightEnabled;
    }

    public int getAssociatedNetworkSelectionOverride() {
        return this.mAssociatedNetworkSelectionOverride;
    }

    private static boolean isValidAssociatedNetworkSelectionOverride(int override) {
        return override >= 0 && override <= 2;
    }

    private static boolean isValidBand(int band) {
        switch (band) {
            case 1: 
            case 2: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private static boolean isValidRssiThresholdArray(int[] thresholds) {
        if (thresholds == null || thresholds.length != 4) {
            return false;
        }
        if (!WifiNetworkSelectionConfig.isRssiThresholdResetArray(thresholds)) {
            int low = -127;
            int high = Math.min(200, -1);
            for (int i = 0; i < thresholds.length; ++i) {
                if (thresholds[i] <= low || thresholds[i] > high) {
                    return false;
                }
                low = thresholds[i];
            }
        }
        return true;
    }

    private static boolean isValidFrequencyWeightArray(SparseArray<Integer> weights) {
        if (weights == null) {
            return false;
        }
        for (int i = 0; i < weights.size(); ++i) {
            int value = weights.valueAt(i);
            if (value >= 0 && value <= 1) continue;
            return false;
        }
        return true;
    }

    public static boolean isRssiThresholdResetArray(int[] thresholds) {
        for (int value : thresholds) {
            if (value == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isValid() {
        return WifiNetworkSelectionConfig.isValidAssociatedNetworkSelectionOverride(this.mAssociatedNetworkSelectionOverride) && WifiNetworkSelectionConfig.isValidRssiThresholdArray(this.mRssi2Thresholds) && WifiNetworkSelectionConfig.isValidRssiThresholdArray(this.mRssi5Thresholds) && WifiNetworkSelectionConfig.isValidRssiThresholdArray(this.mRssi6Thresholds) && WifiNetworkSelectionConfig.isValidFrequencyWeightArray(this.mFrequencyWeights);
    }

    public int[] getRssiThresholds(int band) {
        if (!WifiNetworkSelectionConfig.isValidBand(band)) {
            throw new IllegalArgumentException("Invalid band=" + band);
        }
        switch (band) {
            case 1: {
                return this.mRssi2Thresholds;
            }
            case 2: {
                return this.mRssi5Thresholds;
            }
            case 8: {
                return this.mRssi6Thresholds;
            }
        }
        throw new IllegalArgumentException("Did not find RSSI thresholds for band=" + band);
    }

    public SparseArray<Integer> getFrequencyWeights() {
        return this.mFrequencyWeights;
    }

    public int hashCode() {
        return Objects.hash(this.mSufficiencyCheckEnabledWhenScreenOff, this.mSufficiencyCheckEnabledWhenScreenOn, this.mAssociatedNetworkSelectionOverride, this.mUserConnectChoiceOverrideEnabled, this.mLastSelectionWeightEnabled, Arrays.hashCode(this.mRssi2Thresholds), Arrays.hashCode(this.mRssi5Thresholds), Arrays.hashCode(this.mRssi6Thresholds), this.mFrequencyWeights.contentHashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WifiNetworkSelectionConfig)) {
            return false;
        }
        WifiNetworkSelectionConfig lhs = (WifiNetworkSelectionConfig)obj;
        return this.mSufficiencyCheckEnabledWhenScreenOff == lhs.mSufficiencyCheckEnabledWhenScreenOff && this.mSufficiencyCheckEnabledWhenScreenOn == lhs.mSufficiencyCheckEnabledWhenScreenOn && this.mAssociatedNetworkSelectionOverride == lhs.mAssociatedNetworkSelectionOverride && this.mUserConnectChoiceOverrideEnabled == lhs.mUserConnectChoiceOverrideEnabled && this.mLastSelectionWeightEnabled == lhs.mLastSelectionWeightEnabled && Arrays.equals(this.mRssi2Thresholds, lhs.mRssi2Thresholds) && Arrays.equals(this.mRssi5Thresholds, lhs.mRssi5Thresholds) && Arrays.equals(this.mRssi6Thresholds, lhs.mRssi6Thresholds) && this.mFrequencyWeights.contentEquals(lhs.mFrequencyWeights);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeBoolean(this.mSufficiencyCheckEnabledWhenScreenOff);
        dest.writeBoolean(this.mSufficiencyCheckEnabledWhenScreenOn);
        dest.writeInt(this.mAssociatedNetworkSelectionOverride);
        dest.writeBoolean(this.mUserConnectChoiceOverrideEnabled);
        dest.writeBoolean(this.mLastSelectionWeightEnabled);
        dest.writeIntArray(this.mRssi2Thresholds);
        dest.writeIntArray(this.mRssi5Thresholds);
        dest.writeIntArray(this.mRssi6Thresholds);
        dest.writeSparseArray(this.mFrequencyWeights);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("mSufficiencyCheckEnabledWhenScreenOff=").append(this.mSufficiencyCheckEnabledWhenScreenOff).append(", mSufficiencyCheckEnabledWhenScreenOn=").append(this.mSufficiencyCheckEnabledWhenScreenOn).append(", mAssociatedNetworkSelectionOverride=").append(this.mAssociatedNetworkSelectionOverride).append(", mUserConnectChoiceOverrideEnabled=").append(this.mUserConnectChoiceOverrideEnabled).append(", mLastSelectionWeightEnabled=").append(this.mLastSelectionWeightEnabled).append(", mRssi2Thresholds=").append(Arrays.toString(this.mRssi2Thresholds)).append(", mRssi5Thresholds=").append(Arrays.toString(this.mRssi5Thresholds)).append(", mRssi6Thresholds=").append(Arrays.toString(this.mRssi6Thresholds)).append(", mFrequencyWeights=").append(this.mFrequencyWeights.toString());
        return sb.toString();
    }

    public static class Builder {
        WifiNetworkSelectionConfig mWifiNetworkSelectionConfig = new WifiNetworkSelectionConfig();

        public Builder() {
            this.mWifiNetworkSelectionConfig.mSufficiencyCheckEnabledWhenScreenOff = true;
            this.mWifiNetworkSelectionConfig.mSufficiencyCheckEnabledWhenScreenOn = true;
            this.mWifiNetworkSelectionConfig.mUserConnectChoiceOverrideEnabled = true;
            this.mWifiNetworkSelectionConfig.mLastSelectionWeightEnabled = true;
            this.mWifiNetworkSelectionConfig.mAssociatedNetworkSelectionOverride = 0;
            this.mWifiNetworkSelectionConfig.mRssi2Thresholds = new int[4];
            this.mWifiNetworkSelectionConfig.mRssi5Thresholds = new int[4];
            this.mWifiNetworkSelectionConfig.mRssi6Thresholds = new int[4];
            this.mWifiNetworkSelectionConfig.mFrequencyWeights = new SparseArray();
        }

        public Builder(WifiNetworkSelectionConfig config) {
            this.mWifiNetworkSelectionConfig = config;
        }

        public Builder setSufficiencyCheckEnabledWhenScreenOff(boolean enabled) {
            this.mWifiNetworkSelectionConfig.mSufficiencyCheckEnabledWhenScreenOff = enabled;
            return this;
        }

        public Builder setSufficiencyCheckEnabledWhenScreenOn(boolean enabled) {
            this.mWifiNetworkSelectionConfig.mSufficiencyCheckEnabledWhenScreenOn = enabled;
            return this;
        }

        public Builder setAssociatedNetworkSelectionOverride(int override) throws IllegalArgumentException {
            if (!WifiNetworkSelectionConfig.isValidAssociatedNetworkSelectionOverride(override)) {
                throw new IllegalArgumentException("Invalid override=" + override);
            }
            this.mWifiNetworkSelectionConfig.mAssociatedNetworkSelectionOverride = override;
            return this;
        }

        public Builder setUserConnectChoiceOverrideEnabled(boolean enabled) {
            this.mWifiNetworkSelectionConfig.mUserConnectChoiceOverrideEnabled = enabled;
            return this;
        }

        public Builder setLastSelectionWeightEnabled(boolean enabled) {
            this.mWifiNetworkSelectionConfig.mLastSelectionWeightEnabled = enabled;
            return this;
        }

        public Builder setRssiThresholds(int band, int[] thresholds) throws IllegalArgumentException {
            if (!WifiNetworkSelectionConfig.isValidRssiThresholdArray(thresholds)) {
                throw new IllegalArgumentException("Invalid RSSI thresholds=" + Arrays.toString(thresholds));
            }
            if (!WifiNetworkSelectionConfig.isValidBand(band)) {
                throw new IllegalArgumentException("Invalid band=" + band);
            }
            switch (band) {
                case 1: {
                    this.mWifiNetworkSelectionConfig.mRssi2Thresholds = thresholds;
                    break;
                }
                case 2: {
                    this.mWifiNetworkSelectionConfig.mRssi5Thresholds = thresholds;
                    break;
                }
                case 8: {
                    this.mWifiNetworkSelectionConfig.mRssi6Thresholds = thresholds;
                }
            }
            return this;
        }

        public Builder setFrequencyWeights(SparseArray<Integer> weights) throws IllegalArgumentException {
            if (!WifiNetworkSelectionConfig.isValidFrequencyWeightArray(weights)) {
                if (weights == null) {
                    throw new IllegalArgumentException("Invalid frequency weights=null");
                }
                throw new IllegalArgumentException("Invalid frequency weights=" + weights.toString());
            }
            this.mWifiNetworkSelectionConfig.mFrequencyWeights = weights;
            return this;
        }

        public WifiNetworkSelectionConfig build() {
            return new WifiNetworkSelectionConfig(this.mWifiNetworkSelectionConfig);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FrequencyWeight {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AssociatedNetworkSelectionOverride {
    }
}

