/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.MacAddress;
import android.net.NetworkSpecifier;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiEnterpriseConfig;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiNetworkAgentSpecifier;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PatternMatcher;
import android.text.TextUtils;
import android.util.Pair;
import com.android.wifi.x.com.android.internal.util.Preconditions;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

public class WifiNetworkSpecifier
extends NetworkSpecifier
implements Parcelable {
    private static final String TAG = "WifiNetworkSpecifier";
    public final PatternMatcher ssidPatternMatcher;
    public final Pair<MacAddress, MacAddress> bssidPatternMatcher;
    private final int mBand;
    private final int[] mChannelFreqs;
    public final WifiConfiguration wifiConfiguration;
    public static final Parcelable.Creator<WifiNetworkSpecifier> CREATOR = new Parcelable.Creator<WifiNetworkSpecifier>(){

        @Override
        public WifiNetworkSpecifier createFromParcel(Parcel in) {
            PatternMatcher ssidPatternMatcher = (PatternMatcher)in.readParcelable(null);
            MacAddress baseAddress = (MacAddress)in.readParcelable(null);
            MacAddress mask = (MacAddress)in.readParcelable(null);
            Pair<MacAddress, MacAddress> bssidPatternMatcher = Pair.create(baseAddress, mask);
            int band = in.readInt();
            WifiConfiguration wifiConfiguration = (WifiConfiguration)in.readParcelable(null);
            int[] mChannels = in.createIntArray();
            return new WifiNetworkSpecifier(ssidPatternMatcher, bssidPatternMatcher, band, wifiConfiguration, mChannels);
        }

        public WifiNetworkSpecifier[] newArray(int size) {
            return new WifiNetworkSpecifier[size];
        }
    };

    public static int getBand(int freqMHz) {
        if (ScanResult.is24GHz(freqMHz)) {
            return 1;
        }
        if (ScanResult.is5GHz(freqMHz)) {
            return 2;
        }
        if (ScanResult.is6GHz(freqMHz)) {
            return 8;
        }
        if (ScanResult.is60GHz(freqMHz)) {
            return 16;
        }
        return -1;
    }

    public static boolean validateChannelFrequencyInMhz(int[] channels) {
        if (channels == null) {
            return false;
        }
        for (int channel : channels) {
            if (ScanResult.convertFrequencyMhzToChannelIfSupported(channel) != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean validateBand(int band) {
        switch (band) {
            case -1: 
            case 1: 
            case 2: 
            case 8: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public WifiNetworkSpecifier() throws IllegalAccessException {
        throw new IllegalAccessException("Use the builder to create an instance");
    }

    public WifiNetworkSpecifier(PatternMatcher ssidPatternMatcher, Pair<MacAddress, MacAddress> bssidPatternMatcher, int band, WifiConfiguration wifiConfiguration, int[] channelFreqs) {
        Preconditions.checkNotNull(ssidPatternMatcher);
        Preconditions.checkNotNull(bssidPatternMatcher);
        Preconditions.checkNotNull(wifiConfiguration);
        this.ssidPatternMatcher = ssidPatternMatcher;
        this.bssidPatternMatcher = bssidPatternMatcher;
        this.mBand = band;
        this.wifiConfiguration = wifiConfiguration;
        this.mChannelFreqs = channelFreqs;
    }

    public int getBand() {
        return this.mBand;
    }

    public int[] getPreferredChannelFrequenciesMhz() {
        return (int[])this.mChannelFreqs.clone();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.ssidPatternMatcher, flags);
        dest.writeParcelable((Parcelable)this.bssidPatternMatcher.first, flags);
        dest.writeParcelable((Parcelable)this.bssidPatternMatcher.second, flags);
        dest.writeInt(this.mBand);
        dest.writeParcelable(this.wifiConfiguration, flags);
        dest.writeIntArray(this.mChannelFreqs);
    }

    public int hashCode() {
        return Objects.hash(this.ssidPatternMatcher.getPath(), this.ssidPatternMatcher.getType(), this.bssidPatternMatcher, this.mBand, this.wifiConfiguration.allowedKeyManagement, Arrays.hashCode(this.mChannelFreqs));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WifiNetworkSpecifier)) {
            return false;
        }
        WifiNetworkSpecifier lhs = (WifiNetworkSpecifier)obj;
        return Objects.equals(this.ssidPatternMatcher.getPath(), lhs.ssidPatternMatcher.getPath()) && Objects.equals(this.ssidPatternMatcher.getType(), lhs.ssidPatternMatcher.getType()) && Objects.equals(this.bssidPatternMatcher, lhs.bssidPatternMatcher) && this.mBand == lhs.mBand && Objects.equals(this.wifiConfiguration.allowedKeyManagement, lhs.wifiConfiguration.allowedKeyManagement) && Arrays.equals(this.mChannelFreqs, lhs.mChannelFreqs);
    }

    public String toString() {
        return "WifiNetworkSpecifier [" + ", SSID Match pattern=" + this.ssidPatternMatcher + ", BSSID Match pattern=" + this.bssidPatternMatcher + ", SSID=" + this.wifiConfiguration.SSID + ", BSSID=" + this.wifiConfiguration.BSSID + ", band=" + this.mBand + "]";
    }

    @Override
    public boolean canBeSatisfiedBy(NetworkSpecifier other) {
        if (other instanceof WifiNetworkAgentSpecifier) {
            return ((WifiNetworkAgentSpecifier)other).satisfiesNetworkSpecifier(this);
        }
        return this.equals(other);
    }

    @Override
    public NetworkSpecifier redact() {
        if (!SdkLevel.isAtLeastS()) {
            return this;
        }
        return new Builder().setBand(this.mBand).build();
    }

    public static class Builder {
        private static final String MATCH_ALL_SSID_PATTERN_PATH = ".*";
        private static final String MATCH_EMPTY_SSID_PATTERN_PATH = "";
        private static final Pair<MacAddress, MacAddress> MATCH_NO_BSSID_PATTERN1 = new Pair<MacAddress, MacAddress>(MacAddress.BROADCAST_ADDRESS, MacAddress.BROADCAST_ADDRESS);
        private static final Pair<MacAddress, MacAddress> MATCH_NO_BSSID_PATTERN2 = new Pair<MacAddress, MacAddress>(WifiManager.ALL_ZEROS_MAC_ADDRESS, MacAddress.BROADCAST_ADDRESS);
        private static final Pair<MacAddress, MacAddress> MATCH_ALL_BSSID_PATTERN = new Pair<MacAddress, MacAddress>(WifiManager.ALL_ZEROS_MAC_ADDRESS, WifiManager.ALL_ZEROS_MAC_ADDRESS);
        private static final MacAddress MATCH_EXACT_BSSID_PATTERN_MASK = MacAddress.BROADCAST_ADDRESS;
        private static final int WPA3_ENTERPRISE_AUTO = 0;
        private static final int WPA3_ENTERPRISE_STANDARD = 1;
        private static final int WPA3_ENTERPRISE_192_BIT = 2;
        private PatternMatcher mSsidPatternMatcher = null;
        private Pair<MacAddress, MacAddress> mBssidPatternMatcher = null;
        private boolean mIsEnhancedOpen = false;
        private String mWpa2PskPassphrase = null;
        private String mWpa3SaePassphrase = null;
        private WifiEnterpriseConfig mWpa2EnterpriseConfig = null;
        private WifiEnterpriseConfig mWpa3EnterpriseConfig = null;
        private int mWpa3EnterpriseType = 0;
        private boolean mIsHiddenSSID = false;
        private int mBand = -1;
        private int[] mChannels = new int[0];

        public Builder setSsidPattern(PatternMatcher ssidPattern) {
            Preconditions.checkNotNull(ssidPattern);
            this.mSsidPatternMatcher = ssidPattern;
            return this;
        }

        public Builder setSsid(String ssid) {
            Preconditions.checkNotNull(ssid);
            CharsetEncoder unicodeEncoder = StandardCharsets.UTF_8.newEncoder();
            if (!unicodeEncoder.canEncode(ssid)) {
                throw new IllegalArgumentException("SSID is not a valid unicode string");
            }
            this.mSsidPatternMatcher = new PatternMatcher(ssid, 0);
            return this;
        }

        public Builder setBssidPattern(MacAddress baseAddress, MacAddress mask) {
            Preconditions.checkNotNull(baseAddress);
            Preconditions.checkNotNull(mask);
            this.mBssidPatternMatcher = Pair.create(baseAddress, mask);
            return this;
        }

        public Builder setBssid(MacAddress bssid) {
            Preconditions.checkNotNull(bssid);
            this.mBssidPatternMatcher = Pair.create(bssid, MATCH_EXACT_BSSID_PATTERN_MASK);
            return this;
        }

        public Builder setIsEnhancedOpen(boolean isEnhancedOpen) {
            this.mIsEnhancedOpen = isEnhancedOpen;
            return this;
        }

        public Builder setWpa2Passphrase(String passphrase) {
            Preconditions.checkNotNull(passphrase);
            CharsetEncoder asciiEncoder = StandardCharsets.US_ASCII.newEncoder();
            if (!asciiEncoder.canEncode(passphrase)) {
                throw new IllegalArgumentException("passphrase not ASCII encodable");
            }
            this.mWpa2PskPassphrase = passphrase;
            return this;
        }

        public Builder setWpa3Passphrase(String passphrase) {
            Preconditions.checkNotNull(passphrase);
            CharsetEncoder asciiEncoder = StandardCharsets.US_ASCII.newEncoder();
            if (!asciiEncoder.canEncode(passphrase)) {
                throw new IllegalArgumentException("passphrase not ASCII encodable");
            }
            this.mWpa3SaePassphrase = passphrase;
            return this;
        }

        public Builder setWpa2EnterpriseConfig(WifiEnterpriseConfig enterpriseConfig) {
            Preconditions.checkNotNull(enterpriseConfig);
            this.mWpa2EnterpriseConfig = new WifiEnterpriseConfig(enterpriseConfig);
            return this;
        }

        @Deprecated
        public Builder setWpa3EnterpriseConfig(WifiEnterpriseConfig enterpriseConfig) {
            Preconditions.checkNotNull(enterpriseConfig);
            this.mWpa3EnterpriseConfig = new WifiEnterpriseConfig(enterpriseConfig);
            return this;
        }

        public Builder setWpa3EnterpriseStandardModeConfig(WifiEnterpriseConfig enterpriseConfig) {
            Preconditions.checkNotNull(enterpriseConfig);
            this.mWpa3EnterpriseConfig = new WifiEnterpriseConfig(enterpriseConfig);
            this.mWpa3EnterpriseType = 1;
            return this;
        }

        public Builder setWpa3Enterprise192BitModeConfig(WifiEnterpriseConfig enterpriseConfig) {
            Preconditions.checkNotNull(enterpriseConfig);
            if (enterpriseConfig.getEapMethod() != 1) {
                throw new IllegalArgumentException("The 192-bit mode network type must be TLS");
            }
            if (!WifiEnterpriseConfig.isSuiteBCipherCert(enterpriseConfig.getClientCertificate())) {
                throw new IllegalArgumentException("The client certificate does not meet 192-bit mode requirements.");
            }
            if (!WifiEnterpriseConfig.isSuiteBCipherCert(enterpriseConfig.getCaCertificate())) {
                throw new IllegalArgumentException("The CA certificate does not meet 192-bit mode requirements.");
            }
            this.mWpa3EnterpriseConfig = new WifiEnterpriseConfig(enterpriseConfig);
            this.mWpa3EnterpriseType = 2;
            return this;
        }

        public Builder setIsHiddenSsid(boolean isHiddenSsid) {
            this.mIsHiddenSSID = isHiddenSsid;
            return this;
        }

        public Builder setBand(int band) {
            if (!WifiNetworkSpecifier.validateBand(band)) {
                throw new IllegalArgumentException("Unexpected band in setBand : " + band);
            }
            this.mBand = band;
            return this;
        }

        public Builder setPreferredChannelsFrequenciesMhz(int[] channelFreqs) {
            Objects.requireNonNull(channelFreqs);
            if (!WifiNetworkSpecifier.validateChannelFrequencyInMhz(channelFreqs)) {
                throw new IllegalArgumentException("Invalid channel frequency in the input array");
            }
            this.mChannels = (int[])channelFreqs.clone();
            return this;
        }

        private void setSecurityParamsInWifiConfiguration(WifiConfiguration configuration) {
            if (!TextUtils.isEmpty(this.mWpa2PskPassphrase)) {
                configuration.setSecurityParams(2);
                configuration.preSharedKey = "\"" + this.mWpa2PskPassphrase + "\"";
            } else if (!TextUtils.isEmpty(this.mWpa3SaePassphrase)) {
                configuration.setSecurityParams(4);
                configuration.preSharedKey = "\"" + this.mWpa3SaePassphrase + "\"";
            } else if (this.mWpa2EnterpriseConfig != null) {
                configuration.setSecurityParams(3);
                configuration.enterpriseConfig = this.mWpa2EnterpriseConfig;
            } else if (this.mWpa3EnterpriseConfig != null) {
                if (this.mWpa3EnterpriseType == 0 && this.mWpa3EnterpriseConfig.getEapMethod() == 1 && WifiEnterpriseConfig.isSuiteBCipherCert(this.mWpa3EnterpriseConfig.getClientCertificate()) && WifiEnterpriseConfig.isSuiteBCipherCert(this.mWpa3EnterpriseConfig.getCaCertificate())) {
                    configuration.setSecurityParams(5);
                } else if (this.mWpa3EnterpriseType == 2) {
                    configuration.setSecurityParams(5);
                } else {
                    configuration.setSecurityParams(9);
                }
                configuration.enterpriseConfig = this.mWpa3EnterpriseConfig;
            } else if (this.mIsEnhancedOpen) {
                configuration.setSecurityParams(6);
            } else {
                configuration.setSecurityParams(0);
            }
        }

        private WifiConfiguration buildWifiConfiguration() {
            WifiConfiguration wifiConfiguration = new WifiConfiguration();
            if (this.mSsidPatternMatcher.getType() == 0) {
                wifiConfiguration.SSID = "\"" + this.mSsidPatternMatcher.getPath() + "\"";
            }
            if (this.mBssidPatternMatcher.second == MATCH_EXACT_BSSID_PATTERN_MASK) {
                wifiConfiguration.BSSID = ((MacAddress)this.mBssidPatternMatcher.first).toString();
            }
            this.setSecurityParamsInWifiConfiguration(wifiConfiguration);
            wifiConfiguration.hiddenSSID = this.mIsHiddenSSID;
            return wifiConfiguration;
        }

        private boolean hasSetAnyPattern() {
            return this.mSsidPatternMatcher != null || this.mBssidPatternMatcher != null;
        }

        private void setMatchAnyPatternIfUnset() {
            if (this.mSsidPatternMatcher == null) {
                this.mSsidPatternMatcher = new PatternMatcher(MATCH_ALL_SSID_PATTERN_PATH, 2);
            }
            if (this.mBssidPatternMatcher == null) {
                this.mBssidPatternMatcher = MATCH_ALL_BSSID_PATTERN;
            }
        }

        private boolean hasSetMatchNonePattern() {
            if (this.mSsidPatternMatcher.getType() != 1 && this.mSsidPatternMatcher.getPath().equals(MATCH_EMPTY_SSID_PATTERN_PATH)) {
                return true;
            }
            if (this.mBssidPatternMatcher.equals(MATCH_NO_BSSID_PATTERN1)) {
                return true;
            }
            return this.mBssidPatternMatcher.equals(MATCH_NO_BSSID_PATTERN2);
        }

        private boolean hasSetMatchAllPattern() {
            return this.mSsidPatternMatcher.match(MATCH_EMPTY_SSID_PATTERN_PATH) && this.mBssidPatternMatcher.equals(MATCH_ALL_BSSID_PATTERN);
        }

        private void validateSecurityParams() {
            int numSecurityTypes = 0;
            numSecurityTypes += this.mIsEnhancedOpen ? 1 : 0;
            numSecurityTypes += !TextUtils.isEmpty(this.mWpa2PskPassphrase) ? 1 : 0;
            numSecurityTypes += !TextUtils.isEmpty(this.mWpa3SaePassphrase) ? 1 : 0;
            numSecurityTypes += this.mWpa2EnterpriseConfig != null ? 1 : 0;
            if ((numSecurityTypes += this.mWpa3EnterpriseConfig != null ? 1 : 0) > 1) {
                throw new IllegalStateException("only one of setIsEnhancedOpen, setWpa2Passphrase,setWpa3Passphrase, setWpa2EnterpriseConfig or setWpa3EnterpriseConfig can be invoked for network specifier");
            }
        }

        public WifiNetworkSpecifier build() {
            if (!this.hasSetAnyPattern() && this.mBand == -1) {
                throw new IllegalStateException("one of setSsidPattern/setSsid/setBssidPattern/setBssid/setBand should be invoked for specifier");
            }
            this.setMatchAnyPatternIfUnset();
            if (this.hasSetMatchNonePattern()) {
                throw new IllegalStateException("cannot set match-none pattern for specifier");
            }
            if (this.hasSetMatchAllPattern() && this.mBand == -1) {
                throw new IllegalStateException("cannot set match-all pattern for specifier");
            }
            if (this.mIsHiddenSSID && this.mSsidPatternMatcher.getType() != 0) {
                throw new IllegalStateException("setSsid should also be invoked when setIsHiddenSsid is invoked for network specifier");
            }
            if (this.mChannels.length != 0 && this.mBand != -1) {
                throw new IllegalStateException("cannot setPreferredChannelsFrequencyInMhz with setBand together");
            }
            this.validateSecurityParams();
            return new WifiNetworkSpecifier(this.mSsidPatternMatcher, this.mBssidPatternMatcher, this.mBand, this.buildWifiConfiguration(), this.mChannels);
        }
    }
}

