/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.Context;
import android.net.wifi.IWifiScanner;
import android.net.wifi.IWifiScannerListener;
import android.net.wifi.ScanResult;
import android.net.wifi.SynchronousExecutor;
import android.os.Binder;
import android.os.Bundle;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.WorkSource;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

@SystemApi
public class WifiScanner {
    public static final int WIFI_BAND_INDEX_24_GHZ = 0;
    public static final int WIFI_BAND_INDEX_5_GHZ = 1;
    public static final int WIFI_BAND_INDEX_5_GHZ_DFS_ONLY = 2;
    public static final int WIFI_BAND_INDEX_6_GHZ = 3;
    public static final int WIFI_BAND_INDEX_60_GHZ = 4;
    public static final int WIFI_BAND_COUNT = 5;
    public static final int WIFI_BAND_UNSPECIFIED = 0;
    public static final int WIFI_BAND_24_GHZ = 1;
    public static final int WIFI_BAND_5_GHZ = 2;
    public static final int WIFI_BAND_5_GHZ_DFS_ONLY = 4;
    public static final int WIFI_BAND_6_GHZ = 8;
    public static final int WIFI_BAND_60_GHZ = 16;
    public static final int WIFI_BAND_BOTH = 3;
    public static final int WIFI_BAND_24_GHZ_WITH_5GHZ_DFS = 5;
    public static final int WIFI_BAND_5_GHZ_WITH_DFS = 6;
    public static final int WIFI_BAND_BOTH_WITH_DFS = 7;
    public static final int WIFI_BAND_24_5_6_GHZ = 11;
    public static final int WIFI_BAND_24_5_WITH_DFS_6_GHZ = 15;
    public static final int WIFI_BAND_24_5_6_60_GHZ = 27;
    public static final int WIFI_BAND_24_5_WITH_DFS_6_60_GHZ = 31;
    public static final int WIFI_BAND_ALL = 31;
    public static final int MIN_SCAN_PERIOD_MS = 1000;
    public static final int MAX_SCAN_PERIOD_MS = 1024000;
    public static final int REASON_SUCCEEDED = 0;
    public static final int REASON_UNSPECIFIED = -1;
    public static final int REASON_INVALID_LISTENER = -2;
    public static final int REASON_INVALID_REQUEST = -3;
    public static final int REASON_NOT_AUTHORIZED = -4;
    public static final int REASON_DUPLICATE_REQEUST = -5;
    public static final int REASON_BUSY = -6;
    public static final int REASON_ABORT = -7;
    public static final int REASON_NO_DEVICE = -8;
    public static final int REASON_INVALID_ARGS = -9;
    public static final int REASON_TIMEOUT = -10;
    public static final String GET_AVAILABLE_CHANNELS_EXTRA = "Channels";
    public static final int WIFI_RNR_ENABLED_IF_WIFI_BAND_6_GHZ_SCANNED = 0;
    public static final int WIFI_RNR_ENABLED = 1;
    public static final int WIFI_RNR_NOT_NEEDED = 2;
    public static final int WIFI_SCANNER_SETTINGS_VENDOR_ELEMENTS_MAX_LEN = 512;
    public static final int WIFI_IE_HEAD_LEN = 2;
    @Deprecated
    public static final int REPORT_EVENT_AFTER_BUFFER_FULL = 0;
    public static final int REPORT_EVENT_AFTER_EACH_SCAN = 1;
    public static final int REPORT_EVENT_FULL_SCAN_RESULT = 2;
    public static final int REPORT_EVENT_NO_BATCH = 4;
    public static final int SCAN_TYPE_LOW_LATENCY = 0;
    public static final int SCAN_TYPE_LOW_POWER = 1;
    public static final int SCAN_TYPE_HIGH_ACCURACY = 2;
    public static final int SCAN_TYPE_MAX = 2;
    public static final String SCAN_PARAMS_SCAN_SETTINGS_KEY = "ScanSettings";
    public static final String SCAN_PARAMS_WORK_SOURCE_KEY = "WorkSource";
    public static final String REQUEST_PACKAGE_NAME_KEY = "PackageName";
    public static final String REQUEST_FEATURE_ID_KEY = "FeatureId";
    public static final String PNO_PARAMS_PNO_SETTINGS_KEY = "PnoSettings";
    public static final String PNO_PARAMS_SCAN_SETTINGS_KEY = "ScanSettings";
    private static final String TAG = "WifiScanner";
    private static final boolean DBG = false;
    private static final int BASE = 159744;
    public static final int CMD_START_BACKGROUND_SCAN = 159746;
    public static final int CMD_STOP_BACKGROUND_SCAN = 159747;
    public static final int CMD_GET_SCAN_RESULTS = 159748;
    public static final int CMD_SCAN_RESULT = 159749;
    public static final int CMD_OP_SUCCEEDED = 159761;
    public static final int CMD_OP_FAILED = 159762;
    public static final int CMD_FULL_SCAN_RESULT = 159764;
    public static final int CMD_START_SINGLE_SCAN = 159765;
    public static final int CMD_STOP_SINGLE_SCAN = 159766;
    public static final int CMD_SINGLE_SCAN_COMPLETED = 159767;
    public static final int CMD_START_PNO_SCAN = 159768;
    public static final int CMD_STOP_PNO_SCAN = 159769;
    public static final int CMD_PNO_NETWORK_FOUND = 159770;
    public static final int CMD_REGISTER_SCAN_LISTENER = 159771;
    public static final int CMD_DEREGISTER_SCAN_LISTENER = 159772;
    public static final int CMD_GET_SINGLE_SCAN_RESULTS = 159773;
    public static final int CMD_ENABLE = 159774;
    public static final int CMD_DISABLE = 159775;
    private Context mContext;
    private IWifiScanner mService;
    private final Object mListenerMapLock = new Object();
    private final Map<ActionListener, ServiceListener> mListenerMap = new HashMap<ActionListener, ServiceListener>();

    public static boolean isFullBandScan(int bandsScanned, boolean excludeDfs) {
        return (bandsScanned | 8 | 0x10 | (excludeDfs ? 4 : 0)) == 31;
    }

    @RequiresPermission(value="android.permission.NEARBY_WIFI_DEVICES")
    public List<Integer> getAvailableChannels(int band) {
        try {
            Bundle bundle;
            ArrayList channels;
            Bundle extras = new Bundle();
            if (SdkLevel.isAtLeastS()) {
                extras.putParcelable("EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE", this.mContext.getAttributionSource());
            }
            return (channels = (bundle = this.mService.getAvailableChannels(band, this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), extras)).getIntegerArrayList(GET_AVAILABLE_CHANNELS_EXTRA)) == null ? new ArrayList() : channels;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_STACK")
    public void setScanningEnabled(boolean enable) {
        try {
            this.mService.setScanningEnabled(enable, Process.myTid(), this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.LOCATION_HARDWARE", "android.permission.NETWORK_STACK"})
    public void registerScanListener(Executor executor, ScanListener listener) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(listener, "listener cannot be null");
        ServiceListener serviceListener = new ServiceListener(listener, executor);
        if (!this.addListener(listener, serviceListener)) {
            Binder.clearCallingIdentity();
            executor.execute(() -> listener.onFailure(-5, "Outstanding request with same key not stopped yet"));
            return;
        }
        try {
            this.mService.registerScanListener(serviceListener, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to register listener " + listener);
            this.removeListener(listener);
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.NETWORK_STACK")
    public void registerScanListener(ScanListener listener) {
        this.registerScanListener(new SynchronousExecutor(), listener);
    }

    public void unregisterScanListener(ScanListener listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        ServiceListener serviceListener = this.getServiceListener(listener);
        if (serviceListener == null) {
            Log.e(TAG, "listener does not exist");
            return;
        }
        try {
            this.mService.unregisterScanListener(serviceListener, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to unregister listener");
            throw e.rethrowFromSystemServer();
        }
        finally {
            this.removeListener(listener);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.LOCATION_HARDWARE")
    public boolean isScanning() {
        try {
            return this.mService.isScanning();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.LOCATION_HARDWARE")
    public void startBackgroundScan(ScanSettings settings, ScanListener listener) {
        this.startBackgroundScan(settings, listener, null);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.LOCATION_HARDWARE")
    public void startBackgroundScan(ScanSettings settings, ScanListener listener, WorkSource workSource) {
        Objects.requireNonNull(listener, "listener cannot be null");
        if (this.getServiceListener(listener) != null) {
            return;
        }
        ServiceListener serviceListener = new ServiceListener(listener, new SynchronousExecutor());
        if (!this.addListener(listener, serviceListener)) {
            Log.e(TAG, "listener already exist!");
            return;
        }
        try {
            this.mService.startBackgroundScan(serviceListener, settings, workSource, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.LOCATION_HARDWARE")
    public void stopBackgroundScan(ScanListener listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        ServiceListener serviceListener = this.getServiceListener(listener);
        if (serviceListener == null) {
            Log.e(TAG, "listener does not exist");
            return;
        }
        try {
            this.mService.stopBackgroundScan(serviceListener, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        finally {
            this.removeListener(listener);
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.LOCATION_HARDWARE")
    public boolean getScanResults() {
        try {
            return this.mService.getScanResults(this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.LOCATION_HARDWARE")
    public void startScan(ScanSettings settings, ScanListener listener) {
        this.startScan(settings, listener, null);
    }

    @RequiresPermission(value="android.permission.LOCATION_HARDWARE")
    public void startScan(ScanSettings settings, ScanListener listener, WorkSource workSource) {
        this.startScan(settings, new SynchronousExecutor(), listener, workSource);
    }

    @RequiresPermission(value="android.permission.LOCATION_HARDWARE")
    public void startScan(ScanSettings settings, Executor executor, ScanListener listener, WorkSource workSource) {
        Objects.requireNonNull(listener, "listener cannot be null");
        if (this.getServiceListener(listener) != null) {
            return;
        }
        ServiceListener serviceListener = new ServiceListener(listener, executor);
        if (!this.addListener(listener, serviceListener)) {
            Log.e(TAG, "listener already exist!");
            return;
        }
        try {
            this.mService.startScan(serviceListener, settings, workSource, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.LOCATION_HARDWARE")
    public void stopScan(ScanListener listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        ServiceListener serviceListener = this.getServiceListener(listener);
        if (serviceListener == null) {
            Log.e(TAG, "listener does not exist");
            return;
        }
        try {
            this.mService.stopScan(serviceListener, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        finally {
            this.removeListener(listener);
        }
    }

    @RequiresPermission(value="android.permission.LOCATION_HARDWARE")
    public List<ScanResult> getSingleScanResults() {
        try {
            return this.mService.getSingleScanResults(this.mContext.getPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void startPnoScan(PnoScanListener listener, Executor executor, ScanSettings scanSettings, PnoSettings pnoSettings) {
        scanSettings.isPnoScan = true;
        if (this.getServiceListener(listener) != null) {
            return;
        }
        ServiceListener serviceListener = new ServiceListener(listener, executor);
        if (!this.addListener(listener, serviceListener)) {
            Log.w(TAG, "listener already exist!");
        }
        try {
            this.mService.startPnoScan(serviceListener, scanSettings, pnoSettings, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void startConnectedPnoScan(ScanSettings scanSettings, PnoSettings pnoSettings, Executor executor, PnoScanListener listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        Objects.requireNonNull(pnoSettings, "pnoSettings cannot be null");
        pnoSettings.isConnected = true;
        this.startPnoScan(listener, executor, scanSettings, pnoSettings);
    }

    @RequiresPermission(value="android.permission.NETWORK_STACK")
    public void startDisconnectedPnoScan(ScanSettings scanSettings, PnoSettings pnoSettings, Executor executor, PnoScanListener listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        Objects.requireNonNull(pnoSettings, "pnoSettings cannot be null");
        pnoSettings.isConnected = false;
        this.startPnoScan(listener, executor, scanSettings, pnoSettings);
    }

    @RequiresPermission(value="android.permission.NETWORK_STACK")
    public void stopPnoScan(ScanListener listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        ServiceListener serviceListener = this.getServiceListener(listener);
        if (serviceListener == null) {
            Log.e(TAG, "listener does not exist");
            return;
        }
        try {
            this.mService.stopPnoScan(serviceListener, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        finally {
            this.removeListener(listener);
        }
    }

    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void enableVerboseLogging(boolean enabled) {
        try {
            this.mService.enableVerboseLogging(enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SuppressLint(value={"RequiresPermission"})
    public void configureWifiChange(int rssiSampleSize, int lostApSampleSize, int unchangedSampleSize, int minApsBreachingThreshold, int periodInMs, BssidInfo[] bssidInfos) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @SuppressLint(value={"RequiresPermission"})
    public void startTrackingWifiChange(WifiChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @SuppressLint(value={"RequiresPermission"})
    public void stopTrackingWifiChange(WifiChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    @SystemApi
    @Deprecated
    @SuppressLint(value={"RequiresPermission"})
    public void configureWifiChange(WifiChangeSettings settings) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @SuppressLint(value={"RequiresPermission"})
    public void startTrackingBssids(BssidInfo[] bssidInfos, int apLostThreshold, BssidListener listener) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @SuppressLint(value={"RequiresPermission"})
    public void stopTrackingBssids(BssidListener listener) {
        throw new UnsupportedOperationException();
    }

    public WifiScanner(Context context, IWifiScanner service, Looper looper) {
        this.mContext = context;
        this.mService = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addListener(ActionListener listener, ServiceListener serviceListener) {
        Object object = this.mListenerMapLock;
        synchronized (object) {
            boolean keyExists = this.mListenerMap.containsKey(listener);
            if (keyExists) {
                return false;
            }
            this.mListenerMap.put(listener, serviceListener);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceListener getServiceListener(ActionListener listener) {
        if (listener == null) {
            return null;
        }
        Object object = this.mListenerMapLock;
        synchronized (object) {
            return this.mListenerMap.get(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListener(ActionListener listener) {
        if (listener == null) {
            return;
        }
        Object object = this.mListenerMapLock;
        synchronized (object) {
            this.mListenerMap.remove(listener);
        }
    }

    private class ServiceListener
    extends IWifiScannerListener.Stub {
        private ActionListener mActionListener;
        private Executor mExecutor;

        ServiceListener(ActionListener listener, Executor executor) {
            this.mActionListener = listener;
            this.mExecutor = executor;
        }

        @Override
        public void onSuccess() {
            if (this.mActionListener == null) {
                return;
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(this.mActionListener::onSuccess);
        }

        @Override
        public void onFailure(int reason, String description) {
            if (this.mActionListener == null) {
                return;
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mActionListener.onFailure(reason, description));
            WifiScanner.this.removeListener(this.mActionListener);
        }

        @Override
        public void onResults(ScanData[] results) {
            if (this.mActionListener == null) {
                return;
            }
            if (!(this.mActionListener instanceof ScanListener)) {
                return;
            }
            ScanListener scanListener = (ScanListener)this.mActionListener;
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> scanListener.onResults(results));
        }

        @Override
        public void onFullResult(ScanResult fullScanResult) {
            if (this.mActionListener == null) {
                return;
            }
            if (!(this.mActionListener instanceof ScanListener)) {
                return;
            }
            ScanListener scanListener = (ScanListener)this.mActionListener;
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> scanListener.onFullResult(fullScanResult));
        }

        @Override
        public void onSingleScanCompleted() {
            WifiScanner.this.removeListener(this.mActionListener);
        }

        @Override
        public void onPnoNetworkFound(ScanResult[] results) {
            if (this.mActionListener == null) {
                return;
            }
            if (!(this.mActionListener instanceof PnoScanListener)) {
                return;
            }
            PnoScanListener pnoScanListener = (PnoScanListener)this.mActionListener;
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> pnoScanListener.onPnoNetworkFound(results));
        }
    }

    @SystemApi
    public static interface ActionListener {
        public void onSuccess();

        public void onFailure(int var1, String var2);
    }

    public static interface ScanListener
    extends ActionListener {
        @Deprecated
        public void onPeriodChanged(int var1);

        public void onResults(ScanData[] var1);

        public void onFullResult(ScanResult var1);
    }

    public static class ScanSettings
    implements Parcelable {
        public int band;
        private int mRnrSetting = 0;
        private boolean mEnable6GhzPsc = false;
        public ChannelSpec[] channels;
        @RequiresPermission(value="android.permission.NETWORK_STACK")
        public final List<HiddenNetwork> hiddenNetworks = new ArrayList<HiddenNetwork>();
        private List<ScanResult.InformationElement> mVendorIes = new ArrayList<ScanResult.InformationElement>();
        @Deprecated
        public int periodInMs;
        @Deprecated
        public int reportEvents;
        @Deprecated
        public int numBssidsPerScan;
        @Deprecated
        public int maxScansToCache;
        @Deprecated
        public int maxPeriodInMs;
        @Deprecated
        public int stepCount;
        public boolean isPnoScan;
        @RequiresPermission(value="android.permission.NETWORK_STACK")
        public int type = 0;
        @SystemApi
        public boolean ignoreLocationSettings;
        @SystemApi
        public boolean hideFromAppOps;
        public static final Parcelable.Creator<ScanSettings> CREATOR = new Parcelable.Creator<ScanSettings>(){

            @Override
            public ScanSettings createFromParcel(Parcel in) {
                ScanSettings settings = new ScanSettings();
                settings.band = in.readInt();
                settings.periodInMs = in.readInt();
                settings.reportEvents = in.readInt();
                settings.numBssidsPerScan = in.readInt();
                settings.maxScansToCache = in.readInt();
                settings.maxPeriodInMs = in.readInt();
                settings.stepCount = in.readInt();
                settings.isPnoScan = in.readInt() == 1;
                settings.type = in.readInt();
                settings.ignoreLocationSettings = in.readInt() == 1;
                settings.hideFromAppOps = in.readInt() == 1;
                settings.mRnrSetting = in.readInt();
                settings.mEnable6GhzPsc = in.readBoolean();
                int num_channels = in.readInt();
                settings.channels = new ChannelSpec[num_channels];
                for (int i = 0; i < num_channels; ++i) {
                    int frequency = in.readInt();
                    ChannelSpec spec = new ChannelSpec(frequency);
                    spec.dwellTimeMS = in.readInt();
                    spec.passive = in.readInt() == 1;
                    settings.channels[i] = spec;
                }
                int numNetworks = in.readInt();
                settings.hiddenNetworks.clear();
                for (int i = 0; i < numNetworks; ++i) {
                    String ssid = in.readString();
                    settings.hiddenNetworks.add(new HiddenNetwork(ssid));
                }
                in.readTypedList(settings.mVendorIes, ScanResult.InformationElement.CREATOR);
                return settings;
            }

            public ScanSettings[] newArray(int size) {
                return new ScanSettings[size];
            }
        };

        @RequiresApi(value=31)
        public void set6GhzPscOnlyEnabled(boolean enable) {
            if (!SdkLevel.isAtLeastS()) {
                throw new UnsupportedOperationException();
            }
            this.mEnable6GhzPsc = enable;
        }

        @RequiresApi(value=31)
        public boolean is6GhzPscOnlyEnabled() {
            if (!SdkLevel.isAtLeastS()) {
                throw new UnsupportedOperationException();
            }
            return this.mEnable6GhzPsc;
        }

        @RequiresApi(value=31)
        public void setRnrSetting(int rnrSetting) {
            if (!SdkLevel.isAtLeastS()) {
                throw new UnsupportedOperationException();
            }
            if (rnrSetting < 0 || rnrSetting > 2) {
                throw new IllegalArgumentException("Invalid rnrSetting");
            }
            this.mRnrSetting = rnrSetting;
        }

        @RequiresApi(value=31)
        public int getRnrSetting() {
            if (!SdkLevel.isAtLeastS()) {
                throw new UnsupportedOperationException();
            }
            return this.mRnrSetting;
        }

        @RequiresApi(value=34)
        public void setVendorIes(List<ScanResult.InformationElement> vendorIes) {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException();
            }
            this.mVendorIes.clear();
            int totalBytes = 0;
            for (ScanResult.InformationElement e : vendorIes) {
                if (e.id != 221) {
                    throw new IllegalArgumentException("received InformationElement which is not a Vendor Specific IE (VSIE). VSIEs have an ID = ScanResult.InformationElement.EID_VSA.");
                }
                if (e.bytes == null || e.bytes.length > 255) {
                    throw new IllegalArgumentException("received InformationElement whose payload is null or size is greater than 255.");
                }
                if ((totalBytes += 2 + e.bytes.length) <= 512) continue;
                throw new IllegalArgumentException("received InformationElement whose total size is greater than 512.");
            }
            this.mVendorIes.addAll(vendorIes);
        }

        @RequiresApi(value=34)
        public List<ScanResult.InformationElement> getVendorIes() {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException();
            }
            return this.mVendorIes;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.band);
            dest.writeInt(this.periodInMs);
            dest.writeInt(this.reportEvents);
            dest.writeInt(this.numBssidsPerScan);
            dest.writeInt(this.maxScansToCache);
            dest.writeInt(this.maxPeriodInMs);
            dest.writeInt(this.stepCount);
            dest.writeInt(this.isPnoScan ? 1 : 0);
            dest.writeInt(this.type);
            dest.writeInt(this.ignoreLocationSettings ? 1 : 0);
            dest.writeInt(this.hideFromAppOps ? 1 : 0);
            dest.writeInt(this.mRnrSetting);
            dest.writeBoolean(this.mEnable6GhzPsc);
            if (this.channels != null) {
                dest.writeInt(this.channels.length);
                for (int i = 0; i < this.channels.length; ++i) {
                    dest.writeInt(this.channels[i].frequency);
                    dest.writeInt(this.channels[i].dwellTimeMS);
                    dest.writeInt(this.channels[i].passive ? 1 : 0);
                }
            } else {
                dest.writeInt(0);
            }
            dest.writeInt(this.hiddenNetworks.size());
            for (HiddenNetwork hiddenNetwork : this.hiddenNetworks) {
                dest.writeString(hiddenNetwork.ssid);
            }
            dest.writeTypedList(this.mVendorIes);
        }

        public static class HiddenNetwork {
            public final String ssid;

            public HiddenNetwork(String ssid) {
                this.ssid = ssid;
            }
        }
    }

    public static class PnoSettings
    implements Parcelable {
        public boolean isConnected;
        public int min5GHzRssi;
        public int min24GHzRssi;
        public int min6GHzRssi;
        public int scanIterations;
        public int scanIntervalMultiplier;
        public PnoNetwork[] networkList;
        public static final Parcelable.Creator<PnoSettings> CREATOR = new Parcelable.Creator<PnoSettings>(){

            @Override
            public PnoSettings createFromParcel(Parcel in) {
                PnoSettings settings = new PnoSettings();
                settings.isConnected = in.readInt() == 1;
                settings.min5GHzRssi = in.readInt();
                settings.min24GHzRssi = in.readInt();
                settings.min6GHzRssi = in.readInt();
                settings.scanIterations = in.readInt();
                settings.scanIntervalMultiplier = in.readInt();
                int numNetworks = in.readInt();
                settings.networkList = new PnoNetwork[numNetworks];
                for (int i = 0; i < numNetworks; ++i) {
                    String ssid = in.readString();
                    PnoNetwork network = new PnoNetwork(ssid);
                    network.flags = in.readByte();
                    network.authBitField = in.readByte();
                    network.frequencies = in.createIntArray();
                    settings.networkList[i] = network;
                }
                return settings;
            }

            public PnoSettings[] newArray(int size) {
                return new PnoSettings[size];
            }
        };

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.isConnected ? 1 : 0);
            dest.writeInt(this.min5GHzRssi);
            dest.writeInt(this.min24GHzRssi);
            dest.writeInt(this.min6GHzRssi);
            dest.writeInt(this.scanIterations);
            dest.writeInt(this.scanIntervalMultiplier);
            if (this.networkList != null) {
                dest.writeInt(this.networkList.length);
                for (int i = 0; i < this.networkList.length; ++i) {
                    dest.writeString(this.networkList[i].ssid);
                    dest.writeByte(this.networkList[i].flags);
                    dest.writeByte(this.networkList[i].authBitField);
                    dest.writeIntArray(this.networkList[i].frequencies);
                }
            } else {
                dest.writeInt(0);
            }
        }

        public static class PnoNetwork {
            public static final byte FLAG_DIRECTED_SCAN = 1;
            public static final byte FLAG_A_BAND = 2;
            public static final byte FLAG_G_BAND = 4;
            public static final byte FLAG_STRICT_MATCH = 8;
            public static final byte FLAG_SAME_NETWORK = 16;
            public static final byte AUTH_CODE_OPEN = 1;
            public static final byte AUTH_CODE_PSK = 2;
            public static final byte AUTH_CODE_EAPOL = 4;
            public String ssid;
            public byte flags = 0;
            public byte authBitField = 0;
            public int[] frequencies = new int[0];

            public PnoNetwork(String ssid) {
                this.ssid = ssid;
            }

            public int hashCode() {
                return Objects.hash(this.ssid, this.flags, this.authBitField);
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof PnoNetwork)) {
                    return false;
                }
                PnoNetwork lhs = (PnoNetwork)obj;
                return TextUtils.equals(this.ssid, lhs.ssid) && this.flags == lhs.flags && this.authBitField == lhs.authBitField;
            }
        }
    }

    public static interface PnoScanListener
    extends ScanListener {
        public void onPnoNetworkFound(ScanResult[] var1);
    }

    @SystemApi
    @Deprecated
    public static class HotlistSettings
    implements Parcelable {
        public BssidInfo[] bssidInfos;
        public int apLostThreshold;
        public static final Parcelable.Creator<HotlistSettings> CREATOR = new Parcelable.Creator<HotlistSettings>(){

            @Override
            public HotlistSettings createFromParcel(Parcel in) {
                HotlistSettings settings = new HotlistSettings();
                return settings;
            }

            public HotlistSettings[] newArray(int size) {
                return new HotlistSettings[size];
            }
        };

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
        }
    }

    @Deprecated
    public static interface BssidListener
    extends ActionListener {
        public void onFound(ScanResult[] var1);

        public void onLost(ScanResult[] var1);
    }

    @Deprecated
    public static interface WifiChangeListener
    extends ActionListener {
        public void onChanging(ScanResult[] var1);

        public void onQuiescence(ScanResult[] var1);
    }

    @SystemApi
    @Deprecated
    public static class WifiChangeSettings
    implements Parcelable {
        public int rssiSampleSize;
        public int lostApSampleSize;
        public int unchangedSampleSize;
        public int minApsBreachingThreshold;
        public int periodInMs;
        public BssidInfo[] bssidInfos;
        public static final Parcelable.Creator<WifiChangeSettings> CREATOR = new Parcelable.Creator<WifiChangeSettings>(){

            @Override
            public WifiChangeSettings createFromParcel(Parcel in) {
                return new WifiChangeSettings();
            }

            public WifiChangeSettings[] newArray(int size) {
                return new WifiChangeSettings[size];
            }
        };

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
        }
    }

    @Deprecated
    public static class BssidInfo {
        public String bssid;
        public int low;
        public int high;
        public int frequencyHint;
    }

    public static class ParcelableScanResults
    implements Parcelable {
        public ScanResult[] mResults;
        public static final Parcelable.Creator<ParcelableScanResults> CREATOR = new Parcelable.Creator<ParcelableScanResults>(){

            @Override
            public ParcelableScanResults createFromParcel(Parcel in) {
                int n = in.readInt();
                ScanResult[] results = new ScanResult[n];
                for (int i = 0; i < n; ++i) {
                    results[i] = ScanResult.CREATOR.createFromParcel(in);
                }
                return new ParcelableScanResults(results);
            }

            public ParcelableScanResults[] newArray(int size) {
                return new ParcelableScanResults[size];
            }
        };

        public ParcelableScanResults(ScanResult[] results) {
            this.mResults = results;
        }

        public ScanResult[] getResults() {
            return this.mResults;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            if (this.mResults != null) {
                dest.writeInt(this.mResults.length);
                for (int i = 0; i < this.mResults.length; ++i) {
                    ScanResult result = this.mResults[i];
                    result.writeToParcel(dest, flags);
                }
            } else {
                dest.writeInt(0);
            }
        }
    }

    public static class ParcelableScanData
    implements Parcelable {
        public ScanData[] mResults;
        public static final Parcelable.Creator<ParcelableScanData> CREATOR = new Parcelable.Creator<ParcelableScanData>(){

            @Override
            public ParcelableScanData createFromParcel(Parcel in) {
                int n = in.readInt();
                ScanData[] results = new ScanData[n];
                for (int i = 0; i < n; ++i) {
                    results[i] = ScanData.CREATOR.createFromParcel(in);
                }
                return new ParcelableScanData(results);
            }

            public ParcelableScanData[] newArray(int size) {
                return new ParcelableScanData[size];
            }
        };

        public ParcelableScanData(ScanData[] results) {
            this.mResults = results;
        }

        public ScanData[] getResults() {
            return this.mResults;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            if (this.mResults != null) {
                dest.writeInt(this.mResults.length);
                for (int i = 0; i < this.mResults.length; ++i) {
                    ScanData result = this.mResults[i];
                    result.writeToParcel(dest, flags);
                }
            } else {
                dest.writeInt(0);
            }
        }
    }

    public static class ScanData
    implements Parcelable {
        private int mId;
        private int mFlags;
        private int mBucketsScanned;
        private int mScannedBands;
        private final List<ScanResult> mResults;
        public static final Parcelable.Creator<ScanData> CREATOR = new Parcelable.Creator<ScanData>(){

            @Override
            public ScanData createFromParcel(Parcel in) {
                int id2 = in.readInt();
                int flags = in.readInt();
                int bucketsScanned = in.readInt();
                int bandsScanned = in.readInt();
                ArrayList<ScanResult> results = new ArrayList<ScanResult>();
                in.readParcelableList(results, ScanResult.class.getClassLoader());
                return new ScanData(id2, flags, bucketsScanned, bandsScanned, results);
            }

            public ScanData[] newArray(int size) {
                return new ScanData[size];
            }
        };

        ScanData() {
            this.mResults = new ArrayList<ScanResult>();
        }

        public ScanData(int id2, int flags, ScanResult[] results) {
            this.mId = id2;
            this.mFlags = flags;
            this.mResults = new ArrayList<ScanResult>(Arrays.asList(results));
        }

        public ScanData(int id2, int flags, int bucketsScanned, int bandsScanned, ScanResult[] results) {
            this(id2, flags, bucketsScanned, bandsScanned, new ArrayList<ScanResult>(Arrays.asList(results)));
        }

        public ScanData(int id2, int flags, int bucketsScanned, int bandsScanned, List<ScanResult> results) {
            this.mId = id2;
            this.mFlags = flags;
            this.mBucketsScanned = bucketsScanned;
            this.mScannedBands = bandsScanned;
            this.mResults = results;
        }

        public ScanData(ScanData s) {
            this.mId = s.mId;
            this.mFlags = s.mFlags;
            this.mBucketsScanned = s.mBucketsScanned;
            this.mScannedBands = s.mScannedBands;
            this.mResults = new ArrayList<ScanResult>();
            for (ScanResult scanResult : s.mResults) {
                this.mResults.add(new ScanResult(scanResult));
            }
        }

        public int getId() {
            return this.mId;
        }

        public int getFlags() {
            return this.mFlags;
        }

        public int getBucketsScanned() {
            return this.mBucketsScanned;
        }

        public int getScannedBands() {
            return this.getScannedBandsInternal();
        }

        public int getScannedBandsInternal() {
            return this.mScannedBands;
        }

        public ScanResult[] getResults() {
            return this.mResults.toArray(new ScanResult[0]);
        }

        public void addResults(ScanResult[] newResults) {
            for (ScanResult result : newResults) {
                this.mResults.add(new ScanResult(result));
            }
        }

        public void addResults(ScanData s) {
            this.mScannedBands |= s.mScannedBands;
            this.mFlags |= s.mFlags;
            this.addResults(s.getResults());
        }

        public boolean isFullBandScanResults() {
            return (this.mScannedBands & 1) != 0 && (this.mScannedBands & 2) != 0;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mId);
            dest.writeInt(this.mFlags);
            dest.writeInt(this.mBucketsScanned);
            dest.writeInt(this.mScannedBands);
            dest.writeParcelableList(this.mResults, 0);
        }
    }

    public static class ChannelSpec {
        public int frequency;
        public boolean passive;
        public int dwellTimeMS;

        public ChannelSpec(int frequency) {
            this.frequency = frequency;
            this.passive = false;
            this.dwellTimeMS = 0;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RnrSetting {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScanStatusCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiBand {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiBandIndex {
    }
}

