/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.compat.annotation.UnsupportedAppUsage;
import android.net.wifi.util.HexEncoding;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class WifiSsid
implements Parcelable {
    private final byte[] mBytes;
    public static final Parcelable.Creator<WifiSsid> CREATOR = new Parcelable.Creator<WifiSsid>(){

        @Override
        public WifiSsid createFromParcel(Parcel in) {
            return new WifiSsid(in.createByteArray());
        }

        public WifiSsid[] newArray(int size) {
            return new WifiSsid[size];
        }
    };
    @UnsupportedAppUsage(publicAlternatives="{@link #getBytes()}")
    public final ByteArrayOutputStream octets = new ByteArrayOutputStream(32);
    @UnsupportedAppUsage(publicAlternatives="{@link android.net.wifi.WifiManager#UNKNOWN_SSID}")
    public static final String NONE = "<unknown ssid>";

    private WifiSsid(byte[] bytes) {
        if (bytes == null) {
            bytes = new byte[]{};
        }
        this.mBytes = bytes;
        this.octets.write(bytes, 0, bytes.length);
    }

    public static WifiSsid fromBytes(byte[] bytes) {
        return new WifiSsid(bytes);
    }

    public byte[] getBytes() {
        return (byte[])this.mBytes.clone();
    }

    public static WifiSsid fromUtf8Text(CharSequence utf8Text) {
        if (utf8Text == null) {
            return new WifiSsid(null);
        }
        return new WifiSsid(utf8Text.toString().getBytes(StandardCharsets.UTF_8));
    }

    public CharSequence getUtf8Text() {
        return WifiSsid.decodeSsid(this.mBytes, StandardCharsets.UTF_8);
    }

    public static WifiSsid fromString(String string2) {
        if (string2 == null) {
            return new WifiSsid(null);
        }
        int length = string2.length();
        if (length > 1 && string2.charAt(0) == '\"' && string2.charAt(length - 1) == '\"') {
            return new WifiSsid(string2.substring(1, length - 1).getBytes(StandardCharsets.UTF_8));
        }
        return new WifiSsid(HexEncoding.decode(string2));
    }

    public String toString() {
        String utf8String = WifiSsid.decodeSsid(this.mBytes, StandardCharsets.UTF_8);
        if (TextUtils.isEmpty(utf8String)) {
            return HexEncoding.encodeToString(this.mBytes, false);
        }
        return "\"" + utf8String + "\"";
    }

    private static String decodeSsid(byte[] ssidBytes, Charset charset) {
        CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        CharBuffer out = CharBuffer.allocate(32);
        CoderResult result = decoder.decode(ByteBuffer.wrap(ssidBytes), out, true);
        out.flip();
        if (result.isError()) {
            return null;
        }
        return out.toString();
    }

    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (!(thatObject instanceof WifiSsid)) {
            return false;
        }
        WifiSsid that = (WifiSsid)thatObject;
        return Arrays.equals(this.mBytes, that.mBytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.mBytes);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByteArray(this.mBytes);
    }

    @UnsupportedAppUsage(publicAlternatives="{@link #fromBytes(byte[])}")
    public static WifiSsid createFromAsciiEncoded(String asciiEncoded) {
        return WifiSsid.fromUtf8Text(asciiEncoded);
    }

    @UnsupportedAppUsage(publicAlternatives="{@link #getBytes()}")
    public byte[] getOctets() {
        return this.getBytes();
    }
}

