/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class AwarePairingConfig
implements Parcelable {
    public static final int PAIRING_BOOTSTRAPPING_OPPORTUNISTIC = 1;
    public static final int PAIRING_BOOTSTRAPPING_PIN_CODE_DISPLAY = 2;
    public static final int PAIRING_BOOTSTRAPPING_PASSPHRASE_DISPLAY = 4;
    public static final int PAIRING_BOOTSTRAPPING_QR_DISPLAY = 8;
    public static final int PAIRING_BOOTSTRAPPING_NFC_TAG = 16;
    public static final int PAIRING_BOOTSTRAPPING_PIN_CODE_KEYPAD = 32;
    public static final int PAIRING_BOOTSTRAPPING_PASSPHRASE_KEYPAD = 64;
    public static final int PAIRING_BOOTSTRAPPING_QR_SCAN = 128;
    public static final int PAIRING_BOOTSTRAPPING_NFC_READER = 256;
    private final boolean mPairingSetup;
    private final boolean mPairingCache;
    private final boolean mPairingVerification;
    private final int mBootstrappingMethods;
    public static final Parcelable.Creator<AwarePairingConfig> CREATOR = new Parcelable.Creator<AwarePairingConfig>(){

        @Override
        public AwarePairingConfig createFromParcel(Parcel in) {
            return new AwarePairingConfig(in);
        }

        public AwarePairingConfig[] newArray(int size) {
            return new AwarePairingConfig[size];
        }
    };

    public boolean isPairingCacheEnabled() {
        return this.mPairingCache;
    }

    public boolean isPairingSetupEnabled() {
        return this.mPairingSetup;
    }

    public boolean isPairingVerificationEnabled() {
        return this.mPairingVerification;
    }

    public int getBootstrappingMethods() {
        return this.mBootstrappingMethods;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AwarePairingConfig)) {
            return false;
        }
        AwarePairingConfig that = (AwarePairingConfig)o;
        return this.mPairingSetup == that.mPairingSetup && this.mPairingCache == that.mPairingCache && this.mPairingVerification == that.mPairingVerification && this.mBootstrappingMethods == that.mBootstrappingMethods;
    }

    public int hashCode() {
        return Objects.hash(this.mPairingSetup, this.mPairingCache, this.mPairingVerification, this.mBootstrappingMethods);
    }

    public AwarePairingConfig(boolean setup, boolean cache, boolean verification, int method) {
        this.mPairingSetup = setup;
        this.mPairingCache = cache;
        this.mPairingVerification = verification;
        this.mBootstrappingMethods = method;
    }

    protected AwarePairingConfig(Parcel in) {
        this.mPairingSetup = in.readBoolean();
        this.mPairingCache = in.readBoolean();
        this.mPairingVerification = in.readBoolean();
        this.mBootstrappingMethods = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeBoolean(this.mPairingSetup);
        dest.writeBoolean(this.mPairingCache);
        dest.writeBoolean(this.mPairingVerification);
        dest.writeInt(this.mBootstrappingMethods);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        private boolean mPairingSetup = false;
        private boolean mPairingCache = false;
        private boolean mPairingVerification = false;
        private int mBootStrappingMethods = 0;

        public Builder setPairingSetupEnabled(boolean enabled) {
            this.mPairingSetup = enabled;
            return this;
        }

        public Builder setPairingVerificationEnabled(boolean enabled) {
            this.mPairingVerification = enabled;
            return this;
        }

        public Builder setPairingCacheEnabled(boolean enabled) {
            this.mPairingCache = enabled;
            return this;
        }

        public Builder setBootstrappingMethods(int methods) {
            this.mBootStrappingMethods = methods;
            return this;
        }

        public AwarePairingConfig build() {
            return new AwarePairingConfig(this.mPairingSetup, this.mPairingCache, this.mPairingVerification, this.mBootStrappingMethods);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BootstrappingMethod {
    }
}

