/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.net.wifi.IBooleanListener;
import android.net.wifi.IIntegerListener;
import android.net.wifi.IListListener;
import android.net.wifi.aware.AwareParams;
import android.net.wifi.aware.AwareResources;
import android.net.wifi.aware.Characteristics;
import android.net.wifi.aware.ConfigRequest;
import android.net.wifi.aware.IWifiAwareDiscoverySessionCallback;
import android.net.wifi.aware.IWifiAwareEventCallback;
import android.net.wifi.aware.IWifiAwareMacAddressProvider;
import android.net.wifi.aware.PublishConfig;
import android.net.wifi.aware.SubscribeConfig;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IWifiAwareManager
extends IInterface {
    public boolean isUsageEnabled() throws RemoteException;

    public Characteristics getCharacteristics() throws RemoteException;

    public AwareResources getAvailableAwareResources() throws RemoteException;

    public boolean isDeviceAttached() throws RemoteException;

    public void enableInstantCommunicationMode(String var1, boolean var2) throws RemoteException;

    public boolean isInstantCommunicationModeEnabled() throws RemoteException;

    public boolean isSetChannelOnDataPathSupported() throws RemoteException;

    public void setAwareParams(AwareParams var1) throws RemoteException;

    public void resetPairedDevices(String var1) throws RemoteException;

    public void removePairedDevice(String var1, String var2) throws RemoteException;

    public void getPairedDevices(String var1, IListListener var2) throws RemoteException;

    public void setOpportunisticModeEnabled(String var1, boolean var2) throws RemoteException;

    public void isOpportunisticModeEnabled(String var1, IBooleanListener var2) throws RemoteException;

    public void connect(IBinder var1, String var2, String var3, IWifiAwareEventCallback var4, ConfigRequest var5, boolean var6, Bundle var7, boolean var8) throws RemoteException;

    public void disconnect(int var1, IBinder var2) throws RemoteException;

    public void setMasterPreference(int var1, IBinder var2, int var3) throws RemoteException;

    public void getMasterPreference(int var1, IBinder var2, IIntegerListener var3) throws RemoteException;

    public void publish(String var1, String var2, int var3, PublishConfig var4, IWifiAwareDiscoverySessionCallback var5, Bundle var6) throws RemoteException;

    public void subscribe(String var1, String var2, int var3, SubscribeConfig var4, IWifiAwareDiscoverySessionCallback var5, Bundle var6) throws RemoteException;

    public void updatePublish(int var1, int var2, PublishConfig var3) throws RemoteException;

    public void updateSubscribe(int var1, int var2, SubscribeConfig var3) throws RemoteException;

    public void sendMessage(int var1, int var2, int var3, byte[] var4, int var5, int var6) throws RemoteException;

    public void terminateSession(int var1, int var2) throws RemoteException;

    public void initiateNanPairingSetupRequest(int var1, int var2, int var3, String var4, String var5, int var6) throws RemoteException;

    public void responseNanPairingSetupRequest(int var1, int var2, int var3, int var4, String var5, String var6, boolean var7, int var8) throws RemoteException;

    public void initiateBootStrappingSetupRequest(int var1, int var2, int var3, int var4) throws RemoteException;

    public void suspend(int var1, int var2) throws RemoteException;

    public void resume(int var1, int var2) throws RemoteException;

    public void requestMacAddresses(int var1, int[] var2, IWifiAwareMacAddressProvider var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWifiAwareManager {
        public static final String DESCRIPTOR = "android.net.wifi.aware.IWifiAwareManager";
        static final int TRANSACTION_isUsageEnabled = 1;
        static final int TRANSACTION_getCharacteristics = 2;
        static final int TRANSACTION_getAvailableAwareResources = 3;
        static final int TRANSACTION_isDeviceAttached = 4;
        static final int TRANSACTION_enableInstantCommunicationMode = 5;
        static final int TRANSACTION_isInstantCommunicationModeEnabled = 6;
        static final int TRANSACTION_isSetChannelOnDataPathSupported = 7;
        static final int TRANSACTION_setAwareParams = 8;
        static final int TRANSACTION_resetPairedDevices = 9;
        static final int TRANSACTION_removePairedDevice = 10;
        static final int TRANSACTION_getPairedDevices = 11;
        static final int TRANSACTION_setOpportunisticModeEnabled = 12;
        static final int TRANSACTION_isOpportunisticModeEnabled = 13;
        static final int TRANSACTION_connect = 14;
        static final int TRANSACTION_disconnect = 15;
        static final int TRANSACTION_setMasterPreference = 16;
        static final int TRANSACTION_getMasterPreference = 17;
        static final int TRANSACTION_publish = 18;
        static final int TRANSACTION_subscribe = 19;
        static final int TRANSACTION_updatePublish = 20;
        static final int TRANSACTION_updateSubscribe = 21;
        static final int TRANSACTION_sendMessage = 22;
        static final int TRANSACTION_terminateSession = 23;
        static final int TRANSACTION_initiateNanPairingSetupRequest = 24;
        static final int TRANSACTION_responseNanPairingSetupRequest = 25;
        static final int TRANSACTION_initiateBootStrappingSetupRequest = 26;
        static final int TRANSACTION_suspend = 27;
        static final int TRANSACTION_resume = 28;
        static final int TRANSACTION_requestMacAddresses = 29;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWifiAwareManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWifiAwareManager) {
                return (IWifiAwareManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "isUsageEnabled";
                }
                case 2: {
                    return "getCharacteristics";
                }
                case 3: {
                    return "getAvailableAwareResources";
                }
                case 4: {
                    return "isDeviceAttached";
                }
                case 5: {
                    return "enableInstantCommunicationMode";
                }
                case 6: {
                    return "isInstantCommunicationModeEnabled";
                }
                case 7: {
                    return "isSetChannelOnDataPathSupported";
                }
                case 8: {
                    return "setAwareParams";
                }
                case 9: {
                    return "resetPairedDevices";
                }
                case 10: {
                    return "removePairedDevice";
                }
                case 11: {
                    return "getPairedDevices";
                }
                case 12: {
                    return "setOpportunisticModeEnabled";
                }
                case 13: {
                    return "isOpportunisticModeEnabled";
                }
                case 14: {
                    return "connect";
                }
                case 15: {
                    return "disconnect";
                }
                case 16: {
                    return "setMasterPreference";
                }
                case 17: {
                    return "getMasterPreference";
                }
                case 18: {
                    return "publish";
                }
                case 19: {
                    return "subscribe";
                }
                case 20: {
                    return "updatePublish";
                }
                case 21: {
                    return "updateSubscribe";
                }
                case 22: {
                    return "sendMessage";
                }
                case 23: {
                    return "terminateSession";
                }
                case 24: {
                    return "initiateNanPairingSetupRequest";
                }
                case 25: {
                    return "responseNanPairingSetupRequest";
                }
                case 26: {
                    return "initiateBootStrappingSetupRequest";
                }
                case 27: {
                    return "suspend";
                }
                case 28: {
                    return "resume";
                }
                case 29: {
                    return "requestMacAddresses";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    boolean _result = this.isUsageEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 2: {
                    Characteristics _result = this.getCharacteristics();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    AwareResources _result = this.getAvailableAwareResources();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 4: {
                    boolean _result = this.isDeviceAttached();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    this.enableInstantCommunicationMode(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    boolean _result = this.isInstantCommunicationModeEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 7: {
                    boolean _result = this.isSetChannelOnDataPathSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    AwareParams _arg0 = data.readTypedObject(AwareParams.CREATOR);
                    this.setAwareParams(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    this.resetPairedDevices(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.removePairedDevice(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    IListListener _arg1 = IListListener.Stub.asInterface(data.readStrongBinder());
                    this.getPairedDevices(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    this.setOpportunisticModeEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    String _arg0 = data.readString();
                    IBooleanListener _arg1 = IBooleanListener.Stub.asInterface(data.readStrongBinder());
                    this.isOpportunisticModeEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    IWifiAwareEventCallback _arg3 = IWifiAwareEventCallback.Stub.asInterface(data.readStrongBinder());
                    ConfigRequest _arg4 = data.readTypedObject(ConfigRequest.CREATOR);
                    boolean _arg5 = data.readBoolean();
                    Bundle _arg6 = data.readTypedObject(Bundle.CREATOR);
                    boolean _arg7 = data.readBoolean();
                    this.connect(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    this.disconnect(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    int _arg2 = data.readInt();
                    this.setMasterPreference(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    IIntegerListener _arg2 = IIntegerListener.Stub.asInterface(data.readStrongBinder());
                    this.getMasterPreference(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    PublishConfig _arg3 = data.readTypedObject(PublishConfig.CREATOR);
                    IWifiAwareDiscoverySessionCallback _arg4 = IWifiAwareDiscoverySessionCallback.Stub.asInterface(data.readStrongBinder());
                    Bundle _arg5 = data.readTypedObject(Bundle.CREATOR);
                    this.publish(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    SubscribeConfig _arg3 = data.readTypedObject(SubscribeConfig.CREATOR);
                    IWifiAwareDiscoverySessionCallback _arg4 = IWifiAwareDiscoverySessionCallback.Stub.asInterface(data.readStrongBinder());
                    Bundle _arg5 = data.readTypedObject(Bundle.CREATOR);
                    this.subscribe(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    PublishConfig _arg2 = data.readTypedObject(PublishConfig.CREATOR);
                    this.updatePublish(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    SubscribeConfig _arg2 = data.readTypedObject(SubscribeConfig.CREATOR);
                    this.updateSubscribe(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    byte[] _arg3 = data.createByteArray();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    this.sendMessage(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.terminateSession(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    int _arg5 = data.readInt();
                    this.initiateNanPairingSetupRequest(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    String _arg4 = data.readString();
                    String _arg5 = data.readString();
                    boolean _arg6 = data.readBoolean();
                    int _arg7 = data.readInt();
                    this.responseNanPairingSetupRequest(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    this.initiateBootStrappingSetupRequest(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.suspend(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.resume(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    int _arg0 = data.readInt();
                    int[] _arg1 = data.createIntArray();
                    IWifiAwareMacAddressProvider _arg2 = IWifiAwareMacAddressProvider.Stub.asInterface(data.readStrongBinder());
                    this.requestMacAddresses(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 28;
        }

        private static class Proxy
        implements IWifiAwareManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isUsageEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Characteristics getCharacteristics() throws RemoteException {
                Characteristics _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Characteristics.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AwareResources getAvailableAwareResources() throws RemoteException {
                AwareResources _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(AwareResources.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDeviceAttached() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableInstantCommunicationMode(String callingPackage, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isInstantCommunicationModeEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSetChannelOnDataPathSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAwareParams(AwareParams parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(parameters, 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetPairedDevices(String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removePairedDevice(String callingPackage, String alias) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(alias);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getPairedDevices(String callingPackage, IListListener value) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeStrongInterface(value);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOpportunisticModeEnabled(String callingPackage, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void isOpportunisticModeEnabled(String callingPackage, IBooleanListener value) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeStrongInterface(value);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connect(IBinder binder, String callingPackage, String callingFeatureId, IWifiAwareEventCallback callback, ConfigRequest configRequest, boolean notifyOnIdentityChanged, Bundle extras, boolean forAwareOffload) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    _data.writeStrongInterface(callback);
                    _data.writeTypedObject(configRequest, 0);
                    _data.writeBoolean(notifyOnIdentityChanged);
                    _data.writeTypedObject(extras, 0);
                    _data.writeBoolean(forAwareOffload);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disconnect(int clientId, IBinder binder) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientId);
                    _data.writeStrongBinder(binder);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMasterPreference(int clientId, IBinder binder, int mp) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientId);
                    _data.writeStrongBinder(binder);
                    _data.writeInt(mp);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getMasterPreference(int clientId, IBinder binder, IIntegerListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientId);
                    _data.writeStrongBinder(binder);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void publish(String callingPackage, String callingFeatureId, int clientId, PublishConfig publishConfig, IWifiAwareDiscoverySessionCallback callback, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    _data.writeInt(clientId);
                    _data.writeTypedObject(publishConfig, 0);
                    _data.writeStrongInterface(callback);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void subscribe(String callingPackage, String callingFeatureId, int clientId, SubscribeConfig subscribeConfig, IWifiAwareDiscoverySessionCallback callback, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    _data.writeInt(clientId);
                    _data.writeTypedObject(subscribeConfig, 0);
                    _data.writeStrongInterface(callback);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updatePublish(int clientId, int discoverySessionId, PublishConfig publishConfig) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientId);
                    _data.writeInt(discoverySessionId);
                    _data.writeTypedObject(publishConfig, 0);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateSubscribe(int clientId, int discoverySessionId, SubscribeConfig subscribeConfig) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientId);
                    _data.writeInt(discoverySessionId);
                    _data.writeTypedObject(subscribeConfig, 0);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendMessage(int clientId, int discoverySessionId, int peerId, byte[] message, int messageId, int retryCount) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientId);
                    _data.writeInt(discoverySessionId);
                    _data.writeInt(peerId);
                    _data.writeByteArray(message);
                    _data.writeInt(messageId);
                    _data.writeInt(retryCount);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void terminateSession(int clientId, int discoverySessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientId);
                    _data.writeInt(discoverySessionId);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initiateNanPairingSetupRequest(int clientId, int sessionId, int peerId, String password, String pairingDeviceAlias, int cipherSuite) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientId);
                    _data.writeInt(sessionId);
                    _data.writeInt(peerId);
                    _data.writeString(password);
                    _data.writeString(pairingDeviceAlias);
                    _data.writeInt(cipherSuite);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void responseNanPairingSetupRequest(int clientId, int sessionId, int peerId, int requestId, String password, String pairingDeviceAlias, boolean accept, int cipherSuite) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientId);
                    _data.writeInt(sessionId);
                    _data.writeInt(peerId);
                    _data.writeInt(requestId);
                    _data.writeString(password);
                    _data.writeString(pairingDeviceAlias);
                    _data.writeBoolean(accept);
                    _data.writeInt(cipherSuite);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initiateBootStrappingSetupRequest(int clientId, int sessionId, int peerId, int method) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientId);
                    _data.writeInt(sessionId);
                    _data.writeInt(peerId);
                    _data.writeInt(method);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void suspend(int clientId, int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientId);
                    _data.writeInt(sessionId);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resume(int clientId, int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientId);
                    _data.writeInt(sessionId);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestMacAddresses(int uid, int[] peerIds, IWifiAwareMacAddressProvider callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeIntArray(peerIds);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWifiAwareManager {
        @Override
        public boolean isUsageEnabled() throws RemoteException {
            return false;
        }

        @Override
        public Characteristics getCharacteristics() throws RemoteException {
            return null;
        }

        @Override
        public AwareResources getAvailableAwareResources() throws RemoteException {
            return null;
        }

        @Override
        public boolean isDeviceAttached() throws RemoteException {
            return false;
        }

        @Override
        public void enableInstantCommunicationMode(String callingPackage, boolean enable) throws RemoteException {
        }

        @Override
        public boolean isInstantCommunicationModeEnabled() throws RemoteException {
            return false;
        }

        @Override
        public boolean isSetChannelOnDataPathSupported() throws RemoteException {
            return false;
        }

        @Override
        public void setAwareParams(AwareParams parameters) throws RemoteException {
        }

        @Override
        public void resetPairedDevices(String callingPackage) throws RemoteException {
        }

        @Override
        public void removePairedDevice(String callingPackage, String alias) throws RemoteException {
        }

        @Override
        public void getPairedDevices(String callingPackage, IListListener value) throws RemoteException {
        }

        @Override
        public void setOpportunisticModeEnabled(String callingPackage, boolean enable) throws RemoteException {
        }

        @Override
        public void isOpportunisticModeEnabled(String callingPackage, IBooleanListener value) throws RemoteException {
        }

        @Override
        public void connect(IBinder binder, String callingPackage, String callingFeatureId, IWifiAwareEventCallback callback, ConfigRequest configRequest, boolean notifyOnIdentityChanged, Bundle extras, boolean forAwareOffload) throws RemoteException {
        }

        @Override
        public void disconnect(int clientId, IBinder binder) throws RemoteException {
        }

        @Override
        public void setMasterPreference(int clientId, IBinder binder, int mp) throws RemoteException {
        }

        @Override
        public void getMasterPreference(int clientId, IBinder binder, IIntegerListener listener) throws RemoteException {
        }

        @Override
        public void publish(String callingPackage, String callingFeatureId, int clientId, PublishConfig publishConfig, IWifiAwareDiscoverySessionCallback callback, Bundle extras) throws RemoteException {
        }

        @Override
        public void subscribe(String callingPackage, String callingFeatureId, int clientId, SubscribeConfig subscribeConfig, IWifiAwareDiscoverySessionCallback callback, Bundle extras) throws RemoteException {
        }

        @Override
        public void updatePublish(int clientId, int discoverySessionId, PublishConfig publishConfig) throws RemoteException {
        }

        @Override
        public void updateSubscribe(int clientId, int discoverySessionId, SubscribeConfig subscribeConfig) throws RemoteException {
        }

        @Override
        public void sendMessage(int clientId, int discoverySessionId, int peerId, byte[] message, int messageId, int retryCount) throws RemoteException {
        }

        @Override
        public void terminateSession(int clientId, int discoverySessionId) throws RemoteException {
        }

        @Override
        public void initiateNanPairingSetupRequest(int clientId, int sessionId, int peerId, String password, String pairingDeviceAlias, int cipherSuite) throws RemoteException {
        }

        @Override
        public void responseNanPairingSetupRequest(int clientId, int sessionId, int peerId, int requestId, String password, String pairingDeviceAlias, boolean accept, int cipherSuite) throws RemoteException {
        }

        @Override
        public void initiateBootStrappingSetupRequest(int clientId, int sessionId, int peerId, int method) throws RemoteException {
        }

        @Override
        public void suspend(int clientId, int sessionId) throws RemoteException {
        }

        @Override
        public void resume(int clientId, int sessionId) throws RemoteException {
        }

        @Override
        public void requestMacAddresses(int uid, int[] peerIds, IWifiAwareMacAddressProvider callback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

