/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.nl80211;

import android.net.wifi.nl80211.NativeWifiClient;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IApInterfaceEventCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.nl80211.IApInterfaceEventCallback";
    public static final int BANDWIDTH_INVALID = 0;
    public static final int BANDWIDTH_20_NOHT = 1;
    public static final int BANDWIDTH_20 = 2;
    public static final int BANDWIDTH_40 = 3;
    public static final int BANDWIDTH_80 = 4;
    public static final int BANDWIDTH_80P80 = 5;
    public static final int BANDWIDTH_160 = 6;
    public static final int BANDWIDTH_320 = 7;

    public void onConnectedClientsChanged(NativeWifiClient var1, boolean var2) throws RemoteException;

    public void onSoftApChannelSwitched(int var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IApInterfaceEventCallback {
        static final int TRANSACTION_onConnectedClientsChanged = 1;
        static final int TRANSACTION_onSoftApChannelSwitched = 2;

        public Stub() {
            this.attachInterface(this, IApInterfaceEventCallback.DESCRIPTOR);
        }

        public static IApInterfaceEventCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IApInterfaceEventCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IApInterfaceEventCallback) {
                return (IApInterfaceEventCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onConnectedClientsChanged";
                }
                case 2: {
                    return "onSoftApChannelSwitched";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IApInterfaceEventCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    NativeWifiClient _arg0 = data.readTypedObject(NativeWifiClient.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onConnectedClientsChanged(_arg0, _arg1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSoftApChannelSwitched(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IApInterfaceEventCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IApInterfaceEventCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnectedClientsChanged(NativeWifiClient client, boolean isConnected) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IApInterfaceEventCallback.DESCRIPTOR);
                    _data.writeTypedObject(client, 0);
                    _data.writeBoolean(isConnected);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSoftApChannelSwitched(int frequency, int bandwidth) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IApInterfaceEventCallback.DESCRIPTOR);
                    _data.writeInt(frequency);
                    _data.writeInt(bandwidth);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IApInterfaceEventCallback {
        @Override
        public void onConnectedClientsChanged(NativeWifiClient client, boolean isConnected) throws RemoteException {
        }

        @Override
        public void onSoftApChannelSwitched(int frequency, int bandwidth) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

