/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.nl80211;

import android.net.wifi.nl80211.ISendMgmtFrameEvent;
import android.net.wifi.nl80211.IWifiScannerImpl;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IClientInterface
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.nl80211.IClientInterface";

    public int[] getPacketCounters() throws RemoteException;

    public int[] signalPoll() throws RemoteException;

    public byte[] getMacAddress() throws RemoteException;

    public String getInterfaceName() throws RemoteException;

    public IWifiScannerImpl getWifiScannerImpl() throws RemoteException;

    public void SendMgmtFrame(byte[] var1, ISendMgmtFrameEvent var2, int var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IClientInterface {
        static final int TRANSACTION_getPacketCounters = 1;
        static final int TRANSACTION_signalPoll = 2;
        static final int TRANSACTION_getMacAddress = 3;
        static final int TRANSACTION_getInterfaceName = 4;
        static final int TRANSACTION_getWifiScannerImpl = 5;
        static final int TRANSACTION_SendMgmtFrame = 6;

        public Stub() {
            this.attachInterface(this, IClientInterface.DESCRIPTOR);
        }

        public static IClientInterface asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IClientInterface.DESCRIPTOR);
            if (iin != null && iin instanceof IClientInterface) {
                return (IClientInterface)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getPacketCounters";
                }
                case 2: {
                    return "signalPoll";
                }
                case 3: {
                    return "getMacAddress";
                }
                case 4: {
                    return "getInterfaceName";
                }
                case 5: {
                    return "getWifiScannerImpl";
                }
                case 6: {
                    return "SendMgmtFrame";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IClientInterface.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int[] _result = this.getPacketCounters();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 2: {
                    int[] _result = this.signalPoll();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 3: {
                    byte[] _result = this.getMacAddress();
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    break;
                }
                case 4: {
                    String _result = this.getInterfaceName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 5: {
                    IWifiScannerImpl _result = this.getWifiScannerImpl();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 6: {
                    byte[] _arg0 = data.createByteArray();
                    ISendMgmtFrameEvent _arg1 = ISendMgmtFrameEvent.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.SendMgmtFrame(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 5;
        }

        private static class Proxy
        implements IClientInterface {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IClientInterface.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getPacketCounters() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IClientInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] signalPoll() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IClientInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getMacAddress() throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IClientInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getInterfaceName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IClientInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IWifiScannerImpl getWifiScannerImpl() throws RemoteException {
                IWifiScannerImpl _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IClientInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = IWifiScannerImpl.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void SendMgmtFrame(byte[] frame, ISendMgmtFrameEvent callback, int mcs) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IClientInterface.DESCRIPTOR);
                    _data.writeByteArray(frame);
                    _data.writeStrongInterface(callback);
                    _data.writeInt(mcs);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IClientInterface {
        @Override
        public int[] getPacketCounters() throws RemoteException {
            return null;
        }

        @Override
        public int[] signalPoll() throws RemoteException {
            return null;
        }

        @Override
        public byte[] getMacAddress() throws RemoteException {
            return null;
        }

        @Override
        public String getInterfaceName() throws RemoteException {
            return null;
        }

        @Override
        public IWifiScannerImpl getWifiScannerImpl() throws RemoteException {
            return null;
        }

        @Override
        public void SendMgmtFrame(byte[] frame, ISendMgmtFrameEvent callback, int mcs) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

