/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.nl80211;

import android.net.wifi.nl80211.IPnoScanEvent;
import android.net.wifi.nl80211.IScanEvent;
import android.net.wifi.nl80211.NativeScanResult;
import android.net.wifi.nl80211.PnoSettings;
import android.net.wifi.nl80211.SingleScanSettings;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;

public interface IWifiScannerImpl
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.nl80211.IWifiScannerImpl";
    public static final int SCAN_TYPE_LOW_SPAN = 0;
    public static final int SCAN_TYPE_LOW_POWER = 1;
    public static final int SCAN_TYPE_HIGH_ACCURACY = 2;
    public static final int SCAN_STATUS_SUCCESS = 0;
    public static final int SCAN_STATUS_FAILED_GENERIC = 1;
    public static final int SCAN_STATUS_FAILED_BUSY = 2;
    public static final int SCAN_STATUS_FAILED_ABORT = 3;
    public static final int SCAN_STATUS_FAILED_NODEV = 4;
    public static final int SCAN_STATUS_FAILED_INVALID_ARGS = 5;
    public static final int SCAN_TYPE_DEFAULT = -1;

    public NativeScanResult[] getScanResults() throws RemoteException;

    public NativeScanResult[] getPnoScanResults() throws RemoteException;

    public int getMaxSsidsPerScan() throws RemoteException;

    public boolean scan(SingleScanSettings var1) throws RemoteException;

    public int scanRequest(SingleScanSettings var1) throws RemoteException;

    public void subscribeScanEvents(IScanEvent var1) throws RemoteException;

    public void unsubscribeScanEvents() throws RemoteException;

    public void subscribePnoScanEvents(IPnoScanEvent var1) throws RemoteException;

    public void unsubscribePnoScanEvents() throws RemoteException;

    public boolean startPnoScan(PnoSettings var1) throws RemoteException;

    public boolean stopPnoScan() throws RemoteException;

    public void abortScan() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWifiScannerImpl {
        static final int TRANSACTION_getScanResults = 1;
        static final int TRANSACTION_getPnoScanResults = 2;
        static final int TRANSACTION_getMaxSsidsPerScan = 3;
        static final int TRANSACTION_scan = 4;
        static final int TRANSACTION_scanRequest = 5;
        static final int TRANSACTION_subscribeScanEvents = 6;
        static final int TRANSACTION_unsubscribeScanEvents = 7;
        static final int TRANSACTION_subscribePnoScanEvents = 8;
        static final int TRANSACTION_unsubscribePnoScanEvents = 9;
        static final int TRANSACTION_startPnoScan = 10;
        static final int TRANSACTION_stopPnoScan = 11;
        static final int TRANSACTION_abortScan = 12;

        public Stub() {
            this.attachInterface(this, IWifiScannerImpl.DESCRIPTOR);
        }

        public static IWifiScannerImpl asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IWifiScannerImpl.DESCRIPTOR);
            if (iin != null && iin instanceof IWifiScannerImpl) {
                return (IWifiScannerImpl)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getScanResults";
                }
                case 2: {
                    return "getPnoScanResults";
                }
                case 3: {
                    return "getMaxSsidsPerScan";
                }
                case 4: {
                    return "scan";
                }
                case 5: {
                    return "scanRequest";
                }
                case 6: {
                    return "subscribeScanEvents";
                }
                case 7: {
                    return "unsubscribeScanEvents";
                }
                case 8: {
                    return "subscribePnoScanEvents";
                }
                case 9: {
                    return "unsubscribePnoScanEvents";
                }
                case 10: {
                    return "startPnoScan";
                }
                case 11: {
                    return "stopPnoScan";
                }
                case 12: {
                    return "abortScan";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IWifiScannerImpl.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    Parcelable[] _result = this.getScanResults();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 2: {
                    Parcelable[] _result = this.getPnoScanResults();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 3: {
                    int _result = this.getMaxSsidsPerScan();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 4: {
                    SingleScanSettings _arg0 = data.readTypedObject(SingleScanSettings.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.scan(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    SingleScanSettings _arg0 = data.readTypedObject(SingleScanSettings.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.scanRequest(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 6: {
                    IScanEvent _arg0 = IScanEvent.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.subscribeScanEvents(_arg0);
                    break;
                }
                case 7: {
                    this.unsubscribeScanEvents();
                    break;
                }
                case 8: {
                    IPnoScanEvent _arg0 = IPnoScanEvent.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.subscribePnoScanEvents(_arg0);
                    break;
                }
                case 9: {
                    this.unsubscribePnoScanEvents();
                    break;
                }
                case 10: {
                    PnoSettings _arg0 = data.readTypedObject(PnoSettings.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.startPnoScan(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 11: {
                    boolean _result = this.stopPnoScan();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 12: {
                    this.abortScan();
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 11;
        }

        private static class Proxy
        implements IWifiScannerImpl {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IWifiScannerImpl.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NativeScanResult[] getScanResults() throws RemoteException {
                NativeScanResult[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiScannerImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(NativeScanResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NativeScanResult[] getPnoScanResults() throws RemoteException {
                NativeScanResult[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiScannerImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(NativeScanResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMaxSsidsPerScan() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiScannerImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean scan(SingleScanSettings scanSettings) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiScannerImpl.DESCRIPTOR);
                    _data.writeTypedObject(scanSettings, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int scanRequest(SingleScanSettings scanSettings) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiScannerImpl.DESCRIPTOR);
                    _data.writeTypedObject(scanSettings, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void subscribeScanEvents(IScanEvent handler) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IWifiScannerImpl.DESCRIPTOR);
                    _data.writeStrongInterface(handler);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void unsubscribeScanEvents() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IWifiScannerImpl.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void subscribePnoScanEvents(IPnoScanEvent handler) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IWifiScannerImpl.DESCRIPTOR);
                    _data.writeStrongInterface(handler);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void unsubscribePnoScanEvents() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IWifiScannerImpl.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startPnoScan(PnoSettings pnoSettings) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiScannerImpl.DESCRIPTOR);
                    _data.writeTypedObject(pnoSettings, 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean stopPnoScan() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiScannerImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void abortScan() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiScannerImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWifiScannerImpl {
        @Override
        public NativeScanResult[] getScanResults() throws RemoteException {
            return null;
        }

        @Override
        public NativeScanResult[] getPnoScanResults() throws RemoteException {
            return null;
        }

        @Override
        public int getMaxSsidsPerScan() throws RemoteException {
            return 0;
        }

        @Override
        public boolean scan(SingleScanSettings scanSettings) throws RemoteException {
            return false;
        }

        @Override
        public int scanRequest(SingleScanSettings scanSettings) throws RemoteException {
            return 0;
        }

        @Override
        public void subscribeScanEvents(IScanEvent handler) throws RemoteException {
        }

        @Override
        public void unsubscribeScanEvents() throws RemoteException {
        }

        @Override
        public void subscribePnoScanEvents(IPnoScanEvent handler) throws RemoteException {
        }

        @Override
        public void unsubscribePnoScanEvents() throws RemoteException {
        }

        @Override
        public boolean startPnoScan(PnoSettings pnoSettings) throws RemoteException {
            return false;
        }

        @Override
        public boolean stopPnoScan() throws RemoteException {
            return false;
        }

        @Override
        public void abortScan() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

