/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.net.MacAddress;
import android.net.NetworkInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WpsInfo;
import android.net.wifi.p2p.IWifiP2pManager;
import android.net.wifi.p2p.WifiP2pConfig;
import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.WifiP2pDeviceList;
import android.net.wifi.p2p.WifiP2pGroup;
import android.net.wifi.p2p.WifiP2pGroupList;
import android.net.wifi.p2p.WifiP2pInfo;
import android.net.wifi.p2p.WifiP2pWfdInfo;
import android.net.wifi.p2p.nsd.WifiP2pDnsSdServiceResponse;
import android.net.wifi.p2p.nsd.WifiP2pServiceInfo;
import android.net.wifi.p2p.nsd.WifiP2pServiceRequest;
import android.net.wifi.p2p.nsd.WifiP2pServiceResponse;
import android.net.wifi.p2p.nsd.WifiP2pUpnpServiceResponse;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.CloseGuard;
import android.util.Log;
import android.view.Display;
import androidx.annotation.RequiresApi;
import com.android.wifi.x.com.android.internal.util.AsyncChannel;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class WifiP2pManager {
    private static final String TAG = "WifiP2pManager";
    public static final long FEATURE_SET_VENDOR_ELEMENTS = 1L;
    public static final long FEATURE_FLEXIBLE_DISCOVERY = 2L;
    public static final long FEATURE_GROUP_CLIENT_REMOVAL = 4L;
    public static final long FEATURE_GROUP_OWNER_IPV6_LINK_LOCAL_ADDRESS_PROVIDED = 8L;
    public static final String EXTRA_PARAM_KEY_CONFIG = "android.net.wifi.p2p.EXTRA_PARAM_KEY_CONFIG";
    public static final String EXTRA_PARAM_KEY_SERVICE_INFO = "android.net.wifi.p2p.EXTRA_PARAM_KEY_SERVICE_INFO";
    public static final String EXTRA_PARAM_KEY_PEER_DISCOVERY_FREQ = "android.net.wifi.p2p.EXTRA_PARAM_KEY_PEER_DISCOVERY_FREQ";
    public static final String EXTRA_PARAM_KEY_PEER_ADDRESS = "android.net.wifi.p2p.EXTRA_PARAM_KEY_PEER_ADDRESS";
    public static final String EXTRA_PARAM_KEY_INTERNAL_MESSAGE = "android.net.wifi.p2p.EXTRA_PARAM_KEY_INTERNAL_MESSAGE";
    public static final String EXTRA_PARAM_KEY_DISPLAY_ID = "android.net.wifi.p2p.EXTRA_PARAM_KEY_DISPLAY_ID";
    public static final String EXTRA_PARAM_KEY_DEVICE = "android.net.wifi.p2p.EXTRA_PARAM_KEY_DEVICE";
    public static final String EXTRA_PARAM_KEY_WPS_PIN = "android.net.wifi.p2p.EXTRA_PARAM_KEY_WPS_PIN";
    public static final String EXTRA_PARAM_KEY_INFORMATION_ELEMENT_LIST = "android.net.wifi.p2p.EXTRA_PARAM_KEY_INFORMATION_ELEMENT_LIST";
    public static final String EXTRA_PARAM_KEY_BUNDLE = "android.net.wifi.p2p.EXTRA_PARAM_KEY_BUNDLE";
    public static final String WIFI_P2P_STATE_CHANGED_ACTION = "android.net.wifi.p2p.STATE_CHANGED";
    public static final String EXTRA_WIFI_STATE = "wifi_p2p_state";
    public static final int WIFI_P2P_STATE_DISABLED = 1;
    public static final int WIFI_P2P_STATE_ENABLED = 2;
    public static final String WIFI_P2P_CONNECTION_CHANGED_ACTION = "android.net.wifi.p2p.CONNECTION_STATE_CHANGE";
    public static final String EXTRA_WIFI_P2P_INFO = "wifiP2pInfo";
    public static final String EXTRA_NETWORK_INFO = "networkInfo";
    public static final String EXTRA_WIFI_P2P_GROUP = "p2pGroupInfo";
    public static final String WIFI_P2P_PEERS_CHANGED_ACTION = "android.net.wifi.p2p.PEERS_CHANGED";
    public static final String EXTRA_P2P_DEVICE_LIST = "wifiP2pDeviceList";
    public static final String WIFI_P2P_DISCOVERY_CHANGED_ACTION = "android.net.wifi.p2p.DISCOVERY_STATE_CHANGE";
    public static final String EXTRA_DISCOVERY_STATE = "discoveryState";
    public static final int WIFI_P2P_DISCOVERY_STOPPED = 1;
    public static final int WIFI_P2P_DISCOVERY_STARTED = 2;
    public static final String ACTION_WIFI_P2P_LISTEN_STATE_CHANGED = "android.net.wifi.p2p.action.WIFI_P2P_LISTEN_STATE_CHANGED";
    public static final String EXTRA_LISTEN_STATE = "android.net.wifi.p2p.extra.LISTEN_STATE";
    public static final int WIFI_P2P_LISTEN_STOPPED = 1;
    public static final int WIFI_P2P_LISTEN_STARTED = 2;
    public static final String WIFI_P2P_THIS_DEVICE_CHANGED_ACTION = "android.net.wifi.p2p.THIS_DEVICE_CHANGED";
    public static final String EXTRA_WIFI_P2P_DEVICE = "wifiP2pDevice";
    @SystemApi
    public static final String ACTION_WIFI_P2P_PERSISTENT_GROUPS_CHANGED = "android.net.wifi.p2p.action.WIFI_P2P_PERSISTENT_GROUPS_CHANGED";
    public static final String ACTION_WIFI_P2P_REQUEST_RESPONSE_CHANGED = "android.net.wifi.p2p.action.WIFI_P2P_REQUEST_RESPONSE_CHANGED";
    public static final String EXTRA_REQUEST_RESPONSE = "android.net.wifi.p2p.extra.REQUEST_RESPONSE";
    public static final String EXTRA_REQUEST_CONFIG = "android.net.wifi.p2p.extra.REQUEST_CONFIG";
    public static final String EXTRA_HANDOVER_MESSAGE = "android.net.wifi.p2p.EXTRA_HANDOVER_MESSAGE";
    public static final String CALLING_PACKAGE = "android.net.wifi.p2p.CALLING_PACKAGE";
    public static final String CALLING_FEATURE_ID = "android.net.wifi.p2p.CALLING_FEATURE_ID";
    public static final String CALLING_BINDER = "android.net.wifi.p2p.CALLING_BINDER";
    public static final int WIFI_P2P_SCAN_FULL = 0;
    public static final int WIFI_P2P_SCAN_SOCIAL = 1;
    public static final int WIFI_P2P_SCAN_SINGLE_FREQ = 2;
    public static final int WIFI_P2P_SCAN_FREQ_UNSPECIFIED = 0;
    private static final int WIFI_P2P_VENDOR_ELEMENTS_MAXIMUM_LENGTH = 512;
    IWifiP2pManager mService;
    private static final int BASE = 139264;
    public static final int DISCOVER_PEERS = 139265;
    public static final int DISCOVER_PEERS_FAILED = 139266;
    public static final int DISCOVER_PEERS_SUCCEEDED = 139267;
    public static final int STOP_DISCOVERY = 139268;
    public static final int STOP_DISCOVERY_FAILED = 139269;
    public static final int STOP_DISCOVERY_SUCCEEDED = 139270;
    public static final int CONNECT = 139271;
    public static final int CONNECT_FAILED = 139272;
    public static final int CONNECT_SUCCEEDED = 139273;
    public static final int CANCEL_CONNECT = 139274;
    public static final int CANCEL_CONNECT_FAILED = 139275;
    public static final int CANCEL_CONNECT_SUCCEEDED = 139276;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int CREATE_GROUP = 139277;
    public static final int CREATE_GROUP_FAILED = 139278;
    public static final int CREATE_GROUP_SUCCEEDED = 139279;
    public static final int REMOVE_GROUP = 139280;
    public static final int REMOVE_GROUP_FAILED = 139281;
    public static final int REMOVE_GROUP_SUCCEEDED = 139282;
    public static final int REQUEST_PEERS = 139283;
    public static final int RESPONSE_PEERS = 139284;
    public static final int REQUEST_CONNECTION_INFO = 139285;
    public static final int RESPONSE_CONNECTION_INFO = 139286;
    public static final int REQUEST_GROUP_INFO = 139287;
    public static final int RESPONSE_GROUP_INFO = 139288;
    public static final int ADD_LOCAL_SERVICE = 139292;
    public static final int ADD_LOCAL_SERVICE_FAILED = 139293;
    public static final int ADD_LOCAL_SERVICE_SUCCEEDED = 139294;
    public static final int REMOVE_LOCAL_SERVICE = 139295;
    public static final int REMOVE_LOCAL_SERVICE_FAILED = 139296;
    public static final int REMOVE_LOCAL_SERVICE_SUCCEEDED = 139297;
    public static final int CLEAR_LOCAL_SERVICES = 139298;
    public static final int CLEAR_LOCAL_SERVICES_FAILED = 139299;
    public static final int CLEAR_LOCAL_SERVICES_SUCCEEDED = 139300;
    public static final int ADD_SERVICE_REQUEST = 139301;
    public static final int ADD_SERVICE_REQUEST_FAILED = 139302;
    public static final int ADD_SERVICE_REQUEST_SUCCEEDED = 139303;
    public static final int REMOVE_SERVICE_REQUEST = 139304;
    public static final int REMOVE_SERVICE_REQUEST_FAILED = 139305;
    public static final int REMOVE_SERVICE_REQUEST_SUCCEEDED = 139306;
    public static final int CLEAR_SERVICE_REQUESTS = 139307;
    public static final int CLEAR_SERVICE_REQUESTS_FAILED = 139308;
    public static final int CLEAR_SERVICE_REQUESTS_SUCCEEDED = 139309;
    public static final int DISCOVER_SERVICES = 139310;
    public static final int DISCOVER_SERVICES_FAILED = 139311;
    public static final int DISCOVER_SERVICES_SUCCEEDED = 139312;
    public static final int PING = 139313;
    public static final int RESPONSE_SERVICE = 139314;
    public static final int SET_DEVICE_NAME = 139315;
    public static final int SET_DEVICE_NAME_FAILED = 139316;
    public static final int SET_DEVICE_NAME_SUCCEEDED = 139317;
    public static final int DELETE_PERSISTENT_GROUP = 139318;
    public static final int DELETE_PERSISTENT_GROUP_FAILED = 139319;
    public static final int DELETE_PERSISTENT_GROUP_SUCCEEDED = 139320;
    public static final int REQUEST_PERSISTENT_GROUP_INFO = 139321;
    public static final int RESPONSE_PERSISTENT_GROUP_INFO = 139322;
    public static final int SET_WFD_INFO = 139323;
    public static final int SET_WFD_INFO_FAILED = 139324;
    public static final int SET_WFD_INFO_SUCCEEDED = 139325;
    public static final int START_WPS = 139326;
    public static final int START_WPS_FAILED = 139327;
    public static final int START_WPS_SUCCEEDED = 139328;
    public static final int START_LISTEN = 139329;
    public static final int START_LISTEN_FAILED = 139330;
    public static final int START_LISTEN_SUCCEEDED = 139331;
    public static final int STOP_LISTEN = 139332;
    public static final int STOP_LISTEN_FAILED = 139333;
    public static final int STOP_LISTEN_SUCCEEDED = 139334;
    public static final int SET_CHANNEL = 139335;
    public static final int SET_CHANNEL_FAILED = 139336;
    public static final int SET_CHANNEL_SUCCEEDED = 139337;
    public static final int GET_HANDOVER_REQUEST = 139339;
    public static final int GET_HANDOVER_SELECT = 139340;
    public static final int RESPONSE_GET_HANDOVER_MESSAGE = 139341;
    public static final int INITIATOR_REPORT_NFC_HANDOVER = 139342;
    public static final int RESPONDER_REPORT_NFC_HANDOVER = 139343;
    public static final int REPORT_NFC_HANDOVER_SUCCEEDED = 139344;
    public static final int REPORT_NFC_HANDOVER_FAILED = 139345;
    public static final int FACTORY_RESET = 139346;
    public static final int FACTORY_RESET_FAILED = 139347;
    public static final int FACTORY_RESET_SUCCEEDED = 139348;
    public static final int REQUEST_ONGOING_PEER_CONFIG = 139349;
    public static final int RESPONSE_ONGOING_PEER_CONFIG = 139350;
    public static final int SET_ONGOING_PEER_CONFIG = 139351;
    public static final int SET_ONGOING_PEER_CONFIG_FAILED = 139352;
    public static final int SET_ONGOING_PEER_CONFIG_SUCCEEDED = 139353;
    public static final int REQUEST_P2P_STATE = 139354;
    public static final int RESPONSE_P2P_STATE = 139355;
    public static final int REQUEST_DISCOVERY_STATE = 139356;
    public static final int RESPONSE_DISCOVERY_STATE = 139357;
    public static final int REQUEST_NETWORK_INFO = 139358;
    public static final int RESPONSE_NETWORK_INFO = 139359;
    public static final int UPDATE_CHANNEL_INFO = 139360;
    public static final int REQUEST_DEVICE_INFO = 139361;
    public static final int RESPONSE_DEVICE_INFO = 139362;
    public static final int REMOVE_CLIENT = 139363;
    public static final int REMOVE_CLIENT_FAILED = 139364;
    public static final int REMOVE_CLIENT_SUCCEEDED = 139365;
    public static final int ADD_EXTERNAL_APPROVER = 139366;
    public static final int EXTERNAL_APPROVER_ATTACH = 139367;
    public static final int EXTERNAL_APPROVER_DETACH = 139368;
    public static final int EXTERNAL_APPROVER_CONNECTION_REQUESTED = 139369;
    public static final int EXTERNAL_APPROVER_PIN_GENERATED = 139370;
    public static final int REMOVE_EXTERNAL_APPROVER = 139371;
    public static final int REMOVE_EXTERNAL_APPROVER_FAILED = 139372;
    public static final int REMOVE_EXTERNAL_APPROVER_SUCCEEDED = 139373;
    public static final int SET_CONNECTION_REQUEST_RESULT = 139374;
    public static final int SET_CONNECTION_REQUEST_RESULT_FAILED = 139375;
    public static final int SET_CONNECTION_REQUEST_RESULT_SUCCEEDED = 139376;
    public static final int SET_VENDOR_ELEMENTS = 139377;
    public static final int SET_VENDOR_ELEMENTS_FAILED = 139378;
    public static final int SET_VENDOR_ELEMENTS_SUCCEEDED = 139379;
    public static final int GET_LISTEN_STATE = 139380;
    public static final int GET_LISTEN_STATE_FAILED = 139381;
    public static final int RESPONSE_GET_LISTEN_STATE = 139382;
    public static final int ERROR = 0;
    public static final int P2P_UNSUPPORTED = 1;
    public static final int BUSY = 2;
    public static final int NO_SERVICE_REQUESTS = 3;
    @SystemApi
    public static final int MIRACAST_DISABLED = 0;
    @SystemApi
    public static final int MIRACAST_SOURCE = 1;
    @SystemApi
    public static final int MIRACAST_SINK = 2;
    public static final int CONNECTION_REQUEST_ACCEPT = 0;
    public static final int CONNECTION_REQUEST_REJECT = 1;
    public static final int CONNECTION_REQUEST_DEFER_TO_SERVICE = 2;
    public static final int CONNECTION_REQUEST_DEFER_SHOW_PIN_TO_SERVICE = 3;

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public WifiP2pManager(IWifiP2pManager service) {
        this.mService = service;
    }

    private static void checkChannel(Channel c) {
        if (c == null) {
            throw new IllegalArgumentException("Channel needs to be initialized");
        }
    }

    private static void checkServiceInfo(WifiP2pServiceInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("service info is null");
        }
    }

    private static void checkServiceRequest(WifiP2pServiceRequest req) {
        if (req == null) {
            throw new IllegalArgumentException("service request is null");
        }
    }

    private void checkP2pConfig(WifiP2pConfig c) {
        if (c == null) {
            throw new IllegalArgumentException("config cannot be null");
        }
        if (TextUtils.isEmpty(c.deviceAddress)) {
            throw new IllegalArgumentException("deviceAddress cannot be empty");
        }
    }

    public Channel initialize(Context srcContext, Looper srcLooper, ChannelListener listener) {
        Binder binder = new Binder();
        Bundle extras = this.prepareExtrasBundleWithAttributionSource(srcContext);
        int displayId = 0;
        try {
            Display display = srcContext.getDisplay();
            if (display != null) {
                displayId = display.getDisplayId();
            }
        }
        catch (UnsupportedOperationException display) {
            // empty catch block
        }
        extras.putInt(EXTRA_PARAM_KEY_DISPLAY_ID, displayId);
        Channel channel = this.initializeChannel(srcContext, srcLooper, listener, this.getMessenger(binder, srcContext.getOpPackageName(), extras), binder);
        return channel;
    }

    public Channel initializeInternal(Context srcContext, Looper srcLooper, ChannelListener listener) {
        return this.initializeChannel(srcContext, srcLooper, listener, this.getP2pStateMachineMessenger(), null);
    }

    private Message prepareMessage(int what, int arg1, int arg2, Bundle extras, Context context) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        msg.arg2 = arg2;
        msg.obj = this.maybeGetAttributionSource(context);
        msg.getData().putBundle(EXTRA_PARAM_KEY_BUNDLE, extras);
        return msg;
    }

    private Bundle prepareExtrasBundle(Channel c) {
        Bundle b = new Bundle();
        b.putBinder(CALLING_BINDER, c.getBinder());
        return b;
    }

    private Bundle prepareExtrasBundleWithAttributionSource(Context context) {
        Bundle bundle = new Bundle();
        if (SdkLevel.isAtLeastS()) {
            bundle.putParcelable("EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE", context.getAttributionSource());
        }
        return bundle;
    }

    private Object maybeGetAttributionSource(Context context) {
        return SdkLevel.isAtLeastS() ? context.getAttributionSource() : null;
    }

    private Channel initializeChannel(Context srcContext, Looper srcLooper, ChannelListener listener, Messenger messenger, Binder binder) {
        if (messenger == null) {
            return null;
        }
        Channel c = new Channel(srcContext, srcLooper, listener, binder, this);
        if (c.mAsyncChannel.connectSync(srcContext, (Handler)c.mHandler, messenger) == 0) {
            Bundle bundle = new Bundle();
            bundle.putString(CALLING_PACKAGE, c.mContext.getOpPackageName());
            bundle.putString(CALLING_FEATURE_ID, c.mContext.getAttributionTag());
            bundle.putBinder(CALLING_BINDER, binder);
            Message msg = this.prepareMessage(139360, 0, c.putListener(null), bundle, c.mContext);
            c.mAsyncChannel.sendMessage(msg);
            return c;
        }
        c.close();
        return null;
    }

    @RequiresPermission(allOf={"android.permission.NEARBY_WIFI_DEVICES", "android.permission.ACCESS_FINE_LOCATION"}, conditional=true)
    public void discoverPeers(Channel channel, ActionListener listener) {
        WifiP2pManager.checkChannel(channel);
        Bundle extras = this.prepareExtrasBundle(channel);
        channel.mAsyncChannel.sendMessage(this.prepareMessage(139265, 0, channel.putListener(listener), extras, channel.mContext));
    }

    @RequiresPermission(allOf={"android.permission.NEARBY_WIFI_DEVICES", "android.permission.ACCESS_FINE_LOCATION"}, conditional=true)
    public void discoverPeersOnSocialChannels(Channel channel, ActionListener listener) {
        if (!this.isChannelConstrainedDiscoverySupported()) {
            throw new UnsupportedOperationException();
        }
        WifiP2pManager.checkChannel(channel);
        Bundle extras = this.prepareExtrasBundle(channel);
        channel.mAsyncChannel.sendMessage(this.prepareMessage(139265, 1, channel.putListener(listener), extras, channel.mContext));
    }

    @RequiresPermission(allOf={"android.permission.NEARBY_WIFI_DEVICES", "android.permission.ACCESS_FINE_LOCATION"}, conditional=true)
    public void discoverPeersOnSpecificFrequency(Channel channel, int frequencyMhz, ActionListener listener) {
        if (!this.isChannelConstrainedDiscoverySupported()) {
            throw new UnsupportedOperationException();
        }
        WifiP2pManager.checkChannel(channel);
        if (frequencyMhz <= 0) {
            throw new IllegalArgumentException("This frequency must be a positive value.");
        }
        Bundle extras = this.prepareExtrasBundle(channel);
        extras.putInt(EXTRA_PARAM_KEY_PEER_DISCOVERY_FREQ, frequencyMhz);
        channel.mAsyncChannel.sendMessage(this.prepareMessage(139265, 2, channel.putListener(listener), extras, channel.mContext));
    }

    public void stopPeerDiscovery(Channel channel, ActionListener listener) {
        WifiP2pManager.checkChannel(channel);
        channel.mAsyncChannel.sendMessage(139268, 0, channel.putListener(listener));
    }

    @RequiresPermission(allOf={"android.permission.NEARBY_WIFI_DEVICES", "android.permission.ACCESS_FINE_LOCATION"}, conditional=true)
    public void connect(Channel channel, WifiP2pConfig config, ActionListener listener) {
        WifiP2pManager.checkChannel(channel);
        this.checkP2pConfig(config);
        Bundle extras = this.prepareExtrasBundle(channel);
        extras.putParcelable(EXTRA_PARAM_KEY_CONFIG, config);
        channel.mAsyncChannel.sendMessage(this.prepareMessage(139271, 0, channel.putListener(listener), extras, channel.mContext));
    }

    public void cancelConnect(Channel channel, ActionListener listener) {
        WifiP2pManager.checkChannel(channel);
        channel.mAsyncChannel.sendMessage(139274, 0, channel.putListener(listener));
    }

    @RequiresPermission(allOf={"android.permission.NEARBY_WIFI_DEVICES", "android.permission.ACCESS_FINE_LOCATION"}, conditional=true)
    public void createGroup(Channel channel, ActionListener listener) {
        WifiP2pManager.checkChannel(channel);
        Bundle extras = this.prepareExtrasBundle(channel);
        channel.mAsyncChannel.sendMessage(this.prepareMessage(139277, -2, channel.putListener(listener), extras, channel.mContext));
    }

    @RequiresPermission(allOf={"android.permission.NEARBY_WIFI_DEVICES", "android.permission.ACCESS_FINE_LOCATION"}, conditional=true)
    public void createGroup(Channel channel, WifiP2pConfig config, ActionListener listener) {
        WifiP2pManager.checkChannel(channel);
        Bundle extras = this.prepareExtrasBundle(channel);
        extras.putParcelable(EXTRA_PARAM_KEY_CONFIG, config);
        channel.mAsyncChannel.sendMessage(this.prepareMessage(139277, 0, channel.putListener(listener), extras, channel.mContext));
    }

    public void removeGroup(Channel channel, ActionListener listener) {
        WifiP2pManager.checkChannel(channel);
        channel.mAsyncChannel.sendMessage(139280, 0, channel.putListener(listener));
    }

    @RequiresPermission(allOf={"android.permission.NEARBY_WIFI_DEVICES", "android.permission.ACCESS_FINE_LOCATION"}, conditional=true)
    public void startListening(Channel channel, ActionListener listener) {
        WifiP2pManager.checkChannel(channel);
        Bundle extras = this.prepareExtrasBundle(channel);
        channel.mAsyncChannel.sendMessage(this.prepareMessage(139329, 0, channel.putListener(listener), extras, channel.mContext));
    }

    public void stopListening(Channel channel, ActionListener listener) {
        WifiP2pManager.checkChannel(channel);
        channel.mAsyncChannel.sendMessage(139332, 0, channel.putListener(listener));
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_STACK", "android.permission.OVERRIDE_WIFI_CONFIG"})
    public void setWifiP2pChannels(Channel channel, int listeningChannel, int operatingChannel, ActionListener listener) {
        WifiP2pManager.checkChannel(channel);
        Bundle p2pChannels = new Bundle();
        p2pChannels.putInt("lc", listeningChannel);
        p2pChannels.putInt("oc", operatingChannel);
        channel.mAsyncChannel.sendMessage(139335, 0, channel.putListener(listener), p2pChannels);
    }

    @UnsupportedAppUsage(trackingBug=185141982L)
    public void startWps(Channel channel, WpsInfo wps, ActionListener listener) {
        WifiP2pManager.checkChannel(channel);
        channel.mAsyncChannel.sendMessage(139326, 0, channel.putListener(listener), wps);
    }

    @RequiresPermission(allOf={"android.permission.NEARBY_WIFI_DEVICES", "android.permission.ACCESS_FINE_LOCATION"}, conditional=true)
    public void addLocalService(Channel channel, WifiP2pServiceInfo servInfo, ActionListener listener) {
        WifiP2pManager.checkChannel(channel);
        WifiP2pManager.checkServiceInfo(servInfo);
        Bundle extras = this.prepareExtrasBundle(channel);
        extras.putParcelable(EXTRA_PARAM_KEY_SERVICE_INFO, servInfo);
        channel.mAsyncChannel.sendMessage(this.prepareMessage(139292, 0, channel.putListener(listener), extras, channel.mContext));
    }

    public void removeLocalService(Channel channel, WifiP2pServiceInfo servInfo, ActionListener listener) {
        WifiP2pManager.checkChannel(channel);
        WifiP2pManager.checkServiceInfo(servInfo);
        channel.mAsyncChannel.sendMessage(139295, 0, channel.putListener(listener), servInfo);
    }

    public void clearLocalServices(Channel channel, ActionListener listener) {
        WifiP2pManager.checkChannel(channel);
        channel.mAsyncChannel.sendMessage(139298, 0, channel.putListener(listener));
    }

    public void setServiceResponseListener(Channel channel, ServiceResponseListener listener) {
        WifiP2pManager.checkChannel(channel);
        channel.mServRspListener = listener;
    }

    public void setDnsSdResponseListeners(Channel channel, DnsSdServiceResponseListener servListener, DnsSdTxtRecordListener txtListener) {
        WifiP2pManager.checkChannel(channel);
        channel.mDnsSdServRspListener = servListener;
        channel.mDnsSdTxtListener = txtListener;
    }

    public void setUpnpServiceResponseListener(Channel channel, UpnpServiceResponseListener listener) {
        WifiP2pManager.checkChannel(channel);
        channel.mUpnpServRspListener = listener;
    }

    @RequiresPermission(allOf={"android.permission.NEARBY_WIFI_DEVICES", "android.permission.ACCESS_FINE_LOCATION"}, conditional=true)
    public void discoverServices(Channel channel, ActionListener listener) {
        WifiP2pManager.checkChannel(channel);
        Bundle extras = this.prepareExtrasBundle(channel);
        channel.mAsyncChannel.sendMessage(this.prepareMessage(139310, 0, channel.putListener(listener), extras, channel.mContext));
    }

    public void addServiceRequest(Channel channel, WifiP2pServiceRequest req, ActionListener listener) {
        WifiP2pManager.checkChannel(channel);
        WifiP2pManager.checkServiceRequest(req);
        channel.mAsyncChannel.sendMessage(139301, 0, channel.putListener(listener), req);
    }

    public void removeServiceRequest(Channel channel, WifiP2pServiceRequest req, ActionListener listener) {
        WifiP2pManager.checkChannel(channel);
        WifiP2pManager.checkServiceRequest(req);
        channel.mAsyncChannel.sendMessage(139304, 0, channel.putListener(listener), req);
    }

    public void clearServiceRequests(Channel channel, ActionListener listener) {
        WifiP2pManager.checkChannel(channel);
        channel.mAsyncChannel.sendMessage(139307, 0, channel.putListener(listener));
    }

    @RequiresPermission(allOf={"android.permission.NEARBY_WIFI_DEVICES", "android.permission.ACCESS_FINE_LOCATION"}, conditional=true)
    public void requestPeers(Channel channel, PeerListListener listener) {
        WifiP2pManager.checkChannel(channel);
        Bundle extras = this.prepareExtrasBundle(channel);
        channel.mAsyncChannel.sendMessage(this.prepareMessage(139283, 0, channel.putListener(listener), extras, channel.mContext));
    }

    public void requestConnectionInfo(Channel channel, ConnectionInfoListener listener) {
        WifiP2pManager.checkChannel(channel);
        channel.mAsyncChannel.sendMessage(139285, 0, channel.putListener(listener));
    }

    @RequiresPermission(allOf={"android.permission.NEARBY_WIFI_DEVICES", "android.permission.ACCESS_FINE_LOCATION"}, conditional=true)
    public void requestGroupInfo(Channel channel, GroupInfoListener listener) {
        WifiP2pManager.checkChannel(channel);
        Bundle extras = this.prepareExtrasBundle(channel);
        channel.mAsyncChannel.sendMessage(this.prepareMessage(139287, 0, channel.putListener(listener), extras, channel.mContext));
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_STACK", "android.permission.OVERRIDE_WIFI_CONFIG"})
    public void setDeviceName(Channel channel, String devName, ActionListener listener) {
        WifiP2pManager.checkChannel(channel);
        WifiP2pDevice d = new WifiP2pDevice();
        d.deviceName = devName;
        channel.mAsyncChannel.sendMessage(139315, 0, channel.putListener(listener), d);
    }

    @RequiresPermission(value="android.permission.CONFIGURE_WIFI_DISPLAY")
    public void setWfdInfo(Channel channel, WifiP2pWfdInfo wfdInfo, ActionListener listener) {
        this.setWFDInfo(channel, wfdInfo, listener);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RequiresPermission(value="android.permission.CONFIGURE_WIFI_DISPLAY")
    public void setWFDInfo(Channel channel, WifiP2pWfdInfo wfdInfo, ActionListener listener) {
        WifiP2pManager.checkChannel(channel);
        try {
            this.mService.checkConfigureWifiDisplayPermission();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
        channel.mAsyncChannel.sendMessage(139323, 0, channel.putListener(listener), wfdInfo);
    }

    @RequiresApi(value=33)
    public void removeClient(Channel channel, MacAddress peerAddress, ActionListener listener) {
        if (!this.isGroupClientRemovalSupported()) {
            throw new UnsupportedOperationException();
        }
        WifiP2pManager.checkChannel(channel);
        channel.mAsyncChannel.sendMessage(139363, 0, channel.putListener(listener), peerAddress);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_STACK", "android.permission.OVERRIDE_WIFI_CONFIG"})
    public void deletePersistentGroup(Channel channel, int netId, ActionListener listener) {
        WifiP2pManager.checkChannel(channel);
        channel.mAsyncChannel.sendMessage(139318, netId, channel.putListener(listener));
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_STACK", "android.permission.READ_WIFI_CREDENTIAL", "android.permission.NEARBY_WIFI_DEVICES", "android.permission.ACCESS_FINE_LOCATION"}, conditional=true)
    public void requestPersistentGroupInfo(Channel channel, PersistentGroupInfoListener listener) {
        WifiP2pManager.checkChannel(channel);
        Bundle extras = this.prepareExtrasBundle(channel);
        channel.mAsyncChannel.sendMessage(this.prepareMessage(139321, 0, channel.putListener(listener), extras, channel.mContext));
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CONFIGURE_WIFI_DISPLAY")
    public void setMiracastMode(int mode) {
        try {
            this.mService.setMiracastMode(mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private Messenger getMessenger(Binder binder, String packageName, Bundle extras) {
        try {
            return this.mService.getMessenger(binder, packageName, extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Messenger getP2pStateMachineMessenger() {
        try {
            return this.mService.getP2pStateMachineMessenger();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private long getSupportedFeatures() {
        try {
            return this.mService.getSupportedFeatures();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private boolean isFeatureSupported(long feature) {
        return (this.getSupportedFeatures() & feature) == feature;
    }

    public boolean isSetVendorElementsSupported() {
        return this.isFeatureSupported(1L);
    }

    public boolean isChannelConstrainedDiscoverySupported() {
        return this.isFeatureSupported(2L);
    }

    public boolean isGroupClientRemovalSupported() {
        return this.isFeatureSupported(4L);
    }

    public boolean isGroupOwnerIPv6LinkLocalAddressProvided() {
        return SdkLevel.isAtLeastT() && this.isFeatureSupported(8L);
    }

    public void getNfcHandoverRequest(Channel c, HandoverMessageListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139339, 0, c.putListener(listener));
    }

    public void getNfcHandoverSelect(Channel c, HandoverMessageListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139340, 0, c.putListener(listener));
    }

    public void initiatorReportNfcHandover(Channel c, String handoverSelect, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        Bundle bundle = new Bundle();
        bundle.putString(EXTRA_HANDOVER_MESSAGE, handoverSelect);
        c.mAsyncChannel.sendMessage(139342, 0, c.putListener(listener), bundle);
    }

    public void responderReportNfcHandover(Channel c, String handoverRequest, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        Bundle bundle = new Bundle();
        bundle.putString(EXTRA_HANDOVER_MESSAGE, handoverRequest);
        c.mAsyncChannel.sendMessage(139343, 0, c.putListener(listener), bundle);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void factoryReset(Channel c, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139346, 0, c.putListener(listener));
    }

    @RequiresPermission(value="android.permission.NETWORK_STACK")
    public void requestOngoingPeerConfig(Channel c, OngoingPeerInfoListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139349, Binder.getCallingUid(), c.putListener(listener));
    }

    @RequiresPermission(value="android.permission.NETWORK_STACK")
    public void setOngoingPeerConfig(Channel c, WifiP2pConfig config, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        this.checkP2pConfig(config);
        c.mAsyncChannel.sendMessage(139351, 0, c.putListener(listener), config);
    }

    public void requestP2pState(Channel c, P2pStateListener listener) {
        WifiP2pManager.checkChannel(c);
        if (listener == null) {
            throw new IllegalArgumentException("This listener cannot be null.");
        }
        c.mAsyncChannel.sendMessage(139354, 0, c.putListener(listener));
    }

    public void requestDiscoveryState(Channel c, DiscoveryStateListener listener) {
        WifiP2pManager.checkChannel(c);
        if (listener == null) {
            throw new IllegalArgumentException("This listener cannot be null.");
        }
        c.mAsyncChannel.sendMessage(139356, 0, c.putListener(listener));
    }

    @RequiresPermission(allOf={"android.permission.NEARBY_WIFI_DEVICES", "android.permission.ACCESS_FINE_LOCATION"}, conditional=true)
    public void getListenState(Channel c, final Executor executor, final Consumer<Integer> resultsCallback) {
        Objects.requireNonNull(c, "channel cannot be null and needs to be initialized)");
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        Bundle extras = this.prepareExtrasBundle(c);
        c.mAsyncChannel.sendMessage(this.prepareMessage(139380, 0, c.putListener(new ListenStateListener(){

            @Override
            public void onListenStateAvailable(int state) {
                Binder.clearCallingIdentity();
                executor.execute(() -> resultsCallback.accept(state));
            }
        }), extras, c.mContext));
    }

    public void requestNetworkInfo(Channel c, NetworkInfoListener listener) {
        WifiP2pManager.checkChannel(c);
        if (listener == null) {
            throw new IllegalArgumentException("This listener cannot be null.");
        }
        c.mAsyncChannel.sendMessage(139358, 0, c.putListener(listener));
    }

    @RequiresPermission(allOf={"android.permission.NEARBY_WIFI_DEVICES", "android.permission.ACCESS_FINE_LOCATION"}, conditional=true)
    public void requestDeviceInfo(Channel c, DeviceInfoListener listener) {
        WifiP2pManager.checkChannel(c);
        if (listener == null) {
            throw new IllegalArgumentException("This listener cannot be null.");
        }
        Bundle extras = this.prepareExtrasBundle(c);
        c.mAsyncChannel.sendMessage(this.prepareMessage(139361, 0, c.putListener(listener), extras, c.mContext));
    }

    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    public void addExternalApprover(Channel c, MacAddress deviceAddress, ExternalApproverRequestListener listener) {
        WifiP2pManager.checkChannel(c);
        if (listener == null) {
            throw new IllegalArgumentException("This listener cannot be null.");
        }
        if (null == deviceAddress) {
            throw new IllegalArgumentException("deviceAddress cannot be empty");
        }
        Bundle extras = this.prepareExtrasBundle(c);
        extras.putParcelable(EXTRA_PARAM_KEY_PEER_ADDRESS, deviceAddress);
        c.mAsyncChannel.sendMessage(this.prepareMessage(139366, 0, c.putListener(listener), extras, c.mContext));
    }

    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    public void removeExternalApprover(Channel c, MacAddress deviceAddress, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        if (null == deviceAddress) {
            throw new IllegalArgumentException("deviceAddress cannot be empty");
        }
        Bundle extras = this.prepareExtrasBundle(c);
        extras.putParcelable(EXTRA_PARAM_KEY_PEER_ADDRESS, deviceAddress);
        c.mAsyncChannel.sendMessage(this.prepareMessage(139371, 0, c.putListener(listener), extras, c.mContext));
    }

    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    public void setConnectionRequestResult(Channel c, MacAddress deviceAddress, int result, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        if (null == deviceAddress) {
            throw new IllegalArgumentException("deviceAddress cannot be empty");
        }
        Bundle extras = this.prepareExtrasBundle(c);
        extras.putParcelable(EXTRA_PARAM_KEY_PEER_ADDRESS, deviceAddress);
        c.mAsyncChannel.sendMessage(this.prepareMessage(139374, result, c.putListener(listener), extras, c.mContext));
    }

    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    public void setConnectionRequestResult(Channel c, MacAddress deviceAddress, int result, String pin, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        if (null == deviceAddress) {
            throw new IllegalArgumentException("deviceAddress cannot be empty");
        }
        if (result == 0 && TextUtils.isEmpty(pin)) {
            throw new IllegalArgumentException("PIN cannot be empty for accepting a request");
        }
        Bundle extras = this.prepareExtrasBundle(c);
        extras.putParcelable(EXTRA_PARAM_KEY_PEER_ADDRESS, deviceAddress);
        extras.putString(EXTRA_PARAM_KEY_WPS_PIN, pin);
        c.mAsyncChannel.sendMessage(this.prepareMessage(139374, result, c.putListener(listener), extras, c.mContext));
    }

    @RequiresPermission(allOf={"android.permission.NEARBY_WIFI_DEVICES", "android.permission.OVERRIDE_WIFI_CONFIG"})
    public void setVendorElements(Channel c, List<ScanResult.InformationElement> vendorElements, ActionListener listener) {
        if (!this.isSetVendorElementsSupported()) {
            throw new UnsupportedOperationException();
        }
        WifiP2pManager.checkChannel(c);
        int totalBytes = 0;
        for (ScanResult.InformationElement e : vendorElements) {
            if (e.id != 221) {
                throw new IllegalArgumentException("received InformationElement which is not a Vendor Specific IE (VSIE). VSIEs have an ID = 221.");
            }
            if (e.bytes == null || e.bytes.length > 255) {
                throw new IllegalArgumentException("received InformationElement whose payload size is 0 or greater than 255.");
            }
            if ((totalBytes += 2 + e.bytes.length) <= 512) continue;
            throw new IllegalArgumentException("received InformationElement whose total size is greater than 512.");
        }
        Bundle extras = this.prepareExtrasBundle(c);
        extras.putParcelableArrayList(EXTRA_PARAM_KEY_INFORMATION_ELEMENT_LIST, new ArrayList<ScanResult.InformationElement>(vendorElements));
        c.mAsyncChannel.sendMessage(this.prepareMessage(139377, 0, c.putListener(listener), extras, c.mContext));
    }

    public static int getP2pMaxAllowedVendorElementsLengthBytes() {
        return 512;
    }

    public static interface ChannelListener {
        public void onChannelDisconnected();
    }

    public static class Channel
    implements AutoCloseable {
        private static final int INVALID_LISTENER_KEY = 0;
        private final WifiP2pManager mP2pManager;
        private ChannelListener mChannelListener;
        private ServiceResponseListener mServRspListener;
        private DnsSdServiceResponseListener mDnsSdServRspListener;
        private DnsSdTxtRecordListener mDnsSdTxtListener;
        private UpnpServiceResponseListener mUpnpServRspListener;
        private HashMap<Integer, Object> mListenerMap = new HashMap();
        private final Object mListenerMapLock = new Object();
        private int mListenerKey = 0;
        private final CloseGuard mCloseGuard = new CloseGuard();
        final Binder mBinder;
        @UnsupportedAppUsage
        private AsyncChannel mAsyncChannel = new AsyncChannel();
        private P2pHandler mHandler;
        Context mContext;

        public Channel(Context context, Looper looper, ChannelListener l, Binder binder, WifiP2pManager p2pManager) {
            this.mHandler = new P2pHandler(looper);
            this.mChannelListener = l;
            this.mContext = context;
            this.mBinder = binder;
            this.mP2pManager = p2pManager;
            this.mCloseGuard.open("close");
        }

        public Binder getBinder() {
            return this.mBinder;
        }

        @Override
        public void close() {
            if (this.mP2pManager == null) {
                Log.w(WifiP2pManager.TAG, "Channel.close(): Null mP2pManager!?");
            } else {
                try {
                    this.mP2pManager.mService.close(this.mBinder);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            this.mAsyncChannel.disconnect();
            this.mCloseGuard.close();
            Reference.reachabilityFence(this);
        }

        protected void finalize() throws Throwable {
            try {
                if (this.mCloseGuard != null) {
                    this.mCloseGuard.warnIfOpen();
                }
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        private void handleServiceResponse(WifiP2pServiceResponse resp) {
            if (resp instanceof WifiP2pDnsSdServiceResponse) {
                this.handleDnsSdServiceResponse((WifiP2pDnsSdServiceResponse)resp);
            } else if (resp instanceof WifiP2pUpnpServiceResponse) {
                if (this.mUpnpServRspListener != null) {
                    this.handleUpnpServiceResponse((WifiP2pUpnpServiceResponse)resp);
                }
            } else if (this.mServRspListener != null) {
                this.mServRspListener.onServiceAvailable(resp.getServiceType(), resp.getRawData(), resp.getSrcDevice());
            }
        }

        private void handleUpnpServiceResponse(WifiP2pUpnpServiceResponse resp) {
            this.mUpnpServRspListener.onUpnpServiceAvailable(resp.getUniqueServiceNames(), resp.getSrcDevice());
        }

        private void handleDnsSdServiceResponse(WifiP2pDnsSdServiceResponse resp) {
            if (resp.getDnsType() == 12) {
                if (this.mDnsSdServRspListener != null) {
                    this.mDnsSdServRspListener.onDnsSdServiceAvailable(resp.getInstanceName(), resp.getDnsQueryName(), resp.getSrcDevice());
                }
            } else if (resp.getDnsType() == 16) {
                if (this.mDnsSdTxtListener != null) {
                    this.mDnsSdTxtListener.onDnsSdTxtRecordAvailable(resp.getDnsQueryName(), resp.getTxtRecord(), resp.getSrcDevice());
                }
            } else {
                Log.e(WifiP2pManager.TAG, "Unhandled resp " + resp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        private int putListener(Object listener) {
            int key;
            if (listener == null) {
                return 0;
            }
            Object object = this.mListenerMapLock;
            synchronized (object) {
                do {
                    ++this.mListenerKey;
                } while (key == 0);
                this.mListenerMap.put(key, listener);
            }
            return key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object getListener(int key) {
            if (key == 0) {
                return null;
            }
            Object object = this.mListenerMapLock;
            synchronized (object) {
                return this.mListenerMap.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object removeListener(int key) {
            if (key == 0) {
                return null;
            }
            Object object = this.mListenerMapLock;
            synchronized (object) {
                return this.mListenerMap.remove(key);
            }
        }

        class P2pHandler
        extends Handler {
            P2pHandler(Looper looper) {
                super(looper);
            }

            @Override
            public void handleMessage(Message message) {
                Object listener = null;
                switch (message.what) {
                    case 139367: 
                    case 139369: 
                    case 139370: {
                        listener = Channel.this.getListener(message.arg2);
                        break;
                    }
                    default: {
                        listener = Channel.this.removeListener(message.arg2);
                    }
                }
                switch (message.what) {
                    case 69636: {
                        if (Channel.this.mChannelListener == null) break;
                        Channel.this.mChannelListener.onChannelDisconnected();
                        Channel.this.mChannelListener = null;
                        break;
                    }
                    case 139266: 
                    case 139269: 
                    case 139272: 
                    case 139275: 
                    case 139278: 
                    case 139281: 
                    case 139293: 
                    case 139296: 
                    case 139299: 
                    case 139302: 
                    case 139305: 
                    case 139308: 
                    case 139311: 
                    case 139316: 
                    case 139319: 
                    case 139324: 
                    case 139327: 
                    case 139330: 
                    case 139333: 
                    case 139336: 
                    case 139345: 
                    case 139347: 
                    case 139352: 
                    case 139364: 
                    case 139372: 
                    case 139375: 
                    case 139378: 
                    case 139381: {
                        if (listener == null) break;
                        ((ActionListener)listener).onFailure(message.arg1);
                        break;
                    }
                    case 139267: 
                    case 139270: 
                    case 139273: 
                    case 139276: 
                    case 139279: 
                    case 139282: 
                    case 139294: 
                    case 139297: 
                    case 139300: 
                    case 139303: 
                    case 139306: 
                    case 139309: 
                    case 139312: 
                    case 139317: 
                    case 139320: 
                    case 139325: 
                    case 139328: 
                    case 139331: 
                    case 139334: 
                    case 139337: 
                    case 139344: 
                    case 139348: 
                    case 139353: 
                    case 139365: 
                    case 139373: 
                    case 139376: 
                    case 139379: {
                        if (listener == null) break;
                        ((ActionListener)listener).onSuccess();
                        break;
                    }
                    case 139284: {
                        WifiP2pDeviceList peers = (WifiP2pDeviceList)message.obj;
                        if (listener == null) break;
                        ((PeerListListener)listener).onPeersAvailable(peers);
                        break;
                    }
                    case 139286: {
                        WifiP2pInfo wifiP2pInfo = (WifiP2pInfo)message.obj;
                        if (listener == null) break;
                        ((ConnectionInfoListener)listener).onConnectionInfoAvailable(wifiP2pInfo);
                        break;
                    }
                    case 139288: {
                        WifiP2pGroup group = (WifiP2pGroup)message.obj;
                        if (listener == null) break;
                        ((GroupInfoListener)listener).onGroupInfoAvailable(group);
                        break;
                    }
                    case 139314: {
                        WifiP2pServiceResponse resp = (WifiP2pServiceResponse)message.obj;
                        Channel.this.handleServiceResponse(resp);
                        break;
                    }
                    case 139322: {
                        WifiP2pGroupList groups = (WifiP2pGroupList)message.obj;
                        if (listener == null) break;
                        ((PersistentGroupInfoListener)listener).onPersistentGroupInfoAvailable(groups);
                        break;
                    }
                    case 139341: {
                        Bundle handoverBundle = (Bundle)message.obj;
                        if (listener == null) break;
                        String handoverMessage = handoverBundle != null ? handoverBundle.getString(WifiP2pManager.EXTRA_HANDOVER_MESSAGE) : null;
                        ((HandoverMessageListener)listener).onHandoverMessageAvailable(handoverMessage);
                        break;
                    }
                    case 139350: {
                        WifiP2pConfig peerConfig = (WifiP2pConfig)message.obj;
                        if (listener == null) break;
                        ((OngoingPeerInfoListener)listener).onOngoingPeerAvailable(peerConfig);
                        break;
                    }
                    case 139355: {
                        if (listener == null) break;
                        ((P2pStateListener)listener).onP2pStateAvailable(message.arg1);
                        break;
                    }
                    case 139357: {
                        if (listener == null) break;
                        ((DiscoveryStateListener)listener).onDiscoveryStateAvailable(message.arg1);
                        break;
                    }
                    case 139382: {
                        if (listener == null) break;
                        ((ListenStateListener)listener).onListenStateAvailable(message.arg1);
                        break;
                    }
                    case 139359: {
                        if (listener == null) break;
                        ((NetworkInfoListener)listener).onNetworkInfoAvailable((NetworkInfo)message.obj);
                        break;
                    }
                    case 139362: {
                        if (listener == null) break;
                        ((DeviceInfoListener)listener).onDeviceInfoAvailable((WifiP2pDevice)message.obj);
                        break;
                    }
                    case 139367: {
                        if (listener == null) break;
                        ((ExternalApproverRequestListener)listener).onAttached((MacAddress)message.obj);
                        break;
                    }
                    case 139368: {
                        if (listener == null) break;
                        ((ExternalApproverRequestListener)listener).onDetached((MacAddress)message.obj, message.arg1);
                        break;
                    }
                    case 139369: {
                        if (listener == null) break;
                        int requestType = message.arg1;
                        Bundle bundle = (Bundle)message.obj;
                        WifiP2pDevice device = (WifiP2pDevice)bundle.getParcelable(WifiP2pManager.EXTRA_PARAM_KEY_DEVICE);
                        WifiP2pConfig config = (WifiP2pConfig)bundle.getParcelable(WifiP2pManager.EXTRA_PARAM_KEY_CONFIG);
                        ((ExternalApproverRequestListener)listener).onConnectionRequested(requestType, config, device);
                        break;
                    }
                    case 139370: {
                        if (listener == null) break;
                        Bundle bundle = (Bundle)message.obj;
                        MacAddress deviceAddress = (MacAddress)bundle.getParcelable(WifiP2pManager.EXTRA_PARAM_KEY_PEER_ADDRESS);
                        String pin = bundle.getString(WifiP2pManager.EXTRA_PARAM_KEY_WPS_PIN);
                        ((ExternalApproverRequestListener)listener).onPinGenerated(deviceAddress, pin);
                        break;
                    }
                    default: {
                        Log.d(WifiP2pManager.TAG, "Ignored " + message);
                    }
                }
            }
        }
    }

    public static interface ServiceResponseListener {
        public void onServiceAvailable(int var1, byte[] var2, WifiP2pDevice var3);
    }

    public static interface DnsSdServiceResponseListener {
        public void onDnsSdServiceAvailable(String var1, String var2, WifiP2pDevice var3);
    }

    public static interface DnsSdTxtRecordListener {
        public void onDnsSdTxtRecordAvailable(String var1, Map<String, String> var2, WifiP2pDevice var3);
    }

    public static interface UpnpServiceResponseListener {
        public void onUpnpServiceAvailable(List<String> var1, WifiP2pDevice var2);
    }

    public static interface ActionListener {
        public void onSuccess();

        public void onFailure(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConnectionRequestResponse {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MiracastMode {
    }

    public static interface ExternalApproverRequestListener {
        public static final int REQUEST_TYPE_NEGOTIATION = 0;
        public static final int REQUEST_TYPE_INVITATION = 1;
        public static final int REQUEST_TYPE_JOIN = 2;
        public static final int APPROVER_DETACH_REASON_REMOVE = 0;
        public static final int APPROVER_DETACH_REASON_FAILURE = 1;
        public static final int APPROVER_DETACH_REASON_REPLACE = 2;
        public static final int APPROVER_DETACH_REASON_CLOSE = 3;

        public void onAttached(MacAddress var1);

        public void onDetached(MacAddress var1, int var2);

        public void onConnectionRequested(int var1, WifiP2pConfig var2, WifiP2pDevice var3);

        public void onPinGenerated(MacAddress var1, String var2);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ApproverDetachReason {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface RequestType {
        }
    }

    public static interface DeviceInfoListener {
        public void onDeviceInfoAvailable(WifiP2pDevice var1);
    }

    public static interface OngoingPeerInfoListener {
        public void onOngoingPeerAvailable(WifiP2pConfig var1);
    }

    public static interface NetworkInfoListener {
        public void onNetworkInfoAvailable(NetworkInfo var1);
    }

    public static interface ListenStateListener {
        public void onListenStateAvailable(int var1);
    }

    public static interface DiscoveryStateListener {
        public void onDiscoveryStateAvailable(int var1);
    }

    public static interface P2pStateListener {
        public void onP2pStateAvailable(int var1);
    }

    public static interface HandoverMessageListener {
        public void onHandoverMessageAvailable(String var1);
    }

    @SystemApi
    public static interface PersistentGroupInfoListener {
        public void onPersistentGroupInfoAvailable(WifiP2pGroupList var1);
    }

    public static interface GroupInfoListener {
        public void onGroupInfoAvailable(WifiP2pGroup var1);
    }

    public static interface ConnectionInfoListener {
        public void onConnectionInfoAvailable(WifiP2pInfo var1);
    }

    public static interface PeerListListener {
        public void onPeersAvailable(WifiP2pDeviceList var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiP2pScanType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiP2pListenState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiP2pDiscoveryState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiP2pState {
    }
}

