/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RequiresApi;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;

public class WifiP2pWfdInfo
implements Parcelable {
    private boolean mEnabled;
    private int mDeviceInfo;
    private int mR2DeviceInfo = -1;
    public static final int DEVICE_TYPE_WFD_SOURCE = 0;
    public static final int DEVICE_TYPE_PRIMARY_SINK = 1;
    public static final int DEVICE_TYPE_SECONDARY_SINK = 2;
    public static final int DEVICE_TYPE_SOURCE_OR_PRIMARY_SINK = 3;
    public static final int PREFERRED_CONNECTIVITY_P2P = 0;
    public static final int PREFERRED_CONNECTIVITY_TDLS = 1;
    public static final int DEVICE_INFO_DEVICE_TYPE_MASK = 3;
    public static final int DEVICE_INFO_COUPLED_SINK_SUPPORT_AT_SOURCE = 4;
    public static final int DEVICE_INFO_COUPLED_SINK_SUPPORT_AT_SINK = 8;
    private static final int SESSION_AVAILABLE_BIT1 = 16;
    private static final int SESSION_AVAILABLE_BIT2 = 32;
    public static final int DEVICE_INFO_SESSION_AVAILABLE_MASK = 48;
    public static final int DEVICE_INFO_WFD_SERVICE_DISCOVERY_SUPPORT = 64;
    public static final int DEVICE_INFO_PREFERRED_CONNECTIVITY_MASK = 128;
    public static final int DEVICE_INFO_CONTENT_PROTECTION_SUPPORT = 256;
    public static final int DEVICE_INFO_TIME_SYNCHRONIZATION_SUPPORT = 512;
    public static final int DEVICE_INFO_AUDIO_UNSUPPORTED_AT_PRIMARY_SINK = 1024;
    public static final int DEVICE_INFO_AUDIO_ONLY_SUPPORT_AT_SOURCE = 2048;
    public static final int DEVICE_INFO_TDLS_PERSISTENT_GROUP = 4096;
    public static final int DEVICE_INFO_TDLS_PERSISTENT_GROUP_REINVOKE = 8192;
    private int mCtrlPort;
    private int mMaxThroughput;
    public static final Parcelable.Creator<WifiP2pWfdInfo> CREATOR = new Parcelable.Creator<WifiP2pWfdInfo>(){

        @Override
        public WifiP2pWfdInfo createFromParcel(Parcel in) {
            WifiP2pWfdInfo device = new WifiP2pWfdInfo();
            device.readFromParcel(in);
            return device;
        }

        public WifiP2pWfdInfo[] newArray(int size) {
            return new WifiP2pWfdInfo[size];
        }
    };

    public WifiP2pWfdInfo() {
    }

    @UnsupportedAppUsage
    public WifiP2pWfdInfo(int devInfo, int ctrlPort, int maxTput) {
        this.mEnabled = true;
        this.mDeviceInfo = devInfo;
        this.mCtrlPort = ctrlPort;
        this.mMaxThroughput = maxTput;
        this.mR2DeviceInfo = -1;
    }

    public int getDeviceInfo() {
        return this.mDeviceInfo;
    }

    public void setR2DeviceInfo(int r2DeviceInfo) {
        this.mR2DeviceInfo = r2DeviceInfo;
    }

    public int getR2DeviceInfo() {
        return this.mR2DeviceInfo;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public boolean isR2Supported() {
        return this.mR2DeviceInfo >= 0;
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    @RequiresApi(value=31)
    public boolean setR2DeviceType(int deviceType) {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        if (0 != deviceType && 1 != deviceType && 3 != deviceType) {
            return false;
        }
        if (!this.isR2Supported()) {
            this.mR2DeviceInfo = 0;
        }
        this.mR2DeviceInfo &= 0xFFFFFFFC;
        this.mR2DeviceInfo |= deviceType;
        return true;
    }

    public int getDeviceType() {
        return this.mDeviceInfo & 3;
    }

    public int getR2DeviceType() {
        return this.mR2DeviceInfo & 3;
    }

    public boolean setDeviceType(int deviceType) {
        if (0 <= deviceType && deviceType <= 3) {
            this.mDeviceInfo &= 0xFFFFFFFC;
            this.mDeviceInfo |= deviceType;
            return true;
        }
        return false;
    }

    public boolean isSessionAvailable() {
        return (this.mDeviceInfo & 0x30) != 0;
    }

    public void setSessionAvailable(boolean enabled) {
        if (enabled) {
            this.mDeviceInfo |= 0x10;
            this.mDeviceInfo &= 0xFFFFFFDF;
        } else {
            this.mDeviceInfo &= 0xFFFFFFCF;
        }
    }

    public boolean isContentProtectionSupported() {
        return (this.mDeviceInfo & 0x100) != 0;
    }

    public void setContentProtectionSupported(boolean enabled) {
        this.mDeviceInfo = enabled ? (this.mDeviceInfo |= 0x100) : (this.mDeviceInfo &= 0xFFFFFEFF);
    }

    public boolean isCoupledSinkSupportedAtSource() {
        return (this.mDeviceInfo & 4) != 0;
    }

    public void setCoupledSinkSupportAtSource(boolean enabled) {
        this.mDeviceInfo = enabled ? (this.mDeviceInfo |= 4) : (this.mDeviceInfo &= 0xFFFFFFFB);
    }

    public boolean isCoupledSinkSupportedAtSink() {
        return (this.mDeviceInfo & 8) != 0;
    }

    public void setCoupledSinkSupportAtSink(boolean enabled) {
        this.mDeviceInfo = enabled ? (this.mDeviceInfo |= 8) : (this.mDeviceInfo &= 0xFFFFFFF7);
    }

    public int getControlPort() {
        return this.mCtrlPort;
    }

    public void setControlPort(int port) {
        this.mCtrlPort = port;
    }

    public void setMaxThroughput(int maxThroughput) {
        this.mMaxThroughput = maxThroughput;
    }

    public int getMaxThroughput() {
        return this.mMaxThroughput;
    }

    public String getDeviceInfoHex() {
        return String.format(Locale.US, "%04x%04x%04x", this.mDeviceInfo, this.mCtrlPort, this.mMaxThroughput);
    }

    public String getR2DeviceInfoHex() {
        return String.format(Locale.US, "%04x%04x", 2, this.mR2DeviceInfo);
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("WFD enabled: ").append(this.mEnabled);
        sbuf.append("WFD DeviceInfo: ").append(this.mDeviceInfo);
        sbuf.append("\n WFD CtrlPort: ").append(this.mCtrlPort);
        sbuf.append("\n WFD MaxThroughput: ").append(this.mMaxThroughput);
        sbuf.append("\n WFD R2 DeviceInfo: ").append(this.mR2DeviceInfo);
        return sbuf.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public WifiP2pWfdInfo(WifiP2pWfdInfo source) {
        if (source != null) {
            this.mEnabled = source.mEnabled;
            this.mDeviceInfo = source.mDeviceInfo;
            this.mCtrlPort = source.mCtrlPort;
            this.mMaxThroughput = source.mMaxThroughput;
            this.mR2DeviceInfo = source.mR2DeviceInfo;
        }
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mEnabled ? 1 : 0);
        dest.writeInt(this.mDeviceInfo);
        dest.writeInt(this.mCtrlPort);
        dest.writeInt(this.mMaxThroughput);
        dest.writeInt(this.mR2DeviceInfo);
    }

    private void readFromParcel(Parcel in) {
        this.mEnabled = in.readInt() == 1;
        this.mDeviceInfo = in.readInt();
        this.mCtrlPort = in.readInt();
        this.mMaxThroughput = in.readInt();
        this.mR2DeviceInfo = in.readInt();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface R2DeviceInfoMask {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceInfoMask {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PreferredConnectivity {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceType {
    }
}

