/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.rtt;

import android.annotation.SystemApi;
import android.net.MacAddress;
import android.net.wifi.aware.PeerHandle;
import android.net.wifi.rtt.ResponderLocation;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;

public class RangingResult
implements Parcelable {
    private static final String TAG = "RangingResult";
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAIL = 1;
    public static final int STATUS_RESPONDER_DOES_NOT_SUPPORT_IEEE80211MC = 2;
    public static final int UNSPECIFIED = -1;
    public final int mStatus;
    public final MacAddress mMac;
    public final PeerHandle mPeerHandle;
    public final int mDistanceMm;
    public final int mDistanceStdDevMm;
    public final int mRssi;
    public final int mNumAttemptedMeasurements;
    public final int mNumSuccessfulMeasurements;
    public final byte[] mLci;
    public final byte[] mLcr;
    public final ResponderLocation mResponderLocation;
    public final long mTimestamp;
    public final boolean mIs80211mcMeasurement;
    public final int mFrequencyMHz;
    public final int mPacketBw;
    public static final Parcelable.Creator<RangingResult> CREATOR = new Parcelable.Creator<RangingResult>(){

        public RangingResult[] newArray(int size) {
            return new RangingResult[size];
        }

        @Override
        public RangingResult createFromParcel(Parcel in) {
            int status = in.readInt();
            boolean macAddressPresent = in.readBoolean();
            MacAddress mac = null;
            if (macAddressPresent) {
                mac = MacAddress.CREATOR.createFromParcel(in);
            }
            boolean peerHandlePresent = in.readBoolean();
            PeerHandle peerHandle = null;
            if (peerHandlePresent) {
                peerHandle = new PeerHandle(in.readInt());
            }
            int distanceMm = in.readInt();
            int distanceStdDevMm = in.readInt();
            int rssi = in.readInt();
            int numAttemptedMeasurements = in.readInt();
            int numSuccessfulMeasurements = in.readInt();
            byte[] lci = in.createByteArray();
            byte[] lcr = in.createByteArray();
            ResponderLocation responderLocation = (ResponderLocation)in.readParcelable(this.getClass().getClassLoader());
            long timestamp = in.readLong();
            boolean isllmcMeasurement = in.readBoolean();
            int frequencyMHz = in.readInt();
            int packetBw = in.readInt();
            if (peerHandlePresent) {
                return new RangingResult(status, peerHandle, distanceMm, distanceStdDevMm, rssi, numAttemptedMeasurements, numSuccessfulMeasurements, lci, lcr, responderLocation, timestamp);
            }
            return new RangingResult(status, mac, distanceMm, distanceStdDevMm, rssi, numAttemptedMeasurements, numSuccessfulMeasurements, lci, lcr, responderLocation, timestamp, isllmcMeasurement, frequencyMHz, packetBw);
        }
    };

    public RangingResult(int status, MacAddress mac, int distanceMm, int distanceStdDevMm, int rssi, int numAttemptedMeasurements, int numSuccessfulMeasurements, byte[] lci, byte[] lcr, ResponderLocation responderLocation, long timestamp, boolean is80211McMeasurement, int frequencyMHz, int packetBw) {
        this.mStatus = status;
        this.mMac = mac;
        this.mPeerHandle = null;
        this.mDistanceMm = distanceMm;
        this.mDistanceStdDevMm = distanceStdDevMm;
        this.mRssi = rssi;
        this.mNumAttemptedMeasurements = numAttemptedMeasurements;
        this.mNumSuccessfulMeasurements = numSuccessfulMeasurements;
        this.mLci = lci == null ? EMPTY_BYTE_ARRAY : lci;
        this.mLcr = lcr == null ? EMPTY_BYTE_ARRAY : lcr;
        this.mResponderLocation = responderLocation;
        this.mTimestamp = timestamp;
        this.mIs80211mcMeasurement = is80211McMeasurement;
        this.mFrequencyMHz = frequencyMHz;
        this.mPacketBw = packetBw;
    }

    public RangingResult(int status, MacAddress mac, int distanceMm, int distanceStdDevMm, int rssi, int numAttemptedMeasurements, int numSuccessfulMeasurements, byte[] lci, byte[] lcr, ResponderLocation responderLocation, long timestamp, boolean is80211McMeasurement) {
        this.mStatus = status;
        this.mMac = mac;
        this.mPeerHandle = null;
        this.mDistanceMm = distanceMm;
        this.mDistanceStdDevMm = distanceStdDevMm;
        this.mRssi = rssi;
        this.mNumAttemptedMeasurements = numAttemptedMeasurements;
        this.mNumSuccessfulMeasurements = numSuccessfulMeasurements;
        this.mLci = lci == null ? EMPTY_BYTE_ARRAY : lci;
        this.mLcr = lcr == null ? EMPTY_BYTE_ARRAY : lcr;
        this.mResponderLocation = responderLocation;
        this.mTimestamp = timestamp;
        this.mIs80211mcMeasurement = is80211McMeasurement;
        this.mFrequencyMHz = -1;
        this.mPacketBw = -1;
    }

    public RangingResult(int status, PeerHandle peerHandle, int distanceMm, int distanceStdDevMm, int rssi, int numAttemptedMeasurements, int numSuccessfulMeasurements, byte[] lci, byte[] lcr, ResponderLocation responderLocation, long timestamp) {
        this.mStatus = status;
        this.mMac = null;
        this.mPeerHandle = peerHandle;
        this.mDistanceMm = distanceMm;
        this.mDistanceStdDevMm = distanceStdDevMm;
        this.mRssi = rssi;
        this.mNumAttemptedMeasurements = numAttemptedMeasurements;
        this.mNumSuccessfulMeasurements = numSuccessfulMeasurements;
        this.mLci = lci == null ? EMPTY_BYTE_ARRAY : lci;
        this.mLcr = lcr == null ? EMPTY_BYTE_ARRAY : lcr;
        this.mResponderLocation = responderLocation;
        this.mTimestamp = timestamp;
        this.mIs80211mcMeasurement = true;
        this.mFrequencyMHz = -1;
        this.mPacketBw = -1;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public MacAddress getMacAddress() {
        return this.mMac;
    }

    public PeerHandle getPeerHandle() {
        return this.mPeerHandle;
    }

    public int getDistanceMm() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getDistanceMm(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mDistanceMm;
    }

    public int getDistanceStdDevMm() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getDistanceStdDevMm(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mDistanceStdDevMm;
    }

    public int getRssi() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getRssi(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mRssi;
    }

    public int getNumAttemptedMeasurements() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getNumAttemptedMeasurements(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mNumAttemptedMeasurements;
    }

    public int getNumSuccessfulMeasurements() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getNumSuccessfulMeasurements(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mNumSuccessfulMeasurements;
    }

    public ResponderLocation getUnverifiedResponderLocation() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getUnverifiedResponderLocation(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mResponderLocation;
    }

    @SystemApi
    public byte[] getLci() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getLci(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mLci;
    }

    @SystemApi
    public byte[] getLcr() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getReportedLocationCivic(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mLcr;
    }

    public long getRangingTimestampMillis() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getRangingTimestampMillis(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mTimestamp;
    }

    public boolean is80211mcMeasurement() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("is80211mcMeasurementResult(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mIs80211mcMeasurement;
    }

    public int getMeasurementChannelFrequencyMHz() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getMeasurementChannelFrequencyMHz(): invoked on an invalid result: getStatus()= " + this.mStatus);
        }
        return this.mFrequencyMHz;
    }

    public int getMeasurementBandwidth() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getMeasurementBandwidth(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mPacketBw;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mStatus);
        if (this.mMac == null) {
            dest.writeBoolean(false);
        } else {
            dest.writeBoolean(true);
            this.mMac.writeToParcel(dest, flags);
        }
        if (this.mPeerHandle == null) {
            dest.writeBoolean(false);
        } else {
            dest.writeBoolean(true);
            dest.writeInt(this.mPeerHandle.peerId);
        }
        dest.writeInt(this.mDistanceMm);
        dest.writeInt(this.mDistanceStdDevMm);
        dest.writeInt(this.mRssi);
        dest.writeInt(this.mNumAttemptedMeasurements);
        dest.writeInt(this.mNumSuccessfulMeasurements);
        dest.writeByteArray(this.mLci);
        dest.writeByteArray(this.mLcr);
        dest.writeParcelable(this.mResponderLocation, flags);
        dest.writeLong(this.mTimestamp);
        dest.writeBoolean(this.mIs80211mcMeasurement);
        dest.writeInt(this.mFrequencyMHz);
        dest.writeInt(this.mPacketBw);
    }

    public String toString() {
        return "RangingResult: [status=" + this.mStatus + ", mac=" + this.mMac + ", peerHandle=" + (this.mPeerHandle == null ? "<null>" : Integer.valueOf(this.mPeerHandle.peerId)) + ", distanceMm=" + this.mDistanceMm + ", distanceStdDevMm=" + this.mDistanceStdDevMm + ", rssi=" + this.mRssi + ", numAttemptedMeasurements=" + this.mNumAttemptedMeasurements + ", numSuccessfulMeasurements=" + this.mNumSuccessfulMeasurements + ", lci=" + Arrays.toString(this.mLci) + ", lcr=" + Arrays.toString(this.mLcr) + ", responderLocation=" + this.mResponderLocation + ", timestamp=" + this.mTimestamp + ", is80211mcMeasurement=" + this.mIs80211mcMeasurement + ", frequencyMHz=" + this.mFrequencyMHz + ", packetBw=" + this.mPacketBw + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangingResult)) {
            return false;
        }
        RangingResult lhs = (RangingResult)o;
        return this.mStatus == lhs.mStatus && Objects.equals(this.mMac, lhs.mMac) && Objects.equals(this.mPeerHandle, lhs.mPeerHandle) && this.mDistanceMm == lhs.mDistanceMm && this.mDistanceStdDevMm == lhs.mDistanceStdDevMm && this.mRssi == lhs.mRssi && this.mNumAttemptedMeasurements == lhs.mNumAttemptedMeasurements && this.mNumSuccessfulMeasurements == lhs.mNumSuccessfulMeasurements && Arrays.equals(this.mLci, lhs.mLci) && Arrays.equals(this.mLcr, lhs.mLcr) && this.mTimestamp == lhs.mTimestamp && this.mIs80211mcMeasurement == lhs.mIs80211mcMeasurement && Objects.equals(this.mResponderLocation, lhs.mResponderLocation) && this.mFrequencyMHz == lhs.mFrequencyMHz && this.mPacketBw == lhs.mPacketBw;
    }

    public int hashCode() {
        return Objects.hash(this.mStatus, this.mMac, this.mPeerHandle, this.mDistanceMm, this.mDistanceStdDevMm, this.mRssi, this.mNumAttemptedMeasurements, this.mNumSuccessfulMeasurements, Arrays.hashCode(this.mLci), Arrays.hashCode(this.mLcr), this.mResponderLocation, this.mTimestamp, this.mIs80211mcMeasurement, this.mFrequencyMHz, this.mPacketBw);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RangeResultStatus {
    }
}

