/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.rtt;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.location.Address;
import android.location.Location;
import android.net.MacAddress;
import android.net.Uri;
import android.net.wifi.rtt.CivicLocation;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.SparseArray;
import android.webkit.MimeTypeMap;
import com.android.internal.lang.System_Delegate;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ResponderLocation
implements Parcelable {
    private static final int BYTE_MASK = 255;
    private static final int LSB_IN_BYTE = 1;
    private static final int MSB_IN_BYTE = 128;
    private static final int MIN_BUFFER_SIZE = 3;
    private static final int MAX_BUFFER_SIZE = 256;
    private static final byte MEASUREMENT_TOKEN_AUTONOMOUS = 1;
    private static final byte MEASUREMENT_REPORT_MODE = 0;
    private static final byte MEASUREMENT_TYPE_LCI = 8;
    private static final byte MEASUREMENT_TYPE_LCR = 11;
    private static final byte SUBELEMENT_LCI = 0;
    private static final byte SUBELEMENT_Z = 4;
    private static final byte SUBELEMENT_USAGE = 6;
    private static final byte SUBELEMENT_BSSID_LIST = 7;
    private static final int SUBELEMENT_LCI_LENGTH = 16;
    private static final int SUBELEMENT_Z_LENGTH = 6;
    private static final int SUBELEMENT_USAGE_LENGTH1 = 1;
    private static final int SUBELEMENT_USAGE_LENGTH3 = 3;
    private static final int SUBELEMENT_BSSID_LIST_MIN_BUFFER_LENGTH = 1;
    private static final byte[] LEAD_LCI_ELEMENT_BYTES = new byte[]{1, 0, 8};
    private static final int[] SUBELEMENT_LCI_BIT_FIELD_LENGTHS = new int[]{6, 34, 6, 34, 4, 6, 30, 3, 1, 1, 1, 2};
    private static final int LATLNG_FRACTION_BITS = 25;
    private static final int LATLNG_UNCERTAINTY_BASE = 8;
    private static final int ALTITUDE_FRACTION_BITS = 8;
    private static final int ALTITUDE_UNCERTAINTY_BASE = 21;
    private static final double LAT_ABS_LIMIT = 90.0;
    private static final double LNG_ABS_LIMIT = 180.0;
    private static final int UNCERTAINTY_UNDEFINED = 0;
    private static final int SUBELEMENT_LCI_LAT_UNCERTAINTY_INDEX = 0;
    private static final int SUBELEMENT_LCI_LAT_INDEX = 1;
    private static final int SUBELEMENT_LCI_LNG_UNCERTAINTY_INDEX = 2;
    private static final int SUBELEMENT_LCI_LNG_INDEX = 3;
    private static final int SUBELEMENT_LCI_ALT_TYPE_INDEX = 4;
    private static final int SUBELEMENT_LCI_ALT_UNCERTAINTY_INDEX = 5;
    private static final int SUBELEMENT_LCI_ALT_INDEX = 6;
    private static final int SUBELEMENT_LCI_DATUM_INDEX = 7;
    private static final int SUBELEMENT_LCI_REGLOC_AGREEMENT_INDEX = 8;
    private static final int SUBELEMENT_LCI_REGLOC_DSE_INDEX = 9;
    private static final int SUBELEMENT_LCI_DEPENDENT_STA_INDEX = 10;
    private static final int SUBELEMENT_LCI_VERSION_INDEX = 11;
    public static final int ALTITUDE_UNDEFINED = 0;
    public static final int ALTITUDE_METERS = 1;
    public static final int ALTITUDE_FLOORS = 2;
    public static final int DATUM_UNDEFINED = 0;
    public static final int DATUM_WGS84 = 1;
    public static final int DATUM_NAD83_NAV88 = 2;
    public static final int DATUM_NAD83_MLLW = 3;
    public static final int LCI_VERSION_1 = 1;
    private static final String LOCATION_PROVIDER = "WiFi Access Point";
    private static final int[] SUBELEMENT_Z_BIT_FIELD_LENGTHS = new int[]{2, 14, 24, 8};
    private static final int Z_FLOOR_NUMBER_FRACTION_BITS = 4;
    private static final int Z_FLOOR_HEIGHT_FRACTION_BITS = 12;
    private static final int Z_MAX_HEIGHT_UNCERTAINTY_FACTOR = 25;
    private static final int SUBELEMENT_Z_LAT_EXPECTED_TO_MOVE_INDEX = 0;
    private static final int SUBELEMENT_Z_FLOOR_NUMBER_INDEX = 1;
    private static final int SUBELEMENT_Z_HEIGHT_ABOVE_FLOOR_INDEX = 2;
    private static final int SUBELEMENT_Z_HEIGHT_ABOVE_FLOOR_UNCERTAINTY_INDEX = 3;
    private static final int SUBELEMENT_USAGE_MASK_RETRANSMIT = 1;
    private static final int SUBELEMENT_USAGE_MASK_RETENTION_EXPIRES = 2;
    private static final int SUBELEMENT_USAGE_MASK_STA_LOCATION_POLICY = 4;
    private static final int SUBELEMENT_USAGE_PARAMS_INDEX = 0;
    private static final int SUBELEMENT_BSSID_MAX_INDICATOR_INDEX = 0;
    private static final int SUBELEMENT_BSSID_LIST_INDEX = 1;
    private static final int BYTES_IN_A_BSSID = 6;
    public static final int LOCATION_FIXED = 0;
    public static final int LOCATION_VARIABLE = 1;
    public static final int LOCATION_MOVEMENT_UNKNOWN = 2;
    public static final int LOCATION_RESERVED = 3;
    private static final byte SUBELEMENT_LOCATION_CIVIC = 0;
    private static final byte SUBELEMENT_MAP_IMAGE = 5;
    private static final int SUBELEMENT_LOCATION_CIVIC_MIN_LENGTH = 2;
    private static final int SUBELEMENT_LOCATION_CIVIC_MAX_LENGTH = 256;
    private static final int SUBELEMENT_MAP_IMAGE_URL_MAX_LENGTH = 256;
    private static final byte[] LEAD_LCR_ELEMENT_BYTES = new byte[]{1, 0, 11};
    private static final int CIVIC_COUNTRY_CODE_INDEX = 0;
    private static final int CIVIC_TLV_LIST_INDEX = 2;
    private static final int SUBELEMENT_IMAGE_MAP_TYPE_INDEX = 0;
    private static final int MAP_TYPE_URL_DEFINED = 0;
    private static final String[] SUPPORTED_IMAGE_FILE_EXTENSIONS = new String[]{"", "png", "gif", "jpg", "svg", "dxf", "dwg", "dwf", "cad", "tif", "gml", "kml", "bmp", "pgm", "ppm", "xbm", "xpm", "ico"};
    private final boolean mIsValid;
    private boolean mIsLciValid = false;
    private boolean mIsZValid = false;
    private boolean mIsUsageValid = true;
    private boolean mIsBssidListValid = false;
    private boolean mIsLocationCivicValid = false;
    private boolean mIsMapImageValid = false;
    private double mLatitudeUncertainty;
    private double mLatitude;
    private double mLongitudeUncertainty;
    private double mLongitude;
    private int mAltitudeType;
    private double mAltitudeUncertainty;
    private double mAltitude;
    private int mDatum;
    private boolean mLciRegisteredLocationAgreement;
    private boolean mLciRegisteredLocationDse;
    private boolean mLciDependentStation;
    private int mLciVersion;
    private int mExpectedToMove;
    private double mFloorNumber;
    private double mHeightAboveFloorMeters;
    private double mHeightAboveFloorUncertaintyMeters;
    private boolean mUsageRetransmit;
    private boolean mUsageRetentionExpires;
    private boolean mUsageExtraInfoOnAssociation;
    private ArrayList<MacAddress> mBssidList;
    private String mCivicLocationCountryCode;
    private String mCivicLocationString;
    private CivicLocation mCivicLocation;
    private int mMapImageType;
    private Uri mMapImageUri;
    public static final Parcelable.Creator<ResponderLocation> CREATOR = new Parcelable.Creator<ResponderLocation>(){

        @Override
        public ResponderLocation createFromParcel(Parcel in) {
            return new ResponderLocation(in);
        }

        public ResponderLocation[] newArray(int size) {
            return new ResponderLocation[size];
        }
    };

    public ResponderLocation(byte[] lciBuffer, byte[] lcrBuffer) {
        boolean isLciIeValid = false;
        boolean isLcrIeValid = false;
        this.setLciSubelementDefaults();
        this.setZaxisSubelementDefaults();
        this.setUsageSubelementDefaults();
        this.setBssidListSubelementDefaults();
        this.setCivicLocationSubelementDefaults();
        this.setMapImageSubelementDefaults();
        if (lciBuffer != null && lciBuffer.length > LEAD_LCI_ELEMENT_BYTES.length) {
            isLciIeValid = this.parseInformationElementBuffer(8, lciBuffer, LEAD_LCI_ELEMENT_BYTES);
        }
        if (lcrBuffer != null && lcrBuffer.length > LEAD_LCR_ELEMENT_BYTES.length) {
            isLcrIeValid = this.parseInformationElementBuffer(11, lcrBuffer, LEAD_LCR_ELEMENT_BYTES);
        }
        boolean isLciValid = isLciIeValid && this.mIsUsageValid && (this.mIsLciValid || this.mIsZValid || this.mIsBssidListValid);
        boolean isLcrValid = isLcrIeValid && this.mIsUsageValid && (this.mIsLocationCivicValid || this.mIsMapImageValid);
        boolean bl = this.mIsValid = isLciValid || isLcrValid;
        if (!this.mIsValid) {
            this.setLciSubelementDefaults();
            this.setZaxisSubelementDefaults();
            this.setCivicLocationSubelementDefaults();
            this.setMapImageSubelementDefaults();
        }
    }

    private ResponderLocation(Parcel in) {
        this.mIsValid = in.readByte() != 0;
        this.mIsLciValid = in.readByte() != 0;
        this.mIsZValid = in.readByte() != 0;
        this.mIsUsageValid = in.readByte() != 0;
        this.mIsBssidListValid = in.readByte() != 0;
        this.mIsLocationCivicValid = in.readByte() != 0;
        this.mIsMapImageValid = in.readByte() != 0;
        this.mLatitudeUncertainty = in.readDouble();
        this.mLatitude = in.readDouble();
        this.mLongitudeUncertainty = in.readDouble();
        this.mLongitude = in.readDouble();
        this.mAltitudeType = in.readInt();
        this.mAltitudeUncertainty = in.readDouble();
        this.mAltitude = in.readDouble();
        this.mDatum = in.readInt();
        this.mLciRegisteredLocationAgreement = in.readByte() != 0;
        this.mLciRegisteredLocationDse = in.readByte() != 0;
        this.mLciDependentStation = in.readByte() != 0;
        this.mLciVersion = in.readInt();
        this.mExpectedToMove = in.readInt();
        this.mFloorNumber = in.readDouble();
        this.mHeightAboveFloorMeters = in.readDouble();
        this.mHeightAboveFloorUncertaintyMeters = in.readDouble();
        this.mUsageRetransmit = in.readByte() != 0;
        this.mUsageRetentionExpires = in.readByte() != 0;
        this.mUsageExtraInfoOnAssociation = in.readByte() != 0;
        this.mBssidList = in.readArrayList(MacAddress.class.getClassLoader());
        this.mCivicLocationCountryCode = in.readString();
        this.mCivicLocationString = in.readString();
        this.mCivicLocation = (CivicLocation)in.readParcelable(this.getClass().getClassLoader());
        this.mMapImageType = in.readInt();
        String urlString = in.readString();
        this.mMapImageUri = TextUtils.isEmpty(urlString) ? null : Uri.parse(urlString);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeByte((byte)(this.mIsValid ? 1 : 0));
        parcel.writeByte((byte)(this.mIsLciValid ? 1 : 0));
        parcel.writeByte((byte)(this.mIsZValid ? 1 : 0));
        parcel.writeByte((byte)(this.mIsUsageValid ? 1 : 0));
        parcel.writeByte((byte)(this.mIsBssidListValid ? 1 : 0));
        parcel.writeByte((byte)(this.mIsLocationCivicValid ? 1 : 0));
        parcel.writeByte((byte)(this.mIsMapImageValid ? 1 : 0));
        parcel.writeDouble(this.mLatitudeUncertainty);
        parcel.writeDouble(this.mLatitude);
        parcel.writeDouble(this.mLongitudeUncertainty);
        parcel.writeDouble(this.mLongitude);
        parcel.writeInt(this.mAltitudeType);
        parcel.writeDouble(this.mAltitudeUncertainty);
        parcel.writeDouble(this.mAltitude);
        parcel.writeInt(this.mDatum);
        parcel.writeByte((byte)(this.mLciRegisteredLocationAgreement ? 1 : 0));
        parcel.writeByte((byte)(this.mLciRegisteredLocationDse ? 1 : 0));
        parcel.writeByte((byte)(this.mLciDependentStation ? 1 : 0));
        parcel.writeInt(this.mLciVersion);
        parcel.writeInt(this.mExpectedToMove);
        parcel.writeDouble(this.mFloorNumber);
        parcel.writeDouble(this.mHeightAboveFloorMeters);
        parcel.writeDouble(this.mHeightAboveFloorUncertaintyMeters);
        parcel.writeByte((byte)(this.mUsageRetransmit ? 1 : 0));
        parcel.writeByte((byte)(this.mUsageRetentionExpires ? 1 : 0));
        parcel.writeByte((byte)(this.mUsageExtraInfoOnAssociation ? 1 : 0));
        parcel.writeList(this.mBssidList);
        parcel.writeString(this.mCivicLocationCountryCode);
        parcel.writeString(this.mCivicLocationString);
        parcel.writeParcelable(this.mCivicLocation, flags);
        parcel.writeInt(this.mMapImageType);
        if (this.mMapImageUri != null) {
            parcel.writeString(this.mMapImageUri.toString());
        } else {
            parcel.writeString("");
        }
    }

    private boolean parseInformationElementBuffer(int ieType, byte[] buffer, byte[] expectedLeadBytes) {
        int bufferPtr = 0;
        int bufferLength = buffer.length;
        if (bufferLength < 3 || bufferLength > 256) {
            return false;
        }
        byte[] leadBufferBytes = Arrays.copyOfRange(buffer, bufferPtr, expectedLeadBytes.length);
        for (int i = 1; i < leadBufferBytes.length; ++i) {
            if (leadBufferBytes[i] == expectedLeadBytes[i]) continue;
            return false;
        }
        bufferPtr += expectedLeadBytes.length;
        while (bufferPtr + 1 < bufferLength) {
            byte subelementLength;
            block19: {
                byte[] subelementData;
                byte subelement;
                block18: {
                    subelement = buffer[bufferPtr++];
                    if (bufferPtr + (subelementLength = buffer[bufferPtr++]) > bufferLength || subelementLength <= 0) {
                        return false;
                    }
                    subelementData = Arrays.copyOfRange(buffer, bufferPtr, bufferPtr + subelementLength);
                    if (ieType != 8) break block18;
                    switch (subelement) {
                        case 0: {
                            this.mIsLciValid = this.parseSubelementLci(subelementData);
                            if (!this.mIsLciValid || this.mLciVersion != 1) {
                                this.setLciSubelementDefaults();
                                break;
                            }
                            break block19;
                        }
                        case 4: {
                            this.mIsZValid = this.parseSubelementZ(subelementData);
                            if (!this.mIsZValid) {
                                this.setZaxisSubelementDefaults();
                                break;
                            }
                            break block19;
                        }
                        case 6: {
                            this.mIsUsageValid = this.parseSubelementUsage(subelementData);
                            break;
                        }
                        case 7: {
                            this.mIsBssidListValid = this.parseSubelementBssidList(subelementData);
                            if (!this.mIsBssidListValid) {
                                this.setBssidListSubelementDefaults();
                                break;
                            }
                            break block19;
                        }
                    }
                    break block19;
                }
                if (ieType == 11) {
                    switch (subelement) {
                        case 0: {
                            this.mIsLocationCivicValid = this.parseSubelementLocationCivic(subelementData);
                            if (this.mIsLocationCivicValid) break;
                            this.setCivicLocationSubelementDefaults();
                            break;
                        }
                        case 5: {
                            this.mIsMapImageValid = this.parseSubelementMapImage(subelementData);
                            if (this.mIsMapImageValid) break;
                            this.setMapImageSubelementDefaults();
                            break;
                        }
                    }
                }
            }
            bufferPtr += subelementLength;
        }
        return true;
    }

    private boolean parseSubelementLci(byte[] buffer) {
        if (buffer.length > 16) {
            return false;
        }
        this.swapEndianByteByByte(buffer);
        long[] subelementLciFields = this.getFieldData(buffer, SUBELEMENT_LCI_BIT_FIELD_LENGTHS);
        if (subelementLciFields == null) {
            return false;
        }
        this.mLatitudeUncertainty = this.decodeLciLatLngUncertainty(subelementLciFields[0]);
        this.mLatitude = this.decodeLciLatLng(subelementLciFields, SUBELEMENT_LCI_BIT_FIELD_LENGTHS, 1, 90.0);
        this.mLongitudeUncertainty = this.decodeLciLatLngUncertainty(subelementLciFields[2]);
        this.mLongitude = this.decodeLciLatLng(subelementLciFields, SUBELEMENT_LCI_BIT_FIELD_LENGTHS, 3, 180.0);
        this.mAltitudeType = (int)subelementLciFields[4] & 0xFF;
        this.mAltitudeUncertainty = this.decodeLciAltUncertainty(subelementLciFields[5]);
        this.mAltitude = Math.scalb(subelementLciFields[6], -8);
        this.mDatum = (int)subelementLciFields[7] & 0xFF;
        this.mLciRegisteredLocationAgreement = subelementLciFields[8] == 1L;
        this.mLciRegisteredLocationDse = subelementLciFields[9] == 1L;
        this.mLciDependentStation = subelementLciFields[10] == 1L;
        this.mLciVersion = (int)subelementLciFields[11];
        return true;
    }

    private double decodeLciLatLng(long[] fields, int[] bitFieldSizes, int offset, double limit) {
        double angle = (fields[offset] & (long)Math.pow(2.0, bitFieldSizes[offset] - 1)) != 0L ? Math.scalb((double)fields[offset] - Math.pow(2.0, bitFieldSizes[offset]), -25) : Math.scalb((double)fields[offset], -25);
        if (angle > limit) {
            angle = limit;
        } else if (angle < -limit) {
            angle = -limit;
        }
        return angle;
    }

    private double decodeLciLatLngUncertainty(long encodedValue) {
        return Math.pow(2.0, 8L - encodedValue);
    }

    private double decodeLciAltUncertainty(long encodedValue) {
        return Math.pow(2.0, 21L - encodedValue);
    }

    private boolean parseSubelementZ(byte[] buffer) {
        if (buffer.length != 6) {
            return false;
        }
        this.swapEndianByteByByte(buffer);
        long[] subelementZFields = this.getFieldData(buffer, SUBELEMENT_Z_BIT_FIELD_LENGTHS);
        if (subelementZFields == null) {
            return false;
        }
        this.mExpectedToMove = (int)subelementZFields[0] & 0xFF;
        this.mFloorNumber = this.decodeZUnsignedToSignedValue(subelementZFields, SUBELEMENT_Z_BIT_FIELD_LENGTHS, 1, 4);
        this.mHeightAboveFloorMeters = this.decodeZUnsignedToSignedValue(subelementZFields, SUBELEMENT_Z_BIT_FIELD_LENGTHS, 2, 12);
        long zHeightUncertainty = subelementZFields[3];
        if (zHeightUncertainty <= 0L || zHeightUncertainty >= 25L) {
            return false;
        }
        this.mHeightAboveFloorUncertaintyMeters = Math.pow(2.0, 12L - zHeightUncertainty - 1L);
        return true;
    }

    private double decodeZUnsignedToSignedValue(long[] fieldValues, int[] fieldLengths, int index, int fraction2) {
        int value = (int)fieldValues[index];
        int maxPositiveValue = (int)Math.pow(2.0, fieldLengths[index] - 1) - 1;
        if (value > maxPositiveValue) {
            value = (int)((double)value - Math.pow(2.0, fieldLengths[index]));
        }
        return Math.scalb(value, -fraction2);
    }

    private boolean parseSubelementUsage(byte[] buffer) {
        if (buffer.length != 1 && buffer.length != 3) {
            return false;
        }
        this.mUsageRetransmit = (buffer[0] & 1) != 0;
        this.mUsageRetentionExpires = (buffer[0] & 2) != 0;
        this.mUsageExtraInfoOnAssociation = (buffer[0] & 4) != 0;
        return this.mUsageRetransmit && !this.mUsageRetentionExpires;
    }

    private boolean parseSubelementBssidList(byte[] buffer) {
        if (buffer.length < 1) {
            return false;
        }
        if ((buffer.length - 1) % 6 != 0) {
            return false;
        }
        int maxBssidIndicator = buffer[0] & 0xFF;
        int bssidListLength = (buffer.length - 1) / 6;
        int bssidOffset = 1;
        for (int i = 0; i < bssidListLength; ++i) {
            byte[] bssid = Arrays.copyOfRange(buffer, bssidOffset, bssidOffset + 6);
            MacAddress macAddress = MacAddress.fromBytes(bssid);
            this.mBssidList.add(macAddress);
            bssidOffset += 6;
        }
        return true;
    }

    private boolean parseSubelementLocationCivic(byte[] buffer) {
        if (buffer.length < 2 || buffer.length > 256) {
            return false;
        }
        this.mCivicLocationCountryCode = new String(Arrays.copyOfRange(buffer, 0, 2)).toUpperCase();
        CivicLocation civicLocation = new CivicLocation(Arrays.copyOfRange(buffer, 2, buffer.length), this.mCivicLocationCountryCode);
        if (!civicLocation.isValid()) {
            return false;
        }
        this.mCivicLocation = civicLocation;
        this.mCivicLocationString = civicLocation.toString();
        return true;
    }

    private boolean parseSubelementMapImage(byte[] buffer) {
        if (buffer.length > 256) {
            return false;
        }
        int mapImageType = buffer[0];
        int supportedTypesMax = SUPPORTED_IMAGE_FILE_EXTENSIONS.length - 1;
        if (mapImageType < 0 || mapImageType > supportedTypesMax) {
            return false;
        }
        this.mMapImageType = mapImageType;
        byte[] urlBytes = Arrays.copyOfRange(buffer, 1, buffer.length);
        this.mMapImageUri = Uri.parse(new String(urlBytes, StandardCharsets.UTF_8));
        return true;
    }

    private String imageTypeToMime(int imageTypeCode, String imageUrl) {
        int supportedExtensionsMax = SUPPORTED_IMAGE_FILE_EXTENSIONS.length - 1;
        if (imageTypeCode == 0 && imageUrl == null || imageTypeCode > supportedExtensionsMax) {
            return null;
        }
        MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
        if (imageTypeCode == 0) {
            return mimeTypeMap.getMimeTypeFromExtension(MimeTypeMap.getFileExtensionFromUrl(imageUrl));
        }
        return mimeTypeMap.getMimeTypeFromExtension(SUPPORTED_IMAGE_FILE_EXTENSIONS[imageTypeCode]);
    }

    private long[] getFieldData(byte[] buffer, int[] bitFieldSizes) {
        int bufferLengthBits = buffer.length * 8;
        int sumBitFieldSizes = 0;
        for (int i : bitFieldSizes) {
            if (i > 64) {
                return null;
            }
            sumBitFieldSizes += i;
        }
        if (bufferLengthBits != sumBitFieldSizes) {
            return null;
        }
        long[] fieldData = new long[bitFieldSizes.length];
        int bufferBitPos = 0;
        for (int fieldIndex = 0; fieldIndex < bitFieldSizes.length; ++fieldIndex) {
            int bitFieldSize = bitFieldSizes[fieldIndex];
            long field = 0L;
            for (int n = 0; n < bitFieldSize; ++n) {
                field |= (long)this.getBitAtBitOffsetInByteArray(buffer, bufferBitPos + n) << n;
            }
            fieldData[fieldIndex] = field;
            bufferBitPos += bitFieldSize;
        }
        return fieldData;
    }

    private int getBitAtBitOffsetInByteArray(byte[] buffer, int bufferBitOffset) {
        int bufferIndex = bufferBitOffset / 8;
        int bitOffsetInByte = bufferBitOffset % 8;
        int result = (buffer[bufferIndex] & 128 >> bitOffsetInByte) == 0 ? 0 : 1;
        return result;
    }

    private void swapEndianByteByByte(byte[] buffer) {
        for (int n = 0; n < buffer.length; ++n) {
            byte currentByte = buffer[n];
            int reversedByte = 0;
            byte bitSelectorMask = 1;
            for (int i = 0; i < 8; ++i) {
                reversedByte = (byte)(reversedByte << 1);
                if ((currentByte & bitSelectorMask) != 0) {
                    reversedByte = (byte)(reversedByte | 1);
                }
                bitSelectorMask = (byte)(bitSelectorMask << 1);
            }
            buffer[n] = reversedByte;
        }
    }

    private void setLciSubelementDefaults() {
        this.mIsLciValid = false;
        this.mLatitudeUncertainty = 0.0;
        this.mLatitude = 0.0;
        this.mLongitudeUncertainty = 0.0;
        this.mLongitude = 0.0;
        this.mAltitudeType = 0;
        this.mAltitudeUncertainty = 0.0;
        this.mAltitude = 0.0;
        this.mDatum = 0;
        this.mLciRegisteredLocationAgreement = false;
        this.mLciRegisteredLocationDse = false;
        this.mLciDependentStation = false;
        this.mLciVersion = 0;
    }

    private void setZaxisSubelementDefaults() {
        this.mIsZValid = false;
        this.mExpectedToMove = 0;
        this.mFloorNumber = 0.0;
        this.mHeightAboveFloorMeters = 0.0;
        this.mHeightAboveFloorUncertaintyMeters = 0.0;
    }

    private void setUsageSubelementDefaults() {
        this.mUsageRetransmit = true;
        this.mUsageRetentionExpires = false;
        this.mUsageExtraInfoOnAssociation = false;
    }

    private void setBssidListSubelementDefaults() {
        this.mIsBssidListValid = false;
        this.mBssidList = new ArrayList();
    }

    public void setCivicLocationSubelementDefaults() {
        this.mIsLocationCivicValid = false;
        this.mCivicLocationCountryCode = "";
        this.mCivicLocationString = "";
        this.mCivicLocation = null;
    }

    private void setMapImageSubelementDefaults() {
        this.mIsMapImageValid = false;
        this.mMapImageType = 0;
        this.mMapImageUri = null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ResponderLocation other = (ResponderLocation)obj;
        return this.mIsValid == other.mIsValid && this.mIsLciValid == other.mIsLciValid && this.mIsZValid == other.mIsZValid && this.mIsUsageValid == other.mIsUsageValid && this.mIsBssidListValid == other.mIsBssidListValid && this.mIsLocationCivicValid == other.mIsLocationCivicValid && this.mIsMapImageValid == other.mIsMapImageValid && this.mLatitudeUncertainty == other.mLatitudeUncertainty && this.mLatitude == other.mLatitude && this.mLongitudeUncertainty == other.mLongitudeUncertainty && this.mLongitude == other.mLongitude && this.mAltitudeType == other.mAltitudeType && this.mAltitudeUncertainty == other.mAltitudeUncertainty && this.mAltitude == other.mAltitude && this.mDatum == other.mDatum && this.mLciRegisteredLocationAgreement == other.mLciRegisteredLocationAgreement && this.mLciRegisteredLocationDse == other.mLciRegisteredLocationDse && this.mLciDependentStation == other.mLciDependentStation && this.mLciVersion == other.mLciVersion && this.mExpectedToMove == other.mExpectedToMove && this.mFloorNumber == other.mFloorNumber && this.mHeightAboveFloorMeters == other.mHeightAboveFloorMeters && this.mHeightAboveFloorUncertaintyMeters == other.mHeightAboveFloorUncertaintyMeters && this.mUsageRetransmit == other.mUsageRetransmit && this.mUsageRetentionExpires == other.mUsageRetentionExpires && this.mUsageExtraInfoOnAssociation == other.mUsageExtraInfoOnAssociation && this.mBssidList.equals(other.mBssidList) && this.mCivicLocationCountryCode.equals(other.mCivicLocationCountryCode) && this.mCivicLocationString.equals(other.mCivicLocationString) && Objects.equals(this.mCivicLocation, other.mCivicLocation) && this.mMapImageType == other.mMapImageType && Objects.equals(this.mMapImageUri, other.mMapImageUri);
    }

    public int hashCode() {
        return Objects.hash(this.mIsValid, this.mIsLciValid, this.mIsZValid, this.mIsUsageValid, this.mIsBssidListValid, this.mIsLocationCivicValid, this.mIsMapImageValid, this.mLatitudeUncertainty, this.mLatitude, this.mLongitudeUncertainty, this.mLongitude, this.mAltitudeType, this.mAltitudeUncertainty, this.mAltitude, this.mDatum, this.mLciRegisteredLocationAgreement, this.mLciRegisteredLocationDse, this.mLciDependentStation, this.mLciVersion, this.mExpectedToMove, this.mFloorNumber, this.mHeightAboveFloorMeters, this.mHeightAboveFloorUncertaintyMeters, this.mUsageRetransmit, this.mUsageRetentionExpires, this.mUsageExtraInfoOnAssociation, this.mBssidList, this.mCivicLocationCountryCode, this.mCivicLocationString, this.mCivicLocation, this.mMapImageType, this.mMapImageUri);
    }

    public boolean isValid() {
        return this.mIsValid;
    }

    public boolean isLciSubelementValid() {
        return this.mIsLciValid;
    }

    public double getLatitudeUncertainty() {
        if (!this.mIsLciValid) {
            throw new IllegalStateException("getLatitudeUncertainty(): invoked on an invalid result: mIsLciValid = false.");
        }
        return this.mLatitudeUncertainty;
    }

    public double getLatitude() {
        if (!this.mIsLciValid) {
            throw new IllegalStateException("getLatitude(): invoked on an invalid result: mIsLciValid = false.");
        }
        return this.mLatitude;
    }

    public double getLongitudeUncertainty() {
        if (!this.mIsLciValid) {
            throw new IllegalStateException("getLongitudeUncertainty(): invoked on an invalid result: mIsLciValid = false.");
        }
        return this.mLongitudeUncertainty;
    }

    public double getLongitude() {
        if (!this.mIsLciValid) {
            throw new IllegalStateException("getLatitudeUncertainty(): invoked on an invalid result: mIsLciValid = false.");
        }
        return this.mLongitude;
    }

    public int getAltitudeType() {
        if (!this.mIsLciValid) {
            throw new IllegalStateException("getLatitudeUncertainty(): invoked on an invalid result: mIsLciValid = false.");
        }
        return this.mAltitudeType;
    }

    public double getAltitudeUncertainty() {
        if (!this.mIsLciValid) {
            throw new IllegalStateException("getLatitudeUncertainty(): invoked on an invalid result: mIsLciValid = false.");
        }
        return this.mAltitudeUncertainty;
    }

    public double getAltitude() {
        if (!this.mIsLciValid) {
            throw new IllegalStateException("getAltitude(): invoked on an invalid result: mIsLciValid = false.");
        }
        return this.mAltitude;
    }

    public int getDatum() {
        if (!this.mIsLciValid) {
            throw new IllegalStateException("getDatum(): invoked on an invalid result: mIsLciValid = false.");
        }
        return this.mDatum;
    }

    public boolean getRegisteredLocationAgreementIndication() {
        if (!this.mIsLciValid) {
            throw new IllegalStateException("getRegisteredLocationAgreementIndication(): invoked on an invalid result: mIsLciValid = false.");
        }
        return this.mLciRegisteredLocationAgreement;
    }

    public boolean getRegisteredLocationDseIndication() {
        if (!this.mIsLciValid) {
            throw new IllegalStateException("getRegisteredLocationDseIndication(): invoked on an invalid result: mIsLciValid = false.");
        }
        return this.mLciRegisteredLocationDse;
    }

    public boolean getDependentStationIndication() {
        if (!this.mIsLciValid) {
            throw new IllegalStateException("getDependentStationIndication(): invoked on an invalid result: mIsLciValid = false.");
        }
        return this.mLciDependentStation;
    }

    public int getLciVersion() {
        if (!this.mIsLciValid) {
            throw new IllegalStateException("getLciVersion(): invoked on an invalid result: mIsLciValid = false.");
        }
        return this.mLciVersion;
    }

    public Location toLocation() {
        if (!this.mIsLciValid) {
            throw new IllegalStateException("toLocation(): invoked on an invalid result: mIsLciValid = false.");
        }
        Location location = new Location(LOCATION_PROVIDER);
        location.setLatitude(this.mLatitude);
        location.setLongitude(this.mLongitude);
        location.setAccuracy((float)(this.mLatitudeUncertainty + this.mLongitudeUncertainty) / 2.0f);
        location.setAltitude(this.mAltitude);
        location.setVerticalAccuracyMeters((float)this.mAltitudeUncertainty);
        location.setTime(System_Delegate.currentTimeMillis());
        return location;
    }

    public boolean isZaxisSubelementValid() {
        return this.mIsZValid;
    }

    public int getExpectedToMove() {
        if (!this.mIsZValid) {
            throw new IllegalStateException("getExpectedToMove(): invoked on an invalid result: mIsZValid = false.");
        }
        return this.mExpectedToMove;
    }

    public double getFloorNumber() {
        if (!this.mIsZValid) {
            throw new IllegalStateException("getFloorNumber(): invoked on an invalid result: mIsZValid = false)");
        }
        return this.mFloorNumber;
    }

    public double getHeightAboveFloorMeters() {
        if (!this.mIsZValid) {
            throw new IllegalStateException("getHeightAboveFloorMeters(): invoked on an invalid result: mIsZValid = false)");
        }
        return this.mHeightAboveFloorMeters;
    }

    public double getHeightAboveFloorUncertaintyMeters() {
        if (!this.mIsZValid) {
            throw new IllegalStateException("getHeightAboveFloorUncertaintyMeters():invoked on an invalid result: mIsZValid = false)");
        }
        return this.mHeightAboveFloorUncertaintyMeters;
    }

    public boolean getRetransmitPolicyIndication() {
        return this.mUsageRetransmit;
    }

    public boolean getRetentionExpiresIndication() {
        return this.mUsageRetentionExpires;
    }

    @SystemApi
    public boolean getExtraInfoOnAssociationIndication() {
        return this.mUsageExtraInfoOnAssociation;
    }

    public List<MacAddress> getColocatedBssids() {
        return Collections.unmodifiableList(this.mBssidList);
    }

    public Address toCivicLocationAddress() {
        if (this.mCivicLocation != null && this.mCivicLocation.isValid()) {
            return this.mCivicLocation.toAddress();
        }
        return null;
    }

    @SuppressLint(value={"ChangedType"})
    public SparseArray<String> toCivicLocationSparseArray() {
        if (this.mCivicLocation != null && this.mCivicLocation.isValid()) {
            return this.mCivicLocation.toSparseArray();
        }
        return null;
    }

    public String getCivicLocationCountryCode() {
        return this.mCivicLocationCountryCode;
    }

    public String getCivicLocationElementValue(int key) {
        return this.mCivicLocation.getCivicElementValue(key);
    }

    public String getMapImageMimeType() {
        if (this.mMapImageUri == null) {
            return null;
        }
        return this.imageTypeToMime(this.mMapImageType, this.mMapImageUri.toString());
    }

    public Uri getMapImageUri() {
        return this.mMapImageUri;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ExpectedToMoveType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DatumType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AltitudeType {
    }
}

