/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.sharedconnectivity.app;

import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class SharedConnectivitySettingsState
implements Parcelable {
    private final boolean mInstantTetherEnabled;
    private final PendingIntent mInstantTetherSettingsPendingIntent;
    private final Bundle mExtras;
    public static final Parcelable.Creator<SharedConnectivitySettingsState> CREATOR = new Parcelable.Creator<SharedConnectivitySettingsState>(){

        @Override
        public SharedConnectivitySettingsState createFromParcel(Parcel in) {
            return SharedConnectivitySettingsState.readFromParcel(in);
        }

        public SharedConnectivitySettingsState[] newArray(int size) {
            return new SharedConnectivitySettingsState[size];
        }
    };

    private static void validate(PendingIntent pendingIntent) {
        if (pendingIntent != null && !pendingIntent.isImmutable()) {
            throw new IllegalArgumentException("Pending intent must be immutable");
        }
    }

    private SharedConnectivitySettingsState(boolean instantTetherEnabled, PendingIntent pendingIntent, Bundle extras) {
        SharedConnectivitySettingsState.validate(pendingIntent);
        this.mInstantTetherEnabled = instantTetherEnabled;
        this.mInstantTetherSettingsPendingIntent = pendingIntent;
        this.mExtras = extras;
    }

    public boolean isInstantTetherEnabled() {
        return this.mInstantTetherEnabled;
    }

    public PendingIntent getInstantTetherSettingsPendingIntent() {
        return this.mInstantTetherSettingsPendingIntent;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SharedConnectivitySettingsState)) {
            return false;
        }
        SharedConnectivitySettingsState other = (SharedConnectivitySettingsState)obj;
        return this.mInstantTetherEnabled == other.isInstantTetherEnabled() && Objects.equals(this.mInstantTetherSettingsPendingIntent, other.getInstantTetherSettingsPendingIntent());
    }

    public int hashCode() {
        return Objects.hash(this.mInstantTetherEnabled, this.mInstantTetherSettingsPendingIntent);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        PendingIntent.writePendingIntentOrNullToParcel(this.mInstantTetherSettingsPendingIntent, dest);
        dest.writeBoolean(this.mInstantTetherEnabled);
        dest.writeBundle(this.mExtras);
    }

    public static SharedConnectivitySettingsState readFromParcel(Parcel in) {
        PendingIntent pendingIntent = PendingIntent.readPendingIntentOrNullFromParcel(in);
        boolean instantTetherEnabled = in.readBoolean();
        Bundle extras = in.readBundle();
        return new SharedConnectivitySettingsState(instantTetherEnabled, pendingIntent, extras);
    }

    public String toString() {
        return "SharedConnectivitySettingsState[" + "instantTetherEnabled=" + this.mInstantTetherEnabled + "PendingIntent=" + this.mInstantTetherSettingsPendingIntent.toString() + "extras=" + this.mExtras.toString() + "]";
    }

    public static class Builder {
        private boolean mInstantTetherEnabled;
        private PendingIntent mInstantTetherSettingsPendingIntent;
        private Bundle mExtras = Bundle.EMPTY;

        public Builder setInstantTetherEnabled(boolean instantTetherEnabled) {
            this.mInstantTetherEnabled = instantTetherEnabled;
            return this;
        }

        public Builder setInstantTetherSettingsPendingIntent(PendingIntent pendingIntent) {
            this.mInstantTetherSettingsPendingIntent = pendingIntent;
            return this;
        }

        public Builder setExtras(Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        public SharedConnectivitySettingsState build() {
            return new SharedConnectivitySettingsState(this.mInstantTetherEnabled, this.mInstantTetherSettingsPendingIntent, this.mExtras);
        }
    }
}

