/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.sharedconnectivity.service;

import android.net.wifi.sharedconnectivity.app.HotspotNetwork;
import android.net.wifi.sharedconnectivity.app.HotspotNetworkConnectionStatus;
import android.net.wifi.sharedconnectivity.app.KnownNetwork;
import android.net.wifi.sharedconnectivity.app.KnownNetworkConnectionStatus;
import android.net.wifi.sharedconnectivity.app.SharedConnectivitySettingsState;
import android.net.wifi.sharedconnectivity.service.ISharedConnectivityCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface ISharedConnectivityService
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.sharedconnectivity.service.ISharedConnectivityService";

    public void registerCallback(ISharedConnectivityCallback var1) throws RemoteException;

    public void unregisterCallback(ISharedConnectivityCallback var1) throws RemoteException;

    public void connectHotspotNetwork(HotspotNetwork var1) throws RemoteException;

    public void disconnectHotspotNetwork(HotspotNetwork var1) throws RemoteException;

    public void connectKnownNetwork(KnownNetwork var1) throws RemoteException;

    public void forgetKnownNetwork(KnownNetwork var1) throws RemoteException;

    public List<HotspotNetwork> getHotspotNetworks() throws RemoteException;

    public List<KnownNetwork> getKnownNetworks() throws RemoteException;

    public SharedConnectivitySettingsState getSettingsState() throws RemoteException;

    public HotspotNetworkConnectionStatus getHotspotNetworkConnectionStatus() throws RemoteException;

    public KnownNetworkConnectionStatus getKnownNetworkConnectionStatus() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISharedConnectivityService {
        static final int TRANSACTION_registerCallback = 1;
        static final int TRANSACTION_unregisterCallback = 2;
        static final int TRANSACTION_connectHotspotNetwork = 3;
        static final int TRANSACTION_disconnectHotspotNetwork = 4;
        static final int TRANSACTION_connectKnownNetwork = 5;
        static final int TRANSACTION_forgetKnownNetwork = 6;
        static final int TRANSACTION_getHotspotNetworks = 7;
        static final int TRANSACTION_getKnownNetworks = 8;
        static final int TRANSACTION_getSettingsState = 9;
        static final int TRANSACTION_getHotspotNetworkConnectionStatus = 10;
        static final int TRANSACTION_getKnownNetworkConnectionStatus = 11;

        public Stub() {
            this.attachInterface(this, ISharedConnectivityService.DESCRIPTOR);
        }

        public static ISharedConnectivityService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISharedConnectivityService.DESCRIPTOR);
            if (iin != null && iin instanceof ISharedConnectivityService) {
                return (ISharedConnectivityService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "registerCallback";
                }
                case 2: {
                    return "unregisterCallback";
                }
                case 3: {
                    return "connectHotspotNetwork";
                }
                case 4: {
                    return "disconnectHotspotNetwork";
                }
                case 5: {
                    return "connectKnownNetwork";
                }
                case 6: {
                    return "forgetKnownNetwork";
                }
                case 7: {
                    return "getHotspotNetworks";
                }
                case 8: {
                    return "getKnownNetworks";
                }
                case 9: {
                    return "getSettingsState";
                }
                case 10: {
                    return "getHotspotNetworkConnectionStatus";
                }
                case 11: {
                    return "getKnownNetworkConnectionStatus";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISharedConnectivityService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    ISharedConnectivityCallback _arg0 = ISharedConnectivityCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    ISharedConnectivityCallback _arg0 = ISharedConnectivityCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    HotspotNetwork _arg0 = data.readTypedObject(HotspotNetwork.CREATOR);
                    data.enforceNoDataAvail();
                    this.connectHotspotNetwork(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    HotspotNetwork _arg0 = data.readTypedObject(HotspotNetwork.CREATOR);
                    data.enforceNoDataAvail();
                    this.disconnectHotspotNetwork(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    KnownNetwork _arg0 = data.readTypedObject(KnownNetwork.CREATOR);
                    data.enforceNoDataAvail();
                    this.connectKnownNetwork(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    KnownNetwork _arg0 = data.readTypedObject(KnownNetwork.CREATOR);
                    data.enforceNoDataAvail();
                    this.forgetKnownNetwork(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    List<HotspotNetwork> _result = this.getHotspotNetworks();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 8: {
                    List<KnownNetwork> _result = this.getKnownNetworks();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 9: {
                    SharedConnectivitySettingsState _result = this.getSettingsState();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 10: {
                    HotspotNetworkConnectionStatus _result = this.getHotspotNetworkConnectionStatus();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 11: {
                    KnownNetworkConnectionStatus _result = this.getKnownNetworkConnectionStatus();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 10;
        }

        private static class Proxy
        implements ISharedConnectivityService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISharedConnectivityService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCallback(ISharedConnectivityCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISharedConnectivityService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCallback(ISharedConnectivityCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISharedConnectivityService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connectHotspotNetwork(HotspotNetwork network) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISharedConnectivityService.DESCRIPTOR);
                    _data.writeTypedObject(network, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disconnectHotspotNetwork(HotspotNetwork network) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISharedConnectivityService.DESCRIPTOR);
                    _data.writeTypedObject(network, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connectKnownNetwork(KnownNetwork network) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISharedConnectivityService.DESCRIPTOR);
                    _data.writeTypedObject(network, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forgetKnownNetwork(KnownNetwork network) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISharedConnectivityService.DESCRIPTOR);
                    _data.writeTypedObject(network, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<HotspotNetwork> getHotspotNetworks() throws RemoteException {
                ArrayList<HotspotNetwork> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISharedConnectivityService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(HotspotNetwork.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<KnownNetwork> getKnownNetworks() throws RemoteException {
                ArrayList<KnownNetwork> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISharedConnectivityService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(KnownNetwork.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SharedConnectivitySettingsState getSettingsState() throws RemoteException {
                SharedConnectivitySettingsState _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISharedConnectivityService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SharedConnectivitySettingsState.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public HotspotNetworkConnectionStatus getHotspotNetworkConnectionStatus() throws RemoteException {
                HotspotNetworkConnectionStatus _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISharedConnectivityService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(HotspotNetworkConnectionStatus.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KnownNetworkConnectionStatus getKnownNetworkConnectionStatus() throws RemoteException {
                KnownNetworkConnectionStatus _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISharedConnectivityService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(KnownNetworkConnectionStatus.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ISharedConnectivityService {
        @Override
        public void registerCallback(ISharedConnectivityCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterCallback(ISharedConnectivityCallback callback) throws RemoteException {
        }

        @Override
        public void connectHotspotNetwork(HotspotNetwork network) throws RemoteException {
        }

        @Override
        public void disconnectHotspotNetwork(HotspotNetwork network) throws RemoteException {
        }

        @Override
        public void connectKnownNetwork(KnownNetwork network) throws RemoteException {
        }

        @Override
        public void forgetKnownNetwork(KnownNetwork network) throws RemoteException {
        }

        @Override
        public List<HotspotNetwork> getHotspotNetworks() throws RemoteException {
            return null;
        }

        @Override
        public List<KnownNetwork> getKnownNetworks() throws RemoteException {
            return null;
        }

        @Override
        public SharedConnectivitySettingsState getSettingsState() throws RemoteException {
            return null;
        }

        @Override
        public HotspotNetworkConnectionStatus getHotspotNetworkConnectionStatus() throws RemoteException {
            return null;
        }

        @Override
        public KnownNetworkConnectionStatus getKnownNetworkConnectionStatus() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

