/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.annotation.RequiresPermission;
import android.app.PendingIntent;
import android.content.IntentFilter;
import android.nfc.IAppCallback;
import android.nfc.INfcAdapterExtras;
import android.nfc.INfcCardEmulation;
import android.nfc.INfcControllerAlwaysOnListener;
import android.nfc.INfcDta;
import android.nfc.INfcFCardEmulation;
import android.nfc.INfcTag;
import android.nfc.INfcUnlockHandler;
import android.nfc.ITagRemovedCallback;
import android.nfc.NfcAntennaInfo;
import android.nfc.Tag;
import android.nfc.TechListParcel;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.HashMap;
import java.util.Map;

public interface INfcAdapter
extends IInterface {
    public INfcTag getNfcTagInterface() throws RemoteException;

    public INfcCardEmulation getNfcCardEmulationInterface() throws RemoteException;

    public INfcFCardEmulation getNfcFCardEmulationInterface() throws RemoteException;

    public INfcAdapterExtras getNfcAdapterExtrasInterface(String var1) throws RemoteException;

    public INfcDta getNfcDtaInterface(String var1) throws RemoteException;

    public int getState() throws RemoteException;

    public boolean disable(boolean var1) throws RemoteException;

    public boolean enable() throws RemoteException;

    public void pausePolling(int var1) throws RemoteException;

    public void resumePolling() throws RemoteException;

    public void setForegroundDispatch(PendingIntent var1, IntentFilter[] var2, TechListParcel var3) throws RemoteException;

    public void setAppCallback(IAppCallback var1) throws RemoteException;

    public boolean ignore(int var1, int var2, ITagRemovedCallback var3) throws RemoteException;

    public void dispatch(Tag var1) throws RemoteException;

    public void setReaderMode(IBinder var1, IAppCallback var2, int var3, Bundle var4) throws RemoteException;

    public void addNfcUnlockHandler(INfcUnlockHandler var1, int[] var2) throws RemoteException;

    public void removeNfcUnlockHandler(INfcUnlockHandler var1) throws RemoteException;

    public void verifyNfcPermission() throws RemoteException;

    public boolean isNfcSecureEnabled() throws RemoteException;

    public boolean deviceSupportsNfcSecure() throws RemoteException;

    public boolean setNfcSecure(boolean var1) throws RemoteException;

    public NfcAntennaInfo getNfcAntennaInfo() throws RemoteException;

    public boolean setControllerAlwaysOn(boolean var1) throws RemoteException;

    public boolean isControllerAlwaysOn() throws RemoteException;

    public boolean isControllerAlwaysOnSupported() throws RemoteException;

    public void registerControllerAlwaysOnListener(INfcControllerAlwaysOnListener var1) throws RemoteException;

    public void unregisterControllerAlwaysOnListener(INfcControllerAlwaysOnListener var1) throws RemoteException;

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean isTagIntentAppPreferenceSupported() throws RemoteException;

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public Map getTagIntentAppPreferenceForUser(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public int setTagIntentAppPreferenceForUser(int var1, String var2, boolean var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INfcAdapter {
        public static final String DESCRIPTOR = "android.nfc.INfcAdapter";
        static final int TRANSACTION_getNfcTagInterface = 1;
        static final int TRANSACTION_getNfcCardEmulationInterface = 2;
        static final int TRANSACTION_getNfcFCardEmulationInterface = 3;
        static final int TRANSACTION_getNfcAdapterExtrasInterface = 4;
        static final int TRANSACTION_getNfcDtaInterface = 5;
        static final int TRANSACTION_getState = 6;
        static final int TRANSACTION_disable = 7;
        static final int TRANSACTION_enable = 8;
        static final int TRANSACTION_pausePolling = 9;
        static final int TRANSACTION_resumePolling = 10;
        static final int TRANSACTION_setForegroundDispatch = 11;
        static final int TRANSACTION_setAppCallback = 12;
        static final int TRANSACTION_ignore = 13;
        static final int TRANSACTION_dispatch = 14;
        static final int TRANSACTION_setReaderMode = 15;
        static final int TRANSACTION_addNfcUnlockHandler = 16;
        static final int TRANSACTION_removeNfcUnlockHandler = 17;
        static final int TRANSACTION_verifyNfcPermission = 18;
        static final int TRANSACTION_isNfcSecureEnabled = 19;
        static final int TRANSACTION_deviceSupportsNfcSecure = 20;
        static final int TRANSACTION_setNfcSecure = 21;
        static final int TRANSACTION_getNfcAntennaInfo = 22;
        static final int TRANSACTION_setControllerAlwaysOn = 23;
        static final int TRANSACTION_isControllerAlwaysOn = 24;
        static final int TRANSACTION_isControllerAlwaysOnSupported = 25;
        static final int TRANSACTION_registerControllerAlwaysOnListener = 26;
        static final int TRANSACTION_unregisterControllerAlwaysOnListener = 27;
        static final int TRANSACTION_isTagIntentAppPreferenceSupported = 28;
        static final int TRANSACTION_getTagIntentAppPreferenceForUser = 29;
        static final int TRANSACTION_setTagIntentAppPreferenceForUser = 30;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static INfcAdapter asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof INfcAdapter) {
                return (INfcAdapter)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getNfcTagInterface";
                }
                case 2: {
                    return "getNfcCardEmulationInterface";
                }
                case 3: {
                    return "getNfcFCardEmulationInterface";
                }
                case 4: {
                    return "getNfcAdapterExtrasInterface";
                }
                case 5: {
                    return "getNfcDtaInterface";
                }
                case 6: {
                    return "getState";
                }
                case 7: {
                    return "disable";
                }
                case 8: {
                    return "enable";
                }
                case 9: {
                    return "pausePolling";
                }
                case 10: {
                    return "resumePolling";
                }
                case 11: {
                    return "setForegroundDispatch";
                }
                case 12: {
                    return "setAppCallback";
                }
                case 13: {
                    return "ignore";
                }
                case 14: {
                    return "dispatch";
                }
                case 15: {
                    return "setReaderMode";
                }
                case 16: {
                    return "addNfcUnlockHandler";
                }
                case 17: {
                    return "removeNfcUnlockHandler";
                }
                case 18: {
                    return "verifyNfcPermission";
                }
                case 19: {
                    return "isNfcSecureEnabled";
                }
                case 20: {
                    return "deviceSupportsNfcSecure";
                }
                case 21: {
                    return "setNfcSecure";
                }
                case 22: {
                    return "getNfcAntennaInfo";
                }
                case 23: {
                    return "setControllerAlwaysOn";
                }
                case 24: {
                    return "isControllerAlwaysOn";
                }
                case 25: {
                    return "isControllerAlwaysOnSupported";
                }
                case 26: {
                    return "registerControllerAlwaysOnListener";
                }
                case 27: {
                    return "unregisterControllerAlwaysOnListener";
                }
                case 28: {
                    return "isTagIntentAppPreferenceSupported";
                }
                case 29: {
                    return "getTagIntentAppPreferenceForUser";
                }
                case 30: {
                    return "setTagIntentAppPreferenceForUser";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    INfcTag _result = this.getNfcTagInterface();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 2: {
                    INfcCardEmulation _result = this.getNfcCardEmulationInterface();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 3: {
                    INfcFCardEmulation _result = this.getNfcFCardEmulationInterface();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    INfcAdapterExtras _result = this.getNfcAdapterExtrasInterface(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    INfcDta _result = this.getNfcDtaInterface(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 6: {
                    int _result = this.getState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 7: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.disable(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    boolean _result = this.enable();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.pausePolling(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    this.resumePolling();
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    PendingIntent _arg0 = data.readTypedObject(PendingIntent.CREATOR);
                    IntentFilter[] _arg1 = data.createTypedArray(IntentFilter.CREATOR);
                    TechListParcel _arg2 = data.readTypedObject(TechListParcel.CREATOR);
                    data.enforceNoDataAvail();
                    this.setForegroundDispatch(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    IAppCallback _arg0 = IAppCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setAppCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    ITagRemovedCallback _arg2 = ITagRemovedCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.ignore(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 14: {
                    Tag _arg0 = data.readTypedObject(Tag.CREATOR);
                    data.enforceNoDataAvail();
                    this.dispatch(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    IBinder _arg0 = data.readStrongBinder();
                    IAppCallback _arg1 = IAppCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    Bundle _arg3 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.setReaderMode(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    INfcUnlockHandler _arg0 = INfcUnlockHandler.Stub.asInterface(data.readStrongBinder());
                    int[] _arg1 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.addNfcUnlockHandler(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    INfcUnlockHandler _arg0 = INfcUnlockHandler.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeNfcUnlockHandler(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    this.verifyNfcPermission();
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    boolean _result = this.isNfcSecureEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 20: {
                    boolean _result = this.deviceSupportsNfcSecure();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 21: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.setNfcSecure(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 22: {
                    NfcAntennaInfo _result = this.getNfcAntennaInfo();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 23: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.setControllerAlwaysOn(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 24: {
                    boolean _result = this.isControllerAlwaysOn();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 25: {
                    boolean _result = this.isControllerAlwaysOnSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 26: {
                    INfcControllerAlwaysOnListener _arg0 = INfcControllerAlwaysOnListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerControllerAlwaysOnListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    INfcControllerAlwaysOnListener _arg0 = INfcControllerAlwaysOnListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterControllerAlwaysOnListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    boolean _result = this.isTagIntentAppPreferenceSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 29: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    Map _result = this.getTagIntentAppPreferenceForUser(_arg0);
                    reply.writeNoException();
                    reply.writeMap(_result);
                    break;
                }
                case 30: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    int _result = this.setTagIntentAppPreferenceForUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 29;
        }

        private static class Proxy
        implements INfcAdapter {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public INfcTag getNfcTagInterface() throws RemoteException {
                INfcTag _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = INfcTag.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public INfcCardEmulation getNfcCardEmulationInterface() throws RemoteException {
                INfcCardEmulation _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = INfcCardEmulation.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public INfcFCardEmulation getNfcFCardEmulationInterface() throws RemoteException {
                INfcFCardEmulation _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = INfcFCardEmulation.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public INfcAdapterExtras getNfcAdapterExtrasInterface(String pkg) throws RemoteException {
                INfcAdapterExtras _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = INfcAdapterExtras.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public INfcDta getNfcDtaInterface(String pkg) throws RemoteException {
                INfcDta _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = INfcDta.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean disable(boolean saveState) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(saveState);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void pausePolling(int timeoutInMs) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(timeoutInMs);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resumePolling() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setForegroundDispatch(PendingIntent intent, IntentFilter[] filters, TechListParcel techLists) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(intent, 0);
                    _data.writeTypedArray(filters, 0);
                    _data.writeTypedObject(techLists, 0);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAppCallback(IAppCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean ignore(int nativeHandle, int debounceMs, ITagRemovedCallback callback) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(nativeHandle);
                    _data.writeInt(debounceMs);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatch(Tag tag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(tag, 0);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setReaderMode(IBinder b, IAppCallback callback, int flags, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(b);
                    _data.writeStrongInterface(callback);
                    _data.writeInt(flags);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addNfcUnlockHandler(INfcUnlockHandler unlockHandler, int[] techList) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(unlockHandler);
                    _data.writeIntArray(techList);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeNfcUnlockHandler(INfcUnlockHandler unlockHandler) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(unlockHandler);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void verifyNfcPermission() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isNfcSecureEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean deviceSupportsNfcSecure() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setNfcSecure(boolean enable) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NfcAntennaInfo getNfcAntennaInfo() throws RemoteException {
                NfcAntennaInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(NfcAntennaInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setControllerAlwaysOn(boolean value) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(value);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isControllerAlwaysOn() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isControllerAlwaysOnSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerControllerAlwaysOnListener(INfcControllerAlwaysOnListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterControllerAlwaysOnListener(INfcControllerAlwaysOnListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTagIntentAppPreferenceSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getTagIntentAppPreferenceForUser(int userId) throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setTagIntentAppPreferenceForUser(int userId, String pkg, boolean allow) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(pkg);
                    _data.writeBoolean(allow);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements INfcAdapter {
        @Override
        public INfcTag getNfcTagInterface() throws RemoteException {
            return null;
        }

        @Override
        public INfcCardEmulation getNfcCardEmulationInterface() throws RemoteException {
            return null;
        }

        @Override
        public INfcFCardEmulation getNfcFCardEmulationInterface() throws RemoteException {
            return null;
        }

        @Override
        public INfcAdapterExtras getNfcAdapterExtrasInterface(String pkg) throws RemoteException {
            return null;
        }

        @Override
        public INfcDta getNfcDtaInterface(String pkg) throws RemoteException {
            return null;
        }

        @Override
        public int getState() throws RemoteException {
            return 0;
        }

        @Override
        public boolean disable(boolean saveState) throws RemoteException {
            return false;
        }

        @Override
        public boolean enable() throws RemoteException {
            return false;
        }

        @Override
        public void pausePolling(int timeoutInMs) throws RemoteException {
        }

        @Override
        public void resumePolling() throws RemoteException {
        }

        @Override
        public void setForegroundDispatch(PendingIntent intent, IntentFilter[] filters, TechListParcel techLists) throws RemoteException {
        }

        @Override
        public void setAppCallback(IAppCallback callback) throws RemoteException {
        }

        @Override
        public boolean ignore(int nativeHandle, int debounceMs, ITagRemovedCallback callback) throws RemoteException {
            return false;
        }

        @Override
        public void dispatch(Tag tag) throws RemoteException {
        }

        @Override
        public void setReaderMode(IBinder b, IAppCallback callback, int flags, Bundle extras) throws RemoteException {
        }

        @Override
        public void addNfcUnlockHandler(INfcUnlockHandler unlockHandler, int[] techList) throws RemoteException {
        }

        @Override
        public void removeNfcUnlockHandler(INfcUnlockHandler unlockHandler) throws RemoteException {
        }

        @Override
        public void verifyNfcPermission() throws RemoteException {
        }

        @Override
        public boolean isNfcSecureEnabled() throws RemoteException {
            return false;
        }

        @Override
        public boolean deviceSupportsNfcSecure() throws RemoteException {
            return false;
        }

        @Override
        public boolean setNfcSecure(boolean enable) throws RemoteException {
            return false;
        }

        @Override
        public NfcAntennaInfo getNfcAntennaInfo() throws RemoteException {
            return null;
        }

        @Override
        public boolean setControllerAlwaysOn(boolean value) throws RemoteException {
            return false;
        }

        @Override
        public boolean isControllerAlwaysOn() throws RemoteException {
            return false;
        }

        @Override
        public boolean isControllerAlwaysOnSupported() throws RemoteException {
            return false;
        }

        @Override
        public void registerControllerAlwaysOnListener(INfcControllerAlwaysOnListener listener) throws RemoteException {
        }

        @Override
        public void unregisterControllerAlwaysOnListener(INfcControllerAlwaysOnListener listener) throws RemoteException {
        }

        @Override
        public boolean isTagIntentAppPreferenceSupported() throws RemoteException {
            return false;
        }

        @Override
        public Map getTagIntentAppPreferenceForUser(int userId) throws RemoteException {
            return null;
        }

        @Override
        public int setTagIntentAppPreferenceForUser(int userId, String pkg, boolean allow) throws RemoteException {
            return 0;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

