/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.Activity;
import android.app.ActivityThread;
import android.app.OnActivityPausedListener;
import android.app.PendingIntent;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.nfc.INfcAdapter;
import android.nfc.INfcAdapterExtras;
import android.nfc.INfcCardEmulation;
import android.nfc.INfcDta;
import android.nfc.INfcFCardEmulation;
import android.nfc.INfcTag;
import android.nfc.INfcUnlockHandler;
import android.nfc.ITagRemovedCallback;
import android.nfc.NdefMessage;
import android.nfc.NfcActivityManager;
import android.nfc.NfcAntennaInfo;
import android.nfc.NfcControllerAlwaysOnListener;
import android.nfc.NfcEvent;
import android.nfc.NfcFrameworkInitializer;
import android.nfc.NfcManager;
import android.nfc.NfcServiceManager;
import android.nfc.Tag;
import android.nfc.TechListParcel;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

public class NfcAdapter {
    static final String TAG = "NFC";
    private final NfcControllerAlwaysOnListener mControllerAlwaysOnListener;
    public static final String ACTION_NDEF_DISCOVERED = "android.nfc.action.NDEF_DISCOVERED";
    public static final String ACTION_TECH_DISCOVERED = "android.nfc.action.TECH_DISCOVERED";
    public static final String ACTION_TAG_DISCOVERED = "android.nfc.action.TAG_DISCOVERED";
    @RequiresPermission(value="android.permission.NFC_TRANSACTION_EVENT")
    public static final String ACTION_TRANSACTION_DETECTED = "android.nfc.action.TRANSACTION_DETECTED";
    @RequiresPermission(value="android.permission.NFC_PREFERRED_PAYMENT_INFO")
    public static final String ACTION_PREFERRED_PAYMENT_CHANGED = "android.nfc.action.PREFERRED_PAYMENT_CHANGED";
    public static final String ACTION_TAG_LEFT_FIELD = "android.nfc.action.TAG_LOST";
    public static final String EXTRA_TAG = "android.nfc.extra.TAG";
    public static final String EXTRA_NDEF_MESSAGES = "android.nfc.extra.NDEF_MESSAGES";
    public static final String EXTRA_ID = "android.nfc.extra.ID";
    public static final String ACTION_ADAPTER_STATE_CHANGED = "android.nfc.action.ADAPTER_STATE_CHANGED";
    public static final String EXTRA_ADAPTER_STATE = "android.nfc.extra.ADAPTER_STATE";
    public static final String EXTRA_AID = "android.nfc.extra.AID";
    public static final String EXTRA_DATA = "android.nfc.extra.DATA";
    public static final String EXTRA_SECURE_ELEMENT_NAME = "android.nfc.extra.SECURE_ELEMENT_NAME";
    public static final String EXTRA_PREFERRED_PAYMENT_CHANGED_REASON = "android.nfc.extra.PREFERRED_PAYMENT_CHANGED_REASON";
    public static final int PREFERRED_PAYMENT_LOADED = 1;
    public static final int PREFERRED_PAYMENT_CHANGED = 2;
    public static final int PREFERRED_PAYMENT_UPDATED = 3;
    public static final int STATE_OFF = 1;
    public static final int STATE_TURNING_ON = 2;
    public static final int STATE_ON = 3;
    public static final int STATE_TURNING_OFF = 4;
    public static final int FLAG_READER_NFC_A = 1;
    public static final int FLAG_READER_NFC_B = 2;
    public static final int FLAG_READER_NFC_F = 4;
    public static final int FLAG_READER_NFC_V = 8;
    public static final int FLAG_READER_NFC_BARCODE = 16;
    public static final int FLAG_READER_SKIP_NDEF_CHECK = 128;
    public static final int FLAG_READER_NO_PLATFORM_SOUNDS = 256;
    public static final String EXTRA_READER_PRESENCE_CHECK_DELAY = "presence";
    @SystemApi
    @UnsupportedAppUsage
    public static final int FLAG_NDEF_PUSH_NO_CONFIRM = 1;
    public static final String ACTION_HANDOVER_TRANSFER_STARTED = "android.nfc.action.HANDOVER_TRANSFER_STARTED";
    public static final String ACTION_HANDOVER_TRANSFER_DONE = "android.nfc.action.HANDOVER_TRANSFER_DONE";
    public static final String EXTRA_HANDOVER_TRANSFER_STATUS = "android.nfc.extra.HANDOVER_TRANSFER_STATUS";
    public static final int HANDOVER_TRANSFER_STATUS_SUCCESS = 0;
    public static final int HANDOVER_TRANSFER_STATUS_FAILURE = 1;
    public static final String EXTRA_HANDOVER_TRANSFER_URI = "android.nfc.extra.HANDOVER_TRANSFER_URI";
    public static final String ACTION_REQUIRE_UNLOCK_FOR_NFC = "android.nfc.action.REQUIRE_UNLOCK_FOR_NFC";
    @SystemApi
    public static final int TAG_INTENT_APP_PREF_RESULT_SUCCESS = 0;
    @SystemApi
    public static final int TAG_INTENT_APP_PREF_RESULT_PACKAGE_NOT_FOUND = -1;
    @SystemApi
    public static final int TAG_INTENT_APP_PREF_RESULT_UNAVAILABLE = -2;
    static boolean sIsInitialized = false;
    static boolean sHasNfcFeature;
    static boolean sHasCeFeature;
    @UnsupportedAppUsage
    static INfcAdapter sService;
    static NfcServiceManager.ServiceRegisterer sServiceRegisterer;
    static INfcTag sTagService;
    static INfcCardEmulation sCardEmulationService;
    static INfcFCardEmulation sNfcFCardEmulationService;
    static HashMap<Context, NfcAdapter> sNfcAdapters;
    static NfcAdapter sNullContextNfcAdapter;
    final NfcActivityManager mNfcActivityManager;
    final Context mContext;
    final HashMap<NfcUnlockHandler, INfcUnlockHandler> mNfcUnlockHandlers;
    final Object mLock;
    ITagRemovedCallback mTagRemovedListener;
    OnActivityPausedListener mForegroundDispatchListener = new OnActivityPausedListener(){

        @Override
        public void onPaused(Activity activity) {
            NfcAdapter.this.disableForegroundDispatchInternal(activity, true);
        }
    };

    public List<String> getSupportedOffHostSecureElements() {
        if (this.mContext == null) {
            throw new UnsupportedOperationException("You need a context on NfcAdapter to use the  getSupportedOffHostSecureElements APIs");
        }
        ArrayList<String> offHostSE = new ArrayList<String>();
        PackageManager pm = this.mContext.getPackageManager();
        if (pm == null) {
            Log.e(TAG, "Cannot get package manager, assuming no off-host CE feature");
            return offHostSE;
        }
        if (pm.hasSystemFeature("android.hardware.nfc.uicc")) {
            offHostSE.add("SIM");
        }
        if (pm.hasSystemFeature("android.hardware.nfc.ese")) {
            offHostSE.add("eSE");
        }
        return offHostSE;
    }

    @UnsupportedAppUsage
    public static synchronized NfcAdapter getNfcAdapter(Context context) {
        NfcAdapter adapter;
        if (context == null) {
            if (sNullContextNfcAdapter == null) {
                sNullContextNfcAdapter = new NfcAdapter(null);
            }
            return sNullContextNfcAdapter;
        }
        if (!sIsInitialized) {
            PackageManager pm = context.getPackageManager();
            sHasNfcFeature = pm.hasSystemFeature("android.hardware.nfc");
            boolean bl = sHasCeFeature = pm.hasSystemFeature("android.hardware.nfc.hce") || pm.hasSystemFeature("android.hardware.nfc.hcef") || pm.hasSystemFeature("android.hardware.nfc.uicc") || pm.hasSystemFeature("android.hardware.nfc.ese");
            if (!sHasNfcFeature && !sHasCeFeature) {
                Log.v(TAG, "this device does not have NFC support");
                throw new UnsupportedOperationException();
            }
            NfcServiceManager manager = NfcFrameworkInitializer.getNfcServiceManager();
            if (manager == null) {
                Log.e(TAG, "NfcServiceManager is null");
                throw new UnsupportedOperationException();
            }
            sServiceRegisterer = manager.getNfcManagerServiceRegisterer();
            sService = NfcAdapter.getServiceInterface();
            if (sService == null) {
                Log.e(TAG, "could not retrieve NFC service");
                throw new UnsupportedOperationException();
            }
            if (sHasNfcFeature) {
                try {
                    sTagService = sService.getNfcTagInterface();
                }
                catch (RemoteException e) {
                    Log.e(TAG, "could not retrieve NFC Tag service");
                    throw new UnsupportedOperationException();
                }
            }
            if (sHasCeFeature) {
                try {
                    sNfcFCardEmulationService = sService.getNfcFCardEmulationInterface();
                }
                catch (RemoteException e) {
                    Log.e(TAG, "could not retrieve NFC-F card emulation service");
                    throw new UnsupportedOperationException();
                }
                try {
                    sCardEmulationService = sService.getNfcCardEmulationInterface();
                }
                catch (RemoteException e) {
                    Log.e(TAG, "could not retrieve card emulation service");
                    throw new UnsupportedOperationException();
                }
            }
            sIsInitialized = true;
        }
        if ((adapter = sNfcAdapters.get(context)) == null) {
            adapter = new NfcAdapter(context);
            sNfcAdapters.put(context, adapter);
        }
        return adapter;
    }

    private static INfcAdapter getServiceInterface() {
        IBinder b = sServiceRegisterer.get();
        if (b == null) {
            return null;
        }
        return INfcAdapter.Stub.asInterface(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NfcAdapter getDefaultAdapter(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        if ((context = context.getApplicationContext()) == null) {
            throw new IllegalArgumentException("context not associated with any application (using a mock context?)");
        }
        if (sIsInitialized && sServiceRegisterer.tryGet() == null) {
            Class<NfcAdapter> clazz = NfcAdapter.class;
            synchronized (NfcAdapter.class) {
                if (sIsInitialized) {
                    sIsInitialized = false;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
        }
        NfcManager manager = (NfcManager)context.getSystemService("nfc");
        if (manager == null) {
            return null;
        }
        return manager.getDefaultAdapter();
    }

    @Deprecated
    @UnsupportedAppUsage
    public static NfcAdapter getDefaultAdapter() {
        Log.w(TAG, "WARNING: NfcAdapter.getDefaultAdapter() is deprecated, use NfcAdapter.getDefaultAdapter(Context) instead", new Exception());
        return NfcAdapter.getNfcAdapter(null);
    }

    NfcAdapter(Context context) {
        this.mContext = context;
        this.mNfcActivityManager = new NfcActivityManager(this);
        this.mNfcUnlockHandlers = new HashMap();
        this.mTagRemovedListener = null;
        this.mLock = new Object();
        this.mControllerAlwaysOnListener = new NfcControllerAlwaysOnListener(this.getService());
    }

    @UnsupportedAppUsage
    public Context getContext() {
        return this.mContext;
    }

    @UnsupportedAppUsage
    public INfcAdapter getService() {
        this.isEnabled();
        return sService;
    }

    public INfcTag getTagService() {
        this.isEnabled();
        return sTagService;
    }

    public INfcCardEmulation getCardEmulationService() {
        this.isEnabled();
        return sCardEmulationService;
    }

    public INfcFCardEmulation getNfcFCardEmulationService() {
        this.isEnabled();
        return sNfcFCardEmulationService;
    }

    public INfcDta getNfcDtaInterface() {
        if (this.mContext == null) {
            throw new UnsupportedOperationException("You need a context on NfcAdapter to use the  NFC extras APIs");
        }
        try {
            return sService.getNfcDtaInterface(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            if (sService == null) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return null;
            }
            try {
                return sService.getNfcDtaInterface(this.mContext.getPackageName());
            }
            catch (RemoteException ee) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return null;
            }
        }
    }

    @UnsupportedAppUsage
    public void attemptDeadServiceRecovery(Exception e) {
        Log.e(TAG, "NFC service dead - attempting to recover", e);
        INfcAdapter service = NfcAdapter.getServiceInterface();
        if (service == null) {
            Log.e(TAG, "could not retrieve NFC service during service recovery");
            return;
        }
        sService = service;
        try {
            sTagService = service.getNfcTagInterface();
        }
        catch (RemoteException ee) {
            Log.e(TAG, "could not retrieve NFC tag service during service recovery");
            return;
        }
        try {
            sCardEmulationService = service.getNfcCardEmulationInterface();
        }
        catch (RemoteException ee) {
            Log.e(TAG, "could not retrieve NFC card emulation service during service recovery");
        }
        try {
            sNfcFCardEmulationService = service.getNfcFCardEmulationInterface();
        }
        catch (RemoteException ee) {
            Log.e(TAG, "could not retrieve NFC-F card emulation service during service recovery");
        }
    }

    public boolean isEnabled() {
        try {
            return sService.getState() == 3;
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            if (sService == null) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return false;
            }
            try {
                return sService.getState() == 3;
            }
            catch (RemoteException ee) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return false;
            }
        }
    }

    @UnsupportedAppUsage
    public int getAdapterState() {
        try {
            return sService.getState();
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            if (sService == null) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return 1;
            }
            try {
                return sService.getState();
            }
            catch (RemoteException ee) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return 1;
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean enable() {
        try {
            return sService.enable();
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            if (sService == null) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return false;
            }
            try {
                return sService.enable();
            }
            catch (RemoteException ee) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return false;
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean disable() {
        try {
            return sService.disable(true);
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            if (sService == null) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return false;
            }
            try {
                return sService.disable(true);
            }
            catch (RemoteException ee) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return false;
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean disable(boolean persist) {
        try {
            return sService.disable(persist);
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            if (sService == null) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return false;
            }
            try {
                return sService.disable(persist);
            }
            catch (RemoteException ee) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return false;
            }
        }
    }

    public void pausePolling(int timeoutInMs) {
        try {
            sService.pausePolling(timeoutInMs);
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
        }
    }

    public void resumePolling() {
        try {
            sService.resumePolling();
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage
    public void setBeamPushUris(Uri[] uris, Activity activity) {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage
    public void setBeamPushUrisCallback(CreateBeamUrisCallback callback, Activity activity) {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage
    public void setNdefPushMessage(NdefMessage message, Activity activity, Activity ... activities) {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @UnsupportedAppUsage
    public void setNdefPushMessage(NdefMessage message, Activity activity, int flags) {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage
    public void setNdefPushMessageCallback(CreateNdefMessageCallback callback, Activity activity, Activity ... activities) {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage
    public void setOnNdefPushCompleteCallback(OnNdefPushCompleteCallback callback, Activity activity, Activity ... activities) {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableForegroundDispatch(Activity activity, PendingIntent intent, IntentFilter[] filters, String[][] techLists) {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (activity == null || intent == null) {
                throw new NullPointerException();
            }
            if (!activity.isResumed()) {
                throw new IllegalStateException("Foreground dispatch can only be enabled when your activity is resumed");
            }
            try {
                TechListParcel parcel = null;
                if (techLists != null && techLists.length > 0) {
                    parcel = new TechListParcel(techLists);
                }
                ActivityThread.currentActivityThread().registerOnActivityPausedListener(activity, this.mForegroundDispatchListener);
                sService.setForegroundDispatch(intent, filters, parcel);
            }
            catch (RemoteException e) {
                this.attemptDeadServiceRecovery(e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableForegroundDispatch(Activity activity) {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            ActivityThread.currentActivityThread().unregisterOnActivityPausedListener(activity, this.mForegroundDispatchListener);
            this.disableForegroundDispatchInternal(activity, false);
            return;
        }
    }

    void disableForegroundDispatchInternal(Activity activity, boolean force) {
        try {
            sService.setForegroundDispatch(null, null, null);
            if (!force && !activity.isResumed()) {
                throw new IllegalStateException("You must disable foreground dispatching while your activity is still resumed");
            }
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableReaderMode(Activity activity, ReaderCallback callback, int flags, Bundle extras) {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            this.mNfcActivityManager.enableReaderMode(activity, callback, flags, extras);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableReaderMode(Activity activity) {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.mNfcActivityManager.disableReaderMode(activity);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage
    public boolean invokeBeam(Activity activity) {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage
    public void enableForegroundNdefPush(Activity activity, NdefMessage message) {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage
    public void disableForegroundNdefPush(Activity activity) {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean enableSecureNfc(boolean enable) {
        if (!sHasNfcFeature && !sHasCeFeature) {
            throw new UnsupportedOperationException();
        }
        try {
            return sService.setNfcSecure(enable);
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            if (sService == null) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return false;
            }
            try {
                return sService.setNfcSecure(enable);
            }
            catch (RemoteException ee) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return false;
            }
        }
    }

    public boolean isSecureNfcSupported() {
        if (!sHasNfcFeature && !sHasCeFeature) {
            throw new UnsupportedOperationException();
        }
        try {
            return sService.deviceSupportsNfcSecure();
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            if (sService == null) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return false;
            }
            try {
                return sService.deviceSupportsNfcSecure();
            }
            catch (RemoteException ee) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return false;
            }
        }
    }

    public NfcAntennaInfo getNfcAntennaInfo() {
        if (!sHasNfcFeature && !sHasCeFeature) {
            throw new UnsupportedOperationException();
        }
        try {
            return sService.getNfcAntennaInfo();
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            if (sService == null) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return null;
            }
            try {
                return sService.getNfcAntennaInfo();
            }
            catch (RemoteException ee) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return null;
            }
        }
    }

    public boolean isSecureNfcEnabled() {
        if (!sHasNfcFeature && !sHasCeFeature) {
            throw new UnsupportedOperationException();
        }
        try {
            return sService.isNfcSecureEnabled();
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            if (sService == null) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return false;
            }
            try {
                return sService.isNfcSecureEnabled();
            }
            catch (RemoteException ee) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return false;
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    @UnsupportedAppUsage
    public boolean enableNdefPush() {
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    @UnsupportedAppUsage
    public boolean disableNdefPush() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage
    public boolean isNdefPushEnabled() {
        Class<NfcAdapter> clazz = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ignore(Tag tag, int debounceMs, final OnTagRemovedListener tagRemovedListener, final Handler handler) {
        ITagRemovedCallback.Stub iListener = null;
        if (tagRemovedListener != null) {
            iListener = new ITagRemovedCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onTagRemoved() throws RemoteException {
                    if (handler != null) {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                tagRemovedListener.onTagRemoved();
                            }
                        });
                    } else {
                        tagRemovedListener.onTagRemoved();
                    }
                    Object object = NfcAdapter.this.mLock;
                    synchronized (object) {
                        NfcAdapter.this.mTagRemovedListener = null;
                    }
                }
            };
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mTagRemovedListener = iListener;
        }
        try {
            return sService.ignore(tag.getServiceHandle(), debounceMs, iListener);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void dispatch(Tag tag) {
        if (tag == null) {
            throw new NullPointerException("tag cannot be null");
        }
        try {
            sService.dispatch(tag);
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean addNfcUnlockHandler(final NfcUnlockHandler unlockHandler, String[] tagTechnologies) {
        Object object = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (tagTechnologies.length == 0) {
                return false;
            }
            try {
                object = this.mLock;
                synchronized (object) {
                    if (this.mNfcUnlockHandlers.containsKey(unlockHandler)) {
                        sService.removeNfcUnlockHandler(this.mNfcUnlockHandlers.get(unlockHandler));
                        this.mNfcUnlockHandlers.remove(unlockHandler);
                    }
                    INfcUnlockHandler.Stub iHandler = new INfcUnlockHandler.Stub(){

                        @Override
                        public boolean onUnlockAttempted(Tag tag) throws RemoteException {
                            return unlockHandler.onUnlockAttempted(tag);
                        }
                    };
                    sService.addNfcUnlockHandler(iHandler, Tag.getTechCodesFromStrings(tagTechnologies));
                    this.mNfcUnlockHandlers.put(unlockHandler, iHandler);
                }
            }
            catch (RemoteException e) {
                this.attemptDeadServiceRecovery(e);
                return false;
            }
            catch (IllegalArgumentException e) {
                Log.e(TAG, "Unable to register LockscreenDispatch", e);
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean removeNfcUnlockHandler(NfcUnlockHandler unlockHandler) {
        Object object = NfcAdapter.class;
        synchronized (NfcAdapter.class) {
            if (!sHasNfcFeature) {
                throw new UnsupportedOperationException();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                object = this.mLock;
                synchronized (object) {
                    if (this.mNfcUnlockHandlers.containsKey(unlockHandler)) {
                        sService.removeNfcUnlockHandler(this.mNfcUnlockHandlers.remove(unlockHandler));
                    }
                    return true;
                }
            }
            catch (RemoteException e) {
                this.attemptDeadServiceRecovery(e);
                return false;
            }
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public INfcAdapterExtras getNfcAdapterExtrasInterface() {
        if (this.mContext == null) {
            throw new UnsupportedOperationException("You need a context on NfcAdapter to use the  NFC extras APIs");
        }
        try {
            return sService.getNfcAdapterExtrasInterface(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            if (sService == null) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return null;
            }
            try {
                return sService.getNfcAdapterExtrasInterface(this.mContext.getPackageName());
            }
            catch (RemoteException ee) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return null;
            }
        }
    }

    void enforceResumed(Activity activity) {
        if (!activity.isResumed()) {
            throw new IllegalStateException("API cannot be called while activity is paused");
        }
    }

    int getSdkVersion() {
        if (this.mContext == null) {
            return 9;
        }
        return this.mContext.getApplicationInfo().targetSdkVersion;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NFC_SET_CONTROLLER_ALWAYS_ON")
    public boolean setControllerAlwaysOn(boolean value) {
        if (!sHasNfcFeature && !sHasCeFeature) {
            throw new UnsupportedOperationException();
        }
        try {
            return sService.setControllerAlwaysOn(value);
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            if (sService == null) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return false;
            }
            try {
                return sService.setControllerAlwaysOn(value);
            }
            catch (RemoteException ee) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return false;
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NFC_SET_CONTROLLER_ALWAYS_ON")
    public boolean isControllerAlwaysOn() {
        try {
            return sService.isControllerAlwaysOn();
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            if (sService == null) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return false;
            }
            try {
                return sService.isControllerAlwaysOn();
            }
            catch (RemoteException ee) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return false;
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NFC_SET_CONTROLLER_ALWAYS_ON")
    public boolean isControllerAlwaysOnSupported() {
        if (!sHasNfcFeature && !sHasCeFeature) {
            throw new UnsupportedOperationException();
        }
        try {
            return sService.isControllerAlwaysOnSupported();
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            if (sService == null) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return false;
            }
            try {
                return sService.isControllerAlwaysOnSupported();
            }
            catch (RemoteException ee) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return false;
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NFC_SET_CONTROLLER_ALWAYS_ON")
    public void registerControllerAlwaysOnListener(Executor executor, ControllerAlwaysOnListener listener) {
        this.mControllerAlwaysOnListener.register(executor, listener);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NFC_SET_CONTROLLER_ALWAYS_ON")
    public void unregisterControllerAlwaysOnListener(ControllerAlwaysOnListener listener) {
        this.mControllerAlwaysOnListener.unregister(listener);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public int setTagIntentAppPreferenceForUser(int userId, String pkg, boolean allow) {
        Objects.requireNonNull(pkg, "pkg cannot be null");
        if (!this.isTagIntentAppPreferenceSupported()) {
            Log.e(TAG, "TagIntentAppPreference is not supported");
            throw new UnsupportedOperationException();
        }
        try {
            return sService.setTagIntentAppPreferenceForUser(userId, pkg, allow);
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            if (sService == null) {
                Log.e(TAG, "Failed to recover NFC Service.");
            }
            try {
                return sService.setTagIntentAppPreferenceForUser(userId, pkg, allow);
            }
            catch (RemoteException ee) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return -2;
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public Map<String, Boolean> getTagIntentAppPreferenceForUser(int userId) {
        if (!this.isTagIntentAppPreferenceSupported()) {
            Log.e(TAG, "TagIntentAppPreference is not supported");
            throw new UnsupportedOperationException();
        }
        try {
            Map result = sService.getTagIntentAppPreferenceForUser(userId);
            return result;
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            if (sService == null) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return Collections.emptyMap();
            }
            try {
                Map result = sService.getTagIntentAppPreferenceForUser(userId);
                return result;
            }
            catch (RemoteException ee) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return Collections.emptyMap();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean isTagIntentAppPreferenceSupported() {
        if (!sHasNfcFeature) {
            throw new UnsupportedOperationException();
        }
        try {
            return sService.isTagIntentAppPreferenceSupported();
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            if (sService == null) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return false;
            }
            try {
                return sService.isTagIntentAppPreferenceSupported();
            }
            catch (RemoteException ee) {
                Log.e(TAG, "Failed to recover NFC Service.");
                return false;
            }
        }
    }

    static {
        sNfcAdapters = new HashMap();
    }

    public static interface ReaderCallback {
        public void onTagDiscovered(Tag var1);
    }

    public static interface OnTagRemovedListener {
        public void onTagRemoved();
    }

    @SystemApi
    public static interface NfcUnlockHandler {
        public boolean onUnlockAttempted(Tag var1);
    }

    @SystemApi
    public static interface ControllerAlwaysOnListener {
        public void onControllerAlwaysOnChanged(boolean var1);
    }

    @Deprecated
    public static interface CreateBeamUrisCallback {
        public Uri[] createBeamUris(NfcEvent var1);
    }

    @Deprecated
    public static interface CreateNdefMessageCallback {
        public NdefMessage createNdefMessage(NfcEvent var1);
    }

    @Deprecated
    public static interface OnNdefPushCompleteCallback {
        public void onNdefPushComplete(NfcEvent var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TagIntentAppPreferenceResult {
    }
}

