/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.annotation.SystemApi;
import android.os.IBinder;
import android.os.ServiceManager;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class NfcServiceManager {
    public ServiceRegisterer getNfcManagerServiceRegisterer() {
        return new ServiceRegisterer("nfc");
    }

    public static class ServiceRegisterer {
        private final String mServiceName;

        public ServiceRegisterer(String serviceName) {
            this.mServiceName = serviceName;
        }

        public void register(IBinder service) {
            ServiceManager.addService(this.mServiceName, service);
        }

        public IBinder get() {
            return ServiceManager.getService(this.mServiceName);
        }

        public IBinder getOrThrow() throws ServiceNotFoundException {
            try {
                return ServiceManager.getServiceOrThrow(this.mServiceName);
            }
            catch (ServiceManager.ServiceNotFoundException e) {
                throw new ServiceNotFoundException(this.mServiceName);
            }
        }

        public IBinder tryGet() {
            return ServiceManager.checkService(this.mServiceName);
        }
    }

    public static class ServiceNotFoundException
    extends ServiceManager.ServiceNotFoundException {
        public ServiceNotFoundException(String name) {
            super(name);
        }
    }
}

