/*
 * Decompiled with CFR 0.152.
 */
package android.ondevicepersonalization;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.ondevicepersonalization.OnDevicePersonalizationException;
import android.ondevicepersonalization.SlotResultHandle;
import android.ondevicepersonalization.aidl.IExecuteCallback;
import android.ondevicepersonalization.aidl.IOnDevicePersonalizationManagingService;
import android.ondevicepersonalization.aidl.IRequestSurfacePackageCallback;
import android.os.IBinder;
import android.os.OutcomeReceiver;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.util.Slog;
import android.view.SurfaceControlViewHost;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class OnDevicePersonalizationManager {
    public static final String ON_DEVICE_PERSONALIZATION_SERVICE = "on_device_personalization_service";
    public static final String EXTRA_WIDTH_IN_PIXELS = "android.ondevicepersonalization.extra.WIDTH_IN_PIXELS";
    public static final String EXTRA_HEIGHT_IN_PIXELS = "android.ondevicepersonalization.extra.HEIGHT_IN_PIXELS";
    public static final String EXTRA_DISPLAY_ID = "android.ondevicepersonalization.extra.DISPLAY_ID";
    public static final String EXTRA_HOST_TOKEN = "android.ondevicepersonalization.extra.HOST_TOKEN";
    public static final String EXTRA_APP_PARAMS = "android.ondevicepersonalization.extra.APP_PARAMS";
    public static final String EXTRA_SURFACE_PACKAGE = "android.ondevicepersonalization.extra.SURFACE_PACKAGE";
    private boolean mBound = false;
    private static final String TAG = "OdpManager";
    private IOnDevicePersonalizationManagingService mService;
    private final Context mContext;
    private final CountDownLatch mConnectionLatch = new CountDownLatch(1);
    private final ServiceConnection mConnection = new ServiceConnection(){

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            OnDevicePersonalizationManager.this.mService = IOnDevicePersonalizationManagingService.Stub.asInterface(service);
            OnDevicePersonalizationManager.this.mBound = true;
            OnDevicePersonalizationManager.this.mConnectionLatch.countDown();
        }

        @Override
        public void onNullBinding(ComponentName name) {
            OnDevicePersonalizationManager.this.mBound = false;
            OnDevicePersonalizationManager.this.mConnectionLatch.countDown();
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            OnDevicePersonalizationManager.this.mService = null;
            OnDevicePersonalizationManager.this.mBound = false;
        }
    };
    private static final int BIND_SERVICE_TIMEOUT_SEC = 5;
    private static final String VERSION = "1.0";

    public OnDevicePersonalizationManager(Context context) {
        this.mContext = context;
    }

    public String getVersion() {
        return VERSION;
    }

    public void execute(String servicePackageName, PersistableBundle params, final Executor executor, final OutcomeReceiver<List<SlotResultHandle>, Exception> receiver) {
        try {
            this.bindService(executor);
            IExecuteCallback.Stub callbackWrapper = new IExecuteCallback.Stub(){

                @Override
                public void onSuccess(List<String> slotResultTokens) {
                    executor.execute(() -> {
                        try {
                            ArrayList<SlotResultHandle> slotResults = new ArrayList<SlotResultHandle>(slotResultTokens.size());
                            for (String token : slotResultTokens) {
                                if (token == null) {
                                    slotResults.add(null);
                                    continue;
                                }
                                slotResults.add(new SlotResultHandle(token));
                            }
                            receiver.onResult(slotResults);
                        }
                        catch (Exception e) {
                            receiver.onError(e);
                        }
                    });
                }

                @Override
                public void onError(int errorCode) {
                    executor.execute(() -> receiver.onError(new OnDevicePersonalizationException(errorCode)));
                }
            };
            this.mService.execute(this.mContext.getPackageName(), servicePackageName, params, callbackWrapper);
        }
        catch (Exception e) {
            receiver.onError(e);
        }
    }

    public void requestSurfacePackage(SlotResultHandle slotResultHandle, IBinder hostToken, int displayId, int width, int height, final Executor executor, final OutcomeReceiver<SurfaceControlViewHost.SurfacePackage, Exception> receiver) {
        try {
            this.bindService(executor);
            IRequestSurfacePackageCallback.Stub callbackWrapper = new IRequestSurfacePackageCallback.Stub(){

                @Override
                public void onSuccess(SurfaceControlViewHost.SurfacePackage surfacePackage) {
                    executor.execute(() -> receiver.onResult(surfacePackage));
                }

                @Override
                public void onError(int errorCode) {
                    executor.execute(() -> receiver.onError(new OnDevicePersonalizationException(errorCode)));
                }
            };
            this.mService.requestSurfacePackage(slotResultHandle.getSlotResultToken(), hostToken, displayId, width, height, callbackWrapper);
        }
        catch (RemoteException | InterruptedException | NullPointerException e) {
            receiver.onError(e);
        }
    }

    private void bindService(Executor executor) throws InterruptedException {
        if (!this.mBound) {
            Intent intent = new Intent("android.OnDevicePersonalizationService");
            ComponentName serviceComponent = this.resolveService(intent, this.mContext.getPackageManager());
            if (serviceComponent == null) {
                Slog.e(TAG, "Invalid component for ondevicepersonalization service");
                return;
            }
            intent.setComponent(serviceComponent);
            boolean r = this.mContext.bindService(intent, 1, executor, this.mConnection);
            if (!r) {
                return;
            }
            this.mConnectionLatch.await(5L, TimeUnit.SECONDS);
        }
    }

    private ComponentName resolveService(Intent intent, PackageManager pm) {
        List<ResolveInfo> services = pm.queryIntentServices(intent, PackageManager.ResolveInfoFlags.of(0L));
        if (services == null || services.isEmpty()) {
            Slog.e(TAG, "Failed to find ondevicepersonalization service");
            return null;
        }
        int i = 0;
        if (i < services.size()) {
            ResolveInfo ri = services.get(i);
            ComponentName resolved = new ComponentName(ri.serviceInfo.packageName, ri.serviceInfo.name);
            return resolved;
        }
        Slog.e(TAG, "Didn't find any matching ondevicepersonalization service.");
        return null;
    }
}

