/*
 * Decompiled with CFR 0.152.
 */
package android.ondevicepersonalization;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.ondevicepersonalization.OnDevicePersonalizationException;
import android.ondevicepersonalization.aidl.IPrivacyStatusService;
import android.ondevicepersonalization.aidl.IPrivacyStatusServiceCallback;
import android.os.IBinder;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.util.Slog;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class OnDevicePersonalizationPrivacyStatusManager {
    public static final String ON_DEVICE_PERSONALIZATION_PRIVACY_STATUS_SERVICE = "on_device_personalization_privacy_status_service";
    private static final String TAG = "OdpPrivacyStatusManager";
    private static final String ODP_PRIVACY_STATUS_SERVICE_INTENT = "android.OnDevicePersonalizationPrivacyStatusService";
    private boolean mBound = false;
    private IPrivacyStatusService mService = null;
    private final Context mContext;
    private final CountDownLatch mConnectionLatch = new CountDownLatch(1);
    private final ServiceConnection mConnection = new ServiceConnection(){

        @Override
        public void onServiceConnected(ComponentName name, IBinder binder) {
            OnDevicePersonalizationPrivacyStatusManager.this.mService = IPrivacyStatusService.Stub.asInterface(binder);
            OnDevicePersonalizationPrivacyStatusManager.this.mBound = true;
            OnDevicePersonalizationPrivacyStatusManager.this.mConnectionLatch.countDown();
        }

        @Override
        public void onNullBinding(ComponentName name) {
            OnDevicePersonalizationPrivacyStatusManager.this.mBound = false;
            OnDevicePersonalizationPrivacyStatusManager.this.mConnectionLatch.countDown();
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            OnDevicePersonalizationPrivacyStatusManager.this.mService = null;
            OnDevicePersonalizationPrivacyStatusManager.this.mBound = false;
        }
    };
    private static final int BIND_SERVICE_TIMEOUT_SEC = 5;

    public OnDevicePersonalizationPrivacyStatusManager(Context context) {
        this.mContext = context;
    }

    public void setKidStatus(boolean isKidStatusEnabled, final Executor executor, final OutcomeReceiver<Boolean, Exception> receiver) {
        try {
            this.bindService(executor);
            this.mService.setKidStatus(isKidStatusEnabled, new IPrivacyStatusServiceCallback.Stub(){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(true));
                }

                @Override
                public void onFailure(int errorCode) {
                    executor.execute(() -> receiver.onError(new OnDevicePersonalizationException(errorCode)));
                }
            });
        }
        catch (RemoteException | InterruptedException e) {
            receiver.onError(e);
        }
    }

    private void bindService(Executor executor) throws InterruptedException {
        if (!this.mBound) {
            Intent intent = new Intent(ODP_PRIVACY_STATUS_SERVICE_INTENT);
            ComponentName serviceComponent = this.resolveService(intent);
            if (serviceComponent == null) {
                Slog.e(TAG, "Invalid component for ODP privacy status service");
                return;
            }
            intent.setComponent(serviceComponent);
            boolean r = this.mContext.bindService(intent, 1, executor, this.mConnection);
            if (!r) {
                return;
            }
            this.mConnectionLatch.await(5L, TimeUnit.SECONDS);
        }
    }

    private ComponentName resolveService(Intent intent) {
        List<ResolveInfo> services = this.mContext.getPackageManager().queryIntentServices(intent, 0);
        if (services == null || services.isEmpty()) {
            Slog.e(TAG, "Failed to find OdpPrivacyStatus service");
            return null;
        }
        int i = 0;
        if (i < services.size()) {
            ServiceInfo serviceInfo = services.get((int)i).serviceInfo;
            if (serviceInfo == null) {
                Slog.e(TAG, "Failed to find serviceInfo for OdpPrivacyStatus service.");
                return null;
            }
            return new ComponentName(serviceInfo.packageName, serviceInfo.name);
        }
        Slog.e(TAG, "Didn't find any matching OdpPrivacyStatus service.");
        return null;
    }
}

