/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.BluetoothBatteryStats;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.WakeLockStats;
import android.os.WorkSource;
import android.os.connectivity.CellularBatteryStats;
import android.os.connectivity.WifiBatteryStats;
import com.android.internal.app.IBatteryStats;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

@SystemApi
public class BatteryStatsManager {
    public static final int WIFI_STATE_OFF = 0;
    public static final int WIFI_STATE_OFF_SCANNING = 1;
    public static final int WIFI_STATE_ON_NO_NETWORKS = 2;
    public static final int WIFI_STATE_ON_DISCONNECTED = 3;
    public static final int WIFI_STATE_ON_CONNECTED_STA = 4;
    public static final int WIFI_STATE_ON_CONNECTED_P2P = 5;
    public static final int WIFI_STATE_ON_CONNECTED_STA_P2P = 6;
    public static final int WIFI_STATE_SOFT_AP = 7;
    public static final int NUM_WIFI_STATES = 8;
    public static final int WIFI_SUPPL_STATE_INVALID = 0;
    public static final int WIFI_SUPPL_STATE_DISCONNECTED = 1;
    public static final int WIFI_SUPPL_STATE_INTERFACE_DISABLED = 2;
    public static final int WIFI_SUPPL_STATE_INACTIVE = 3;
    public static final int WIFI_SUPPL_STATE_SCANNING = 4;
    public static final int WIFI_SUPPL_STATE_AUTHENTICATING = 5;
    public static final int WIFI_SUPPL_STATE_ASSOCIATING = 6;
    public static final int WIFI_SUPPL_STATE_ASSOCIATED = 7;
    public static final int WIFI_SUPPL_STATE_FOUR_WAY_HANDSHAKE = 8;
    public static final int WIFI_SUPPL_STATE_GROUP_HANDSHAKE = 9;
    public static final int WIFI_SUPPL_STATE_COMPLETED = 10;
    public static final int WIFI_SUPPL_STATE_DORMANT = 11;
    public static final int WIFI_SUPPL_STATE_UNINITIALIZED = 12;
    public static final int NUM_WIFI_SUPPL_STATES = 13;
    private final IBatteryStats mBatteryStats;

    public BatteryStatsManager(IBatteryStats batteryStats) {
        this.mBatteryStats = batteryStats;
    }

    @RequiresPermission(value="android.permission.BATTERY_STATS")
    public BatteryUsageStats getBatteryUsageStats() {
        return this.getBatteryUsageStats(BatteryUsageStatsQuery.DEFAULT);
    }

    @RequiresPermission(value="android.permission.BATTERY_STATS")
    public BatteryUsageStats getBatteryUsageStats(BatteryUsageStatsQuery query) {
        return this.getBatteryUsageStats(List.of(query)).get(0);
    }

    @RequiresPermission(value="android.permission.BATTERY_STATS")
    public List<BatteryUsageStats> getBatteryUsageStats(List<BatteryUsageStatsQuery> queries) {
        try {
            return this.mBatteryStats.getBatteryUsageStats(queries);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void reportWifiRssiChanged(int newRssi) {
        try {
            this.mBatteryStats.noteWifiRssiChanged(newRssi);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void reportWifiOn() {
        try {
            this.mBatteryStats.noteWifiOn();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void reportWifiOff() {
        try {
            this.mBatteryStats.noteWifiOff();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void reportWifiState(int newWifiState, String accessPoint) {
        try {
            this.mBatteryStats.noteWifiState(newWifiState, accessPoint);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void reportWifiScanStartedFromSource(WorkSource ws) {
        try {
            this.mBatteryStats.noteWifiScanStartedFromSource(ws);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void reportWifiScanStoppedFromSource(WorkSource ws) {
        try {
            this.mBatteryStats.noteWifiScanStoppedFromSource(ws);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void reportWifiBatchedScanStartedFromSource(WorkSource ws, int csph) {
        try {
            this.mBatteryStats.noteWifiBatchedScanStartedFromSource(ws, csph);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void reportWifiBatchedScanStoppedFromSource(WorkSource ws) {
        try {
            this.mBatteryStats.noteWifiBatchedScanStoppedFromSource(ws);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.BATTERY_STATS", "android.permission.UPDATE_DEVICE_STATS"})
    public CellularBatteryStats getCellularBatteryStats() {
        try {
            return this.mBatteryStats.getCellularBatteryStats();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return null;
        }
    }

    @RequiresPermission(anyOf={"android.permission.BATTERY_STATS", "android.permission.UPDATE_DEVICE_STATS"})
    public WifiBatteryStats getWifiBatteryStats() {
        try {
            return this.mBatteryStats.getWifiBatteryStats();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return null;
        }
    }

    @RequiresPermission(value="android.permission.BATTERY_STATS")
    public WakeLockStats getWakeLockStats() {
        try {
            return this.mBatteryStats.getWakeLockStats();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.BATTERY_STATS")
    public BluetoothBatteryStats getBluetoothBatteryStats() {
        try {
            return this.mBatteryStats.getBluetoothBatteryStats();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void reportFullWifiLockAcquiredFromSource(WorkSource ws) {
        try {
            this.mBatteryStats.noteFullWifiLockAcquiredFromSource(ws);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void reportFullWifiLockReleasedFromSource(WorkSource ws) {
        try {
            this.mBatteryStats.noteFullWifiLockReleasedFromSource(ws);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void reportWifiSupplicantStateChanged(int newSupplState, boolean failedAuth) {
        try {
            this.mBatteryStats.noteWifiSupplicantStateChanged(newSupplState, failedAuth);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void reportWifiMulticastEnabled(WorkSource ws) {
        try {
            this.mBatteryStats.noteWifiMulticastEnabled(ws.getAttributionUid());
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void reportWifiMulticastDisabled(WorkSource ws) {
        try {
            this.mBatteryStats.noteWifiMulticastDisabled(ws.getAttributionUid());
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void reportMobileRadioPowerState(boolean isActive, int uid) {
        try {
            this.mBatteryStats.noteMobileRadioPowerState(BatteryStatsManager.getDataConnectionPowerState(isActive), SystemClock.elapsedRealtimeNanos(), uid);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void reportWifiRadioPowerState(boolean isActive, int uid) {
        try {
            this.mBatteryStats.noteWifiRadioPowerState(BatteryStatsManager.getDataConnectionPowerState(isActive), SystemClock.elapsedRealtimeNanos(), uid);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(anyOf={"android.permission.MAINLINE_NETWORK_STACK", "android.permission.NETWORK_STACK"})
    public void reportNetworkInterfaceForTransports(String iface, int[] transportTypes) throws RuntimeException {
        try {
            this.mBatteryStats.noteNetworkInterfaceForTransports(iface, transportTypes);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void reportBluetoothOn(int uid, int reason, String packageName) {
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void reportBluetoothOff(int uid, int reason, String packageName) {
    }

    @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void reportBleScanStarted(WorkSource ws, boolean isUnoptimized) {
        try {
            this.mBatteryStats.noteBleScanStarted(ws, isUnoptimized);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void reportBleScanStopped(WorkSource ws, boolean isUnoptimized) {
        try {
            this.mBatteryStats.noteBleScanStopped(ws, isUnoptimized);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void reportBleScanReset() {
        try {
            this.mBatteryStats.noteBleScanReset();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
    public void reportBleScanResults(WorkSource ws, int numNewResults) {
        try {
            this.mBatteryStats.noteBleScanResults(ws, numNewResults);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    private static int getDataConnectionPowerState(boolean isActive) {
        return isActive ? 3 : 1;
    }

    @RequiresPermission(value="android.permission.DEVICE_POWER")
    public void setChargerAcOnline(boolean online, boolean forceUpdate) {
        try {
            this.mBatteryStats.setChargerAcOnline(online, forceUpdate);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.DEVICE_POWER")
    public void setBatteryLevel(int level, boolean forceUpdate) {
        try {
            this.mBatteryStats.setBatteryLevel(level, forceUpdate);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.DEVICE_POWER")
    public void unplugBattery(boolean forceUpdate) {
        try {
            this.mBatteryStats.unplugBattery(forceUpdate);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.DEVICE_POWER")
    public void resetBattery(boolean forceUpdate) {
        try {
            this.mBatteryStats.resetBattery(forceUpdate);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.DEVICE_POWER")
    public void suspendBatteryInput() {
        try {
            this.mBatteryStats.suspendBatteryInput();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiSupplState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiState {
    }
}

