/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Binder;
import android.os.BugreportParams;
import android.os.Handler;
import android.os.IDumpstate;
import android.os.IDumpstateListener;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import android.widget.Toast;
import com.android.internal.util.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;
import libcore.io.IoUtils;

public class BugreportManager {
    private static final String TAG = "BugreportManager";
    private final Context mContext;
    private final IDumpstate mBinder;

    public BugreportManager(Context context, IDumpstate binder) {
        this.mContext = context;
        this.mBinder = binder;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.DUMP")
    public void preDumpUiData() {
        try {
            this.mBinder.preDumpUiData(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.DUMP")
    public void startBugreport(ParcelFileDescriptor bugreportFd, ParcelFileDescriptor screenshotFd, BugreportParams params, Executor executor, BugreportCallback callback) {
        try {
            boolean isScreenshotRequested;
            Preconditions.checkNotNull(bugreportFd);
            Preconditions.checkNotNull(params);
            Preconditions.checkNotNull(executor);
            Preconditions.checkNotNull(callback);
            boolean deferConsent = (params.getFlags() & 2) != 0;
            boolean bl = isScreenshotRequested = screenshotFd != null || deferConsent;
            if (screenshotFd == null) {
                screenshotFd = ParcelFileDescriptor.open(new File("/dev/null"), 0x10000000);
            }
            DumpstateListener dsListener = new DumpstateListener(executor, callback, isScreenshotRequested, deferConsent);
            this.mBinder.startBugreport(-1, this.mContext.getOpPackageName(), bugreportFd.getFileDescriptor(), screenshotFd.getFileDescriptor(), params.getMode(), params.getFlags(), dsListener, isScreenshotRequested);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (FileNotFoundException e) {
            Log.wtf(TAG, "Not able to find /dev/null file: ", e);
        }
        finally {
            IoUtils.closeQuietly(bugreportFd);
            if (screenshotFd != null) {
                IoUtils.closeQuietly(screenshotFd);
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.DUMP")
    public void retrieveBugreport(String bugreportFile, ParcelFileDescriptor bugreportFd, Executor executor, BugreportCallback callback) {
        try {
            Preconditions.checkNotNull(bugreportFile);
            Preconditions.checkNotNull(bugreportFd);
            Preconditions.checkNotNull(executor);
            Preconditions.checkNotNull(callback);
            DumpstateListener dsListener = new DumpstateListener(executor, callback, false, false);
            this.mBinder.retrieveBugreport(Binder.getCallingUid(), this.mContext.getOpPackageName(), bugreportFd.getFileDescriptor(), bugreportFile, dsListener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        finally {
            IoUtils.closeQuietly(bugreportFd);
        }
    }

    public void startConnectivityBugreport(ParcelFileDescriptor bugreportFd, Executor executor, BugreportCallback callback) {
        this.startBugreport(bugreportFd, null, new BugreportParams(4), executor, callback);
    }

    public void cancelBugreport() {
        try {
            this.mBinder.cancelBugreport(-1, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.DUMP")
    public void requestBugreport(BugreportParams params, CharSequence shareTitle, CharSequence shareDescription) {
        try {
            String title = shareTitle == null ? null : shareTitle.toString();
            String description = shareDescription == null ? null : shareDescription.toString();
            ActivityManager.getService().requestBugReportWithDescription(title, description, params.getMode());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private class DumpstateListener
    extends IDumpstateListener.Stub {
        private final Executor mExecutor;
        private final BugreportCallback mCallback;
        private final boolean mIsScreenshotRequested;
        private final boolean mIsConsentDeferred;

        DumpstateListener(Executor executor, BugreportCallback callback, boolean isScreenshotRequested, boolean isConsentDeferred) {
            this.mExecutor = executor;
            this.mCallback = callback;
            this.mIsScreenshotRequested = isScreenshotRequested;
            this.mIsConsentDeferred = isConsentDeferred;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onProgress(int progress) throws RemoteException {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onProgress(progress));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(int errorCode) throws RemoteException {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onError(errorCode));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFinished(String bugreportFile) throws RemoteException {
            long identity = Binder.clearCallingIdentity();
            try {
                if (this.mIsConsentDeferred) {
                    this.mExecutor.execute(() -> this.mCallback.onFinished(bugreportFile));
                } else {
                    this.mExecutor.execute(() -> this.mCallback.onFinished());
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        @Override
        public void onScreenshotTaken(boolean success) throws RemoteException {
            if (!this.mIsScreenshotRequested) {
                return;
            }
            Handler mainThreadHandler = new Handler(Looper.getMainLooper());
            mainThreadHandler.post(() -> {
                int message = success ? 17039770 : 17039769;
                Toast.makeText(BugreportManager.this.mContext, message, 1).show();
            });
        }

        @Override
        public void onUiIntensiveBugreportDumpsFinished() throws RemoteException {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onEarlyReportFinished());
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    public static abstract class BugreportCallback {
        public static final int BUGREPORT_ERROR_INVALID_INPUT = 1;
        public static final int BUGREPORT_ERROR_RUNTIME = 2;
        public static final int BUGREPORT_ERROR_USER_DENIED_CONSENT = 3;
        public static final int BUGREPORT_ERROR_USER_CONSENT_TIMED_OUT = 4;
        public static final int BUGREPORT_ERROR_ANOTHER_REPORT_IN_PROGRESS = 5;
        public static final int BUGREPORT_ERROR_NO_BUGREPORT_TO_RETRIEVE = 6;

        public void onProgress(float progress) {
        }

        public void onError(int errorCode) {
        }

        public void onFinished() {
        }

        @SystemApi
        public void onFinished(String bugreportFile) {
        }

        public void onEarlyReportFinished() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface BugreportErrorCode {
        }
    }
}

