/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BinaryOperator;

public class BundleMerger
implements Parcelable {
    private static final String TAG = "BundleMerger";
    private int mDefaultStrategy = 0;
    private final ArrayMap<String, Integer> mStrategies = new ArrayMap();
    public static final int STRATEGY_REJECT = 0;
    public static final int STRATEGY_FIRST = 1;
    public static final int STRATEGY_LAST = 2;
    public static final int STRATEGY_COMPARABLE_MIN = 3;
    public static final int STRATEGY_COMPARABLE_MAX = 4;
    public static final int STRATEGY_NUMBER_ADD = 10;
    public static final int STRATEGY_NUMBER_INCREMENT_FIRST = 20;
    public static final int STRATEGY_NUMBER_INCREMENT_FIRST_AND_ADD = 25;
    public static final int STRATEGY_BOOLEAN_AND = 30;
    public static final int STRATEGY_BOOLEAN_OR = 40;
    public static final int STRATEGY_ARRAY_APPEND = 50;
    public static final int STRATEGY_ARRAY_LIST_APPEND = 60;
    public static final Parcelable.Creator<BundleMerger> CREATOR = new Parcelable.Creator<BundleMerger>(){

        @Override
        public BundleMerger createFromParcel(Parcel in) {
            return new BundleMerger(in);
        }

        public BundleMerger[] newArray(int size) {
            return new BundleMerger[size];
        }
    };

    public BundleMerger() {
    }

    private BundleMerger(Parcel in) {
        this.mDefaultStrategy = in.readInt();
        int N = in.readInt();
        for (int i = 0; i < N; ++i) {
            this.mStrategies.put(in.readString(), in.readInt());
        }
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mDefaultStrategy);
        int N = this.mStrategies.size();
        out.writeInt(N);
        for (int i = 0; i < N; ++i) {
            out.writeString(this.mStrategies.keyAt(i));
            out.writeInt(this.mStrategies.valueAt(i));
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void setDefaultMergeStrategy(int strategy) {
        this.mDefaultStrategy = strategy;
    }

    public void setMergeStrategy(String key, int strategy) {
        this.mStrategies.put(key, strategy);
    }

    public int getMergeStrategy(String key) {
        return this.mStrategies.getOrDefault(key, this.mDefaultStrategy);
    }

    public BinaryOperator<Bundle> asBinaryOperator() {
        return this::merge;
    }

    public Bundle merge(Bundle first, Bundle last) {
        if (first == null && last == null) {
            return null;
        }
        if (first == null) {
            first = Bundle.EMPTY;
        }
        if (last == null) {
            last = Bundle.EMPTY;
        }
        Bundle res = new Bundle();
        res.putAll(first);
        res.putAll(last);
        ArraySet<String> conflictingKeys = new ArraySet<String>();
        conflictingKeys.addAll(first.keySet());
        conflictingKeys.retainAll(last.keySet());
        for (int i = 0; i < conflictingKeys.size(); ++i) {
            String key = (String)conflictingKeys.valueAt(i);
            int strategy = this.getMergeStrategy(key);
            Object firstValue = first.get(key);
            Object lastValue = last.get(key);
            try {
                res.putObject(key, BundleMerger.merge(strategy, firstValue, lastValue));
                continue;
            }
            catch (Exception e) {
                Log.w(TAG, "Failed to merge key " + key + " with " + firstValue + " and " + lastValue + " using strategy " + strategy, e);
            }
        }
        return res;
    }

    @VisibleForTesting
    public static Object merge(int strategy, Object first, Object last) {
        if (first == null) {
            return last;
        }
        if (last == null) {
            return first;
        }
        if (first.getClass() != last.getClass()) {
            throw new IllegalArgumentException("Merging requires consistent classes; first " + first.getClass() + " last " + last.getClass());
        }
        switch (strategy) {
            case 0: {
                if (Objects.deepEquals(first, last)) {
                    return first;
                }
                return null;
            }
            case 1: {
                return first;
            }
            case 2: {
                return last;
            }
            case 3: {
                return BundleMerger.comparableMin(first, last);
            }
            case 4: {
                return BundleMerger.comparableMax(first, last);
            }
            case 10: {
                return BundleMerger.numberAdd(first, last);
            }
            case 20: {
                return BundleMerger.numberIncrementFirst(first, last);
            }
            case 25: {
                return BundleMerger.numberAdd(BundleMerger.numberIncrementFirst(first, last), last);
            }
            case 30: {
                return BundleMerger.booleanAnd(first, last);
            }
            case 40: {
                return BundleMerger.booleanOr(first, last);
            }
            case 50: {
                return BundleMerger.arrayAppend(first, last);
            }
            case 60: {
                return BundleMerger.arrayListAppend(first, last);
            }
        }
        throw new UnsupportedOperationException();
    }

    private static Object comparableMin(Object first, Object last) {
        return ((Comparable)first).compareTo(last) < 0 ? first : last;
    }

    private static Object comparableMax(Object first, Object last) {
        return ((Comparable)first).compareTo(last) >= 0 ? first : last;
    }

    private static Object numberAdd(Object first, Object last) {
        if (first instanceof Integer) {
            return (Integer)first + (Integer)last;
        }
        if (first instanceof Long) {
            return (Long)first + (Long)last;
        }
        if (first instanceof Float) {
            return Float.valueOf(((Float)first).floatValue() + ((Float)last).floatValue());
        }
        if (first instanceof Double) {
            return (Double)first + (Double)last;
        }
        throw new IllegalArgumentException("Unable to add " + first.getClass());
    }

    private static Number numberIncrementFirst(Object first, Object last) {
        if (first instanceof Integer) {
            return (Integer)first + 1;
        }
        if (first instanceof Long) {
            return (Long)first + 1L;
        }
        throw new IllegalArgumentException("Unable to add " + first.getClass());
    }

    private static Object booleanAnd(Object first, Object last) {
        return (Boolean)first != false && (Boolean)last != false;
    }

    private static Object booleanOr(Object first, Object last) {
        return (Boolean)first != false || (Boolean)last != false;
    }

    private static Object arrayAppend(Object first, Object last) {
        if (!first.getClass().isArray()) {
            throw new IllegalArgumentException("Unable to append " + first.getClass());
        }
        Class<?> clazz = first.getClass().getComponentType();
        int firstLength = Array.getLength(first);
        int lastLength = Array.getLength(last);
        Object res = Array.newInstance(clazz, firstLength + lastLength);
        System.arraycopy(first, 0, res, 0, firstLength);
        System.arraycopy(last, 0, res, firstLength, lastLength);
        return res;
    }

    private static Object arrayListAppend(Object first, Object last) {
        if (!(first instanceof ArrayList)) {
            throw new IllegalArgumentException("Unable to append " + first.getClass());
        }
        ArrayList firstList = (ArrayList)first;
        ArrayList lastList = (ArrayList)last;
        ArrayList res = new ArrayList(firstList.size() + lastList.size());
        res.addAll(firstList);
        res.addAll(lastList);
        return res;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Strategy {
    }
}

