/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.ICancellationSignal;
import android.os.OperationCanceledException;
import android.os.RemoteException;

public class CancellationSignal {
    @UnsupportedAppUsage(maxTargetSdk=28)
    private boolean mIsCanceled;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private OnCancelListener mOnCancelListener;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private ICancellationSignal mRemote;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private boolean mCancelInProgress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        CancellationSignal cancellationSignal = this;
        synchronized (cancellationSignal) {
            return this.mIsCanceled;
        }
    }

    public void throwIfCanceled() {
        if (this.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        ICancellationSignal remote;
        OnCancelListener listener;
        CancellationSignal cancellationSignal = this;
        synchronized (cancellationSignal) {
            if (this.mIsCanceled) {
                return;
            }
            this.mIsCanceled = true;
            this.mCancelInProgress = true;
            listener = this.mOnCancelListener;
            remote = this.mRemote;
        }
        try {
            if (listener != null) {
                listener.onCancel();
            }
            if (remote != null) {
                try {
                    remote.cancel();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        finally {
            cancellationSignal = this;
            synchronized (cancellationSignal) {
                this.mCancelInProgress = false;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnCancelListener(OnCancelListener listener) {
        CancellationSignal cancellationSignal = this;
        synchronized (cancellationSignal) {
            this.waitForCancelFinishedLocked();
            if (this.mOnCancelListener == listener) {
                return;
            }
            this.mOnCancelListener = listener;
            if (!this.mIsCanceled || listener == null) {
                return;
            }
        }
        listener.onCancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemote(ICancellationSignal remote) {
        CancellationSignal cancellationSignal = this;
        synchronized (cancellationSignal) {
            this.waitForCancelFinishedLocked();
            if (this.mRemote == remote) {
                return;
            }
            this.mRemote = remote;
            if (!this.mIsCanceled || remote == null) {
                return;
            }
        }
        try {
            remote.cancel();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    private void waitForCancelFinishedLocked() {
        while (this.mCancelInProgress) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static ICancellationSignal createTransport() {
        return new Transport();
    }

    public static CancellationSignal fromTransport(ICancellationSignal transport) {
        if (transport instanceof Transport) {
            return ((Transport)transport).mCancellationSignal;
        }
        return null;
    }

    public static interface OnCancelListener {
        public void onCancel();
    }

    private static class Transport
    extends ICancellationSignal.Stub {
        final CancellationSignal mCancellationSignal = new CancellationSignal();

        private Transport() {
        }

        @Override
        public void cancel() throws RemoteException {
            this.mCancellationSignal.cancel();
        }
    }
}

