/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SuppressLint;
import android.os.Binder;
import android.os.CancellationSignal;
import android.os.IBinder;
import android.os.RemoteException;
import android.system.SystemCleaner;
import android.util.Pair;
import android.view.inputmethod.CancellableHandwritingGesture;
import android.view.inputmethod.HandwritingGesture;
import java.lang.ref.Cleaner;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.HashMap;

public class CancellationSignalBeamer {
    static final Cleaner sCleaner = SystemCleaner.cleaner();

    public static class Receiver
    implements IBinder.DeathRecipient {
        private final HashMap<IBinder, CancellationSignal> mTokenMap = new HashMap();
        private final boolean mCancelOnSenderDeath;

        public Receiver(boolean cancelOnSenderDeath) {
            this.mCancelOnSenderDeath = cancelOnSenderDeath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressLint(value={"VisiblySynchronized"})
        public CancellationSignal unbeam(IBinder token) {
            if (token == null) {
                return null;
            }
            Receiver receiver = this;
            synchronized (receiver) {
                CancellationSignal cs = this.mTokenMap.get(token);
                if (cs != null) {
                    return cs;
                }
                cs = new CancellationSignal();
                this.mTokenMap.put(token, cs);
                try {
                    token.linkToDeath(this, 0);
                }
                catch (RemoteException e) {
                    this.dead(token);
                }
                return cs;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressLint(value={"VisiblySynchronized"})
        public void forget(IBinder token) {
            Receiver receiver = this;
            synchronized (receiver) {
                if (this.mTokenMap.remove(token) != null) {
                    token.unlinkToDeath(this, 0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressLint(value={"VisiblySynchronized"})
        public void cancel(IBinder token) {
            CancellationSignal cs;
            Receiver receiver = this;
            synchronized (receiver) {
                cs = this.mTokenMap.get(token);
                if (cs == null) {
                    return;
                }
                this.forget(token);
            }
            cs.cancel();
        }

        private void dead(IBinder token) {
            if (this.mCancelOnSenderDeath) {
                this.cancel(token);
            } else {
                this.forget(token);
            }
        }

        @Override
        public void binderDied(IBinder who) {
            this.dead(who);
        }

        @Override
        public void binderDied() {
            throw new RuntimeException("unreachable");
        }
    }

    public static abstract class Sender {
        private static final ThreadLocal<Pair<Sender, ArrayList<CloseableToken>>> sScope = new ThreadLocal();

        public CloseableToken beam(CancellationSignal cs) {
            if (cs == null) {
                return null;
            }
            return new Token(this, cs);
        }

        public abstract void onCancel(IBinder var1);

        public abstract void onForget(IBinder var1);

        public MustClose beamScopeIfNeeded(HandwritingGesture gesture) {
            if (!(gesture instanceof CancellableHandwritingGesture)) {
                return null;
            }
            sScope.set(Pair.create(this, new ArrayList()));
            return () -> {
                ArrayList tokens = (ArrayList)Sender.sScope.get().second;
                sScope.remove();
                for (int i = tokens.size() - 1; i >= 0; --i) {
                    if (tokens.get(i) == null) continue;
                    ((CloseableToken)tokens.get(i)).close();
                }
            };
        }

        public static IBinder beamFromScope(CancellationSignal cs) {
            Pair<Sender, ArrayList<CloseableToken>> state = sScope.get();
            if (state != null) {
                CloseableToken token = ((Sender)state.first).beam(cs);
                ((ArrayList)state.second).add(token);
                return token;
            }
            return null;
        }

        private static class Token
        extends Binder
        implements CloseableToken,
        Runnable {
            private final Sender mSender;
            private Preparer mPreparer;

            private Token(Sender sender, CancellationSignal signal) {
                this.mSender = sender;
                this.mPreparer = new Preparer(sender, signal, this);
            }

            @Override
            public void close() {
                Preparer preparer = this.mPreparer;
                this.mPreparer = null;
                if (preparer != null) {
                    preparer.setup();
                }
            }

            @Override
            public void run() {
                this.mSender.onForget(this);
            }

            private static class Preparer
            implements CancellationSignal.OnCancelListener {
                private final Sender mSender;
                private final CancellationSignal mSignal;
                private final Token mToken;

                private Preparer(Sender sender, CancellationSignal signal, Token token) {
                    this.mSender = sender;
                    this.mSignal = signal;
                    this.mToken = token;
                }

                void setup() {
                    sCleaner.register(this, this.mToken);
                    this.mSignal.setOnCancelListener(this);
                }

                @Override
                public void onCancel() {
                    try {
                        this.mSender.onCancel(this.mToken);
                    }
                    finally {
                        Reference.reachabilityFence(this);
                    }
                }
            }
        }

        public static interface MustClose
        extends AutoCloseable {
            @Override
            public void close();
        }

        public static interface CloseableToken
        extends IBinder,
        MustClose {
            @Override
            public void close();
        }
    }
}

