/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.VibrationEffect;
import android.util.SparseArray;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class CombinedVibration
implements Parcelable {
    private static final int PARCEL_TOKEN_MONO = 1;
    private static final int PARCEL_TOKEN_STEREO = 2;
    private static final int PARCEL_TOKEN_SEQUENTIAL = 3;
    public static final Parcelable.Creator<CombinedVibration> CREATOR = new Parcelable.Creator<CombinedVibration>(){

        @Override
        public CombinedVibration createFromParcel(Parcel in) {
            int token = in.readInt();
            if (token == 1) {
                return new Mono(in);
            }
            if (token == 2) {
                return new Stereo(in);
            }
            if (token == 3) {
                return new Sequential(in);
            }
            throw new IllegalStateException("Unexpected combined vibration event type token in parcel.");
        }

        public CombinedVibration[] newArray(int size) {
            return new CombinedVibration[size];
        }
    };

    CombinedVibration() {
    }

    public static CombinedVibration createParallel(VibrationEffect effect) {
        Mono combined = new Mono(effect);
        ((CombinedVibration)combined).validate();
        return combined;
    }

    public static ParallelCombination startParallel() {
        return new ParallelCombination();
    }

    public static SequentialCombination startSequential() {
        return new SequentialCombination();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public abstract long getDuration();

    public boolean isHapticFeedbackCandidate() {
        return false;
    }

    public abstract void validate();

    public abstract boolean hasVibrator(int var1);

    public static class Mono
    extends CombinedVibration {
        private final VibrationEffect mEffect;
        public static final Parcelable.Creator<Mono> CREATOR = new Parcelable.Creator<Mono>(){

            @Override
            public Mono createFromParcel(Parcel in) {
                in.readInt();
                return new Mono(in);
            }

            public Mono[] newArray(int size) {
                return new Mono[size];
            }
        };

        Mono(Parcel in) {
            this.mEffect = VibrationEffect.CREATOR.createFromParcel(in);
        }

        Mono(VibrationEffect effect) {
            this.mEffect = effect;
        }

        public VibrationEffect getEffect() {
            return this.mEffect;
        }

        @Override
        public long getDuration() {
            return this.mEffect.getDuration();
        }

        @Override
        public boolean isHapticFeedbackCandidate() {
            return this.mEffect.isHapticFeedbackCandidate();
        }

        @Override
        public void validate() {
            this.mEffect.validate();
        }

        @Override
        public boolean hasVibrator(int vibratorId) {
            return true;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Mono)) {
                return false;
            }
            Mono other = (Mono)o;
            return this.mEffect.equals(other.mEffect);
        }

        public int hashCode() {
            return Objects.hash(this.mEffect);
        }

        public String toString() {
            return "Mono{mEffect=" + this.mEffect + '}';
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(1);
            this.mEffect.writeToParcel(out, flags);
        }
    }

    public static class ParallelCombination {
        private final SparseArray<VibrationEffect> mEffects = new SparseArray();

        ParallelCombination() {
        }

        public ParallelCombination addVibrator(int vibratorId, VibrationEffect effect) {
            this.mEffects.put(vibratorId, effect);
            return this;
        }

        public CombinedVibration combine() {
            if (this.mEffects.size() == 0) {
                throw new IllegalStateException("Combination must have at least one element to combine.");
            }
            Stereo combined = new Stereo(this.mEffects);
            ((CombinedVibration)combined).validate();
            return combined;
        }
    }

    public static class SequentialCombination {
        private final ArrayList<CombinedVibration> mEffects = new ArrayList();
        private final ArrayList<Integer> mDelays = new ArrayList();

        SequentialCombination() {
        }

        public SequentialCombination addNext(int vibratorId, VibrationEffect effect) {
            return this.addNext(vibratorId, effect, 0);
        }

        public SequentialCombination addNext(int vibratorId, VibrationEffect effect, int delay) {
            return this.addNext(CombinedVibration.startParallel().addVibrator(vibratorId, effect).combine(), delay);
        }

        public SequentialCombination addNext(CombinedVibration effect) {
            return this.addNext(effect, 0);
        }

        public SequentialCombination addNext(CombinedVibration effect, int delay) {
            if (effect instanceof Sequential) {
                Sequential sequentialEffect = (Sequential)effect;
                int firstEffectIndex = this.mDelays.size();
                this.mEffects.addAll(sequentialEffect.getEffects());
                this.mDelays.addAll(sequentialEffect.getDelays());
                this.mDelays.set(firstEffectIndex, delay + this.mDelays.get(firstEffectIndex));
            } else {
                this.mEffects.add(effect);
                this.mDelays.add(delay);
            }
            return this;
        }

        public CombinedVibration combine() {
            if (this.mEffects.size() == 0) {
                throw new IllegalStateException("Combination must have at least one element to combine.");
            }
            Sequential combined = new Sequential(this.mEffects, this.mDelays);
            ((CombinedVibration)combined).validate();
            return combined;
        }
    }

    public static class Sequential
    extends CombinedVibration {
        private static final long MAX_HAPTIC_FEEDBACK_SEQUENCE_SIZE = 3L;
        private final List<CombinedVibration> mEffects;
        private final List<Integer> mDelays;
        public static final Parcelable.Creator<Sequential> CREATOR = new Parcelable.Creator<Sequential>(){

            @Override
            public Sequential createFromParcel(Parcel in) {
                in.readInt();
                return new Sequential(in);
            }

            public Sequential[] newArray(int size) {
                return new Sequential[size];
            }
        };

        Sequential(Parcel in) {
            int size = in.readInt();
            this.mEffects = new ArrayList<CombinedVibration>(size);
            this.mDelays = new ArrayList<Integer>(size);
            for (int i = 0; i < size; ++i) {
                this.mDelays.add(in.readInt());
                this.mEffects.add(CREATOR.createFromParcel(in));
            }
        }

        Sequential(List<CombinedVibration> effects, List<Integer> delays) {
            this.mEffects = new ArrayList<CombinedVibration>(effects);
            this.mDelays = new ArrayList<Integer>(delays);
        }

        public List<CombinedVibration> getEffects() {
            return this.mEffects;
        }

        public List<Integer> getDelays() {
            return this.mDelays;
        }

        @Override
        public long getDuration() {
            boolean hasUnknownStep = false;
            long durations = 0L;
            int effectCount = this.mEffects.size();
            for (int i = 0; i < effectCount; ++i) {
                CombinedVibration effect = this.mEffects.get(i);
                long duration = effect.getDuration();
                if (duration == Long.MAX_VALUE) {
                    return duration;
                }
                durations += duration;
                hasUnknownStep |= duration < 0L;
            }
            if (hasUnknownStep) {
                return -1L;
            }
            long delays = 0L;
            for (int i = 0; i < effectCount; ++i) {
                delays += (long)this.mDelays.get(i).intValue();
            }
            return durations + delays;
        }

        @Override
        public boolean isHapticFeedbackCandidate() {
            int effectCount = this.mEffects.size();
            if ((long)effectCount > 3L) {
                return false;
            }
            for (int i = 0; i < effectCount; ++i) {
                if (this.mEffects.get(i).isHapticFeedbackCandidate()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void validate() {
            int i;
            Preconditions.checkArgument(this.mEffects.size() > 0, "There should be at least one effect set for a combined effect");
            Preconditions.checkArgument(this.mEffects.size() == this.mDelays.size(), "Effect and delays should have equal length");
            int effectCount = this.mEffects.size();
            for (i = 0; i < effectCount; ++i) {
                if (this.mDelays.get(i) >= 0) continue;
                throw new IllegalArgumentException("Delays must all be >= 0 (delays=" + this.mDelays + ")");
            }
            for (i = 0; i < effectCount; ++i) {
                CombinedVibration effect = this.mEffects.get(i);
                if (effect instanceof Sequential) {
                    throw new IllegalArgumentException("There should be no nested sequential effects in a combined effect");
                }
                effect.validate();
            }
        }

        @Override
        public boolean hasVibrator(int vibratorId) {
            int effectCount = this.mEffects.size();
            for (int i = 0; i < effectCount; ++i) {
                if (!this.mEffects.get(i).hasVibrator(vibratorId)) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Sequential)) {
                return false;
            }
            Sequential other = (Sequential)o;
            return this.mDelays.equals(other.mDelays) && this.mEffects.equals(other.mEffects);
        }

        public int hashCode() {
            return Objects.hash(this.mEffects, this.mDelays);
        }

        public String toString() {
            return "Sequential{mEffects=" + this.mEffects + ", mDelays=" + this.mDelays + '}';
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(3);
            out.writeInt(this.mEffects.size());
            for (int i = 0; i < this.mEffects.size(); ++i) {
                out.writeInt(this.mDelays.get(i));
                this.mEffects.get(i).writeToParcel(out, flags);
            }
        }
    }

    public static class Stereo
    extends CombinedVibration {
        private final SparseArray<VibrationEffect> mEffects;
        public static final Parcelable.Creator<Stereo> CREATOR = new Parcelable.Creator<Stereo>(){

            @Override
            public Stereo createFromParcel(Parcel in) {
                in.readInt();
                return new Stereo(in);
            }

            public Stereo[] newArray(int size) {
                return new Stereo[size];
            }
        };

        Stereo(Parcel in) {
            int size = in.readInt();
            this.mEffects = new SparseArray(size);
            for (int i = 0; i < size; ++i) {
                int vibratorId = in.readInt();
                this.mEffects.put(vibratorId, VibrationEffect.CREATOR.createFromParcel(in));
            }
        }

        Stereo(SparseArray<VibrationEffect> effects) {
            this.mEffects = new SparseArray(effects.size());
            for (int i = 0; i < effects.size(); ++i) {
                this.mEffects.put(effects.keyAt(i), effects.valueAt(i));
            }
        }

        public SparseArray<VibrationEffect> getEffects() {
            return this.mEffects;
        }

        @Override
        public long getDuration() {
            long maxDuration = Long.MIN_VALUE;
            boolean hasUnknownStep = false;
            for (int i = 0; i < this.mEffects.size(); ++i) {
                long duration = this.mEffects.valueAt(i).getDuration();
                if (duration == Long.MAX_VALUE) {
                    return duration;
                }
                maxDuration = Math.max(maxDuration, duration);
                hasUnknownStep |= duration < 0L;
            }
            if (hasUnknownStep) {
                return -1L;
            }
            return maxDuration;
        }

        @Override
        public boolean isHapticFeedbackCandidate() {
            for (int i = 0; i < this.mEffects.size(); ++i) {
                if (this.mEffects.valueAt(i).isHapticFeedbackCandidate()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void validate() {
            Preconditions.checkArgument(this.mEffects.size() > 0, "There should be at least one effect set for a combined effect");
            for (int i = 0; i < this.mEffects.size(); ++i) {
                this.mEffects.valueAt(i).validate();
            }
        }

        @Override
        public boolean hasVibrator(int vibratorId) {
            return this.mEffects.indexOfKey(vibratorId) >= 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Stereo)) {
                return false;
            }
            Stereo other = (Stereo)o;
            if (this.mEffects.size() != other.mEffects.size()) {
                return false;
            }
            for (int i = 0; i < this.mEffects.size(); ++i) {
                if (this.mEffects.valueAt(i).equals(other.mEffects.get(this.mEffects.keyAt(i)))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.mEffects.contentHashCode();
        }

        public String toString() {
            return "Stereo{mEffects=" + this.mEffects + '}';
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(2);
            out.writeInt(this.mEffects.size());
            for (int i = 0; i < this.mEffects.size(); ++i) {
                out.writeInt(this.mEffects.keyAt(i));
                this.mEffects.valueAt(i).writeToParcel(out, flags);
            }
        }
    }
}

