/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.app.GameManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.VMRuntime;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GraphicsEnvironment {
    private static final GraphicsEnvironment sInstance = new GraphicsEnvironment();
    private static final boolean DEBUG = false;
    private static final String TAG = "GraphicsEnvironment";
    private static final String SYSTEM_DRIVER_NAME = "system";
    private static final String SYSTEM_DRIVER_VERSION_NAME = "";
    private static final long SYSTEM_DRIVER_VERSION_CODE = 0L;
    private static final String ANGLE_DRIVER_NAME = "angle";
    private static final String ANGLE_DRIVER_VERSION_NAME = "";
    private static final long ANGLE_DRIVER_VERSION_CODE = 0L;
    private static final String PROPERTY_GFX_DRIVER_PRODUCTION = "ro.gfx.driver.0";
    private static final String PROPERTY_GFX_DRIVER_PRERELEASE = "ro.gfx.driver.1";
    private static final String PROPERTY_GFX_DRIVER_BUILD_TIME = "ro.gfx.driver_build_time";
    private static final String METADATA_DRIVER_BUILD_TIME = "com.android.graphics.driver.build_time";
    private static final String METADATA_DEVELOPER_DRIVER_ENABLE = "com.android.graphics.developerdriver.enable";
    private static final String METADATA_INJECT_LAYERS_ENABLE = "com.android.graphics.injectLayers.enable";
    private static final String UPDATABLE_DRIVER_ALLOWLIST_ALL = "*";
    private static final String UPDATABLE_DRIVER_SPHAL_LIBRARIES_FILENAME = "sphal_libraries.txt";
    private static final String ACTION_ANGLE_FOR_ANDROID = "android.app.action.ANGLE_FOR_ANDROID";
    private static final String ACTION_ANGLE_FOR_ANDROID_TOAST_MESSAGE = "android.app.action.ANGLE_FOR_ANDROID_TOAST_MESSAGE";
    private static final String INTENT_KEY_A4A_TOAST_MESSAGE = "A4A Toast Message";
    private static final int VULKAN_1_0 = 0x400000;
    private static final int VULKAN_1_1 = 0x401000;
    private static final int VULKAN_1_2 = 0x402000;
    private static final int VULKAN_1_3 = 0x403000;
    private static final int UPDATABLE_DRIVER_GLOBAL_OPT_IN_DEFAULT = 0;
    private static final int UPDATABLE_DRIVER_GLOBAL_OPT_IN_PRODUCTION_DRIVER = 1;
    private static final int UPDATABLE_DRIVER_GLOBAL_OPT_IN_PRERELEASE_DRIVER = 2;
    private static final int UPDATABLE_DRIVER_GLOBAL_OPT_IN_OFF = 3;
    private static final int ANGLE_GL_DRIVER_ALL_ANGLE_ON = 1;
    private static final int ANGLE_GL_DRIVER_ALL_ANGLE_OFF = 0;
    private static final String ANGLE_GL_DRIVER_CHOICE_DEFAULT = "default";
    private static final String ANGLE_GL_DRIVER_CHOICE_ANGLE = "angle";
    private static final String ANGLE_GL_DRIVER_CHOICE_NATIVE = "native";
    private ClassLoader mClassLoader;
    private String mLibrarySearchPaths;
    private String mLibraryPermittedPaths;
    private GameManager mGameManager;
    private int mAngleOptInIndex = -1;
    private boolean mEnabledByGameMode = false;

    public static GraphicsEnvironment getInstance() {
        return sInstance;
    }

    public void setup(Context context, Bundle coreSettings) {
        PackageManager pm = context.getPackageManager();
        String packageName = context.getPackageName();
        ApplicationInfo appInfoWithMetaData = GraphicsEnvironment.getAppInfoWithMetadata(context, pm, packageName);
        this.mGameManager = context.getSystemService(GameManager.class);
        Trace.traceBegin(2L, "setupGpuLayers");
        this.setupGpuLayers(context, coreSettings, pm, packageName, appInfoWithMetaData);
        Trace.traceEnd(2L);
        Trace.traceBegin(2L, "setupAngle");
        boolean useAngle = false;
        if (this.setupAngle(context, coreSettings, pm, packageName) && this.shouldUseAngle(context, coreSettings, packageName)) {
            useAngle = true;
            GraphicsEnvironment.setGpuStats("angle", "", 0L, 0L, packageName, this.getVulkanVersion(pm));
        }
        Trace.traceEnd(2L);
        Trace.traceBegin(2L, "chooseDriver");
        if (!this.chooseDriver(context, coreSettings, pm, packageName, appInfoWithMetaData) && !useAngle) {
            GraphicsEnvironment.setGpuStats(SYSTEM_DRIVER_NAME, "", 0L, SystemProperties.getLong(PROPERTY_GFX_DRIVER_BUILD_TIME, 0L), packageName, this.getVulkanVersion(pm));
        }
        Trace.traceEnd(2L);
        Trace.traceBegin(2L, "notifyGraphicsEnvironmentSetup");
        if (this.mGameManager != null && appInfoWithMetaData.category == 0) {
            this.mGameManager.notifyGraphicsEnvironmentSetup();
        }
        Trace.traceEnd(2L);
    }

    public void toggleAngleAsSystemDriver(boolean enabled) {
        GraphicsEnvironment.nativeToggleAngleAsSystemDriver(enabled);
    }

    private boolean isAngleEnabledByGameMode(Context context, String packageName) {
        try {
            boolean gameModeEnabledAngle = this.mGameManager != null && this.mGameManager.isAngleEnabled(packageName);
            Log.v(TAG, "ANGLE GameManagerService for " + packageName + ": " + gameModeEnabledAngle);
            return gameModeEnabledAngle;
        }
        catch (SecurityException e) {
            Log.e(TAG, "Caught exception while querying GameManagerService if ANGLE is enabled for package: " + packageName);
            return false;
        }
    }

    private boolean shouldUseAngle(Context context, Bundle coreSettings, String packageName) {
        if (TextUtils.isEmpty(packageName)) {
            Log.v(TAG, "No package name specified; use the system driver");
            return false;
        }
        return this.shouldUseAngleInternal(context, coreSettings, packageName);
    }

    private int getVulkanVersion(PackageManager pm) {
        if (pm.hasSystemFeature("android.hardware.vulkan.version", 0x403000)) {
            return 0x403000;
        }
        if (pm.hasSystemFeature("android.hardware.vulkan.version", 0x402000)) {
            return 0x402000;
        }
        if (pm.hasSystemFeature("android.hardware.vulkan.version", 0x401000)) {
            return 0x401000;
        }
        if (pm.hasSystemFeature("android.hardware.vulkan.version", 0x400000)) {
            return 0x400000;
        }
        return 0;
    }

    private boolean canInjectLayers(ApplicationInfo ai) {
        return ai.metaData != null && ai.metaData.getBoolean(METADATA_INJECT_LAYERS_ENABLE) && GraphicsEnvironment.setInjectLayersPrSetDumpable();
    }

    public void setLayerPaths(ClassLoader classLoader, String searchPaths, String permittedPaths) {
        this.mClassLoader = classLoader;
        this.mLibrarySearchPaths = searchPaths;
        this.mLibraryPermittedPaths = permittedPaths;
    }

    public String getDebugLayerPathsFromSettings(Bundle coreSettings, IPackageManager pm, String packageName, ApplicationInfo ai) {
        if (!this.debugLayerEnabled(coreSettings, packageName, ai)) {
            return null;
        }
        Log.i(TAG, "GPU debug layers enabled for " + packageName);
        String debugLayerPaths = "";
        String gpuDebugLayerApps = coreSettings.getString("gpu_debug_layer_app", "");
        if (!gpuDebugLayerApps.isEmpty()) {
            Log.i(TAG, "GPU debug layer apps: " + gpuDebugLayerApps);
            String[] layerApps = gpuDebugLayerApps.split(":");
            for (int i = 0; i < layerApps.length; ++i) {
                String paths = this.getDebugLayerAppPaths(pm, layerApps[i]);
                if (paths.isEmpty()) continue;
                debugLayerPaths = debugLayerPaths + paths + File.pathSeparator;
            }
        }
        return debugLayerPaths;
    }

    private String getDebugLayerAppPaths(IPackageManager pm, String packageName) {
        ApplicationInfo appInfo;
        try {
            appInfo = pm.getApplicationInfo(packageName, 131072L, UserHandle.myUserId());
        }
        catch (RemoteException e) {
            return "";
        }
        if (appInfo == null) {
            Log.w(TAG, "Debug layer app '" + packageName + "' not installed");
            return "";
        }
        String abi = GraphicsEnvironment.chooseAbi(appInfo);
        StringBuilder sb = new StringBuilder();
        sb.append(appInfo.nativeLibraryDir).append(File.pathSeparator).append(appInfo.sourceDir).append("!/lib/").append(abi);
        String paths = sb.toString();
        return paths;
    }

    private boolean debugLayerEnabled(Bundle coreSettings, String packageName, ApplicationInfo ai) {
        if (!GraphicsEnvironment.isDebuggable() && !this.canInjectLayers(ai)) {
            return false;
        }
        int enable = coreSettings.getInt("enable_gpu_debug_layers", 0);
        if (enable == 0) {
            return false;
        }
        String gpuDebugApp = coreSettings.getString("gpu_debug_app", "");
        return packageName != null && !gpuDebugApp.isEmpty() && !packageName.isEmpty() && gpuDebugApp.equals(packageName);
    }

    private void setupGpuLayers(Context context, Bundle coreSettings, PackageManager pm, String packageName, ApplicationInfo ai) {
        boolean enabled = this.debugLayerEnabled(coreSettings, packageName, ai);
        String layerPaths = "";
        if (enabled) {
            layerPaths = this.mLibraryPermittedPaths;
            String layers = coreSettings.getString("gpu_debug_layers");
            Log.i(TAG, "Vulkan debug layer list: " + layers);
            if (layers != null && !layers.isEmpty()) {
                GraphicsEnvironment.setDebugLayers(layers);
            }
            String layersGLES = coreSettings.getString("gpu_debug_layers_gles");
            Log.i(TAG, "GLES debug layer list: " + layersGLES);
            if (layersGLES != null && !layersGLES.isEmpty()) {
                GraphicsEnvironment.setDebugLayersGLES(layersGLES);
            }
        }
        layerPaths = layerPaths + this.mLibrarySearchPaths;
        GraphicsEnvironment.setLayerPaths(this.mClassLoader, layerPaths);
    }

    private static List<String> getGlobalSettingsString(ContentResolver contentResolver, Bundle bundle, String globalSetting) {
        String settingsValue = bundle != null ? bundle.getString(globalSetting) : Settings.Global.getString(contentResolver, globalSetting);
        ArrayList<String> valueList = settingsValue != null ? new ArrayList<String>(Arrays.asList(settingsValue.split(","))) : new ArrayList<String>();
        return valueList;
    }

    private static int getPackageIndex(String packageName, List<String> packages) {
        for (int idx = 0; idx < packages.size(); ++idx) {
            if (!packages.get(idx).equals(packageName)) continue;
            return idx;
        }
        return -1;
    }

    private static ApplicationInfo getAppInfoWithMetadata(Context context, PackageManager pm, String packageName) {
        ApplicationInfo ai;
        try {
            ai = pm.getApplicationInfo(packageName, 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            ai = context.getApplicationInfo();
        }
        return ai;
    }

    private boolean shouldUseAngleInternal(Context context, Bundle bundle, String packageName) {
        ContentResolver contentResolver;
        int allUseAngle;
        if (TextUtils.isEmpty(packageName)) {
            return false;
        }
        if (bundle != null) {
            allUseAngle = bundle.getInt("angle_gl_driver_all_angle");
        } else {
            contentResolver = context.getContentResolver();
            allUseAngle = Settings.Global.getInt(contentResolver, "angle_gl_driver_all_angle", 0);
        }
        if (allUseAngle == 1) {
            Log.v(TAG, "Turn on ANGLE for all applications.");
            return true;
        }
        contentResolver = context.getContentResolver();
        List<String> optInPackages = GraphicsEnvironment.getGlobalSettingsString(contentResolver, bundle, "angle_gl_driver_selection_pkgs");
        List<String> optInValues = GraphicsEnvironment.getGlobalSettingsString(contentResolver, bundle, "angle_gl_driver_selection_values");
        Log.v(TAG, "Currently set values for:");
        Log.v(TAG, "  angle_gl_driver_selection_pkgs=" + optInPackages);
        Log.v(TAG, "  angle_gl_driver_selection_values=" + optInValues);
        this.mEnabledByGameMode = this.isAngleEnabledByGameMode(context, packageName);
        if (optInPackages.size() != optInValues.size()) {
            Log.v(TAG, "Global.Settings values are invalid: number of packages: " + optInPackages.size() + ", number of values: " + optInValues.size());
            return this.mEnabledByGameMode;
        }
        int pkgIndex = GraphicsEnvironment.getPackageIndex(packageName, optInPackages);
        if (pkgIndex < 0) {
            Log.v(TAG, packageName + " is not listed in per-application setting");
            return this.mEnabledByGameMode;
        }
        this.mAngleOptInIndex = pkgIndex;
        String optInValue = optInValues.get(pkgIndex);
        Log.v(TAG, "ANGLE Developer option for '" + packageName + "' set to: '" + optInValue + "'");
        if (optInValue.equals("angle")) {
            return true;
        }
        if (optInValue.equals(ANGLE_GL_DRIVER_CHOICE_NATIVE)) {
            return false;
        }
        return this.mEnabledByGameMode;
    }

    private String getAnglePackageName(PackageManager pm) {
        Intent intent = new Intent(ACTION_ANGLE_FOR_ANDROID);
        List<ResolveInfo> resolveInfos = pm.queryIntentActivities(intent, 0x100000);
        if (resolveInfos.size() != 1) {
            Log.e(TAG, "Invalid number of ANGLE packages. Required: 1, Found: " + resolveInfos.size());
            for (ResolveInfo resolveInfo : resolveInfos) {
                Log.e(TAG, "Found ANGLE package: " + resolveInfo.activityInfo.packageName);
            }
            return "";
        }
        return resolveInfos.get((int)0).activityInfo.packageName;
    }

    private String getAngleDebugPackage(Context context, Bundle coreSettings) {
        String debugPackage;
        if (!GraphicsEnvironment.isDebuggable()) {
            return "";
        }
        if (coreSettings != null) {
            debugPackage = coreSettings.getString("angle_debug_package");
        } else {
            ContentResolver contentResolver = context.getContentResolver();
            debugPackage = Settings.Global.getString(contentResolver, "angle_debug_package");
        }
        if (TextUtils.isEmpty(debugPackage)) {
            return "";
        }
        return debugPackage;
    }

    private boolean setupAngle(Context context, Bundle bundle, PackageManager pm, String packageName) {
        if (!this.shouldUseAngle(context, bundle, packageName)) {
            return false;
        }
        ApplicationInfo angleInfo = null;
        String anglePkgName = this.getAngleDebugPackage(context, bundle);
        if (!anglePkgName.isEmpty()) {
            Log.v(TAG, "ANGLE debug package enabled: " + anglePkgName);
            try {
                angleInfo = pm.getApplicationInfo(anglePkgName, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.v(TAG, "ANGLE debug package '" + anglePkgName + "' not installed");
                return false;
            }
        }
        if (angleInfo == null) {
            anglePkgName = this.getAnglePackageName(pm);
            if (TextUtils.isEmpty(anglePkgName)) {
                Log.v(TAG, "Failed to find ANGLE package.");
                return false;
            }
            Log.v(TAG, "ANGLE package enabled: " + anglePkgName);
            try {
                angleInfo = pm.getApplicationInfo(anglePkgName, 0x100000);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.v(TAG, "ANGLE package '" + anglePkgName + "' not installed");
                return false;
            }
        }
        String abi = GraphicsEnvironment.chooseAbi(angleInfo);
        String paths = angleInfo.nativeLibraryDir + File.pathSeparator + angleInfo.sourceDir + "!/lib/" + abi;
        String[] features = this.getAngleEglFeatures(context, bundle);
        GraphicsEnvironment.setAngleInfo(paths, packageName, "angle", features);
        return true;
    }

    private boolean shouldShowAngleInUseDialogBox(Context context) {
        try {
            ContentResolver contentResolver = context.getContentResolver();
            int showDialogBox = Settings.Global.getInt(contentResolver, "show_angle_in_use_dialog_box");
            return showDialogBox == 1;
        }
        catch (Settings.SettingNotFoundException | SecurityException exception) {
            return false;
        }
    }

    private boolean setupAndUseAngle(Context context, String packageName) {
        if (!this.setupAngle(context, null, context.getPackageManager(), packageName)) {
            Log.v(TAG, "Package '" + packageName + "' should not use ANGLE");
            return false;
        }
        boolean useAngle = GraphicsEnvironment.getShouldUseAngle(packageName);
        Log.v(TAG, "Package '" + packageName + "' should use ANGLE = '" + useAngle + "'");
        return useAngle;
    }

    public void showAngleInUseDialogBox(Context context) {
        String packageName = context.getPackageName();
        if (this.shouldShowAngleInUseDialogBox(context) && this.setupAndUseAngle(context, packageName)) {
            Intent intent = new Intent(ACTION_ANGLE_FOR_ANDROID_TOAST_MESSAGE);
            String anglePkg = this.getAnglePackageName(context.getPackageManager());
            intent.setPackage(anglePkg);
            context.sendOrderedBroadcast(intent, null, new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    Bundle results = this.getResultExtras(true);
                    String toastMsg = results.getString(GraphicsEnvironment.INTENT_KEY_A4A_TOAST_MESSAGE);
                    Toast toast = Toast.makeText(context, toastMsg, 1);
                    toast.show();
                }
            }, null, -1, null, null);
        }
    }

    private String[] getAngleEglFeatures(Context context, Bundle coreSettings) {
        if (this.mAngleOptInIndex < 0) {
            return null;
        }
        List<String> featuresLists = GraphicsEnvironment.getGlobalSettingsString(context.getContentResolver(), coreSettings, "angle_egl_features");
        if (featuresLists.size() <= this.mAngleOptInIndex) {
            return null;
        }
        return featuresLists.get(this.mAngleOptInIndex).split(":");
    }

    private String chooseDriverInternal(Bundle coreSettings, ApplicationInfo ai) {
        boolean hasPrereleaseDriver;
        String productionDriver = SystemProperties.get(PROPERTY_GFX_DRIVER_PRODUCTION);
        boolean hasProductionDriver = productionDriver != null && !productionDriver.isEmpty();
        String prereleaseDriver = SystemProperties.get(PROPERTY_GFX_DRIVER_PRERELEASE);
        boolean bl = hasPrereleaseDriver = prereleaseDriver != null && !prereleaseDriver.isEmpty();
        if (!hasProductionDriver && !hasPrereleaseDriver) {
            Log.v(TAG, "Neither updatable production driver nor prerelease driver is supported.");
            return null;
        }
        if (ai.isPrivilegedApp() || ai.isSystemApp() && !ai.isUpdatedSystemApp()) {
            return null;
        }
        boolean enablePrereleaseDriver = ai.metaData != null && ai.metaData.getBoolean(METADATA_DEVELOPER_DRIVER_ENABLE) || GraphicsEnvironment.isDebuggable();
        switch (coreSettings.getInt("updatable_driver_all_apps", 0)) {
            case 3: {
                Log.v(TAG, "The updatable driver is turned off on this device.");
                return null;
            }
            case 1: {
                Log.v(TAG, "All apps opt in to use updatable production driver.");
                return hasProductionDriver ? productionDriver : null;
            }
            case 2: {
                Log.v(TAG, "All apps opt in to use updatable prerelease driver.");
                return hasPrereleaseDriver && enablePrereleaseDriver ? prereleaseDriver : null;
            }
        }
        String appPackageName = ai.packageName;
        if (GraphicsEnvironment.getGlobalSettingsString(null, coreSettings, "updatable_driver_production_opt_out_apps").contains(appPackageName)) {
            Log.v(TAG, "App opts out for updatable production driver.");
            return null;
        }
        if (GraphicsEnvironment.getGlobalSettingsString(null, coreSettings, "updatable_driver_prerelease_opt_in_apps").contains(appPackageName)) {
            Log.v(TAG, "App opts in for updatable prerelease driver.");
            return hasPrereleaseDriver && enablePrereleaseDriver ? prereleaseDriver : null;
        }
        if (!hasProductionDriver) {
            Log.v(TAG, "Updatable production driver is not supported on the device.");
            return null;
        }
        boolean isOptIn = GraphicsEnvironment.getGlobalSettingsString(null, coreSettings, "updatable_driver_production_opt_in_apps").contains(appPackageName);
        List<String> allowlist = GraphicsEnvironment.getGlobalSettingsString(null, coreSettings, "updatable_driver_production_allowlist");
        if (!isOptIn && allowlist.indexOf(UPDATABLE_DRIVER_ALLOWLIST_ALL) != 0 && !allowlist.contains(appPackageName)) {
            Log.v(TAG, "App is not on the allowlist for updatable production driver.");
            return null;
        }
        if (!isOptIn && GraphicsEnvironment.getGlobalSettingsString(null, coreSettings, "updatable_driver_production_denylist").contains(appPackageName)) {
            Log.v(TAG, "App is on the denylist for updatable production driver.");
            return null;
        }
        return productionDriver;
    }

    private boolean chooseDriver(Context context, Bundle coreSettings, PackageManager pm, String packageName, ApplicationInfo ai) {
        PackageInfo driverPackageInfo;
        String driverPackageName = this.chooseDriverInternal(coreSettings, ai);
        if (driverPackageName == null) {
            return false;
        }
        try {
            driverPackageInfo = pm.getPackageInfo(driverPackageName, 0x100080);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w(TAG, "updatable driver package '" + driverPackageName + "' not installed");
            return false;
        }
        ApplicationInfo driverAppInfo = driverPackageInfo.applicationInfo;
        if (driverAppInfo.targetSdkVersion < 26) {
            return false;
        }
        String abi = GraphicsEnvironment.chooseAbi(driverAppInfo);
        if (abi == null) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(driverAppInfo.nativeLibraryDir).append(File.pathSeparator);
        sb.append(driverAppInfo.sourceDir).append("!/lib/").append(abi);
        String paths = sb.toString();
        String sphalLibraries = this.getSphalLibraries(context, driverPackageName);
        Log.v(TAG, "Updatable driver package search path: " + paths + ", required sphal libraries: " + sphalLibraries);
        GraphicsEnvironment.setDriverPathAndSphalLibraries(paths, sphalLibraries);
        if (driverAppInfo.metaData == null) {
            throw new NullPointerException("apk's meta-data cannot be null");
        }
        String driverBuildTime = driverAppInfo.metaData.getString(METADATA_DRIVER_BUILD_TIME);
        if (driverBuildTime == null || driverBuildTime.length() <= 1) {
            Log.w(TAG, "com.android.graphics.driver.build_time is not set");
            driverBuildTime = "L0";
        }
        GraphicsEnvironment.setGpuStats(driverPackageName, driverPackageInfo.versionName, driverAppInfo.longVersionCode, Long.parseLong(driverBuildTime.substring(1)), packageName, 0);
        return true;
    }

    private static String chooseAbi(ApplicationInfo ai) {
        String isa = VMRuntime.getCurrentInstructionSet();
        if (ai.primaryCpuAbi != null && isa.equals(VMRuntime.getInstructionSet(ai.primaryCpuAbi))) {
            return ai.primaryCpuAbi;
        }
        if (ai.secondaryCpuAbi != null && isa.equals(VMRuntime.getInstructionSet(ai.secondaryCpuAbi))) {
            return ai.secondaryCpuAbi;
        }
        return null;
    }

    private String getSphalLibraries(Context context, String driverPackageName) {
        try {
            String assetString;
            Context driverContext = context.createPackageContext(driverPackageName, 4);
            BufferedReader reader = new BufferedReader(new InputStreamReader(driverContext.getAssets().open(UPDATABLE_DRIVER_SPHAL_LIBRARIES_FILENAME)));
            ArrayList<String> assetStrings = new ArrayList<String>();
            while ((assetString = reader.readLine()) != null) {
                assetStrings.add(assetString);
            }
            return String.join((CharSequence)":", assetStrings);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    private static boolean isDebuggable() {
        return OverrideMethod.invokeI("android.os.GraphicsEnvironment#isDebuggable()Z", true, null) != 0;
    }

    private static void setLayerPaths(ClassLoader classLoader, String string2) {
        OverrideMethod.invokeV("android.os.GraphicsEnvironment#setLayerPaths(Ljava/lang/ClassLoader;Ljava/lang/String;)V", true, null);
    }

    private static void setDebugLayers(String string2) {
        OverrideMethod.invokeV("android.os.GraphicsEnvironment#setDebugLayers(Ljava/lang/String;)V", true, null);
    }

    private static void setDebugLayersGLES(String string2) {
        OverrideMethod.invokeV("android.os.GraphicsEnvironment#setDebugLayersGLES(Ljava/lang/String;)V", true, null);
    }

    private static void setDriverPathAndSphalLibraries(String string2, String string3) {
        OverrideMethod.invokeV("android.os.GraphicsEnvironment#setDriverPathAndSphalLibraries(Ljava/lang/String;Ljava/lang/String;)V", true, null);
    }

    private static void setGpuStats(String string2, String string3, long l, long l2, String string4, int n) {
        OverrideMethod.invokeV("android.os.GraphicsEnvironment#setGpuStats(Ljava/lang/String;Ljava/lang/String;JJLjava/lang/String;I)V", true, null);
    }

    private static void setAngleInfo(String string2, String string3, String string4, String[] stringArray) {
        OverrideMethod.invokeV("android.os.GraphicsEnvironment#setAngleInfo(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", true, null);
    }

    private static boolean getShouldUseAngle(String string2) {
        return OverrideMethod.invokeI("android.os.GraphicsEnvironment#getShouldUseAngle(Ljava/lang/String;)Z", true, null) != 0;
    }

    private static boolean setInjectLayersPrSetDumpable() {
        return OverrideMethod.invokeI("android.os.GraphicsEnvironment#setInjectLayersPrSetDumpable()Z", true, null) != 0;
    }

    private static void nativeToggleAngleAsSystemDriver(boolean bl) {
        OverrideMethod.invokeV("android.os.GraphicsEnvironment#nativeToggleAngleAsSystemDriver(Z)V", true, null);
    }

    public static void hintActivityLaunch() {
        OverrideMethod.invokeV("android.os.GraphicsEnvironment#hintActivityLaunch()V", true, null);
    }
}

